/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.model.entity.Cliente;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class ClienteSpecification
implements Specification<Cliente> {
    private static final long serialVersionUID = 2913820643893311970L;
    private SearchCriteria criteria;

    public ClienteSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<Cliente> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("nome")) {
            return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get("nome")}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().equals("excluido")) {
            return builder.equal((Expression)root.get("excluido"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("ativo")) {
            return builder.equal((Expression)root.get("ativo"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("bloqueado")) {
            return builder.equal((Expression)root.get("usuario").get("bloqueado"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("onlyConcentreCustomers")) {
            return builder.isNotNull((Expression)root.get("codigoDoPdv"));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(">")) {
            return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase("<")) {
            return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get(this.criteria.getKey())}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }
}

