/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.model.entity.Cashback;
import com.escolpi.omni.api.util.DateUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class CashbackSpecification
implements Specification<Cashback> {
    private static final long serialVersionUID = 4825280729400018720L;
    private SearchCriteria criteria;

    public CashbackSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<Cashback> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("clienteNome")) {
            return builder.like(builder.function("unaccent", String.class, new Expression[]{builder.upper((Expression)root.get("cliente").get("nome"))}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().equals("dataHoraUtilizacaoInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dataDeInicioDaUtilizacao"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataHoraUtilizacaoFim")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dataDeInicioDaUtilizacao"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        return null;
    }
}

