/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Perfil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Size;

@Entity
@Table(name="usuarios")
@SequenceGenerator(name="usuarios_gen", sequenceName="usuarios_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
public class Usuario
implements Serializable {
    private static final long serialVersionUID = 1304513524323455199L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="usuarios_gen")
    @Column(name="id")
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="empresa_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"matriz", "municipio", "segmento", "usuario", "razaoSocial", "cnpj", "logotipo", "logotipoStore", "planoDeFundoStore", "nomeAbreviado", "telefonePrincipal", "telefoneSecundario", "urlSite", "cep", "logradouro", "numero", "complemento", "bairro", "contato", "emailContato", "fcmTokenServidor", "tempoDeEntrega", "tempoDeRetirada", "urlFacebook", "urlInstagram", "urlTwitter", "urlYoutube", "indWhatsapp", "urlAppAndroid", "urlAppIos", "urlStore", "versao", "versaoAndroid", "valorIsencaoEntrega", "aberto", "versaoIOS", "sobre", "aceitaPedidosAuto", "aceitaComandasAuto", "valorTarifaUnica", "dataDeCadastro", "dataInicioDeUtilizacao", "fusoHorario", "imprimePedidosAuto", "emailPagSeguro", "tokenPagSeguro", "ativo", "parcelaMinima", "maximoDeParcelas", "tokenFcm", "idStore", "quantidadeImpressoes", "fazDelivery", "fazRetirada", "imprimePedidosDistribuidosAuto", "emTeste", "valorMinimoParaEntrega", "latitude", "longitude", "facebookPixelId", "porcentagemDoCashback", "versaoVendas", "versaoVendasAndroid", "versaoVendasIos", "valorPlano", "limitePedidos", "valorPedidoExcedente", "diaVencimentoMensalidade", "porcentagemOutraPlataforma", "porcentagemDeComissao", "plano", "receberInformativos", "endereco"})
    private Empresa empresa;
    @Column(name="nome")
    private String nome;
    @Column(name="login")
    @Size(max=120)
    private @Size(max=120) String login;
    @Column(name="senha")
    @Size(max=150)
    private @Size(max=150) String senha;
    @Column(name="ind_bloqueio")
    private Boolean bloqueado;
    @Column(name="ind_demonstracao")
    private boolean demonstracao;
    @Column(name="ind_excluido")
    private boolean excluido;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="perfil_id", referencedColumnName="id")
    private Perfil perfil;
    @Column(name="codigo_pdv")
    private Integer codigoDoPdv;
    @Column(name="login_telefone")
    private String telefone;
    @Transient
    private String confirmacaoSenha;

    public Usuario(String login, String senha) {
        this.login = login;
        this.senha = senha;
        this.bloqueado = false;
    }

    public Usuario(Long id, boolean demonstracao) {
        this.id = id;
        this.demonstracao = demonstracao;
    }

    public Usuario() {
        this.bloqueado = false;
    }

    public Usuario(Long id) {
        this.id = id;
    }

    public Usuario(String login) {
        this.login = login;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public Boolean getBloqueado() {
        return this.bloqueado;
    }

    public void setBloqueado(Boolean bloqueado) {
        this.bloqueado = bloqueado;
    }

    public boolean isDemonstracao() {
        return this.demonstracao;
    }

    public void setDemonstracao(boolean demonstracao) {
        this.demonstracao = demonstracao;
    }

    public boolean isExcluido() {
        return this.excluido;
    }

    public void setExcluido(boolean excluido) {
        this.excluido = excluido;
    }

    public Perfil getPerfil() {
        return this.perfil;
    }

    public void setPerfil(Perfil perfil) {
        this.perfil = perfil;
    }

    public Integer getCodigoDoPdv() {
        return this.codigoDoPdv;
    }

    public void setCodigoDoPdv(Integer codigoDoPdv) {
        this.codigoDoPdv = codigoDoPdv;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getConfirmacaoSenha() {
        return this.confirmacaoSenha;
    }

    public void setConfirmacaoSenha(String confirmacaoSenha) {
        this.confirmacaoSenha = confirmacaoSenha;
    }
}

