/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.PromocaoRegraDeCompra;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="promocoes_brindes")
@SequenceGenerator(name="promocoes_brindes_gen", sequenceName="promocoes_brindes_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PromocaoBrinde
implements Serializable {
    private static final long serialVersionUID = -6619003721529891656L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="promocoes_brindes_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="promocao_regra_id")
    @JsonIgnoreProperties(value={"promocao", "descricao", "categoria", "brindes"})
    private PromocaoRegraDeCompra regra;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="produto_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa", "codigoAtos", "codigoAtosBrotoMedio", "codigoAtosBrotoGrande", "codigoAtosBrotoGigante", "emPromocao", "caminhoFoto", "dataHoraUltimaAtualizacao", "excluido"})
    private Produto produto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="categoria_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa", "grupo", "excluida"})
    private CategoriaDoProduto categoria;
    @Column(name="valor_brinde")
    private BigDecimal valor;
    @Column(name="ind_gratuito")
    private Boolean gratuito = false;

    public PromocaoBrinde() {
    }

    public PromocaoBrinde(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PromocaoRegraDeCompra getRegra() {
        return this.regra;
    }

    public void setRegra(PromocaoRegraDeCompra regra) {
        this.regra = regra;
    }

    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    public CategoriaDoProduto getCategoria() {
        return this.categoria;
    }

    public void setCategoria(CategoriaDoProduto categoria) {
        this.categoria = categoria;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public Boolean getGratuito() {
        return this.gratuito;
    }

    public void setGratuito(Boolean gratuito) {
        this.gratuito = gratuito;
    }
}

