/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.CupomDeDesconto;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.PromocaoRegraDeCompra;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Size;

@Entity
@Table(name="promocoes")
@SequenceGenerator(name="promocoes_gen", sequenceName="promocoes_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Promocao
implements Serializable {
    private static final long serialVersionUID = -1211783470035929239L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="promocoes_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="empresa_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"matriz", "municipio", "segmento", "usuario", "razaoSocial", "cnpj", "logotipo", "logotipoStore", "planoDeFundoStore", "nomeAbreviado", "telefonePrincipal", "telefoneSecundario", "urlSite", "cep", "logradouro", "numero", "complemento", "bairro", "contato", "emailContato", "fcmTokenServidor", "tempoDeEntrega", "tempoDeRetirada", "urlFacebook", "urlInstagram", "urlTwitter", "urlYoutube", "indWhatsapp", "urlAppAndroid", "urlAppIos", "urlStore", "versao", "versaoAndroid", "valorIsencaoEntrega", "aberto", "versaoIOS", "sobre", "aceitaPedidosAuto", "aceitaComandasAuto", "valorTarifaUnica", "dataDeCadastro", "dataInicioDeUtilizacao", "fusoHorario", "imprimePedidosAuto", "emailPagSeguro", "tokenPagSeguro", "ativo", "parcelaMinima", "maximoDeParcelas", "tokenFcm", "idStore", "quantidadeImpressoes", "fazDelivery", "fazRetirada", "imprimePedidosDistribuidosAuto", "emTeste", "valorMinimoParaEntrega", "latitude", "longitude", "facebookPixelId", "porcentagemDoCashback", "versaoVendas", "versaoVendasAndroid", "versaoVendasIos", "valorPlano", "limitePedidos", "valorPedidoExcedente", "diaVencimentoMensalidade", "porcentagemOutraPlataforma", "porcentagemDeComissao", "plano", "receberInformativos", "endereco"})
    private Empresa empresa;
    @Column(name="titulo")
    @Size(max=100)
    private @Size(max=100) String titulo;
    @Column(name="descricao")
    @Size(max=250)
    private @Size(max=250) String descricao;
    @Column(name="caminho_foto")
    @Size(max=250)
    private @Size(max=250) String caminhoFoto;
    @Temporal(value=TemporalType.DATE)
    @Column(name="dt_inicio_validade")
    private Date dtInicioValidade;
    @Temporal(value=TemporalType.DATE)
    @Column(name="dt_fim_validade")
    private Date dtFimValidade;
    @Column(name="valor_fixo")
    private BigDecimal valorFixo;
    @Column(name="ind_aceita_cupom_desconto")
    private Boolean aceitaCupomDeDesconto;
    @Column(name="ind_ativo")
    private Boolean ativo;
    @Column(name="ind_excluido")
    private Boolean excluida;
    @Column(name="disponibilidades")
    private String disponibilidades;
    @Column(name="ind_foto_externa")
    private Boolean fotoExterna;
    @OneToMany(mappedBy="promocao", fetch=FetchType.LAZY)
    private Set<PromocaoRegraDeCompra> regrasDeCompra;
    @Transient
    private String foto;
    @Transient
    private String miniatura;
    @Transient
    private CupomDeDesconto cupomDeDesconto;

    public Promocao() {
    }

    public Promocao(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getCaminhoFoto() {
        return this.caminhoFoto;
    }

    public void setCaminhoFoto(String caminhoFoto) {
        this.caminhoFoto = caminhoFoto;
    }

    public Date getDtInicioValidade() {
        return this.dtInicioValidade;
    }

    public void setDtInicioValidade(Date dtInicioValidade) {
        this.dtInicioValidade = dtInicioValidade;
    }

    public Date getDtFimValidade() {
        return this.dtFimValidade;
    }

    public void setDtFimValidade(Date dtFimValidade) {
        this.dtFimValidade = dtFimValidade;
    }

    public BigDecimal getValorFixo() {
        return this.valorFixo;
    }

    public void setValorFixo(BigDecimal valorFixo) {
        this.valorFixo = valorFixo;
    }

    public Boolean getAceitaCupomDeDesconto() {
        return this.aceitaCupomDeDesconto;
    }

    public void setAceitaCupomDeDesconto(Boolean aceitaCupomDeDesconto) {
        this.aceitaCupomDeDesconto = aceitaCupomDeDesconto;
    }

    public String getDisponibilidades() {
        return this.disponibilidades;
    }

    public void setDisponibilidades(String disponibilidades) {
        this.disponibilidades = disponibilidades;
    }

    public Boolean getFotoExterna() {
        return this.fotoExterna;
    }

    public void setFotoExterna(Boolean fotoExterna) {
        this.fotoExterna = fotoExterna;
    }

    public Set<PromocaoRegraDeCompra> getRegrasDeCompra() {
        return this.regrasDeCompra;
    }

    public void setRegrasDeCompra(Set<PromocaoRegraDeCompra> regrasDeCompra) {
        this.regrasDeCompra = regrasDeCompra;
    }

    public String getFoto() {
        return this.foto;
    }

    public void setFoto(String foto) {
        this.foto = foto;
    }

    public String getMiniatura() {
        return this.miniatura;
    }

    public void setMiniatura(String miniatura) {
        this.miniatura = miniatura;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public Boolean getExcluida() {
        return this.excluida;
    }

    public void setExcluida(Boolean excluida) {
        this.excluida = excluida;
    }

    public CupomDeDesconto getCupomDeDesconto() {
        return this.cupomDeDesconto;
    }

    public void setCupomDeDesconto(CupomDeDesconto cupomDeDesconto) {
        this.cupomDeDesconto = cupomDeDesconto;
    }
}

