/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.enumeration.ControleEstoque;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.model.entity.Contratacao;
import com.escolpi.omni.api.model.entity.Municipio;
import com.escolpi.omni.api.model.entity.Plano;
import com.escolpi.omni.api.model.entity.Segmento;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.entity.dto.EmpresaConfiguracaoDto;
import com.escolpi.omni.api.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="empresas")
@SequenceGenerator(name="empresas_gen", sequenceName="empresas_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
public class Empresa
implements Serializable {
    private static final long serialVersionUID = -5329463765228855988L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="empresas_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="matriz_id", referencedColumnName="id")
    private Empresa matriz;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="municipio_id", referencedColumnName="id", nullable=false)
    private Municipio municipio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="segmento_id", referencedColumnName="id", nullable=false)
    private Segmento segmento;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usuario_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"senha", "empresa"})
    private Usuario usuario;
    @Column(name="razao_social")
    private String razaoSocial;
    @Column(name="nome_fantasia")
    private String nomeFantasia;
    @Column(name="cnpj")
    private String cnpj;
    @Column(name="path_logotipo")
    private String logotipo;
    @Column(name="path_logotipo_store")
    private String logotipoStore;
    @Column(name="path_plano_fundo_store")
    private String planoDeFundoStore;
    @Column(name="nome_abreviado")
    private String nomeAbreviado;
    @Column(name="telefone_principal")
    private String telefonePrincipal;
    @Column(name="telefone_secundario")
    private String telefoneSecundario;
    @Column(name="url_site")
    private String urlSite;
    @Column(name="cep")
    private String cep;
    @Column(name="logradouro")
    private String logradouro;
    @Column(name="numero")
    private String numero;
    @Column(name="complemento")
    private String complemento;
    @Column(name="bairro")
    private String bairro;
    @Column(name="contato")
    private String contato;
    @Column(name="email_contato")
    private String emailContato;
    @Column(name="fcm_token_servidor")
    private String fcmTokenServidor;
    @Column(name="tempo_entrega")
    private Integer tempoDeEntrega;
    @Column(name="tempo_retirada")
    private Integer tempoDeRetirada;
    @Column(name="url_facebook")
    private String urlFacebook;
    @Column(name="url_instagram")
    private String urlInstagram;
    @Column(name="url_twitter")
    private String urlTwitter;
    @Column(name="url_youtube")
    private String urlYoutube;
    @Column(name="ind_whatsapp")
    private Boolean whatsapp;
    @Column(name="url_app_android")
    private String urlAppAndroid;
    @Column(name="url_app_ios")
    private String urlAppIos;
    @Column(name="url_store")
    private String urlStore;
    @Column(name="versao")
    private String versao;
    @Column(name="versao_android")
    private String versaoAndroid;
    @Column(name="valor_isencao_entrega", length=8, precision=2)
    private BigDecimal valorIsencaoEntrega;
    @Column(name="ind_aberto")
    private Boolean aberto;
    @Column(name="versao_ios")
    private String versaoIOS;
    @Column(name="sobre")
    private String sobre;
    @Column(name="ind_aceita_pedidos_auto")
    private Boolean aceitaPedidosAuto;
    @Column(name="ind_aceita_pedidos_comanda_auto")
    private Boolean aceitaComandasAuto;
    @Column(name="valor_tarifa_unica")
    private BigDecimal valorTarifaUnica;
    @Column(name="dt_cadastro")
    private Date dataDeCadastro;
    @Column(name="dt_inicio_utilizacao")
    private Date dataInicioDeUtilizacao;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="fuso_horario")
    private FusoHorario fusoHorario;
    @Column(name="ind_imprime_pedidos_auto")
    private Boolean imprimePedidosAuto;
    @Column(name="email_pagseguro")
    private String emailPagSeguro;
    @Column(name="token_pagseguro")
    private String tokenPagSeguro;
    @Column(name="ind_desconto_pagamento_em_dinheiro")
    private Boolean descontoPagamentoEmDinheiro;
    @Column(name="valor_desconto_pagamento_em_dinheiro")
    private BigDecimal valorDescontoPagamentoEmDinheiro;
    @Column(name="ind_emp_ativo")
    private Boolean ativo;
    @Column(name="parcela_minima")
    private BigDecimal parcelaMinima;
    @Column(name="maximo_parcelas")
    private Integer maximoDeParcelas;
    @Column(name="token_fcm")
    private String tokenFcm;
    @Column(name="id_store")
    private String idStore;
    @Column(name="quantidade_impressoes")
    private Integer quantidadeImpressoes;
    @Column(name="ind_faz_delivery")
    private Boolean fazDelivery;
    @Column(name="ind_faz_retirada")
    private Boolean fazRetirada;
    @Column(name="ind_imprime_pedidos_distribuidos_auto")
    private Boolean imprimePedidosDistribuidosAuto;
    @Column(name="ind_em_testes")
    private Boolean emTeste;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ind_controle_estoque")
    private ControleEstoque controleEstoque;
    @Column(name="valor_min_para_entrega")
    private BigDecimal valorMinimoParaEntrega;
    @Column(name="latitude")
    private String latitude;
    @Column(name="longitude")
    private String longitude;
    @Column(name="facebook_pixel")
    private String facebookPixelId;
    @Column(name="porcentagem_cashback")
    private BigDecimal porcentagemDoCashback;
    @Column(name="versao_vendas")
    private String versaoVendas;
    @Column(name="versao_vendas_android")
    private String versaoVendasAndroid;
    @Column(name="versao_vendas_ios")
    private String versaoVendasIos;
    @Column(name="valor_plano")
    private BigDecimal valorPlano;
    @Column(name="limite_pedidos")
    private Integer limitePedidos;
    @Column(name="valor_pedido_excedente")
    private BigDecimal valorPedidoExcedente;
    @Column(name="dia_vencimento_mensalidade")
    private Integer diaVencimentoMensalidade;
    @Column(name="porcentagem_outra_plataforma")
    private Double porcentagemOutraPlataforma;
    @Column(name="porcentagem_comissao")
    private Double porcentagemDeComissao;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="plano_id", referencedColumnName="id")
    private Plano plano;
    @Column(name="ind_receber_informativos")
    private Boolean receberInformativos;
    @Column(name="serial")
    private UUID serial;
    @Column(name="atosbot_id", length=50)
    private String atosBotId;
    @Column(name="servidor", length=50)
    private String servidor;
    @Column(name="instancia", length=50)
    private String instancia;
    @Transient
    private String foto;
    @Transient
    private String fotoStore;
    @Transient
    private String planoDeFundoNaLoja;
    @Transient
    private String senhaAtual;
    @Transient
    private String senha;
    @Transient
    private String confirmacaoSenha;
    @Transient
    private Contratacao contrato;
    @Transient
    private List<EmpresaConfiguracaoDto> configuracoesDaEmpresa;

    public Empresa() {
    }

    public Empresa(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Empresa getMatriz() {
        return this.matriz;
    }

    public void setMatriz(Empresa matriz) {
        this.matriz = matriz;
    }

    public Municipio getMunicipio() {
        return this.municipio;
    }

    public void setMunicipio(Municipio municipio) {
        this.municipio = municipio;
    }

    public Segmento getSegmento() {
        return this.segmento;
    }

    public void setSegmento(Segmento segmento) {
        this.segmento = segmento;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getLogotipo() {
        return this.logotipo;
    }

    public void setLogotipo(String logotipo) {
        this.logotipo = logotipo;
    }

    public String getLogotipoStore() {
        return this.logotipoStore;
    }

    public void setLogotipoStore(String logotipoStore) {
        this.logotipoStore = logotipoStore;
    }

    public String getPlanoDeFundoStore() {
        return this.planoDeFundoStore;
    }

    public void setPlanoDeFundoStore(String planoDeFundoStore) {
        this.planoDeFundoStore = planoDeFundoStore;
    }

    public String getNomeAbreviado() {
        return this.nomeAbreviado;
    }

    public void setNomeAbreviado(String nomeAbreviado) {
        this.nomeAbreviado = nomeAbreviado;
    }

    public String getTelefonePrincipal() {
        return this.telefonePrincipal;
    }

    public void setTelefonePrincipal(String telefonePrincipal) {
        this.telefonePrincipal = telefonePrincipal;
    }

    public String getTelefoneSecundario() {
        return this.telefoneSecundario;
    }

    public void setTelefoneSecundario(String telefoneSecundario) {
        this.telefoneSecundario = telefoneSecundario;
    }

    public String getUrlSite() {
        return this.urlSite;
    }

    public void setUrlSite(String urlSite) {
        this.urlSite = urlSite;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
    }

    public String getEmailContato() {
        return this.emailContato;
    }

    public void setEmailContato(String emailContato) {
        this.emailContato = emailContato;
    }

    public String getFcmTokenServidor() {
        return this.fcmTokenServidor;
    }

    public void setFcmTokenServidor(String fcmTokenServidor) {
        this.fcmTokenServidor = fcmTokenServidor;
    }

    public Integer getTempoDeEntrega() {
        return this.tempoDeEntrega;
    }

    public void setTempoDeEntrega(Integer tempoDeEntrega) {
        this.tempoDeEntrega = tempoDeEntrega;
    }

    public Integer getTempoDeRetirada() {
        return this.tempoDeRetirada;
    }

    public void setTempoDeRetirada(Integer tempoDeRetirada) {
        this.tempoDeRetirada = tempoDeRetirada;
    }

    public String getUrlFacebook() {
        return this.urlFacebook;
    }

    public void setUrlFacebook(String urlFacebook) {
        this.urlFacebook = urlFacebook;
    }

    public String getUrlInstagram() {
        return this.urlInstagram;
    }

    public void setUrlInstagram(String urlInstagram) {
        this.urlInstagram = urlInstagram;
    }

    public String getUrlTwitter() {
        return this.urlTwitter;
    }

    public void setUrlTwitter(String urlTwitter) {
        this.urlTwitter = urlTwitter;
    }

    public String getUrlYoutube() {
        return this.urlYoutube;
    }

    public void setUrlYoutube(String urlYoutube) {
        this.urlYoutube = urlYoutube;
    }

    public Boolean getWhatsapp() {
        return this.whatsapp;
    }

    public void setWhatsapp(Boolean indWhatsapp) {
        this.whatsapp = indWhatsapp;
    }

    public String getUrlAppAndroid() {
        return this.urlAppAndroid;
    }

    public void setUrlAppAndroid(String urlAppAndroid) {
        this.urlAppAndroid = urlAppAndroid;
    }

    public String getUrlAppIos() {
        return this.urlAppIos;
    }

    public void setUrlAppIos(String urlAppIos) {
        this.urlAppIos = urlAppIos;
    }

    public String getUrlStore() {
        return this.urlStore;
    }

    public void setUrlStore(String urlStore) {
        this.urlStore = urlStore;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public String getVersaoAndroid() {
        return this.versaoAndroid;
    }

    public void setVersaoAndroid(String versaoAndroid) {
        this.versaoAndroid = versaoAndroid;
    }

    public BigDecimal getValorIsencaoEntrega() {
        return this.valorIsencaoEntrega;
    }

    public void setValorIsencaoEntrega(BigDecimal valorIsencaoEntrega) {
        this.valorIsencaoEntrega = valorIsencaoEntrega;
    }

    public Boolean getAberto() {
        return this.aberto;
    }

    public void setAberto(Boolean ativo) {
        this.aberto = ativo;
    }

    public FusoHorario getFusoHorario() {
        return this.fusoHorario;
    }

    public void setFusoHorario(FusoHorario fusoHorario) {
        this.fusoHorario = fusoHorario;
    }

    public Boolean getImprimePedidosAuto() {
        return this.imprimePedidosAuto;
    }

    public void setImprimePedidosAuto(Boolean imprimePedidosAuto) {
        this.imprimePedidosAuto = imprimePedidosAuto;
    }

    public String getEmailPagSeguro() {
        return this.emailPagSeguro;
    }

    public void setEmailPagSeguro(String emailPagSeguro) {
        this.emailPagSeguro = emailPagSeguro;
    }

    public String getTokenPagSeguro() {
        return this.tokenPagSeguro;
    }

    public void setTokenPagSeguro(String tokenPagSeguro) {
        this.tokenPagSeguro = tokenPagSeguro;
    }

    public Boolean getDescontoPagamentoEmDinheiro() {
        return this.descontoPagamentoEmDinheiro;
    }

    public void setDescontoPagamentoEmDinheiro(Boolean descontoPagamentoEmDinheiro) {
        this.descontoPagamentoEmDinheiro = descontoPagamentoEmDinheiro;
    }

    public BigDecimal getValorDescontoPagamentoEmDinheiro() {
        return this.valorDescontoPagamentoEmDinheiro;
    }

    public void setValorDescontoPagamentoEmDinheiro(BigDecimal valorDescontoPagamentoEmDinheiro) {
        this.valorDescontoPagamentoEmDinheiro = valorDescontoPagamentoEmDinheiro;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public BigDecimal getParcelaMinima() {
        return this.parcelaMinima;
    }

    public void setParcelaMinima(BigDecimal parcelaMinima) {
        this.parcelaMinima = parcelaMinima;
    }

    public Integer getMaximoDeParcelas() {
        return this.maximoDeParcelas;
    }

    public void setMaximoDeParcelas(Integer maximoDeParcelas) {
        this.maximoDeParcelas = maximoDeParcelas;
    }

    public String getTokenFcm() {
        return this.tokenFcm;
    }

    public void setTokenFcm(String tokenFcm) {
        this.tokenFcm = tokenFcm;
    }

    public String getIdStore() {
        return this.idStore;
    }

    public void setIdStore(String idStore) {
        this.idStore = idStore;
    }

    public Integer getQuantidadeImpressoes() {
        return this.quantidadeImpressoes;
    }

    public void setQuantidadeImpressoes(Integer quantidadeImpressoes) {
        this.quantidadeImpressoes = quantidadeImpressoes;
    }

    public Boolean getFazDelivery() {
        return this.fazDelivery;
    }

    public void setFazDelivery(Boolean fazDelivery) {
        this.fazDelivery = fazDelivery;
    }

    public Boolean getFazRetirada() {
        return this.fazRetirada;
    }

    public void setFazRetirada(Boolean fazRetirada) {
        this.fazRetirada = fazRetirada;
    }

    public Boolean getImprimePedidosDistribuidosAuto() {
        return this.imprimePedidosDistribuidosAuto;
    }

    public void setImprimePedidosDistribuidosAuto(Boolean imprimePedidosDistribuidosAuto) {
        this.imprimePedidosDistribuidosAuto = imprimePedidosDistribuidosAuto;
    }

    public Boolean getEmTeste() {
        return this.emTeste;
    }

    public void setEmTeste(Boolean emTeste) {
        this.emTeste = emTeste;
    }

    public ControleEstoque getControleEstoque() {
        return this.controleEstoque;
    }

    public void setControleEstoque(ControleEstoque controleEstoque) {
        this.controleEstoque = controleEstoque;
    }

    public BigDecimal getValorMinimoParaEntrega() {
        return this.valorMinimoParaEntrega;
    }

    public void setValorMinimoParaEntrega(BigDecimal valorMinimoParaEntrega) {
        this.valorMinimoParaEntrega = valorMinimoParaEntrega;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getFacebookPixelId() {
        return this.facebookPixelId;
    }

    public void setFacebookPixelId(String facebookPixelId) {
        this.facebookPixelId = facebookPixelId;
    }

    public BigDecimal getPorcentagemDoCashback() {
        return this.porcentagemDoCashback;
    }

    public void setPorcentagemDoCashback(BigDecimal porcentagemDoCashback) {
        this.porcentagemDoCashback = porcentagemDoCashback;
    }

    public String getVersaoVendas() {
        return this.versaoVendas;
    }

    public void setVersaoVendas(String versaoVendas) {
        this.versaoVendas = versaoVendas;
    }

    public String getVersaoVendasAndroid() {
        return this.versaoVendasAndroid;
    }

    public void setVersaoVendasAndroid(String vendaVersaoAndroid) {
        this.versaoVendasAndroid = vendaVersaoAndroid;
    }

    public String getVersaoVendasIos() {
        return this.versaoVendasIos;
    }

    public void setVersaoVendasIos(String vendasVersaoIos) {
        this.versaoVendasIos = vendasVersaoIos;
    }

    public BigDecimal getValorPlano() {
        return this.valorPlano;
    }

    public void setValorPlano(BigDecimal valorPlano) {
        this.valorPlano = valorPlano;
    }

    public Integer getLimitePedidos() {
        return this.limitePedidos;
    }

    public void setLimitePedidos(Integer limitePedidos) {
        this.limitePedidos = limitePedidos;
    }

    public BigDecimal getValorPedidoExcedente() {
        return this.valorPedidoExcedente;
    }

    public void setValorPedidoExcedente(BigDecimal valorPedidoExcedente) {
        this.valorPedidoExcedente = valorPedidoExcedente;
    }

    public Integer getDiaVencimentoMensalidade() {
        return this.diaVencimentoMensalidade;
    }

    public void setDiaVencimentoMensalidade(Integer diaVencimentoMensalidade) {
        this.diaVencimentoMensalidade = diaVencimentoMensalidade;
    }

    public Double getPorcentagemOutraPlataforma() {
        return this.porcentagemOutraPlataforma;
    }

    public void setPorcentagemOutraPlataforma(Double porcentagemOutraPlataforma) {
        this.porcentagemOutraPlataforma = porcentagemOutraPlataforma;
    }

    public Double getPorcentagemDeComissao() {
        return this.porcentagemDeComissao;
    }

    public void setPorcentagemDeComissao(Double porcentagemDeComissao) {
        this.porcentagemDeComissao = porcentagemDeComissao;
    }

    public Plano getPlano() {
        return this.plano;
    }

    public void setPlano(Plano plano) {
        this.plano = plano;
    }

    public Boolean getReceberInformativos() {
        return this.receberInformativos;
    }

    public UUID getSerial() {
        return this.serial;
    }

    public void setSerial(UUID serial) {
        this.serial = serial;
    }

    public String getAtosBotId() {
        return this.atosBotId;
    }

    public void setAtosBotId(String atosBotId) {
        this.atosBotId = atosBotId;
    }

    public String getServidor() {
        return this.servidor;
    }

    public void setServidor(String servidor) {
        this.servidor = servidor;
    }

    public String getInstancia() {
        return this.instancia;
    }

    public void setInstancia(String instancia) {
        this.instancia = instancia;
    }

    public void setReceberInformativos(Boolean receberInformativos) {
        this.receberInformativos = receberInformativos;
    }

    public String getFoto() {
        return this.foto;
    }

    public String getVersaoIOS() {
        return this.versaoIOS;
    }

    public void setVersaoIOS(String versaoIOS) {
        this.versaoIOS = versaoIOS;
    }

    public String getSobre() {
        return this.sobre;
    }

    public void setSobre(String sobre) {
        this.sobre = sobre;
    }

    public Boolean getAceitaPedidosAuto() {
        return this.aceitaPedidosAuto;
    }

    public void setAceitaPedidosAuto(Boolean aceitaPedidosAuto) {
        this.aceitaPedidosAuto = aceitaPedidosAuto;
    }

    public Boolean getAceitaComandasAuto() {
        return this.aceitaComandasAuto;
    }

    public void setAceitaComandasAuto(Boolean aceitaComandasAuto) {
        this.aceitaComandasAuto = aceitaComandasAuto;
    }

    public BigDecimal getValorTarifaUnica() {
        return this.valorTarifaUnica;
    }

    public void setValorTarifaUnica(BigDecimal valorTarifaUnica) {
        this.valorTarifaUnica = valorTarifaUnica;
    }

    public Date getDataDeCadastro() {
        return this.dataDeCadastro;
    }

    public void setDataDeCadastro(Date dataDeCadastro) {
        this.dataDeCadastro = dataDeCadastro;
    }

    public Date getDataInicioDeUtilizacao() {
        return this.dataInicioDeUtilizacao;
    }

    public void setDataInicioDeUtilizacao(Date dataInicioDeUtilizacao) {
        this.dataInicioDeUtilizacao = dataInicioDeUtilizacao;
    }

    public void setFoto(String foto) {
        this.foto = foto;
    }

    public String getFotoStore() {
        return this.fotoStore;
    }

    public void setFotoStore(String fotoStore) {
        this.fotoStore = fotoStore;
    }

    public String getPlanoDeFundoNaLoja() {
        return this.planoDeFundoNaLoja;
    }

    public void setPlanoDeFundoNaLoja(String planoDeFundoNaLoja) {
        this.planoDeFundoNaLoja = planoDeFundoNaLoja;
    }

    public String getSenhaAtual() {
        return this.senhaAtual;
    }

    public void setSenhaAtual(String senhaAtual) {
        this.senhaAtual = senhaAtual;
    }

    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getConfirmacaoSenha() {
        return this.confirmacaoSenha;
    }

    public void setConfirmacaoSenha(String confirmacaoSenha) {
        this.confirmacaoSenha = confirmacaoSenha;
    }

    public Contratacao getContrato() {
        return this.contrato;
    }

    public void setContrato(Contratacao contrato) {
        this.contrato = contrato;
    }

    public List<EmpresaConfiguracaoDto> getConfiguracoesDaEmpresa() {
        return this.configuracoesDaEmpresa;
    }

    public void setConfiguracoesDaEmpresa(List<EmpresaConfiguracaoDto> configuracoesDaEmpresa) {
        this.configuracoesDaEmpresa = configuracoesDaEmpresa;
    }

    @Transient
    public String getEndereco() {
        if (this.logradouro != null && this.numero != null && this.municipio != null) {
            return String.format("%s, %s, %s, %s, %s/%s", this.logradouro, this.numero, this.bairro, StringUtil.formatarCEP((String)this.cep), this.municipio.getNome(), this.municipio.getUf());
        }
        return "";
    }

    @Transient
    public boolean getModoDemonstracao(boolean modoDemonstracao) {
        if (this.usuario != null) {
            return this.usuario.isDemonstracao();
        }
        return false;
    }
}

