/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.enumeration.TipoPessoa;
import com.escolpi.omni.api.model.entity.CancelamentoDaConta;
import com.escolpi.omni.api.model.entity.CupomUtilizado;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EnderecoDeEntrega;
import com.escolpi.omni.api.model.entity.SolicitacaoDeAtivacao;
import com.escolpi.omni.api.model.entity.Usuario;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="clientes")
@SequenceGenerator(name="clientes_gen", sequenceName="clientes_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Cliente
implements Serializable {
    private static final long serialVersionUID = -5877088685360506517L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="clientes_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="empresa_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"matriz", "municipio", "segmento", "usuario", "razaoSocial", "cnpj", "logotipo", "logotipoStore", "planoDeFundoStore", "nomeAbreviado", "telefonePrincipal", "telefoneSecundario", "urlSite", "cep", "logradouro", "numero", "complemento", "bairro", "contato", "emailContato", "fcmTokenServidor", "tempoDeEntrega", "tempoDeRetirada", "urlFacebook", "urlInstagram", "urlTwitter", "urlYoutube", "indWhatsapp", "urlAppAndroid", "urlAppIos", "urlStore", "versao", "versaoAndroid", "valorIsencaoEntrega", "aberto", "versaoIOS", "sobre", "aceitaPedidosAuto", "aceitaComandasAuto", "valorTarifaUnica", "dataDeCadastro", "dataInicioDeUtilizacao", "fusoHorario", "imprimePedidosAuto", "emailPagSeguro", "tokenPagSeguro", "ativo", "parcelaMinima", "maximoDeParcelas", "tokenFcm", "idStore", "quantidadeImpressoes", "fazDelivery", "fazRetirada", "imprimePedidosDistribuidosAuto", "emTeste", "valorMinimoParaEntrega", "latitude", "longitude", "facebookPixelId", "porcentagemDoCashback", "versaoVendas", "versaoVendasAndroid", "versaoVendasIos", "valorPlano", "limitePedidos", "valorPedidoExcedente", "diaVencimentoMensalidade", "porcentagemOutraPlataforma", "porcentagemDeComissao", "plano", "receberInformativos", "endereco"})
    private Empresa empresa;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="usuario_id")
    private Usuario usuario;
    @Column(name="nome")
    private String nome;
    @Column(name="cpf")
    private String cpf;
    @Column(name="telefone")
    private String telefone;
    @Temporal(value=TemporalType.DATE)
    @Column(name="dt_cadastro")
    private Date dataCadastro;
    @Temporal(value=TemporalType.DATE)
    @Column(name="dt_nascimento")
    private Date dataNascimento;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="dthr_atualizacao")
    private Date dataHoraAtualizacao;
    @Column(name="ind_ativacao")
    private Boolean ativo;
    @Column(name="ind_bloqueio_pagamento_online")
    private Boolean pagamentoOnlineBloqueado;
    @Column(name="codigo_pdv")
    private Long codigoDoPdv;
    @Column(name="observacoes")
    private String observacoes;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ind_tipo_pessoa")
    private TipoPessoa tipoPessoa;
    @JsonIgnoreProperties(allowSetters=true)
    @OneToMany(mappedBy="cliente", fetch=FetchType.LAZY)
    Set<EnderecoDeEntrega> enderecosDeEntrega = new HashSet();
    @OneToMany(mappedBy="cliente", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @JsonIgnore
    private Set<CupomUtilizado> cuponsUtilizados;
    @OneToMany(mappedBy="cliente", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @JsonIgnore
    private Set<SolicitacaoDeAtivacao> solicitacoesDeAtivacao;
    @OneToMany(mappedBy="cliente", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @JsonIgnore
    private Set<CancelamentoDaConta> cancelamentosDaConta;

    public Cliente() {
    }

    public Cliente(Long id) {
        this.id = id;
    }

    public Cliente(Long id, String nome) {
        this.id = id;
        this.nome = nome;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public Date getDataHoraAtualizacao() {
        return this.dataHoraAtualizacao;
    }

    public void setDataHoraAtualizacao(Date dataHoraAtualizacao) {
        this.dataHoraAtualizacao = dataHoraAtualizacao;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public Boolean getPagamentoOnlineBloqueado() {
        return this.pagamentoOnlineBloqueado;
    }

    public void setPagamentoOnlineBloqueado(Boolean pagamentoOnlineBloqueado) {
        this.pagamentoOnlineBloqueado = pagamentoOnlineBloqueado;
    }

    public Long getCodigoDoPdv() {
        return this.codigoDoPdv;
    }

    public void setCodigoDoPdv(Long codigoDoPdv) {
        this.codigoDoPdv = codigoDoPdv;
    }

    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    public Set<EnderecoDeEntrega> getEnderecosDeEntrega() {
        return this.enderecosDeEntrega;
    }

    public void setEnderecosDeEntrega(Set<EnderecoDeEntrega> enderecosDeEntrega) {
        this.enderecosDeEntrega = enderecosDeEntrega;
    }

    public Set<CupomUtilizado> getCuponsUtilizados() {
        return this.cuponsUtilizados;
    }

    public void setCuponsUtilizados(Set<CupomUtilizado> cuponsUtilizados) {
        this.cuponsUtilizados = cuponsUtilizados;
    }

    public Set<SolicitacaoDeAtivacao> getSolicitacoesDeAtivacao() {
        return this.solicitacoesDeAtivacao;
    }

    public void setSolicitacoesDeAtivacao(Set<SolicitacaoDeAtivacao> solicitacoesDeAtivacao) {
        this.solicitacoesDeAtivacao = solicitacoesDeAtivacao;
    }

    public Set<CancelamentoDaConta> getCancelamentosDaConta() {
        return this.cancelamentosDaConta;
    }

    public void setCancelamentosDaConta(Set<CancelamentoDaConta> cancelamentosDaConta) {
        this.cancelamentosDaConta = cancelamentosDaConta;
    }

    @Transient
    public String getEmail() {
        if (this.usuario != null) {
            return this.usuario.getLogin();
        }
        return "";
    }
}

