exports.ids = [17];
exports.modules = {

/***/ "Vyzf":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@angular/core/fesm2015/core.js
var core = __webpack_require__("8Y7J");

// CONCATENATED MODULE: ./src/app/pages/company/settings/settings.module.ts
class SettingsModule {
}

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/angular-fontawesome.ngfactory.js
var angular_fontawesome_ngfactory = __webpack_require__("fNgX");

// EXTERNAL MODULE: ./node_modules/@angular/router/router.ngfactory.js
var router_ngfactory = __webpack_require__("pMnS");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/index.ngfactory.js
var index_ngfactory = __webpack_require__("jXVt");

// CONCATENATED MODULE: ./src/app/pages/company/settings/settings.component.scss.shim.ngstyle.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 
var styles = ["div.form-content[_ngcontent-%COMP%] > div.col-10[_ngcontent-%COMP%]{padding:0}"];


// EXTERNAL MODULE: ./src/app/shared/ui/field/field.component.ngfactory.js + 1 modules
var field_component_ngfactory = __webpack_require__("jZyr");

// EXTERNAL MODULE: ./src/app/shared/ui/field/field.component.ts
var field_component = __webpack_require__("jaPl");

// EXTERNAL MODULE: ./node_modules/@angular/forms/fesm2015/forms.js
var fesm2015_forms = __webpack_require__("s7LF");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/fesm2015/index.js + 5 modules
var fesm2015 = __webpack_require__("tKwJ");

// EXTERNAL MODULE: ./src/app/shared/directives/input-decimal.directive.ts
var input_decimal_directive = __webpack_require__("O7kp");

// EXTERNAL MODULE: ./node_modules/@angular/common/fesm2015/common.js
var common = __webpack_require__("SVse");

// EXTERNAL MODULE: ./src/app/shared/directives/input-integer.directive.ts
var input_integer_directive = __webpack_require__("CwyO");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ngfactory.js + 1 modules
var page_title_component_ngfactory = __webpack_require__("laEC");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ts
var page_title_component = __webpack_require__("S4p5");

// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ngfactory.js + 1 modules
var form_container_component_ngfactory = __webpack_require__("+aW9");

// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ts
var form_container_component = __webpack_require__("NX1Y");

// EXTERNAL MODULE: ./src/app/shared/services/alert.service.ts
var alert_service = __webpack_require__("Cmua");

// EXTERNAL MODULE: ./src/app/shared/services/auth.service.ts + 3 modules
var auth_service = __webpack_require__("IYfF");

// EXTERNAL MODULE: ./src/app/shared/services/messages.service.ts + 1 modules
var messages_service = __webpack_require__("N7YL");

// EXTERNAL MODULE: ./node_modules/@angular/router/fesm2015/router.js + 5 modules
var router = __webpack_require__("iInd");

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/fesm2015/angular-fontawesome.js
var angular_fontawesome = __webpack_require__("Nv++");

// EXTERNAL MODULE: ./node_modules/@angular/platform-browser/fesm2015/platform-browser.js
var platform_browser = __webpack_require__("cUpR");

// EXTERNAL MODULE: ./node_modules/tslib/tslib.js
var tslib = __webpack_require__("zOht");

// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/index.js
var free_solid_svg_icons = __webpack_require__("YTkO");

// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-form.component.ts
var base_form_component = __webpack_require__("rduj");

// EXTERNAL MODULE: ./src/app/shared/enums/controle-estoque.ts
var controle_estoque = __webpack_require__("++8y");

// CONCATENATED MODULE: ./src/app/shared/enums/fuso-horario.ts
class FusoHorario {
    constructor(id, descricao, diferencaHoras, referencia) {
        this.id = id;
        this.descricao = descricao;
        this.diferencaHoras = diferencaHoras;
        this.referencia = referencia;
    }
}
const FUSO_HORARIO = {
    BRASILIA: new FusoHorario(1, 'Brasília', 0, 'BRASILIA'),
    AMAZONIA: new FusoHorario(2, 'Amazônia', -1, 'AMAZONIA'),
    ACRE: new FusoHorario(3, 'Acre', -2, 'ACRE'),
    FERNANDO_DE_NORONHA: new FusoHorario(4, 'Fernando de Noronha', 1, 'FERNANDO_DE_NORONHA')
};

// EXTERNAL MODULE: ./src/app/shared/models/resource.ts
var resource = __webpack_require__("05o1");

// CONCATENATED MODULE: ./src/app/shared/models/plano.ts

class plano_Plano extends resource["a" /* Resource */] {
    constructor(id) {
        super();
        this.id = id ? id : null;
    }
}

// EXTERNAL MODULE: ./src/app/shared/utils/null.util.ts
var null_util = __webpack_require__("5tvI");

// EXTERNAL MODULE: ./src/app/shared/utils/number.util.ts
var number_util = __webpack_require__("qzEW");

// EXTERNAL MODULE: ./src/app/shared/utils/string.util.ts
var string_util = __webpack_require__("8n1d");

// EXTERNAL MODULE: ./src/environments/environment.ts
var environment = __webpack_require__("AytR");

// CONCATENATED MODULE: ./src/app/pages/company/settings/settings.component.ts













class settings_component_SettingsComponent extends base_form_component["a" /* BaseFormComponent */] {
    constructor(cd, alertService, authService, messagesService, requestService, toastrService, formBuilder, router, companyService, planService, productService) {
        super(alertService, authService, messagesService, requestService, toastrService);
        this.cd = cd;
        this.formBuilder = formBuilder;
        this.router = router;
        this.companyService = companyService;
        this.planService = planService;
        this.productService = productService;
        this.activeTab = 'config-gerais';
        this.authorizationCodeVerifier = '';
        this.errorPasswordMsg = '';
        this.hasCashback = false;
        this.hasDeliveryFeeByRadius = false;
        this.hasOnlineMenu = false;
        this.hidePassword = true;
        this.hideConfirmPassword = true;
        this.isAdmin = false;
        this.portalLink = '';
        this.timeZones = [];
        this.companyService.companyId = this.authService.loggedUser.id;
        this.planService.companyId = this.authService.loggedUser.id;
        this.productService.companyId = this.authService.loggedUser.id;
    }
    get hasStoreId() {
        return null_util["a" /* NullUtil */].isNotNull(this.authService.loggedUser.idStore);
    }
    get hideIcon() {
        return free_solid_svg_icons["faEyeSlash"];
    }
    get showIcon() {
        return free_solid_svg_icons["faEye"];
    }
    get settingsIcon() {
        return free_solid_svg_icons["faCogs"];
    }
    ngOnInit() {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            this.populateTimeZones();
            this.loadCompanyConfigs();
            this.loadPlans();
            this.loadInstances();
            this.loadStockControls();
            this.initForm();
            this.loadFormData();
            this.isAdmin = null_util["a" /* NullUtil */].isNotNull(this.authService.loggedUser.logadoComoAdm)
                && this.authService.loggedUser.logadoComoAdm;
            this.cd.detectChanges();
        });
    }
    back() {
        this.router.navigate(['admin/home']);
    }
    changePlan(id) {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            if (number_util["a" /* NumberUtil */].isNotNullOrZero(id)) {
                this.loadState();
                const plan = yield this.planService.get(id).toPromise().then(plan => plan)
                    .catch(() => null);
                if (plan) {
                    this.form.get('planValue').setValue(Object(common["D" /* formatNumber */])(plan.valor, 'pt-BR', '1.2-2'));
                }
                else {
                    this.form.get('planValue').setValue('');
                }
                this.loadState();
                this.cd.detectChanges();
            }
        });
    }
    checkDiscountWithMoneyPayment(checked) {
        if (!checked) {
            this.form.get('discountWithMoneyPaymentValue').setValue('');
            this.form.get('discountWithMoneyPaymentValue').clearAsyncValidators();
        }
        else {
            this.form.get('discountWithMoneyPaymentValue').setValidators(fesm2015_forms["z" /* Validators */].required);
        }
        this.form.get('discountWithMoneyPaymentValue').updateValueAndValidity();
        this.cd.detectChanges();
    }
    getAuthorizeUrl() {
        return `${environment["a" /* environment */].apiUrl}/menv/${this.authService.loggedUser.id}/authorize`;
    }
    iFoodLinkIsReady() {
        return this.portalLink.includes('ifood');
    }
    // TODO: Implementar nova forma de importar os produtos do IFood
    // async importProductsFromIFood() {
    //     this.loadState();
    //     const iFoodStoreLink = `${this.formData.iFoodStoreLink}`;
    //     await this.iFoodService.importProductsFromIFood(iFoodStoreLink).toPromise().then(() => {
    //         this.loadState();
    //         this.cd.detectChanges();
    //     }).catch((resp: HttpErrorResponse) => {
    //         this.requestService.handleError(resp, this.toastrService);
    //         this.loadState();
    //     })
    // }
    initForm() {
        this.form = this.formBuilder.group({
            storeId: [''],
            fusoHorario: [''],
            cashbackPercentage: [''],
            printQuantity: ['', [fesm2015_forms["z" /* Validators */].required, fesm2015_forms["z" /* Validators */].min(1)]],
            stockControl: [controle_estoque["a" /* CONTROLE_DE_ESTOQUE */].SEM_CONTROLE.referencia],
            autoAcceptOrders: [false],
            autoAcceptOrdersOnTable: [false],
            autoPrintOrders: [false],
            autoPrintDistributedOrders: [false],
            initTour: [false],
            uniqueDeliveryChargeValue: [''],
            valorIsencaoEntrega: [''],
            minValueToDeliver: [''],
            enableDelivery: [false],
            enableWithdraw: [false],
            integrationId: [''],
            clientId: [''],
            clientSecret: [''],
            accessToken: [''],
            refreshToken: [''],
            supportName: [''],
            supportEmail: [''],
            callbackUrl: [''],
            latitude: [''],
            longitude: [''],
            minimumValue: [''],
            maximumInstallments: [''],
            applyDiscountWithMoneyPayment: [false],
            discountWithMoneyPaymentValue: [''],
            password: ['', fesm2015_forms["z" /* Validators */].minLength(8)],
            confirmPassword: ['', fesm2015_forms["z" /* Validators */].minLength(8)],
            iFoodAuthCode: ['', fesm2015_forms["z" /* Validators */].maxLength(9)],
            merchantId: [''],
            iFoodStoreLink: [''],
            planId: [''],
            planValue: [''],
            monthlyDueDay: [''],
            limitOrders: [''],
            surplusValue: [''],
            anotherPlatformPercentage: [''],
            comissionPercentage: [''],
            receiveNews: [''],
            atosBotId: [''],
            server: ['', fesm2015_forms["z" /* Validators */].required],
            whatsapp: [false],
            instance: ['', fesm2015_forms["z" /* Validators */].required]
        });
    }
    loadFormData() {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            this.loadState();
            const company = yield this.companyService.get().toPromise()
                .then(company => company)
                .catch((resp) => {
                this.loadState();
                this.requestService.handleError(resp, this.toastrService);
                return null;
            });
            if (company) {
                this.form.patchValue({
                    storeId: company.idStore || null,
                    fusoHorario: company.fusoHorario,
                    printQuantity: company.quantidadeImpressoes,
                    stockControl: company.controleEstoque,
                    autoAcceptOrders: company.aceitaPedidosAuto,
                    autoAcceptOrdersOnTable: company.aceitaComandasAuto,
                    autoPrintOrders: company.imprimePedidosAuto,
                    autoPrintDistributedOrders: company.imprimePedidosDistribuidosAuto,
                    initTour: company.iniciarTour,
                    uniqueDeliveryChargeValue: Object(common["D" /* formatNumber */])(company.valorTarifaUnica || 0, 'pt-BR', '1.2-2'),
                    valorIsencaoEntrega: company.valorIsencaoEntrega
                        ? Object(common["D" /* formatNumber */])(company.valorIsencaoEntrega, 'pt-BR', '1.2-2')
                        : '',
                    minValueToDeliver: company.valorMinimoParaEntrega
                        ? Object(common["D" /* formatNumber */])(company.valorMinimoParaEntrega, 'pt-BR', '1.2-2') : '',
                    enableDelivery: company.fazDelivery,
                    enableWithdraw: company.fazRetirada,
                    cashbackPercentage: Object(common["D" /* formatNumber */])(company.porcentagemDoCashback || 0, 'pt-BR', '1.2-2'),
                    minimumValue: Object(common["D" /* formatNumber */])(company.parcelaMinima, 'pt-BR', '1.2-2'),
                    maximumInstallments: Object(common["D" /* formatNumber */])(company.maximoDeParcelas, 'pt-BR', '1.0-0'),
                    applyDiscountWithMoneyPayment: company.descontoPagamentoEmDinheiro || false,
                    discountWithMoneyPaymentValue: number_util["a" /* NumberUtil */].isNotNullOrZero(company.valorDescontoPagamentoEmDinheiro)
                        ? Object(common["D" /* formatNumber */])(company.valorDescontoPagamentoEmDinheiro, 'pt-BR', '1.2-2') : null,
                    latitude: company.latitude,
                    longitude: company.longitude,
                    planId: company.plano ? company.plano.id : null,
                    planValue: Object(common["D" /* formatNumber */])((company.valorPlano || 0), 'pt-BR', '1.2-2'),
                    monthlyDueDay: company.diaVencimentoMensalidade,
                    limitOrders: company.limitePedidos,
                    surplusValue: Object(common["D" /* formatNumber */])((company.valorPedidoExcedente || 0), 'pt-BR', '1.2-2'),
                    anotherPlatformPercentage: company.porcentagemOutraPlataforma,
                    comissionPercentage: Object(common["D" /* formatNumber */])((company.porcentagemDeComissao || 0), 'pt-BR', '1.2-2'),
                    receiveNews: company.receberInformativos || false,
                    atosBotId: company.atosBotId,
                    server: company.servidor,
                    instance: company.instancia,
                    whatsapp: company.whatsapp || false
                });
            }
            this.loadState();
            this.cd.detectChanges();
        });
    }
    loggedAsAdmin() {
        return this.authService.loggedUser.logadoComoAdm;
    }
    onTabChange(event) {
        this.activeTab = event.tabId;
        this.cd.detectChanges();
    }
    resetProducts() {
        this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.030', ['Produtos']), (result) => {
            if (result.value) {
                if (this.inDemoMode()) {
                    return;
                }
                this.productService.resetProducts().subscribe(() => {
                    this.alertService.success(this.messagesService.getMessage('MSG.SUCESSO.041', ['Produtos']));
                    this.cd.detectChanges();
                }, resp => {
                    this.requestService.handleError(resp, this.toastrService);
                    this.cd.detectChanges();
                });
            }
        });
    }
    showFeedback() { }
    submit() {
        if (!string_util["a" /* StringUtil */].isBlank(this.formData.password) || !string_util["a" /* StringUtil */].isBlank(this.formData.confirmPassword))
            if (!this.validateAuthenticationChange())
                return;
        this.form.get('confirmPassword').setErrors(null);
        this.errorPasswordMsg = '';
        const company = this.populateCompanySettings();
        const isAdmin = null_util["a" /* NullUtil */].isNotNull(this.authService.loggedUser.logadoComoAdm)
            && this.authService.loggedUser.logadoComoAdm;
        this.loadState();
        this.companyService.updateCompanySettings(company).subscribe(() => {
            this.loadState();
            this.alertService.success(this.messagesService.getMessage('MSG.SUCESSO.021', ['Empresa']), () => {
                const aux = company.foto;
                company.foto = company.logotipo;
                company.logotipo = aux;
                company.logadoComoAdm = isAdmin;
                this.authService.loggedUser = company;
                this.activeTab = 'config-gerais';
                this.cd.detectChanges();
            });
        }, (resp) => {
            this.loadState();
            this.handleError(resp);
            this.cd.detectChanges();
        });
    }
    loadCompanyConfigs() {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            this.hasOnlineMenu = yield this.companyService.getCompanyConfig('config-cardapio-digital').toPromise()
                .then(config => config.valor === '1');
            this.hasCashback = yield this.companyService.getCompanyConfig('config-ativar-cashback').toPromise()
                .then(config => config.valor === '1');
            this.hasDeliveryFeeByRadius = yield this.companyService.getCompanyConfig('config-criterio-taxa-entrega').toPromise()
                .then(config => config.valor === 'Raio');
            this.cd.detectChanges();
        });
    }
    loadPlans() {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            this.planOptions = yield this.planService.listPlanOptions().toPromise()
                .then(options => options).catch(() => []);
            this.cd.detectChanges();
        });
    }
    loadInstances() {
        this.instanceOptions = [
            { label: 'Instância 1', value: '1' },
            { label: 'Instância 2', value: '2' },
            { label: 'Instância 3', value: '3' },
            { label: 'Instância 4', value: '4' }
        ];
    }
    loadStockControls() {
        this.stockControlOptions = [
            {
                label: controle_estoque["a" /* CONTROLE_DE_ESTOQUE */].SEM_CONTROLE.descricao,
                value: controle_estoque["a" /* CONTROLE_DE_ESTOQUE */].SEM_CONTROLE.referencia
            },
            {
                label: controle_estoque["a" /* CONTROLE_DE_ESTOQUE */].CONCENTRE.descricao,
                value: controle_estoque["a" /* CONTROLE_DE_ESTOQUE */].CONCENTRE.referencia
            },
            {
                label: controle_estoque["a" /* CONTROLE_DE_ESTOQUE */].EXTERNO.descricao,
                value: controle_estoque["a" /* CONTROLE_DE_ESTOQUE */].EXTERNO.referencia
            }
        ];
    }
    populateCompanySettings() {
        const company = this.authService.loggedUser;
        company.idStore = this.formData.storeId;
        company.fusoHorario = this.formData.fusoHorario;
        company.porcentagemDoCashback = number_util["a" /* NumberUtil */].parseDecimal(this.formData.cashbackPercentage || 0);
        company.quantidadeImpressoes = this.formData.printQuantity;
        company.controleEstoque = this.formData.stockControl;
        company.atosBotId = this.formData.atosBotId;
        company.servidor = this.formData.server;
        company.instancia = this.formData.instance;
        company.whatsapp = this.formData.whatsapp;
        company.aceitaPedidosAuto = this.formData.autoAcceptOrders;
        company.aceitaComandasAuto = this.formData.autoAcceptOrdersOnTable;
        company.imprimePedidosAuto = this.formData.autoPrintOrders;
        company.imprimePedidosDistribuidosAuto = this.formData.autoPrintDistributedOrders;
        company.iniciarTour = this.formData.initTour;
        company.valorTarifaUnica = number_util["a" /* NumberUtil */].parseDecimal(this.formData.uniqueDeliveryChargeValue);
        company.valorIsencaoEntrega = number_util["a" /* NumberUtil */].parseDecimal(this.formData.valorIsencaoEntrega);
        company.valorMinimoParaEntrega = number_util["a" /* NumberUtil */].parseDecimal(this.formData.minValueToDeliver);
        company.fazDelivery = this.formData.enableDelivery;
        company.fazRetirada = this.formData.enableWithdraw;
        company.latitude = this.formData.latitude;
        company.longitude = this.formData.longitude;
        company.parcelaMinima = number_util["a" /* NumberUtil */].parseDecimal(this.formData.minimumValue);
        company.maximoDeParcelas = this.formData.maximumInstallments;
        company.descontoPagamentoEmDinheiro = this.formData.applyDiscountWithMoneyPayment || false;
        company.valorDescontoPagamentoEmDinheiro = number_util["a" /* NumberUtil */].parseDecimal(this.formData.discountWithMoneyPaymentValue);
        company.senha = this.formData.password;
        company.confirmacaoSenha = this.formData.confirmPassword;
        company.plano = number_util["a" /* NumberUtil */].isNotNullOrZero(this.formData.planId) ? new plano_Plano(this.formData.planId) : null;
        company.valorPlano = number_util["a" /* NumberUtil */].parseDecimal(this.formData.planValue);
        company.valorPedidoExcedente = number_util["a" /* NumberUtil */].parseDecimal(this.formData.surplusValue);
        company.diaVencimentoMensalidade = this.formData.monthlyDueDay;
        company.porcentagemOutraPlataforma = this.formData.anotherPlatformPercentage;
        company.porcentagemDeComissao = number_util["a" /* NumberUtil */].parseDecimal(this.formData.comissionPercentage);
        return company;
    }
    populateTimeZones() {
        this.timeZones = [
            FUSO_HORARIO.ACRE,
            FUSO_HORARIO.AMAZONIA,
            FUSO_HORARIO.BRASILIA,
            FUSO_HORARIO.FERNANDO_DE_NORONHA
        ];
    }
    validateAuthenticationChange() {
        if (string_util["a" /* StringUtil */].isBlank(this.formData.password)) {
            this.toastrService.warning(this.messagesService.getMessage('MSG.ERRO.001', ['Nova senha']));
            return false;
        }
        if (string_util["a" /* StringUtil */].isBlank(this.formData.confirmPassword)) {
            this.toastrService.warning(this.messagesService.getMessage('MSG.ERRO.001', ['Confirmação da senha']));
            return false;
        }
        this.form.get('confirmPassword').setErrors((this.formData.password !== this.formData.confirmPassword) ? { invalid: true } : null);
        this.errorPasswordMsg = (this.formData.password !== this.formData.confirmPassword)
            ? this.messagesService.getMessage('MSG.ERRO.004') : '';
        if (this.formData.password !== this.formData.confirmPassword) {
            return false;
        }
        return true;
    }
}

// EXTERNAL MODULE: ./src/app/shared/services/request.service.ts
var request_service = __webpack_require__("a9NN");

// EXTERNAL MODULE: ./src/app/shared/services/empresa.service.ts
var empresa_service = __webpack_require__("x715");

// EXTERNAL MODULE: ./src/app/shared/services/resource.service.ts
var resource_service = __webpack_require__("edFq");

// EXTERNAL MODULE: ./node_modules/@angular/common/fesm2015/http.js
var http = __webpack_require__("IheW");

// CONCATENATED MODULE: ./src/app/shared/services/plano.service.ts



class plano_service_PlanoService extends resource_service["a" /* ResourceService */] {
    constructor(http) {
        super(http, 'admin/planos');
    }
    /**
     * Lista todas as opções de planos para seleção.
     * @returns Observable<DataOption[]>
     */
    listPlanOptions() {
        return this.http.get(`${this.api}/${this.endpoint}/opcoes`);
    }
}
plano_service_PlanoService.ngInjectableDef = core["ɵɵdefineInjectable"]({ factory: function PlanoService_Factory() { return new plano_service_PlanoService(core["ɵɵinject"](http["c" /* HttpClient */])); }, token: plano_service_PlanoService, providedIn: "root" });

// EXTERNAL MODULE: ./src/app/shared/services/produto.service.ts
var produto_service = __webpack_require__("RVWZ");

// CONCATENATED MODULE: ./src/app/pages/company/settings/settings.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 


























var styles_SettingsComponent = [styles];
var RenderType_SettingsComponent = core["ɵcrt"]({ encapsulation: 0, styles: styles_SettingsComponent, data: {} });

function View_SettingsComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 9, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 8, "omni-field", [["field", "storeId"], ["label", "ID da Loja Virtual"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](2, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showPopover: [3, "showPopover"], popoverTemplate: [4, "popoverTemplate"] }, null), (_l()(), core["ɵeld"](3, 0, null, 0, 6, "input", [["formControlName", "storeId"], ["fullWidth", ""], ["nbInput", ""], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 4)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 4).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 4)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 4)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](4, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](6, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](8, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](9, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = "storeId"; var currVal_1 = _co.form; var currVal_2 = "ID da Loja Virtual"; var currVal_3 = true; var currVal_4 = core["ɵnov"](_v.parent, 269); _ck(_v, 2, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4); var currVal_29 = "storeId"; _ck(_v, 6, 0, currVal_29); var currVal_30 = "primary"; var currVal_31 = ""; _ck(_v, 9, 0, currVal_30, currVal_31); }, function (_ck, _v) { var _co = _v.component; var currVal_5 = (!_co.loggedAsAdmin() ? true : null); var currVal_6 = core["ɵnov"](_v, 8).ngClassUntouched; var currVal_7 = core["ɵnov"](_v, 8).ngClassTouched; var currVal_8 = core["ɵnov"](_v, 8).ngClassPristine; var currVal_9 = core["ɵnov"](_v, 8).ngClassDirty; var currVal_10 = core["ɵnov"](_v, 8).ngClassValid; var currVal_11 = core["ɵnov"](_v, 8).ngClassInvalid; var currVal_12 = core["ɵnov"](_v, 8).ngClassPending; var currVal_13 = core["ɵnov"](_v, 9).fullWidth; var currVal_14 = core["ɵnov"](_v, 9).tiny; var currVal_15 = core["ɵnov"](_v, 9).small; var currVal_16 = core["ɵnov"](_v, 9).medium; var currVal_17 = core["ɵnov"](_v, 9).large; var currVal_18 = core["ɵnov"](_v, 9).giant; var currVal_19 = core["ɵnov"](_v, 9).primary; var currVal_20 = core["ɵnov"](_v, 9).info; var currVal_21 = core["ɵnov"](_v, 9).success; var currVal_22 = core["ɵnov"](_v, 9).warning; var currVal_23 = core["ɵnov"](_v, 9).danger; var currVal_24 = core["ɵnov"](_v, 9).basic; var currVal_25 = core["ɵnov"](_v, 9).control; var currVal_26 = core["ɵnov"](_v, 9).rectangle; var currVal_27 = core["ɵnov"](_v, 9).semiRound; var currVal_28 = core["ɵnov"](_v, 9).round; _ck(_v, 3, 1, [currVal_5, currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28]); }); }
function View_SettingsComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-option", [], [[2, "selected", null], [1, "disabled", 0], [8, "tabIndex", 0]], [[null, "click"], [null, "keydown.space"], [null, "keydown.enter"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("keydown.space" === en)) {
        var pd_1 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_1 && ad);
    } if (("keydown.enter" === en)) {
        var pd_2 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, index_ngfactory["Z" /* View_NbOptionComponent_0 */], index_ngfactory["C" /* RenderType_NbOptionComponent */])), core["ɵdid"](1, 180224, [[2, 4]], 0, fesm2015["yc" /* NbOptionComponent */], [fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], core["ElementRef"], core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_3 = _v.context.$implicit.referencia; _ck(_v, 1, 0, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).selectedClass; var currVal_1 = core["ɵnov"](_v, 1).disabledAttribute; var currVal_2 = core["ɵnov"](_v, 1).tabindex; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2); var currVal_4 = _v.context.$implicit.descricao; _ck(_v, 2, 0, currVal_4); }); }
function View_SettingsComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 12, "omni-field", [["field", "cashbackPercentage"], ["label", "% do Cashback"], ["popoverTemplate", "Informe o percentual de Cashback a ser creditado/descontado nos pedidos dos clientes."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](2, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showPopover: [3, "showPopover"], popoverTemplate: [4, "popoverTemplate"] }, null), (_l()(), core["ɵeld"](3, 0, null, 0, 10, "input", [["formControlName", "cashbackPercentage"], ["fullWidth", ""], ["maxlength", "6"], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0,00"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 4).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 4).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 5)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 5).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 5)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 5)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](4, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](5, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](6, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](9, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](11, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](12, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](13, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = "cashbackPercentage"; var currVal_1 = _co.form; var currVal_2 = "% do Cashback"; var currVal_3 = true; var currVal_4 = "Informe o percentual de Cashback a ser creditado/descontado nos pedidos dos clientes."; _ck(_v, 2, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4); var currVal_30 = _co.form.get("cashbackPercentage"); _ck(_v, 4, 0, currVal_30); var currVal_31 = "6"; _ck(_v, 6, 0, currVal_31); var currVal_32 = "cashbackPercentage"; _ck(_v, 9, 0, currVal_32); var currVal_33 = "primary"; var currVal_34 = ""; _ck(_v, 12, 0, currVal_33, currVal_34); var currVal_35 = _co.form.get("cashbackPercentage"); _ck(_v, 13, 0, currVal_35); }, function (_ck, _v) { var _co = _v.component; var currVal_5 = (_co.isLoading ? true : null); var currVal_6 = (core["ɵnov"](_v, 6).maxlength ? core["ɵnov"](_v, 6).maxlength : null); var currVal_7 = core["ɵnov"](_v, 11).ngClassUntouched; var currVal_8 = core["ɵnov"](_v, 11).ngClassTouched; var currVal_9 = core["ɵnov"](_v, 11).ngClassPristine; var currVal_10 = core["ɵnov"](_v, 11).ngClassDirty; var currVal_11 = core["ɵnov"](_v, 11).ngClassValid; var currVal_12 = core["ɵnov"](_v, 11).ngClassInvalid; var currVal_13 = core["ɵnov"](_v, 11).ngClassPending; var currVal_14 = core["ɵnov"](_v, 12).fullWidth; var currVal_15 = core["ɵnov"](_v, 12).tiny; var currVal_16 = core["ɵnov"](_v, 12).small; var currVal_17 = core["ɵnov"](_v, 12).medium; var currVal_18 = core["ɵnov"](_v, 12).large; var currVal_19 = core["ɵnov"](_v, 12).giant; var currVal_20 = core["ɵnov"](_v, 12).primary; var currVal_21 = core["ɵnov"](_v, 12).info; var currVal_22 = core["ɵnov"](_v, 12).success; var currVal_23 = core["ɵnov"](_v, 12).warning; var currVal_24 = core["ɵnov"](_v, 12).danger; var currVal_25 = core["ɵnov"](_v, 12).basic; var currVal_26 = core["ɵnov"](_v, 12).control; var currVal_27 = core["ɵnov"](_v, 12).rectangle; var currVal_28 = core["ɵnov"](_v, 12).semiRound; var currVal_29 = core["ɵnov"](_v, 12).round; _ck(_v, 3, 1, [currVal_5, currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29]); }); }
function View_SettingsComponent_5(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-option", [], [[2, "selected", null], [1, "disabled", 0], [8, "tabIndex", 0]], [[null, "click"], [null, "keydown.space"], [null, "keydown.enter"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("keydown.space" === en)) {
        var pd_1 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_1 && ad);
    } if (("keydown.enter" === en)) {
        var pd_2 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, index_ngfactory["Z" /* View_NbOptionComponent_0 */], index_ngfactory["C" /* RenderType_NbOptionComponent */])), core["ɵdid"](1, 180224, [[4, 4]], 0, fesm2015["yc" /* NbOptionComponent */], [fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], core["ElementRef"], core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_3 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).selectedClass; var currVal_1 = core["ɵnov"](_v, 1).disabledAttribute; var currVal_2 = core["ɵnov"](_v, 1).tabindex; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2); var currVal_4 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_4); }); }
function View_SettingsComponent_4(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 12, "omni-field", [["field", "server"], ["label", "Inst\u00E2ncia"], ["popoverTemplate", "Selecione em qual servidor a loja Pedido Agora do Cliente est\u00E1 instalada."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](2, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"], showPopover: [4, "showPopover"], popoverTemplate: [5, "popoverTemplate"] }, null), (_l()(), core["ɵeld"](3, 0, null, 0, 10, "nb-select", [["fullWidth", ""], ["placeholder", "Selecione a inst\u00E2ncia"], ["status", "primary"]], [[2, "appearance-outline", null], [2, "appearance-filled", null], [2, "appearance-hero", null], [2, "full-width", null], [2, "open", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["db" /* View_NbSelectComponent_0 */], index_ngfactory["G" /* RenderType_NbSelectComponent */])), core["ɵprd"](6144, null, fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], null, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](5, 5423104, null, 2, fesm2015["id" /* NbSelectComponent */], [fesm2015["g" /* NB_DOCUMENT */], fesm2015["Gc" /* NbOverlayService */], core["ElementRef"], fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], core["ChangeDetectorRef"], fesm2015["qe" /* ɵd */]], { status: [0, "status"], fullWidth: [1, "fullWidth"], placeholder: [2, "placeholder"] }, null), core["ɵqud"](603979776, 4, { options: 1 }), core["ɵqud"](603979776, 5, { customLabel: 0 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](9, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](11, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, 1, 1, null, View_SettingsComponent_5)), core["ɵdid"](13, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = "server"; var currVal_1 = _co.form; var currVal_2 = "Inst\u00E2ncia"; var currVal_3 = true; var currVal_4 = true; var currVal_5 = "Selecione em qual servidor a loja Pedido Agora do Cliente est\u00E1 instalada."; _ck(_v, 2, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5); var currVal_33 = "primary"; var currVal_34 = ""; var currVal_35 = "Selecione a inst\u00E2ncia"; _ck(_v, 5, 0, currVal_33, currVal_34, currVal_35); var currVal_36 = _co.form.get("instance"); _ck(_v, 9, 0, currVal_36); var currVal_37 = _co.instanceOptions; _ck(_v, 13, 0, currVal_37); }, function (_ck, _v) { var currVal_6 = core["ɵnov"](_v, 5).outline; var currVal_7 = core["ɵnov"](_v, 5).filled; var currVal_8 = core["ɵnov"](_v, 5).hero; var currVal_9 = core["ɵnov"](_v, 5).fullWidth; var currVal_10 = core["ɵnov"](_v, 5).isOpen; var currVal_11 = core["ɵnov"](_v, 5).tiny; var currVal_12 = core["ɵnov"](_v, 5).small; var currVal_13 = core["ɵnov"](_v, 5).medium; var currVal_14 = core["ɵnov"](_v, 5).large; var currVal_15 = core["ɵnov"](_v, 5).giant; var currVal_16 = core["ɵnov"](_v, 5).primary; var currVal_17 = core["ɵnov"](_v, 5).info; var currVal_18 = core["ɵnov"](_v, 5).success; var currVal_19 = core["ɵnov"](_v, 5).warning; var currVal_20 = core["ɵnov"](_v, 5).danger; var currVal_21 = core["ɵnov"](_v, 5).basic; var currVal_22 = core["ɵnov"](_v, 5).control; var currVal_23 = core["ɵnov"](_v, 5).rectangle; var currVal_24 = core["ɵnov"](_v, 5).round; var currVal_25 = core["ɵnov"](_v, 5).semiRound; var currVal_26 = core["ɵnov"](_v, 11).ngClassUntouched; var currVal_27 = core["ɵnov"](_v, 11).ngClassTouched; var currVal_28 = core["ɵnov"](_v, 11).ngClassPristine; var currVal_29 = core["ɵnov"](_v, 11).ngClassDirty; var currVal_30 = core["ɵnov"](_v, 11).ngClassValid; var currVal_31 = core["ɵnov"](_v, 11).ngClassInvalid; var currVal_32 = core["ɵnov"](_v, 11).ngClassPending; _ck(_v, 3, 1, [currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32]); }); }
function View_SettingsComponent_6(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-option", [], [[2, "selected", null], [1, "disabled", 0], [8, "tabIndex", 0]], [[null, "click"], [null, "keydown.space"], [null, "keydown.enter"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("keydown.space" === en)) {
        var pd_1 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_1 && ad);
    } if (("keydown.enter" === en)) {
        var pd_2 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, index_ngfactory["Z" /* View_NbOptionComponent_0 */], index_ngfactory["C" /* RenderType_NbOptionComponent */])), core["ɵdid"](1, 180224, [[6, 4]], 0, fesm2015["yc" /* NbOptionComponent */], [fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], core["ElementRef"], core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_3 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).selectedClass; var currVal_1 = core["ɵnov"](_v, 1).disabledAttribute; var currVal_2 = core["ɵnov"](_v, 1).tabindex; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2); var currVal_4 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_4); }); }
function View_SettingsComponent_7(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 36, "nb-tab", [["responsive", ""], ["tabIcon", "message-circle"], ["tabId", "atosbot"], ["tabTitle", "ATOS Bot"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](1, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](2, 0, null, 0, 34, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 11, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 10, "omni-field", [["field", "atosBotId"], ["label", "ID do Atos Bot:"], ["popoverTemplate", "Informe o c\u00F3digo de integra\u00E7\u00E3o do ATOS Bot para ativar o servi\u00E7o de mensageria por Whatsapp\u2122."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](5, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showPopover: [3, "showPopover"], popoverTemplate: [4, "popoverTemplate"] }, null), (_l()(), core["ɵeld"](6, 0, null, 0, 8, "input", [["formControlName", "atosBotId"], ["fullWidth", ""], ["maxlength", "50"], ["nbInput", ""], ["placeholder", "Informe o c\u00F3digo do servidor do ATOS Bot"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 7)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 7).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 7)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 7)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](7, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](8, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](11, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](13, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](14, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](15, 0, null, null, 11, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](16, 0, null, null, 10, "omni-field", [["field", "server"], ["label", "Servidor:"], ["popoverTemplate", "Informe o n\u00FAmero do servidor do ATOS Bot para apontar o servidor de origem do sistema de mensageria por Whatsapp\u2122."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](17, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showPopover: [3, "showPopover"], popoverTemplate: [4, "popoverTemplate"] }, null), (_l()(), core["ɵeld"](18, 0, null, 0, 8, "input", [["formControlName", "server"], ["fullWidth", ""], ["maxlength", "50"], ["nbInput", ""], ["placeholder", "Informe o n\u00FAmero do servidor"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 19)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 19).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 19)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 19)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](19, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](20, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](23, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](25, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](26, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](27, 0, null, null, 9, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](28, 0, null, null, 8, "omni-field", [["field", "atosBotId"], ["label", "Habilitar interga\u00E7\u00E3o com o ATOS Bot"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](29, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showHiddenLabel: [3, "showHiddenLabel"] }, null), (_l()(), core["ɵeld"](30, 0, null, 0, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](31, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](33, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](35, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Habilitar interga\u00E7\u00E3o com o ATOS Bot "]))], function (_ck, _v) { var _co = _v.component; var currVal_2 = "ATOS Bot"; var currVal_3 = "atosbot"; var currVal_4 = "message-circle"; var currVal_5 = ""; var currVal_6 = (_co.activeTab === "atosbot"); _ck(_v, 1, 0, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_7 = "atosBotId"; var currVal_8 = _co.form; var currVal_9 = "ID do Atos Bot:"; var currVal_10 = true; var currVal_11 = "Informe o c\u00F3digo de integra\u00E7\u00E3o do ATOS Bot para ativar o servi\u00E7o de mensageria por Whatsapp\u2122."; _ck(_v, 5, 0, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11); var currVal_37 = "50"; _ck(_v, 8, 0, currVal_37); var currVal_38 = "atosBotId"; _ck(_v, 11, 0, currVal_38); var currVal_39 = "primary"; var currVal_40 = ""; _ck(_v, 14, 0, currVal_39, currVal_40); var currVal_41 = "server"; var currVal_42 = _co.form; var currVal_43 = "Servidor:"; var currVal_44 = true; var currVal_45 = "Informe o n\u00FAmero do servidor do ATOS Bot para apontar o servidor de origem do sistema de mensageria por Whatsapp\u2122."; _ck(_v, 17, 0, currVal_41, currVal_42, currVal_43, currVal_44, currVal_45); var currVal_71 = "50"; _ck(_v, 20, 0, currVal_71); var currVal_72 = "server"; _ck(_v, 23, 0, currVal_72); var currVal_73 = "primary"; var currVal_74 = ""; _ck(_v, 26, 0, currVal_73, currVal_74); var currVal_75 = "atosBotId"; var currVal_76 = _co.form; var currVal_77 = "Habilitar interga\u00E7\u00E3o com o ATOS Bot"; var currVal_78 = true; _ck(_v, 29, 0, currVal_75, currVal_76, currVal_77, currVal_78); var currVal_93 = _co.isLoading; var currVal_94 = "primary"; _ck(_v, 31, 0, currVal_93, currVal_94); var currVal_95 = _co.form.get("whatsapp"); var currVal_96 = _co.isLoading; _ck(_v, 33, 0, currVal_95, currVal_96); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 1).disabled; var currVal_1 = core["ɵnov"](_v, 1).activeValue; _ck(_v, 0, 0, currVal_0, currVal_1); var currVal_12 = (_co.isLoading ? true : null); var currVal_13 = (core["ɵnov"](_v, 8).maxlength ? core["ɵnov"](_v, 8).maxlength : null); var currVal_14 = core["ɵnov"](_v, 13).ngClassUntouched; var currVal_15 = core["ɵnov"](_v, 13).ngClassTouched; var currVal_16 = core["ɵnov"](_v, 13).ngClassPristine; var currVal_17 = core["ɵnov"](_v, 13).ngClassDirty; var currVal_18 = core["ɵnov"](_v, 13).ngClassValid; var currVal_19 = core["ɵnov"](_v, 13).ngClassInvalid; var currVal_20 = core["ɵnov"](_v, 13).ngClassPending; var currVal_21 = core["ɵnov"](_v, 14).fullWidth; var currVal_22 = core["ɵnov"](_v, 14).tiny; var currVal_23 = core["ɵnov"](_v, 14).small; var currVal_24 = core["ɵnov"](_v, 14).medium; var currVal_25 = core["ɵnov"](_v, 14).large; var currVal_26 = core["ɵnov"](_v, 14).giant; var currVal_27 = core["ɵnov"](_v, 14).primary; var currVal_28 = core["ɵnov"](_v, 14).info; var currVal_29 = core["ɵnov"](_v, 14).success; var currVal_30 = core["ɵnov"](_v, 14).warning; var currVal_31 = core["ɵnov"](_v, 14).danger; var currVal_32 = core["ɵnov"](_v, 14).basic; var currVal_33 = core["ɵnov"](_v, 14).control; var currVal_34 = core["ɵnov"](_v, 14).rectangle; var currVal_35 = core["ɵnov"](_v, 14).semiRound; var currVal_36 = core["ɵnov"](_v, 14).round; _ck(_v, 6, 1, [currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34, currVal_35, currVal_36]); var currVal_46 = (_co.isLoading ? true : null); var currVal_47 = (core["ɵnov"](_v, 20).maxlength ? core["ɵnov"](_v, 20).maxlength : null); var currVal_48 = core["ɵnov"](_v, 25).ngClassUntouched; var currVal_49 = core["ɵnov"](_v, 25).ngClassTouched; var currVal_50 = core["ɵnov"](_v, 25).ngClassPristine; var currVal_51 = core["ɵnov"](_v, 25).ngClassDirty; var currVal_52 = core["ɵnov"](_v, 25).ngClassValid; var currVal_53 = core["ɵnov"](_v, 25).ngClassInvalid; var currVal_54 = core["ɵnov"](_v, 25).ngClassPending; var currVal_55 = core["ɵnov"](_v, 26).fullWidth; var currVal_56 = core["ɵnov"](_v, 26).tiny; var currVal_57 = core["ɵnov"](_v, 26).small; var currVal_58 = core["ɵnov"](_v, 26).medium; var currVal_59 = core["ɵnov"](_v, 26).large; var currVal_60 = core["ɵnov"](_v, 26).giant; var currVal_61 = core["ɵnov"](_v, 26).primary; var currVal_62 = core["ɵnov"](_v, 26).info; var currVal_63 = core["ɵnov"](_v, 26).success; var currVal_64 = core["ɵnov"](_v, 26).warning; var currVal_65 = core["ɵnov"](_v, 26).danger; var currVal_66 = core["ɵnov"](_v, 26).basic; var currVal_67 = core["ɵnov"](_v, 26).control; var currVal_68 = core["ɵnov"](_v, 26).rectangle; var currVal_69 = core["ɵnov"](_v, 26).semiRound; var currVal_70 = core["ɵnov"](_v, 26).round; _ck(_v, 18, 1, [currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58, currVal_59, currVal_60, currVal_61, currVal_62, currVal_63, currVal_64, currVal_65, currVal_66, currVal_67, currVal_68, currVal_69, currVal_70]); var currVal_79 = core["ɵnov"](_v, 31).primary; var currVal_80 = core["ɵnov"](_v, 31).success; var currVal_81 = core["ɵnov"](_v, 31).warning; var currVal_82 = core["ɵnov"](_v, 31).danger; var currVal_83 = core["ɵnov"](_v, 31).info; var currVal_84 = core["ɵnov"](_v, 31).basic; var currVal_85 = core["ɵnov"](_v, 31).control; var currVal_86 = core["ɵnov"](_v, 35).ngClassUntouched; var currVal_87 = core["ɵnov"](_v, 35).ngClassTouched; var currVal_88 = core["ɵnov"](_v, 35).ngClassPristine; var currVal_89 = core["ɵnov"](_v, 35).ngClassDirty; var currVal_90 = core["ɵnov"](_v, 35).ngClassValid; var currVal_91 = core["ɵnov"](_v, 35).ngClassInvalid; var currVal_92 = core["ɵnov"](_v, 35).ngClassPending; _ck(_v, 30, 1, [currVal_79, currVal_80, currVal_81, currVal_82, currVal_83, currVal_84, currVal_85, currVal_86, currVal_87, currVal_88, currVal_89, currVal_90, currVal_91, currVal_92]); }); }
function View_SettingsComponent_8(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 26, "nb-tab", [["responsive", ""], ["tabIcon", "pin"], ["tabId", "localizacao"], ["tabTitle", "Localiza\u00E7\u00E3o"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](1, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](2, 0, null, 0, 24, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 11, "div", [["class", "form-group col-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 10, "omni-field", [["field", "latitude"], ["label", "Latitude"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](5, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](6, 0, null, 0, 8, "input", [["formControlName", "latitude"], ["fullWidth", ""], ["maxlength", "20"], ["nbInput", ""], ["placeholder", "Informe a latitude"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 7)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 7).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 7)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 7)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](7, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](8, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](11, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](13, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](14, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](15, 0, null, null, 11, "div", [["class", "form-group col-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](16, 0, null, null, 10, "omni-field", [["field", "longitude"], ["label", "Longitude"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](17, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](18, 0, null, 0, 8, "input", [["formControlName", "longitude"], ["fullWidth", ""], ["maxlength", "20"], ["nbInput", ""], ["placeholder", "Informe a longitude"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 19)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 19).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 19)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 19)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](19, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](20, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](23, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](25, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](26, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_2 = "Localiza\u00E7\u00E3o"; var currVal_3 = "localizacao"; var currVal_4 = "pin"; var currVal_5 = ""; var currVal_6 = (_co.activeTab === "localizacao"); _ck(_v, 1, 0, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_7 = "latitude"; var currVal_8 = _co.form; var currVal_9 = "Latitude"; _ck(_v, 5, 0, currVal_7, currVal_8, currVal_9); var currVal_35 = "20"; _ck(_v, 8, 0, currVal_35); var currVal_36 = "latitude"; _ck(_v, 11, 0, currVal_36); var currVal_37 = "primary"; var currVal_38 = ""; _ck(_v, 14, 0, currVal_37, currVal_38); var currVal_39 = "longitude"; var currVal_40 = _co.form; var currVal_41 = "Longitude"; _ck(_v, 17, 0, currVal_39, currVal_40, currVal_41); var currVal_67 = "20"; _ck(_v, 20, 0, currVal_67); var currVal_68 = "longitude"; _ck(_v, 23, 0, currVal_68); var currVal_69 = "primary"; var currVal_70 = ""; _ck(_v, 26, 0, currVal_69, currVal_70); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 1).disabled; var currVal_1 = core["ɵnov"](_v, 1).activeValue; _ck(_v, 0, 0, currVal_0, currVal_1); var currVal_10 = (_co.isLoading ? true : null); var currVal_11 = (core["ɵnov"](_v, 8).maxlength ? core["ɵnov"](_v, 8).maxlength : null); var currVal_12 = core["ɵnov"](_v, 13).ngClassUntouched; var currVal_13 = core["ɵnov"](_v, 13).ngClassTouched; var currVal_14 = core["ɵnov"](_v, 13).ngClassPristine; var currVal_15 = core["ɵnov"](_v, 13).ngClassDirty; var currVal_16 = core["ɵnov"](_v, 13).ngClassValid; var currVal_17 = core["ɵnov"](_v, 13).ngClassInvalid; var currVal_18 = core["ɵnov"](_v, 13).ngClassPending; var currVal_19 = core["ɵnov"](_v, 14).fullWidth; var currVal_20 = core["ɵnov"](_v, 14).tiny; var currVal_21 = core["ɵnov"](_v, 14).small; var currVal_22 = core["ɵnov"](_v, 14).medium; var currVal_23 = core["ɵnov"](_v, 14).large; var currVal_24 = core["ɵnov"](_v, 14).giant; var currVal_25 = core["ɵnov"](_v, 14).primary; var currVal_26 = core["ɵnov"](_v, 14).info; var currVal_27 = core["ɵnov"](_v, 14).success; var currVal_28 = core["ɵnov"](_v, 14).warning; var currVal_29 = core["ɵnov"](_v, 14).danger; var currVal_30 = core["ɵnov"](_v, 14).basic; var currVal_31 = core["ɵnov"](_v, 14).control; var currVal_32 = core["ɵnov"](_v, 14).rectangle; var currVal_33 = core["ɵnov"](_v, 14).semiRound; var currVal_34 = core["ɵnov"](_v, 14).round; _ck(_v, 6, 1, [currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34]); var currVal_42 = (_co.isLoading ? true : null); var currVal_43 = (core["ɵnov"](_v, 20).maxlength ? core["ɵnov"](_v, 20).maxlength : null); var currVal_44 = core["ɵnov"](_v, 25).ngClassUntouched; var currVal_45 = core["ɵnov"](_v, 25).ngClassTouched; var currVal_46 = core["ɵnov"](_v, 25).ngClassPristine; var currVal_47 = core["ɵnov"](_v, 25).ngClassDirty; var currVal_48 = core["ɵnov"](_v, 25).ngClassValid; var currVal_49 = core["ɵnov"](_v, 25).ngClassInvalid; var currVal_50 = core["ɵnov"](_v, 25).ngClassPending; var currVal_51 = core["ɵnov"](_v, 26).fullWidth; var currVal_52 = core["ɵnov"](_v, 26).tiny; var currVal_53 = core["ɵnov"](_v, 26).small; var currVal_54 = core["ɵnov"](_v, 26).medium; var currVal_55 = core["ɵnov"](_v, 26).large; var currVal_56 = core["ɵnov"](_v, 26).giant; var currVal_57 = core["ɵnov"](_v, 26).primary; var currVal_58 = core["ɵnov"](_v, 26).info; var currVal_59 = core["ɵnov"](_v, 26).success; var currVal_60 = core["ɵnov"](_v, 26).warning; var currVal_61 = core["ɵnov"](_v, 26).danger; var currVal_62 = core["ɵnov"](_v, 26).basic; var currVal_63 = core["ɵnov"](_v, 26).control; var currVal_64 = core["ɵnov"](_v, 26).rectangle; var currVal_65 = core["ɵnov"](_v, 26).semiRound; var currVal_66 = core["ɵnov"](_v, 26).round; _ck(_v, 18, 1, [currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58, currVal_59, currVal_60, currVal_61, currVal_62, currVal_63, currVal_64, currVal_65, currVal_66]); }); }
function View_SettingsComponent_10(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-option", [], [[2, "selected", null], [1, "disabled", 0], [8, "tabIndex", 0]], [[null, "click"], [null, "keydown.space"], [null, "keydown.enter"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("keydown.space" === en)) {
        var pd_1 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_1 && ad);
    } if (("keydown.enter" === en)) {
        var pd_2 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, index_ngfactory["Z" /* View_NbOptionComponent_0 */], index_ngfactory["C" /* RenderType_NbOptionComponent */])), core["ɵdid"](1, 180224, [[8, 4]], 0, fesm2015["yc" /* NbOptionComponent */], [fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], core["ElementRef"], core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_3 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).selectedClass; var currVal_1 = core["ɵnov"](_v, 1).disabledAttribute; var currVal_2 = core["ɵnov"](_v, 1).tabindex; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2); var currVal_4 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_4); }); }
function View_SettingsComponent_9(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 112, "nb-tab", [["responsive", ""], ["tabIcon", "shopping-bag"], ["tabId", "plan"], ["tabTitle", "Plano"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](1, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](2, 0, null, 0, 101, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 16, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 15, "omni-field", [["field", "planId"], ["label", "Plano"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](5, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](6, 0, null, 0, 13, "nb-select", [["fullWidth", ""], ["placeholder", "Selecione o Plano"], ["status", "primary"]], [[2, "appearance-outline", null], [2, "appearance-filled", null], [2, "appearance-hero", null], [2, "full-width", null], [2, "open", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "selectedChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("selectedChange" === en)) {
        var pd_0 = (_co.changePlan($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["db" /* View_NbSelectComponent_0 */], index_ngfactory["G" /* RenderType_NbSelectComponent */])), core["ɵdid"](7, 5423104, null, 2, fesm2015["id" /* NbSelectComponent */], [fesm2015["g" /* NB_DOCUMENT */], fesm2015["Gc" /* NbOverlayService */], core["ElementRef"], fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], core["ChangeDetectorRef"], fesm2015["qe" /* ɵd */]], { status: [0, "status"], disabled: [1, "disabled"], fullWidth: [2, "fullWidth"], placeholder: [3, "placeholder"] }, { selectedChange: "selectedChange" }), core["ɵqud"](603979776, 8, { options: 1 }), core["ɵqud"](603979776, 9, { customLabel: 0 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](11, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](13, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵprd"](2048, null, fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], null, [fesm2015["id" /* NbSelectComponent */]]), (_l()(), core["ɵeld"](15, 0, null, 1, 2, "nb-option", [], [[2, "selected", null], [1, "disabled", 0], [8, "tabIndex", 0]], [[null, "click"], [null, "keydown.space"], [null, "keydown.enter"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 16).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("keydown.space" === en)) {
        var pd_1 = (core["ɵnov"](_v, 16).onClick($event) !== false);
        ad = (pd_1 && ad);
    } if (("keydown.enter" === en)) {
        var pd_2 = (core["ɵnov"](_v, 16).onClick($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, index_ngfactory["Z" /* View_NbOptionComponent_0 */], index_ngfactory["C" /* RenderType_NbOptionComponent */])), core["ɵdid"](16, 180224, [[8, 4]], 0, fesm2015["yc" /* NbOptionComponent */], [fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], core["ElementRef"], core["ChangeDetectorRef"]], null, null), (_l()(), core["ɵted"](-1, 0, ["Selecione o Plano"])), (_l()(), core["ɵand"](16777216, null, 1, 1, null, View_SettingsComponent_10)), core["ɵdid"](19, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](20, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](21, 0, null, null, 12, "omni-field", [["field", "planValue"], ["label", "Valor do Plano"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](22, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](23, 0, null, 0, 10, "input", [["formControlName", "planValue"], ["fullWidth", ""], ["maxlength", "8"], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0,00"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 24).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 24).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 25)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 25).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 25)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 25)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](24, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](25, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](26, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](29, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](31, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](32, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](33, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](34, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](35, 0, null, null, 12, "omni-field", [["field", "monthlyDueDay"], ["label", "Dia de vencimento da mensalidade"], ["tooltipText", "Informe um dia v\u00E1lido eentre os dias 1 e 31."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](36, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showTooltip: [3, "showTooltip"], tooltipText: [4, "tooltipText"] }, null), (_l()(), core["ɵeld"](37, 0, null, 0, 10, "input", [["formControlName", "monthlyDueDay"], ["fullWidth", ""], ["maxlength", "2"], ["nbInput", ""], ["omniInputInteger", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 38).onInput($event.target) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 38).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 39)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 39).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 39)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 39)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](38, 16384, null, 0, input_integer_directive["a" /* InputIntegerDirective */], [core["ElementRef"]], null, null), core["ɵdid"](39, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](40, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](43, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](45, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](46, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](47, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](48, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](49, 0, null, null, 12, "omni-field", [["field", "limitOrders"], ["label", "Limitar Pedidos"], ["tooltipText", "Quantidade de pedidos contemplados pelo plano gratuito."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](50, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showTooltip: [3, "showTooltip"], tooltipText: [4, "tooltipText"] }, null), (_l()(), core["ɵeld"](51, 0, null, 0, 10, "input", [["formControlName", "limitOrders"], ["fullWidth", ""], ["maxlength", "3"], ["nbInput", ""], ["omniInputInteger", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 52).onInput($event.target) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 52).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 53)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 53).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 53)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 53)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](52, 16384, null, 0, input_integer_directive["a" /* InputIntegerDirective */], [core["ElementRef"]], null, null), core["ɵdid"](53, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](54, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](57, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](59, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](60, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](61, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](62, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](63, 0, null, null, 12, "omni-field", [["field", "surplusValue"], ["label", "Valor excedente p/ Pedido"], ["tooltipText", "Valor unit\u00E1rio a ser cobrado para cada pedido excedente do limite do plano."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](64, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showTooltip: [3, "showTooltip"], tooltipText: [4, "tooltipText"] }, null), (_l()(), core["ɵeld"](65, 0, null, 0, 10, "input", [["formControlName", "surplusValue"], ["fullWidth", ""], ["maxlength", "8"], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 66).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 66).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 67)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 67).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 67)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 67)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](66, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](67, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](68, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](71, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](73, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](74, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](75, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](76, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](77, 0, null, null, 12, "omni-field", [["field", "anotherPlatformPercentage"], ["label", "% de Outras Plataformas"], ["tooltipText", "Porcentagem estimada que \u00E9 cobrada em plataformas."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](78, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showTooltip: [3, "showTooltip"], tooltipText: [4, "tooltipText"] }, null), (_l()(), core["ɵeld"](79, 0, null, 0, 10, "input", [["formControlName", "anotherPlatformPercentage"], ["fullWidth", ""], ["maxlength", "6"], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 80).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 80).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 81)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 81).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 81)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 81)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](80, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](81, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](82, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](85, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](87, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](88, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](89, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](90, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](91, 0, null, null, 12, "omni-field", [["field", "comissionPercentage"], ["label", "% de Comiss\u00E3o"], ["tooltipText", "Porcentagem estimada de comiss\u00E3o cobrada em plataformas."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](92, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showTooltip: [3, "showTooltip"], tooltipText: [4, "tooltipText"] }, null), (_l()(), core["ɵeld"](93, 0, null, 0, 10, "input", [["formControlName", "comissionPercentage"], ["fullWidth", ""], ["maxlength", "6"], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 94).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 94).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 95)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 95).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 95)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 95)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](94, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](95, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](96, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](99, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](101, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](102, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](103, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](104, 0, null, 0, 8, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](105, 0, null, null, 7, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](106, 0, null, null, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](107, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](109, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](111, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Receber Informativos "]))], function (_ck, _v) { var _co = _v.component; var currVal_2 = "Plano"; var currVal_3 = "plan"; var currVal_4 = "shopping-bag"; var currVal_5 = ""; var currVal_6 = (_co.activeTab === "plan"); _ck(_v, 1, 0, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_7 = "planId"; var currVal_8 = _co.form; var currVal_9 = "Plano"; _ck(_v, 5, 0, currVal_7, currVal_8, currVal_9); var currVal_37 = "primary"; var currVal_38 = _co.isLoading; var currVal_39 = ""; var currVal_40 = "Selecione o Plano"; _ck(_v, 7, 0, currVal_37, currVal_38, currVal_39, currVal_40); var currVal_41 = _co.form.get("planId"); var currVal_42 = _co.isLoading; _ck(_v, 11, 0, currVal_41, currVal_42); var currVal_46 = _co.planOptions; _ck(_v, 19, 0, currVal_46); var currVal_47 = "planValue"; var currVal_48 = _co.form; var currVal_49 = "Valor do Plano"; _ck(_v, 22, 0, currVal_47, currVal_48, currVal_49); var currVal_75 = _co.form.get("planValue"); _ck(_v, 24, 0, currVal_75); var currVal_76 = "8"; _ck(_v, 26, 0, currVal_76); var currVal_77 = "planValue"; _ck(_v, 29, 0, currVal_77); var currVal_78 = "primary"; var currVal_79 = ""; _ck(_v, 32, 0, currVal_78, currVal_79); var currVal_80 = _co.form.get("planValue"); _ck(_v, 33, 0, currVal_80); var currVal_81 = "monthlyDueDay"; var currVal_82 = _co.form; var currVal_83 = "Dia de vencimento da mensalidade"; var currVal_84 = true; var currVal_85 = "Informe um dia v\u00E1lido eentre os dias 1 e 31."; _ck(_v, 36, 0, currVal_81, currVal_82, currVal_83, currVal_84, currVal_85); var currVal_111 = "2"; _ck(_v, 40, 0, currVal_111); var currVal_112 = "monthlyDueDay"; _ck(_v, 43, 0, currVal_112); var currVal_113 = "primary"; var currVal_114 = ""; _ck(_v, 46, 0, currVal_113, currVal_114); var currVal_115 = _co.form.get("monthlyDueDay"); _ck(_v, 47, 0, currVal_115); var currVal_116 = "limitOrders"; var currVal_117 = _co.form; var currVal_118 = "Limitar Pedidos"; var currVal_119 = true; var currVal_120 = "Quantidade de pedidos contemplados pelo plano gratuito."; _ck(_v, 50, 0, currVal_116, currVal_117, currVal_118, currVal_119, currVal_120); var currVal_146 = "3"; _ck(_v, 54, 0, currVal_146); var currVal_147 = "limitOrders"; _ck(_v, 57, 0, currVal_147); var currVal_148 = "primary"; var currVal_149 = ""; _ck(_v, 60, 0, currVal_148, currVal_149); var currVal_150 = _co.form.get("limitOrders"); _ck(_v, 61, 0, currVal_150); var currVal_151 = "surplusValue"; var currVal_152 = _co.form; var currVal_153 = "Valor excedente p/ Pedido"; var currVal_154 = true; var currVal_155 = "Valor unit\u00E1rio a ser cobrado para cada pedido excedente do limite do plano."; _ck(_v, 64, 0, currVal_151, currVal_152, currVal_153, currVal_154, currVal_155); var currVal_181 = _co.form.get("surplusValue"); _ck(_v, 66, 0, currVal_181); var currVal_182 = "8"; _ck(_v, 68, 0, currVal_182); var currVal_183 = "surplusValue"; _ck(_v, 71, 0, currVal_183); var currVal_184 = "primary"; var currVal_185 = ""; _ck(_v, 74, 0, currVal_184, currVal_185); var currVal_186 = _co.form.get("surplusValue"); _ck(_v, 75, 0, currVal_186); var currVal_187 = "anotherPlatformPercentage"; var currVal_188 = _co.form; var currVal_189 = "% de Outras Plataformas"; var currVal_190 = true; var currVal_191 = "Porcentagem estimada que \u00E9 cobrada em plataformas."; _ck(_v, 78, 0, currVal_187, currVal_188, currVal_189, currVal_190, currVal_191); var currVal_217 = _co.form.get("anotherPlatformPercentage"); _ck(_v, 80, 0, currVal_217); var currVal_218 = "6"; _ck(_v, 82, 0, currVal_218); var currVal_219 = "anotherPlatformPercentage"; _ck(_v, 85, 0, currVal_219); var currVal_220 = "primary"; var currVal_221 = ""; _ck(_v, 88, 0, currVal_220, currVal_221); var currVal_222 = _co.form.get("anotherPlatformPercentage"); _ck(_v, 89, 0, currVal_222); var currVal_223 = "comissionPercentage"; var currVal_224 = _co.form; var currVal_225 = "% de Comiss\u00E3o"; var currVal_226 = true; var currVal_227 = "Porcentagem estimada de comiss\u00E3o cobrada em plataformas."; _ck(_v, 92, 0, currVal_223, currVal_224, currVal_225, currVal_226, currVal_227); var currVal_253 = _co.form.get("comissionPercentage"); _ck(_v, 94, 0, currVal_253); var currVal_254 = "6"; _ck(_v, 96, 0, currVal_254); var currVal_255 = "comissionPercentage"; _ck(_v, 99, 0, currVal_255); var currVal_256 = "primary"; var currVal_257 = ""; _ck(_v, 102, 0, currVal_256, currVal_257); var currVal_258 = _co.form.get("comissionPercentage"); _ck(_v, 103, 0, currVal_258); var currVal_273 = _co.isLoading; var currVal_274 = "primary"; _ck(_v, 107, 0, currVal_273, currVal_274); var currVal_275 = _co.form.get("receiveNews"); var currVal_276 = _co.isLoading; _ck(_v, 109, 0, currVal_275, currVal_276); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 1).disabled; var currVal_1 = core["ɵnov"](_v, 1).activeValue; _ck(_v, 0, 0, currVal_0, currVal_1); var currVal_10 = core["ɵnov"](_v, 7).outline; var currVal_11 = core["ɵnov"](_v, 7).filled; var currVal_12 = core["ɵnov"](_v, 7).hero; var currVal_13 = core["ɵnov"](_v, 7).fullWidth; var currVal_14 = core["ɵnov"](_v, 7).isOpen; var currVal_15 = core["ɵnov"](_v, 7).tiny; var currVal_16 = core["ɵnov"](_v, 7).small; var currVal_17 = core["ɵnov"](_v, 7).medium; var currVal_18 = core["ɵnov"](_v, 7).large; var currVal_19 = core["ɵnov"](_v, 7).giant; var currVal_20 = core["ɵnov"](_v, 7).primary; var currVal_21 = core["ɵnov"](_v, 7).info; var currVal_22 = core["ɵnov"](_v, 7).success; var currVal_23 = core["ɵnov"](_v, 7).warning; var currVal_24 = core["ɵnov"](_v, 7).danger; var currVal_25 = core["ɵnov"](_v, 7).basic; var currVal_26 = core["ɵnov"](_v, 7).control; var currVal_27 = core["ɵnov"](_v, 7).rectangle; var currVal_28 = core["ɵnov"](_v, 7).round; var currVal_29 = core["ɵnov"](_v, 7).semiRound; var currVal_30 = core["ɵnov"](_v, 13).ngClassUntouched; var currVal_31 = core["ɵnov"](_v, 13).ngClassTouched; var currVal_32 = core["ɵnov"](_v, 13).ngClassPristine; var currVal_33 = core["ɵnov"](_v, 13).ngClassDirty; var currVal_34 = core["ɵnov"](_v, 13).ngClassValid; var currVal_35 = core["ɵnov"](_v, 13).ngClassInvalid; var currVal_36 = core["ɵnov"](_v, 13).ngClassPending; _ck(_v, 6, 1, [currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34, currVal_35, currVal_36]); var currVal_43 = core["ɵnov"](_v, 16).selectedClass; var currVal_44 = core["ɵnov"](_v, 16).disabledAttribute; var currVal_45 = core["ɵnov"](_v, 16).tabindex; _ck(_v, 15, 0, currVal_43, currVal_44, currVal_45); var currVal_50 = (_co.isLoading ? true : null); var currVal_51 = (core["ɵnov"](_v, 26).maxlength ? core["ɵnov"](_v, 26).maxlength : null); var currVal_52 = core["ɵnov"](_v, 31).ngClassUntouched; var currVal_53 = core["ɵnov"](_v, 31).ngClassTouched; var currVal_54 = core["ɵnov"](_v, 31).ngClassPristine; var currVal_55 = core["ɵnov"](_v, 31).ngClassDirty; var currVal_56 = core["ɵnov"](_v, 31).ngClassValid; var currVal_57 = core["ɵnov"](_v, 31).ngClassInvalid; var currVal_58 = core["ɵnov"](_v, 31).ngClassPending; var currVal_59 = core["ɵnov"](_v, 32).fullWidth; var currVal_60 = core["ɵnov"](_v, 32).tiny; var currVal_61 = core["ɵnov"](_v, 32).small; var currVal_62 = core["ɵnov"](_v, 32).medium; var currVal_63 = core["ɵnov"](_v, 32).large; var currVal_64 = core["ɵnov"](_v, 32).giant; var currVal_65 = core["ɵnov"](_v, 32).primary; var currVal_66 = core["ɵnov"](_v, 32).info; var currVal_67 = core["ɵnov"](_v, 32).success; var currVal_68 = core["ɵnov"](_v, 32).warning; var currVal_69 = core["ɵnov"](_v, 32).danger; var currVal_70 = core["ɵnov"](_v, 32).basic; var currVal_71 = core["ɵnov"](_v, 32).control; var currVal_72 = core["ɵnov"](_v, 32).rectangle; var currVal_73 = core["ɵnov"](_v, 32).semiRound; var currVal_74 = core["ɵnov"](_v, 32).round; _ck(_v, 23, 1, [currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58, currVal_59, currVal_60, currVal_61, currVal_62, currVal_63, currVal_64, currVal_65, currVal_66, currVal_67, currVal_68, currVal_69, currVal_70, currVal_71, currVal_72, currVal_73, currVal_74]); var currVal_86 = (_co.isLoading ? true : null); var currVal_87 = (core["ɵnov"](_v, 40).maxlength ? core["ɵnov"](_v, 40).maxlength : null); var currVal_88 = core["ɵnov"](_v, 45).ngClassUntouched; var currVal_89 = core["ɵnov"](_v, 45).ngClassTouched; var currVal_90 = core["ɵnov"](_v, 45).ngClassPristine; var currVal_91 = core["ɵnov"](_v, 45).ngClassDirty; var currVal_92 = core["ɵnov"](_v, 45).ngClassValid; var currVal_93 = core["ɵnov"](_v, 45).ngClassInvalid; var currVal_94 = core["ɵnov"](_v, 45).ngClassPending; var currVal_95 = core["ɵnov"](_v, 46).fullWidth; var currVal_96 = core["ɵnov"](_v, 46).tiny; var currVal_97 = core["ɵnov"](_v, 46).small; var currVal_98 = core["ɵnov"](_v, 46).medium; var currVal_99 = core["ɵnov"](_v, 46).large; var currVal_100 = core["ɵnov"](_v, 46).giant; var currVal_101 = core["ɵnov"](_v, 46).primary; var currVal_102 = core["ɵnov"](_v, 46).info; var currVal_103 = core["ɵnov"](_v, 46).success; var currVal_104 = core["ɵnov"](_v, 46).warning; var currVal_105 = core["ɵnov"](_v, 46).danger; var currVal_106 = core["ɵnov"](_v, 46).basic; var currVal_107 = core["ɵnov"](_v, 46).control; var currVal_108 = core["ɵnov"](_v, 46).rectangle; var currVal_109 = core["ɵnov"](_v, 46).semiRound; var currVal_110 = core["ɵnov"](_v, 46).round; _ck(_v, 37, 1, [currVal_86, currVal_87, currVal_88, currVal_89, currVal_90, currVal_91, currVal_92, currVal_93, currVal_94, currVal_95, currVal_96, currVal_97, currVal_98, currVal_99, currVal_100, currVal_101, currVal_102, currVal_103, currVal_104, currVal_105, currVal_106, currVal_107, currVal_108, currVal_109, currVal_110]); var currVal_121 = (_co.isLoading ? true : null); var currVal_122 = (core["ɵnov"](_v, 54).maxlength ? core["ɵnov"](_v, 54).maxlength : null); var currVal_123 = core["ɵnov"](_v, 59).ngClassUntouched; var currVal_124 = core["ɵnov"](_v, 59).ngClassTouched; var currVal_125 = core["ɵnov"](_v, 59).ngClassPristine; var currVal_126 = core["ɵnov"](_v, 59).ngClassDirty; var currVal_127 = core["ɵnov"](_v, 59).ngClassValid; var currVal_128 = core["ɵnov"](_v, 59).ngClassInvalid; var currVal_129 = core["ɵnov"](_v, 59).ngClassPending; var currVal_130 = core["ɵnov"](_v, 60).fullWidth; var currVal_131 = core["ɵnov"](_v, 60).tiny; var currVal_132 = core["ɵnov"](_v, 60).small; var currVal_133 = core["ɵnov"](_v, 60).medium; var currVal_134 = core["ɵnov"](_v, 60).large; var currVal_135 = core["ɵnov"](_v, 60).giant; var currVal_136 = core["ɵnov"](_v, 60).primary; var currVal_137 = core["ɵnov"](_v, 60).info; var currVal_138 = core["ɵnov"](_v, 60).success; var currVal_139 = core["ɵnov"](_v, 60).warning; var currVal_140 = core["ɵnov"](_v, 60).danger; var currVal_141 = core["ɵnov"](_v, 60).basic; var currVal_142 = core["ɵnov"](_v, 60).control; var currVal_143 = core["ɵnov"](_v, 60).rectangle; var currVal_144 = core["ɵnov"](_v, 60).semiRound; var currVal_145 = core["ɵnov"](_v, 60).round; _ck(_v, 51, 1, [currVal_121, currVal_122, currVal_123, currVal_124, currVal_125, currVal_126, currVal_127, currVal_128, currVal_129, currVal_130, currVal_131, currVal_132, currVal_133, currVal_134, currVal_135, currVal_136, currVal_137, currVal_138, currVal_139, currVal_140, currVal_141, currVal_142, currVal_143, currVal_144, currVal_145]); var currVal_156 = (_co.isLoading ? true : null); var currVal_157 = (core["ɵnov"](_v, 68).maxlength ? core["ɵnov"](_v, 68).maxlength : null); var currVal_158 = core["ɵnov"](_v, 73).ngClassUntouched; var currVal_159 = core["ɵnov"](_v, 73).ngClassTouched; var currVal_160 = core["ɵnov"](_v, 73).ngClassPristine; var currVal_161 = core["ɵnov"](_v, 73).ngClassDirty; var currVal_162 = core["ɵnov"](_v, 73).ngClassValid; var currVal_163 = core["ɵnov"](_v, 73).ngClassInvalid; var currVal_164 = core["ɵnov"](_v, 73).ngClassPending; var currVal_165 = core["ɵnov"](_v, 74).fullWidth; var currVal_166 = core["ɵnov"](_v, 74).tiny; var currVal_167 = core["ɵnov"](_v, 74).small; var currVal_168 = core["ɵnov"](_v, 74).medium; var currVal_169 = core["ɵnov"](_v, 74).large; var currVal_170 = core["ɵnov"](_v, 74).giant; var currVal_171 = core["ɵnov"](_v, 74).primary; var currVal_172 = core["ɵnov"](_v, 74).info; var currVal_173 = core["ɵnov"](_v, 74).success; var currVal_174 = core["ɵnov"](_v, 74).warning; var currVal_175 = core["ɵnov"](_v, 74).danger; var currVal_176 = core["ɵnov"](_v, 74).basic; var currVal_177 = core["ɵnov"](_v, 74).control; var currVal_178 = core["ɵnov"](_v, 74).rectangle; var currVal_179 = core["ɵnov"](_v, 74).semiRound; var currVal_180 = core["ɵnov"](_v, 74).round; _ck(_v, 65, 1, [currVal_156, currVal_157, currVal_158, currVal_159, currVal_160, currVal_161, currVal_162, currVal_163, currVal_164, currVal_165, currVal_166, currVal_167, currVal_168, currVal_169, currVal_170, currVal_171, currVal_172, currVal_173, currVal_174, currVal_175, currVal_176, currVal_177, currVal_178, currVal_179, currVal_180]); var currVal_192 = (_co.isLoading ? true : null); var currVal_193 = (core["ɵnov"](_v, 82).maxlength ? core["ɵnov"](_v, 82).maxlength : null); var currVal_194 = core["ɵnov"](_v, 87).ngClassUntouched; var currVal_195 = core["ɵnov"](_v, 87).ngClassTouched; var currVal_196 = core["ɵnov"](_v, 87).ngClassPristine; var currVal_197 = core["ɵnov"](_v, 87).ngClassDirty; var currVal_198 = core["ɵnov"](_v, 87).ngClassValid; var currVal_199 = core["ɵnov"](_v, 87).ngClassInvalid; var currVal_200 = core["ɵnov"](_v, 87).ngClassPending; var currVal_201 = core["ɵnov"](_v, 88).fullWidth; var currVal_202 = core["ɵnov"](_v, 88).tiny; var currVal_203 = core["ɵnov"](_v, 88).small; var currVal_204 = core["ɵnov"](_v, 88).medium; var currVal_205 = core["ɵnov"](_v, 88).large; var currVal_206 = core["ɵnov"](_v, 88).giant; var currVal_207 = core["ɵnov"](_v, 88).primary; var currVal_208 = core["ɵnov"](_v, 88).info; var currVal_209 = core["ɵnov"](_v, 88).success; var currVal_210 = core["ɵnov"](_v, 88).warning; var currVal_211 = core["ɵnov"](_v, 88).danger; var currVal_212 = core["ɵnov"](_v, 88).basic; var currVal_213 = core["ɵnov"](_v, 88).control; var currVal_214 = core["ɵnov"](_v, 88).rectangle; var currVal_215 = core["ɵnov"](_v, 88).semiRound; var currVal_216 = core["ɵnov"](_v, 88).round; _ck(_v, 79, 1, [currVal_192, currVal_193, currVal_194, currVal_195, currVal_196, currVal_197, currVal_198, currVal_199, currVal_200, currVal_201, currVal_202, currVal_203, currVal_204, currVal_205, currVal_206, currVal_207, currVal_208, currVal_209, currVal_210, currVal_211, currVal_212, currVal_213, currVal_214, currVal_215, currVal_216]); var currVal_228 = (_co.isLoading ? true : null); var currVal_229 = (core["ɵnov"](_v, 96).maxlength ? core["ɵnov"](_v, 96).maxlength : null); var currVal_230 = core["ɵnov"](_v, 101).ngClassUntouched; var currVal_231 = core["ɵnov"](_v, 101).ngClassTouched; var currVal_232 = core["ɵnov"](_v, 101).ngClassPristine; var currVal_233 = core["ɵnov"](_v, 101).ngClassDirty; var currVal_234 = core["ɵnov"](_v, 101).ngClassValid; var currVal_235 = core["ɵnov"](_v, 101).ngClassInvalid; var currVal_236 = core["ɵnov"](_v, 101).ngClassPending; var currVal_237 = core["ɵnov"](_v, 102).fullWidth; var currVal_238 = core["ɵnov"](_v, 102).tiny; var currVal_239 = core["ɵnov"](_v, 102).small; var currVal_240 = core["ɵnov"](_v, 102).medium; var currVal_241 = core["ɵnov"](_v, 102).large; var currVal_242 = core["ɵnov"](_v, 102).giant; var currVal_243 = core["ɵnov"](_v, 102).primary; var currVal_244 = core["ɵnov"](_v, 102).info; var currVal_245 = core["ɵnov"](_v, 102).success; var currVal_246 = core["ɵnov"](_v, 102).warning; var currVal_247 = core["ɵnov"](_v, 102).danger; var currVal_248 = core["ɵnov"](_v, 102).basic; var currVal_249 = core["ɵnov"](_v, 102).control; var currVal_250 = core["ɵnov"](_v, 102).rectangle; var currVal_251 = core["ɵnov"](_v, 102).semiRound; var currVal_252 = core["ɵnov"](_v, 102).round; _ck(_v, 93, 1, [currVal_228, currVal_229, currVal_230, currVal_231, currVal_232, currVal_233, currVal_234, currVal_235, currVal_236, currVal_237, currVal_238, currVal_239, currVal_240, currVal_241, currVal_242, currVal_243, currVal_244, currVal_245, currVal_246, currVal_247, currVal_248, currVal_249, currVal_250, currVal_251, currVal_252]); var currVal_259 = core["ɵnov"](_v, 107).primary; var currVal_260 = core["ɵnov"](_v, 107).success; var currVal_261 = core["ɵnov"](_v, 107).warning; var currVal_262 = core["ɵnov"](_v, 107).danger; var currVal_263 = core["ɵnov"](_v, 107).info; var currVal_264 = core["ɵnov"](_v, 107).basic; var currVal_265 = core["ɵnov"](_v, 107).control; var currVal_266 = core["ɵnov"](_v, 111).ngClassUntouched; var currVal_267 = core["ɵnov"](_v, 111).ngClassTouched; var currVal_268 = core["ɵnov"](_v, 111).ngClassPristine; var currVal_269 = core["ɵnov"](_v, 111).ngClassDirty; var currVal_270 = core["ɵnov"](_v, 111).ngClassValid; var currVal_271 = core["ɵnov"](_v, 111).ngClassInvalid; var currVal_272 = core["ɵnov"](_v, 111).ngClassPending; _ck(_v, 106, 1, [currVal_259, currVal_260, currVal_261, currVal_262, currVal_263, currVal_264, currVal_265, currVal_266, currVal_267, currVal_268, currVal_269, currVal_270, currVal_271, currVal_272]); }); }
function View_SettingsComponent_11(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 4, "div", [["class", "popover-page d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 1, "h6", [], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Store ID"])), (_l()(), core["ɵeld"](3, 0, null, null, 1, "p", [["class", "text-justify"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, [" Trata-se de um c\u00F3digo de identifica\u00E7\u00E3o da empresa para que a mesma seja acessada no OMNI Store Light, nossa loja virtual aberta onde o cliente pode realizar pedidos. "]))], null, null); }
function View_SettingsComponent_0(_l) { return core["ɵvid"](2, [(_l()(), core["ɵeld"](0, 0, null, null, 268, "form", [["novalidate", ""]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "ngSubmit"], [null, "submit"], [null, "reset"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("submit" === en)) {
        var pd_0 = (core["ɵnov"](_v, 2).onSubmit($event) !== false);
        ad = (pd_0 && ad);
    } if (("reset" === en)) {
        var pd_1 = (core["ɵnov"](_v, 2).onReset() !== false);
        ad = (pd_1 && ad);
    } if (("ngSubmit" === en)) {
        var pd_2 = (_co.onSubmit() !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](1, 16384, null, 0, fesm2015_forms["D" /* ɵangular_packages_forms_forms_z */], [], null, null), core["ɵdid"](2, 540672, null, 0, fesm2015_forms["l" /* FormGroupDirective */], [[8, null], [8, null]], { form: [0, "form"] }, { ngSubmit: "ngSubmit" }), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["l" /* FormGroupDirective */]]), core["ɵdid"](4, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](5, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](6, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 1, "omni-page-title", [["pageTitle", "Configura\u00E7\u00F5es"]], null, null, null, page_title_component_ngfactory["b" /* View_PageTitleComponent_0 */], page_title_component_ngfactory["a" /* RenderType_PageTitleComponent */])), core["ɵdid"](8, 114688, null, 0, page_title_component["a" /* PageTitleComponent */], [fesm2015["Rb" /* NbDialogService */]], { icon: [0, "icon"], pageTitle: [1, "pageTitle"] }, null), (_l()(), core["ɵeld"](9, 0, null, null, 259, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](10, 0, null, null, 258, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](11, 0, null, null, 257, "omni-form-container", [], null, [[null, "backButtonClick"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("backButtonClick" === en)) {
        var pd_0 = (_co.back() !== false);
        ad = (pd_0 && ad);
    } return ad; }, form_container_component_ngfactory["b" /* View_FormContainerComponent_0 */], form_container_component_ngfactory["a" /* RenderType_FormContainerComponent */])), core["ɵdid"](12, 114688, null, 0, form_container_component["a" /* FormContainerComponent */], [alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */]], { isLoading: [0, "isLoading"] }, { backButtonClick: "backButtonClick" }), (_l()(), core["ɵeld"](13, 0, null, 1, 251, "div", [["class", "form-content"]], null, null, null, null, null)), (_l()(), core["ɵeld"](14, 0, null, null, 250, "nb-tabset", [], [[2, "full-width", null]], [[null, "changeTab"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("changeTab" === en)) {
        var pd_0 = (_co.onTabChange($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["gb" /* View_NbTabsetComponent_0 */], index_ngfactory["J" /* RenderType_NbTabsetComponent */])), core["ɵdid"](15, 1097728, null, 1, fesm2015["Dd" /* NbTabsetComponent */], [router["a" /* ActivatedRoute */], core["ChangeDetectorRef"]], null, { changeTab: "changeTab" }), core["ɵqud"](603979776, 1, { tabs: 1 }), (_l()(), core["ɵeld"](17, 0, null, 0, 88, "nb-tab", [["responsive", ""], ["tabIcon", "settings-2"], ["tabId", "config-gerais"], ["tabTitle", "Config. Gerais"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](18, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](19, 0, null, 0, 46, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_SettingsComponent_1)), core["ɵdid"](21, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](22, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](23, 0, null, null, 12, "omni-field", [["field", "fusoHorario"], ["label", "Fuso hor\u00E1rio"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](24, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"], validOnSubmit: [4, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](25, 0, null, 0, 10, "nb-select", [["fullWidth", ""], ["placeholder", "Selecione um fuso hor\u00E1rio"], ["status", "primary"]], [[2, "appearance-outline", null], [2, "appearance-filled", null], [2, "appearance-hero", null], [2, "full-width", null], [2, "open", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["db" /* View_NbSelectComponent_0 */], index_ngfactory["G" /* RenderType_NbSelectComponent */])), core["ɵprd"](6144, null, fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], null, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](27, 5423104, null, 2, fesm2015["id" /* NbSelectComponent */], [fesm2015["g" /* NB_DOCUMENT */], fesm2015["Gc" /* NbOverlayService */], core["ElementRef"], fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], core["ChangeDetectorRef"], fesm2015["qe" /* ɵd */]], { status: [0, "status"], disabled: [1, "disabled"], fullWidth: [2, "fullWidth"], placeholder: [3, "placeholder"] }, null), core["ɵqud"](603979776, 2, { options: 1 }), core["ɵqud"](603979776, 3, { customLabel: 0 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](31, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](33, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, 1, 1, null, View_SettingsComponent_2)), core["ɵdid"](35, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](36, 0, null, null, 11, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](37, 0, null, null, 10, "omni-field", [["field", "printQuantity"], ["label", "Qtd. de vias p/ impress\u00E3o"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](38, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](39, 0, null, 0, 8, "input", [["formControlName", "printQuantity"], ["fullWidth", ""], ["maxlength", "2"], ["nbInput", ""], ["placeholder", "Quantidade de vias"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 40)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 40).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 40)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 40)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](40, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](41, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](44, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](46, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](47, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_SettingsComponent_3)), core["ɵdid"](49, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_SettingsComponent_4)), core["ɵdid"](51, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](52, 0, null, null, 13, "div", [["class", "form-group col-12 col-md-6 col-lg-4 col-xl-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](53, 0, null, null, 12, "omni-field", [["field", "stockControl"], ["label", "Controle de Estoque"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](54, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](55, 0, null, 0, 10, "nb-select", [["fullWidth", ""], ["status", "primary"]], [[2, "appearance-outline", null], [2, "appearance-filled", null], [2, "appearance-hero", null], [2, "full-width", null], [2, "open", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["db" /* View_NbSelectComponent_0 */], index_ngfactory["G" /* RenderType_NbSelectComponent */])), core["ɵprd"](6144, null, fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], null, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](57, 5423104, null, 2, fesm2015["id" /* NbSelectComponent */], [fesm2015["g" /* NB_DOCUMENT */], fesm2015["Gc" /* NbOverlayService */], core["ElementRef"], fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], core["ChangeDetectorRef"], fesm2015["qe" /* ɵd */]], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵqud"](603979776, 6, { options: 1 }), core["ɵqud"](603979776, 7, { customLabel: 0 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](61, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](63, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, 1, 1, null, View_SettingsComponent_6)), core["ɵdid"](65, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](66, 0, null, 0, 39, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](67, 0, null, null, 38, "div", [["class", "col-12 d-flex flex-row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](68, 0, null, null, 14, "div", [["class", "d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](69, 0, null, null, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](70, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](72, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](74, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Aceitar pedidos automaticamente "])), (_l()(), core["ɵeld"](76, 0, null, null, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](77, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](79, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](81, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Aceitar pedidos na mesa automaticamente "])), (_l()(), core["ɵeld"](83, 0, null, null, 14, "div", [["class", "d-flex flex-column ml-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](84, 0, null, null, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](85, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](87, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](89, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Imprimir pedidos automaticamente "])), (_l()(), core["ɵeld"](91, 0, null, null, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](92, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](94, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](96, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Imprimir pedidos distribuidos automaticamente "])), (_l()(), core["ɵeld"](98, 0, null, null, 7, "div", [["class", "d-flex flex-column ml-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](99, 0, null, null, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](100, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](102, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](104, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Iniciar tour ao efetuar o login "])), (_l()(), core["ɵeld"](106, 0, null, 0, 55, "nb-tab", [["responsive", ""], ["tabIcon", "cube"], ["tabId", "entregas"], ["tabTitle", "Entrega"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](107, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](108, 0, null, 0, 36, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](109, 0, null, null, 11, "div", [["class", "form-group col-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](110, 0, null, null, 10, "omni-field", [["field", "uniqueDeliveryChargeValue"], ["label", "Taxa de Entrega \u00FAnica"], ["tooltipText", "A taxa de de entrega \u00FAnica \u00E9 uma taxa que pode ser cobrada em cada entrega independente do bairro ou cidade."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](111, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showTooltip: [3, "showTooltip"], tooltipText: [4, "tooltipText"] }, null), (_l()(), core["ɵeld"](112, 0, null, 0, 8, "input", [["formControlName", "uniqueDeliveryChargeValue"], ["fullWidth", ""], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0,00"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 113).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 113).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 114)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 114).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 114)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 114)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](113, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](114, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](116, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](118, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](119, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](120, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](121, 0, null, null, 11, "div", [["class", "form-group col-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](122, 0, null, null, 10, "omni-field", [["field", "valorIsencaoEntrega"], ["label", "N\u00E3o cobrar taxa de entrega a partir de"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](123, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](124, 0, null, 0, 8, "input", [["formControlName", "valorIsencaoEntrega"], ["fullWidth", ""], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0,00"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 125).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 125).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 126)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 126).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 126)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 126)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](125, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](126, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](128, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](130, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](131, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](132, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](133, 0, null, null, 11, "div", [["class", "form-group col-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](134, 0, null, null, 10, "omni-field", [["field", "minValueToDeliver"], ["label", "Aceitar entrega de pedidos com valor a partir de"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](135, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](136, 0, null, 0, 8, "input", [["formControlName", "minValueToDeliver"], ["fullWidth", ""], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0,00"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 137).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 137).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 138)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 138).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 138)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 138)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](137, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](138, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](140, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](142, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](143, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](144, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](145, 0, null, 0, 16, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](146, 0, null, null, 15, "div", [["class", "form-group col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](147, 0, null, null, 14, "div", [["class", "d-flex flex-row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](148, 0, null, null, 6, "nb-checkbox", [["class", "mr-4"], ["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](149, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](151, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](153, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Habilitar Entrega "])), (_l()(), core["ɵeld"](155, 0, null, null, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](156, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](158, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](160, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Habilitar Retirada "])), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_SettingsComponent_7)), core["ɵdid"](163, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_SettingsComponent_8)), core["ɵdid"](165, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](166, 0, null, 0, 47, "nb-tab", [["responsive", ""], ["tabIcon", "credit-card"], ["tabId", "pagamentos"], ["tabTitle", "Pagamentos"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](167, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](168, 0, null, 0, 45, "div", [["class", "row d-flex align-items-end"]], null, null, null, null, null)), (_l()(), core["ɵeld"](169, 0, null, null, 11, "div", [["class", "form-group col-12 col-sm-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](170, 0, null, null, 10, "omni-field", [["field", "minimumValue"], ["label", "Parcela m\u00EDnima"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](171, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](172, 0, null, 0, 8, "input", [["formControlName", "minimumValue"], ["fullWidth", ""], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0,00"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 173).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 173).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 174)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 174).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 174)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 174)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](173, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](174, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](176, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](178, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](179, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](180, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](181, 0, null, null, 11, "div", [["class", "form-group col-12 col-sm-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](182, 0, null, null, 10, "omni-field", [["field", "maximumInstallments"], ["label", "M\u00E1ximo de parcelas"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](183, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](184, 0, null, 0, 8, "input", [["formControlName", "maximumInstallments"], ["fullWidth", ""], ["maxlength", "2"], ["nbInput", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 185)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 185).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 185)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 185)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](185, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](186, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](189, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](191, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](192, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](193, 0, null, null, 20, "div", [["class", "form-group col-12 col-sm-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](194, 0, null, null, 6, "nb-checkbox", [["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "checkedChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("checkedChange" === en)) {
        var pd_0 = (_co.checkDiscountWithMoneyPayment($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵdid"](195, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { disabled: [0, "disabled"], status: [1, "status"] }, { checkedChange: "checkedChange" }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](197, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](199, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, 0, [" Desconto para pagamento em dinheiro "])), (_l()(), core["ɵeld"](201, 0, null, null, 12, "omni-field", [["field", "discountWithMoneyPaymentValue"], ["label", "% de desconto para pagamento em dinheiro"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](202, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showLabel: [3, "showLabel"] }, null), (_l()(), core["ɵeld"](203, 0, null, 0, 10, "input", [["formControlName", "discountWithMoneyPaymentValue"], ["fullWidth", ""], ["maxlength", "5"], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0,00 %"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 204).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 204).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 205)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 205).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 205)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 205)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](204, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](205, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](206, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](209, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](211, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](212, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](213, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](214, 0, null, 0, 48, "nb-tab", [["responsive", ""], ["tabIcon", "shield"], ["tabId", "seguranca"], ["tabTitle", "Seguran\u00E7a"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](215, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](216, 0, null, 0, 3, "div", [["class", "row mt-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](217, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](218, 0, null, null, 1, "p", [["class", "text-muted"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, [" Atualize sua senha nova senha e re-digite a nova senha para confirma\u00E7\u00E3o. "])), (_l()(), core["ɵeld"](220, 0, null, 0, 42, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](221, 0, null, null, 20, "div", [["class", "col-6 col-sm-6 col-md-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](222, 0, null, null, 19, "omni-field", [["field", "password"], ["label", "Nova Senha"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](223, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](224, 0, null, 0, 17, "div", [["class", "input-with-icon"]], null, null, null, null, null)), (_l()(), core["ɵeld"](225, 0, null, null, 6, "input", [["fieldSize", "large"], ["formControlName", "password"], ["fullWidth", ""], ["nbInput", ""], ["placeholder", "Nova Senha"], ["status", "primary"]], [[1, "disabled", 0], [1, "type", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 226)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 226).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 226)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 226)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](226, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](228, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](230, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](231, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { fieldSize: [0, "fieldSize"], status: [1, "status"], fullWidth: [2, "fullWidth"] }, null), (_l()(), core["ɵeld"](232, 0, null, null, 9, "button", [["ghost", ""], ["nbButton", ""], ["nbTooltipStatus", "primary"], ["size", "small"], ["status", "primary"], ["type", "button"]], [[1, "disabled", 0], [2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 233).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = ((_co.hidePassword = !_co.hidePassword) !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](233, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], ghost: [2, "ghost"] }, null), core["ɵprd"](512, null, fesm2015["Tb" /* NbDynamicOverlay */], fesm2015["Tb" /* NbDynamicOverlay */], [fesm2015["Gc" /* NbOverlayService */], core["ComponentFactoryResolver"], core["NgZone"], fesm2015["Bc" /* NbOverlayContainer */]]), core["ɵprd"](512, null, fesm2015["Ub" /* NbDynamicOverlayHandler */], fesm2015["Ub" /* NbDynamicOverlayHandler */], [fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], fesm2015["Tb" /* NbDynamicOverlay */]]), core["ɵdid"](236, 4931584, null, 0, fesm2015["Pd" /* NbTooltipDirective */], [core["ElementRef"], fesm2015["Ub" /* NbDynamicOverlayHandler */]], { content: [0, "content"], status: [1, "status"] }, null), (_l()(), core["ɵeld"](237, 0, null, 0, 4, "fa-icon", [["class", "ng-fa-icon"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵprd"](512, null, common["K" /* ɵNgClassImpl */], common["L" /* ɵNgClassR2Impl */], [core["IterableDiffers"], core["KeyValueDiffers"], core["ElementRef"], core["Renderer2"]]), core["ɵdid"](239, 278528, null, 0, common["m" /* NgClass */], [common["K" /* ɵNgClassImpl */]], { ngClass: [0, "ngClass"] }, null), core["ɵpod"](240, { "text-primary": 0 }), core["ɵdid"](241, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"] }, null), (_l()(), core["ɵeld"](242, 0, null, null, 20, "div", [["class", "col-6 col-sm-6 col-md-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](243, 0, null, null, 19, "omni-field", [["field", "confirmPassword"], ["label", "Confirme a senha"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](244, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], errorMsg: [3, "errorMsg"] }, null), (_l()(), core["ɵeld"](245, 0, null, 0, 17, "div", [["class", "input-with-icon"]], null, null, null, null, null)), (_l()(), core["ɵeld"](246, 0, null, null, 6, "input", [["fieldSize", "large"], ["formControlName", "confirmPassword"], ["fullWidth", ""], ["nbInput", ""], ["placeholder", "Confirme a senha"], ["status", "primary"]], [[1, "disabled", 0], [1, "type", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 247)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 247).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 247)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 247)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](247, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](249, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](251, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](252, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { fieldSize: [0, "fieldSize"], status: [1, "status"], fullWidth: [2, "fullWidth"] }, null), (_l()(), core["ɵeld"](253, 0, null, null, 9, "button", [["ghost", ""], ["nbButton", ""], ["nbTooltipStatus", "primary"], ["size", "small"], ["status", "primary"], ["type", "button"]], [[1, "disabled", 0], [2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 254).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = ((_co.hideConfirmPassword = !_co.hideConfirmPassword) !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](254, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], ghost: [2, "ghost"] }, null), core["ɵprd"](512, null, fesm2015["Tb" /* NbDynamicOverlay */], fesm2015["Tb" /* NbDynamicOverlay */], [fesm2015["Gc" /* NbOverlayService */], core["ComponentFactoryResolver"], core["NgZone"], fesm2015["Bc" /* NbOverlayContainer */]]), core["ɵprd"](512, null, fesm2015["Ub" /* NbDynamicOverlayHandler */], fesm2015["Ub" /* NbDynamicOverlayHandler */], [fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], fesm2015["Tb" /* NbDynamicOverlay */]]), core["ɵdid"](257, 4931584, null, 0, fesm2015["Pd" /* NbTooltipDirective */], [core["ElementRef"], fesm2015["Ub" /* NbDynamicOverlayHandler */]], { content: [0, "content"], status: [1, "status"] }, null), (_l()(), core["ɵeld"](258, 0, null, 0, 4, "fa-icon", [["class", "ng-fa-icon"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵprd"](512, null, common["K" /* ɵNgClassImpl */], common["L" /* ɵNgClassR2Impl */], [core["IterableDiffers"], core["KeyValueDiffers"], core["ElementRef"], core["Renderer2"]]), core["ɵdid"](260, 278528, null, 0, common["m" /* NgClass */], [common["K" /* ɵNgClassImpl */]], { ngClass: [0, "ngClass"] }, null), core["ɵpod"](261, { "text-primary": 0 }), core["ɵdid"](262, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"] }, null), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_SettingsComponent_9)), core["ɵdid"](264, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](265, 0, null, 3, 3, "div", [["class", "form-footer"]], null, null, null, null, null)), (_l()(), core["ɵeld"](266, 0, null, null, 2, "button", [["nbButton", ""], ["status", "success"], ["type", "submit"]], [[1, "disabled", 0], [2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 267).onClick($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](267, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"] }, null), (_l()(), core["ɵted"](268, 0, [" ", " "])), (_l()(), core["ɵand"](0, [["storeIdTemplate", 2]], null, 0, null, View_SettingsComponent_11))], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.form; _ck(_v, 2, 0, currVal_7); var currVal_8 = _co.settingsIcon; var currVal_9 = "Configura\u00E7\u00F5es"; _ck(_v, 8, 0, currVal_8, currVal_9); var currVal_10 = _co.isLoading; _ck(_v, 12, 0, currVal_10); var currVal_14 = "Config. Gerais"; var currVal_15 = "config-gerais"; var currVal_16 = "settings-2"; var currVal_17 = ""; var currVal_18 = (_co.activeTab === "config-gerais"); _ck(_v, 18, 0, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18); var currVal_19 = _co.hasStoreId; _ck(_v, 21, 0, currVal_19); var currVal_20 = "fusoHorario"; var currVal_21 = _co.form; var currVal_22 = "Fuso hor\u00E1rio"; var currVal_23 = true; var currVal_24 = true; _ck(_v, 24, 0, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24); var currVal_52 = "primary"; var currVal_53 = _co.isLoading; var currVal_54 = ""; var currVal_55 = "Selecione um fuso hor\u00E1rio"; _ck(_v, 27, 0, currVal_52, currVal_53, currVal_54, currVal_55); var currVal_56 = _co.form.get("fusoHorario"); var currVal_57 = _co.isLoading; _ck(_v, 31, 0, currVal_56, currVal_57); var currVal_58 = _co.timeZones; _ck(_v, 35, 0, currVal_58); var currVal_59 = "printQuantity"; var currVal_60 = _co.form; var currVal_61 = "Qtd. de vias p/ impress\u00E3o"; _ck(_v, 38, 0, currVal_59, currVal_60, currVal_61); var currVal_87 = "2"; _ck(_v, 41, 0, currVal_87); var currVal_88 = "printQuantity"; _ck(_v, 44, 0, currVal_88); var currVal_89 = "primary"; var currVal_90 = ""; _ck(_v, 47, 0, currVal_89, currVal_90); var currVal_91 = _co.hasCashback; _ck(_v, 49, 0, currVal_91); var currVal_92 = _co.isAdmin; _ck(_v, 51, 0, currVal_92); var currVal_93 = "stockControl"; var currVal_94 = _co.form; var currVal_95 = "Controle de Estoque"; _ck(_v, 54, 0, currVal_93, currVal_94, currVal_95); var currVal_123 = "primary"; var currVal_124 = ""; _ck(_v, 57, 0, currVal_123, currVal_124); var currVal_125 = _co.form.get("stockControl"); _ck(_v, 61, 0, currVal_125); var currVal_126 = _co.stockControlOptions; _ck(_v, 65, 0, currVal_126); var currVal_141 = _co.isLoading; var currVal_142 = "primary"; _ck(_v, 70, 0, currVal_141, currVal_142); var currVal_143 = _co.form.get("autoAcceptOrders"); var currVal_144 = _co.isLoading; _ck(_v, 72, 0, currVal_143, currVal_144); var currVal_159 = _co.isLoading; var currVal_160 = "primary"; _ck(_v, 77, 0, currVal_159, currVal_160); var currVal_161 = _co.form.get("autoAcceptOrdersOnTable"); var currVal_162 = _co.isLoading; _ck(_v, 79, 0, currVal_161, currVal_162); var currVal_177 = _co.isLoading; var currVal_178 = "primary"; _ck(_v, 85, 0, currVal_177, currVal_178); var currVal_179 = _co.form.get("autoPrintOrders"); var currVal_180 = _co.isLoading; _ck(_v, 87, 0, currVal_179, currVal_180); var currVal_195 = _co.isLoading; var currVal_196 = "primary"; _ck(_v, 92, 0, currVal_195, currVal_196); var currVal_197 = _co.form.get("autoPrintDistributedOrders"); var currVal_198 = _co.isLoading; _ck(_v, 94, 0, currVal_197, currVal_198); var currVal_213 = _co.isLoading; var currVal_214 = "primary"; _ck(_v, 100, 0, currVal_213, currVal_214); var currVal_215 = _co.form.get("initTour"); var currVal_216 = _co.isLoading; _ck(_v, 102, 0, currVal_215, currVal_216); var currVal_219 = "Entrega"; var currVal_220 = "entregas"; var currVal_221 = "cube"; var currVal_222 = ""; var currVal_223 = (_co.activeTab === "entregas"); _ck(_v, 107, 0, currVal_219, currVal_220, currVal_221, currVal_222, currVal_223); var currVal_224 = "uniqueDeliveryChargeValue"; var currVal_225 = _co.form; var currVal_226 = "Taxa de Entrega \u00FAnica"; var currVal_227 = true; var currVal_228 = "A taxa de de entrega \u00FAnica \u00E9 uma taxa que pode ser cobrada em cada entrega independente do bairro ou cidade."; _ck(_v, 111, 0, currVal_224, currVal_225, currVal_226, currVal_227, currVal_228); var currVal_253 = _co.form.get("uniqueDeliveryChargeValue"); _ck(_v, 113, 0, currVal_253); var currVal_254 = "uniqueDeliveryChargeValue"; _ck(_v, 116, 0, currVal_254); var currVal_255 = "primary"; var currVal_256 = ""; _ck(_v, 119, 0, currVal_255, currVal_256); var currVal_257 = _co.form.get("uniqueDeliveryChargeValue"); _ck(_v, 120, 0, currVal_257); var currVal_258 = "valorIsencaoEntrega"; var currVal_259 = _co.form; var currVal_260 = "N\u00E3o cobrar taxa de entrega a partir de"; _ck(_v, 123, 0, currVal_258, currVal_259, currVal_260); var currVal_285 = _co.form.get("valorIsencaoEntrega"); _ck(_v, 125, 0, currVal_285); var currVal_286 = "valorIsencaoEntrega"; _ck(_v, 128, 0, currVal_286); var currVal_287 = "primary"; var currVal_288 = ""; _ck(_v, 131, 0, currVal_287, currVal_288); var currVal_289 = _co.form.get("valorIsencaoEntrega"); _ck(_v, 132, 0, currVal_289); var currVal_290 = "minValueToDeliver"; var currVal_291 = _co.form; var currVal_292 = "Aceitar entrega de pedidos com valor a partir de"; _ck(_v, 135, 0, currVal_290, currVal_291, currVal_292); var currVal_317 = _co.form.get("minValueToDeliver"); _ck(_v, 137, 0, currVal_317); var currVal_318 = "minValueToDeliver"; _ck(_v, 140, 0, currVal_318); var currVal_319 = "primary"; var currVal_320 = ""; _ck(_v, 143, 0, currVal_319, currVal_320); var currVal_321 = _co.form.get("minValueToDeliver"); _ck(_v, 144, 0, currVal_321); var currVal_336 = _co.isLoading; var currVal_337 = "primary"; _ck(_v, 149, 0, currVal_336, currVal_337); var currVal_338 = _co.form.get("enableDelivery"); var currVal_339 = _co.isLoading; _ck(_v, 151, 0, currVal_338, currVal_339); var currVal_354 = _co.isLoading; var currVal_355 = "primary"; _ck(_v, 156, 0, currVal_354, currVal_355); var currVal_356 = _co.form.get("enableWithdraw"); var currVal_357 = _co.isLoading; _ck(_v, 158, 0, currVal_356, currVal_357); var currVal_358 = _co.isAdmin; _ck(_v, 163, 0, currVal_358); var currVal_359 = _co.hasDeliveryFeeByRadius; _ck(_v, 165, 0, currVal_359); var currVal_362 = "Pagamentos"; var currVal_363 = "pagamentos"; var currVal_364 = "credit-card"; var currVal_365 = ""; var currVal_366 = (_co.activeTab === "pagamentos"); _ck(_v, 167, 0, currVal_362, currVal_363, currVal_364, currVal_365, currVal_366); var currVal_367 = "minimumValue"; var currVal_368 = _co.form; var currVal_369 = "Parcela m\u00EDnima"; _ck(_v, 171, 0, currVal_367, currVal_368, currVal_369); var currVal_394 = _co.form.get("minimumValue"); _ck(_v, 173, 0, currVal_394); var currVal_395 = "minimumValue"; _ck(_v, 176, 0, currVal_395); var currVal_396 = "primary"; var currVal_397 = ""; _ck(_v, 179, 0, currVal_396, currVal_397); var currVal_398 = _co.form.get("minimumValue"); _ck(_v, 180, 0, currVal_398); var currVal_399 = "maximumInstallments"; var currVal_400 = _co.form; var currVal_401 = "M\u00E1ximo de parcelas"; _ck(_v, 183, 0, currVal_399, currVal_400, currVal_401); var currVal_427 = "2"; _ck(_v, 186, 0, currVal_427); var currVal_428 = "maximumInstallments"; _ck(_v, 189, 0, currVal_428); var currVal_429 = "primary"; var currVal_430 = ""; _ck(_v, 192, 0, currVal_429, currVal_430); var currVal_445 = _co.isLoading; var currVal_446 = "primary"; _ck(_v, 195, 0, currVal_445, currVal_446); var currVal_447 = _co.form.get("applyDiscountWithMoneyPayment"); var currVal_448 = _co.isLoading; _ck(_v, 197, 0, currVal_447, currVal_448); var currVal_449 = "discountWithMoneyPaymentValue"; var currVal_450 = _co.form; var currVal_451 = "% de desconto para pagamento em dinheiro"; var currVal_452 = false; _ck(_v, 202, 0, currVal_449, currVal_450, currVal_451, currVal_452); var currVal_478 = _co.form.get("discountWithMoneyPaymentValue"); _ck(_v, 204, 0, currVal_478); var currVal_479 = "5"; _ck(_v, 206, 0, currVal_479); var currVal_480 = "discountWithMoneyPaymentValue"; _ck(_v, 209, 0, currVal_480); var currVal_481 = "primary"; var currVal_482 = ""; _ck(_v, 212, 0, currVal_481, currVal_482); var currVal_483 = _co.form.get("discountWithMoneyPaymentValue"); _ck(_v, 213, 0, currVal_483); var currVal_486 = "Seguran\u00E7a"; var currVal_487 = "seguranca"; var currVal_488 = "shield"; var currVal_489 = ""; var currVal_490 = (_co.activeTab === "seguranca"); _ck(_v, 215, 0, currVal_486, currVal_487, currVal_488, currVal_489, currVal_490); var currVal_491 = "password"; var currVal_492 = _co.form; var currVal_493 = "Nova Senha"; _ck(_v, 223, 0, currVal_491, currVal_492, currVal_493); var currVal_519 = "password"; _ck(_v, 228, 0, currVal_519); var currVal_520 = "large"; var currVal_521 = "primary"; var currVal_522 = ""; _ck(_v, 231, 0, currVal_520, currVal_521, currVal_522); var currVal_550 = "small"; var currVal_551 = "primary"; var currVal_552 = ""; _ck(_v, 233, 0, currVal_550, currVal_551, currVal_552); var currVal_553 = (_co.hidePassword ? "Mostrar Senha" : "Ocultar Senha"); var currVal_554 = "primary"; _ck(_v, 236, 0, currVal_553, currVal_554); var currVal_557 = _ck(_v, 240, 0, !_co.isLoading); _ck(_v, 239, 0, currVal_557); var currVal_558 = (_co.hidePassword ? _co.showIcon : _co.hideIcon); _ck(_v, 241, 0, currVal_558); var currVal_559 = "confirmPassword"; var currVal_560 = _co.form; var currVal_561 = "Confirme a senha"; var currVal_562 = _co.errorPasswordMsg; _ck(_v, 244, 0, currVal_559, currVal_560, currVal_561, currVal_562); var currVal_588 = "confirmPassword"; _ck(_v, 249, 0, currVal_588); var currVal_589 = "large"; var currVal_590 = "primary"; var currVal_591 = ""; _ck(_v, 252, 0, currVal_589, currVal_590, currVal_591); var currVal_619 = "small"; var currVal_620 = "primary"; var currVal_621 = ""; _ck(_v, 254, 0, currVal_619, currVal_620, currVal_621); var currVal_622 = (_co.hideConfirmPassword ? "Mostrar Confirme a Senha" : "Ocultar Confirme a Senha"); var currVal_623 = "primary"; _ck(_v, 257, 0, currVal_622, currVal_623); var currVal_626 = _ck(_v, 261, 0, !_co.isLoading); _ck(_v, 260, 0, currVal_626); var currVal_627 = (_co.hideConfirmPassword ? _co.showIcon : _co.hideIcon); _ck(_v, 262, 0, currVal_627); var currVal_628 = _co.isAdmin; _ck(_v, 264, 0, currVal_628); var currVal_656 = "success"; _ck(_v, 267, 0, currVal_656); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 4).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 4).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 4).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 4).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 4).ngClassValid; var currVal_5 = core["ɵnov"](_v, 4).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 4).ngClassPending; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_11 = core["ɵnov"](_v, 15).fullWidthValue; _ck(_v, 14, 0, currVal_11); var currVal_12 = core["ɵnov"](_v, 18).disabled; var currVal_13 = core["ɵnov"](_v, 18).activeValue; _ck(_v, 17, 0, currVal_12, currVal_13); var currVal_25 = core["ɵnov"](_v, 27).outline; var currVal_26 = core["ɵnov"](_v, 27).filled; var currVal_27 = core["ɵnov"](_v, 27).hero; var currVal_28 = core["ɵnov"](_v, 27).fullWidth; var currVal_29 = core["ɵnov"](_v, 27).isOpen; var currVal_30 = core["ɵnov"](_v, 27).tiny; var currVal_31 = core["ɵnov"](_v, 27).small; var currVal_32 = core["ɵnov"](_v, 27).medium; var currVal_33 = core["ɵnov"](_v, 27).large; var currVal_34 = core["ɵnov"](_v, 27).giant; var currVal_35 = core["ɵnov"](_v, 27).primary; var currVal_36 = core["ɵnov"](_v, 27).info; var currVal_37 = core["ɵnov"](_v, 27).success; var currVal_38 = core["ɵnov"](_v, 27).warning; var currVal_39 = core["ɵnov"](_v, 27).danger; var currVal_40 = core["ɵnov"](_v, 27).basic; var currVal_41 = core["ɵnov"](_v, 27).control; var currVal_42 = core["ɵnov"](_v, 27).rectangle; var currVal_43 = core["ɵnov"](_v, 27).round; var currVal_44 = core["ɵnov"](_v, 27).semiRound; var currVal_45 = core["ɵnov"](_v, 33).ngClassUntouched; var currVal_46 = core["ɵnov"](_v, 33).ngClassTouched; var currVal_47 = core["ɵnov"](_v, 33).ngClassPristine; var currVal_48 = core["ɵnov"](_v, 33).ngClassDirty; var currVal_49 = core["ɵnov"](_v, 33).ngClassValid; var currVal_50 = core["ɵnov"](_v, 33).ngClassInvalid; var currVal_51 = core["ɵnov"](_v, 33).ngClassPending; _ck(_v, 25, 1, [currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34, currVal_35, currVal_36, currVal_37, currVal_38, currVal_39, currVal_40, currVal_41, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51]); var currVal_62 = (_co.isLoading ? true : null); var currVal_63 = (core["ɵnov"](_v, 41).maxlength ? core["ɵnov"](_v, 41).maxlength : null); var currVal_64 = core["ɵnov"](_v, 46).ngClassUntouched; var currVal_65 = core["ɵnov"](_v, 46).ngClassTouched; var currVal_66 = core["ɵnov"](_v, 46).ngClassPristine; var currVal_67 = core["ɵnov"](_v, 46).ngClassDirty; var currVal_68 = core["ɵnov"](_v, 46).ngClassValid; var currVal_69 = core["ɵnov"](_v, 46).ngClassInvalid; var currVal_70 = core["ɵnov"](_v, 46).ngClassPending; var currVal_71 = core["ɵnov"](_v, 47).fullWidth; var currVal_72 = core["ɵnov"](_v, 47).tiny; var currVal_73 = core["ɵnov"](_v, 47).small; var currVal_74 = core["ɵnov"](_v, 47).medium; var currVal_75 = core["ɵnov"](_v, 47).large; var currVal_76 = core["ɵnov"](_v, 47).giant; var currVal_77 = core["ɵnov"](_v, 47).primary; var currVal_78 = core["ɵnov"](_v, 47).info; var currVal_79 = core["ɵnov"](_v, 47).success; var currVal_80 = core["ɵnov"](_v, 47).warning; var currVal_81 = core["ɵnov"](_v, 47).danger; var currVal_82 = core["ɵnov"](_v, 47).basic; var currVal_83 = core["ɵnov"](_v, 47).control; var currVal_84 = core["ɵnov"](_v, 47).rectangle; var currVal_85 = core["ɵnov"](_v, 47).semiRound; var currVal_86 = core["ɵnov"](_v, 47).round; _ck(_v, 39, 1, [currVal_62, currVal_63, currVal_64, currVal_65, currVal_66, currVal_67, currVal_68, currVal_69, currVal_70, currVal_71, currVal_72, currVal_73, currVal_74, currVal_75, currVal_76, currVal_77, currVal_78, currVal_79, currVal_80, currVal_81, currVal_82, currVal_83, currVal_84, currVal_85, currVal_86]); var currVal_96 = core["ɵnov"](_v, 57).outline; var currVal_97 = core["ɵnov"](_v, 57).filled; var currVal_98 = core["ɵnov"](_v, 57).hero; var currVal_99 = core["ɵnov"](_v, 57).fullWidth; var currVal_100 = core["ɵnov"](_v, 57).isOpen; var currVal_101 = core["ɵnov"](_v, 57).tiny; var currVal_102 = core["ɵnov"](_v, 57).small; var currVal_103 = core["ɵnov"](_v, 57).medium; var currVal_104 = core["ɵnov"](_v, 57).large; var currVal_105 = core["ɵnov"](_v, 57).giant; var currVal_106 = core["ɵnov"](_v, 57).primary; var currVal_107 = core["ɵnov"](_v, 57).info; var currVal_108 = core["ɵnov"](_v, 57).success; var currVal_109 = core["ɵnov"](_v, 57).warning; var currVal_110 = core["ɵnov"](_v, 57).danger; var currVal_111 = core["ɵnov"](_v, 57).basic; var currVal_112 = core["ɵnov"](_v, 57).control; var currVal_113 = core["ɵnov"](_v, 57).rectangle; var currVal_114 = core["ɵnov"](_v, 57).round; var currVal_115 = core["ɵnov"](_v, 57).semiRound; var currVal_116 = core["ɵnov"](_v, 63).ngClassUntouched; var currVal_117 = core["ɵnov"](_v, 63).ngClassTouched; var currVal_118 = core["ɵnov"](_v, 63).ngClassPristine; var currVal_119 = core["ɵnov"](_v, 63).ngClassDirty; var currVal_120 = core["ɵnov"](_v, 63).ngClassValid; var currVal_121 = core["ɵnov"](_v, 63).ngClassInvalid; var currVal_122 = core["ɵnov"](_v, 63).ngClassPending; _ck(_v, 55, 1, [currVal_96, currVal_97, currVal_98, currVal_99, currVal_100, currVal_101, currVal_102, currVal_103, currVal_104, currVal_105, currVal_106, currVal_107, currVal_108, currVal_109, currVal_110, currVal_111, currVal_112, currVal_113, currVal_114, currVal_115, currVal_116, currVal_117, currVal_118, currVal_119, currVal_120, currVal_121, currVal_122]); var currVal_127 = core["ɵnov"](_v, 70).primary; var currVal_128 = core["ɵnov"](_v, 70).success; var currVal_129 = core["ɵnov"](_v, 70).warning; var currVal_130 = core["ɵnov"](_v, 70).danger; var currVal_131 = core["ɵnov"](_v, 70).info; var currVal_132 = core["ɵnov"](_v, 70).basic; var currVal_133 = core["ɵnov"](_v, 70).control; var currVal_134 = core["ɵnov"](_v, 74).ngClassUntouched; var currVal_135 = core["ɵnov"](_v, 74).ngClassTouched; var currVal_136 = core["ɵnov"](_v, 74).ngClassPristine; var currVal_137 = core["ɵnov"](_v, 74).ngClassDirty; var currVal_138 = core["ɵnov"](_v, 74).ngClassValid; var currVal_139 = core["ɵnov"](_v, 74).ngClassInvalid; var currVal_140 = core["ɵnov"](_v, 74).ngClassPending; _ck(_v, 69, 1, [currVal_127, currVal_128, currVal_129, currVal_130, currVal_131, currVal_132, currVal_133, currVal_134, currVal_135, currVal_136, currVal_137, currVal_138, currVal_139, currVal_140]); var currVal_145 = core["ɵnov"](_v, 77).primary; var currVal_146 = core["ɵnov"](_v, 77).success; var currVal_147 = core["ɵnov"](_v, 77).warning; var currVal_148 = core["ɵnov"](_v, 77).danger; var currVal_149 = core["ɵnov"](_v, 77).info; var currVal_150 = core["ɵnov"](_v, 77).basic; var currVal_151 = core["ɵnov"](_v, 77).control; var currVal_152 = core["ɵnov"](_v, 81).ngClassUntouched; var currVal_153 = core["ɵnov"](_v, 81).ngClassTouched; var currVal_154 = core["ɵnov"](_v, 81).ngClassPristine; var currVal_155 = core["ɵnov"](_v, 81).ngClassDirty; var currVal_156 = core["ɵnov"](_v, 81).ngClassValid; var currVal_157 = core["ɵnov"](_v, 81).ngClassInvalid; var currVal_158 = core["ɵnov"](_v, 81).ngClassPending; _ck(_v, 76, 1, [currVal_145, currVal_146, currVal_147, currVal_148, currVal_149, currVal_150, currVal_151, currVal_152, currVal_153, currVal_154, currVal_155, currVal_156, currVal_157, currVal_158]); var currVal_163 = core["ɵnov"](_v, 85).primary; var currVal_164 = core["ɵnov"](_v, 85).success; var currVal_165 = core["ɵnov"](_v, 85).warning; var currVal_166 = core["ɵnov"](_v, 85).danger; var currVal_167 = core["ɵnov"](_v, 85).info; var currVal_168 = core["ɵnov"](_v, 85).basic; var currVal_169 = core["ɵnov"](_v, 85).control; var currVal_170 = core["ɵnov"](_v, 89).ngClassUntouched; var currVal_171 = core["ɵnov"](_v, 89).ngClassTouched; var currVal_172 = core["ɵnov"](_v, 89).ngClassPristine; var currVal_173 = core["ɵnov"](_v, 89).ngClassDirty; var currVal_174 = core["ɵnov"](_v, 89).ngClassValid; var currVal_175 = core["ɵnov"](_v, 89).ngClassInvalid; var currVal_176 = core["ɵnov"](_v, 89).ngClassPending; _ck(_v, 84, 1, [currVal_163, currVal_164, currVal_165, currVal_166, currVal_167, currVal_168, currVal_169, currVal_170, currVal_171, currVal_172, currVal_173, currVal_174, currVal_175, currVal_176]); var currVal_181 = core["ɵnov"](_v, 92).primary; var currVal_182 = core["ɵnov"](_v, 92).success; var currVal_183 = core["ɵnov"](_v, 92).warning; var currVal_184 = core["ɵnov"](_v, 92).danger; var currVal_185 = core["ɵnov"](_v, 92).info; var currVal_186 = core["ɵnov"](_v, 92).basic; var currVal_187 = core["ɵnov"](_v, 92).control; var currVal_188 = core["ɵnov"](_v, 96).ngClassUntouched; var currVal_189 = core["ɵnov"](_v, 96).ngClassTouched; var currVal_190 = core["ɵnov"](_v, 96).ngClassPristine; var currVal_191 = core["ɵnov"](_v, 96).ngClassDirty; var currVal_192 = core["ɵnov"](_v, 96).ngClassValid; var currVal_193 = core["ɵnov"](_v, 96).ngClassInvalid; var currVal_194 = core["ɵnov"](_v, 96).ngClassPending; _ck(_v, 91, 1, [currVal_181, currVal_182, currVal_183, currVal_184, currVal_185, currVal_186, currVal_187, currVal_188, currVal_189, currVal_190, currVal_191, currVal_192, currVal_193, currVal_194]); var currVal_199 = core["ɵnov"](_v, 100).primary; var currVal_200 = core["ɵnov"](_v, 100).success; var currVal_201 = core["ɵnov"](_v, 100).warning; var currVal_202 = core["ɵnov"](_v, 100).danger; var currVal_203 = core["ɵnov"](_v, 100).info; var currVal_204 = core["ɵnov"](_v, 100).basic; var currVal_205 = core["ɵnov"](_v, 100).control; var currVal_206 = core["ɵnov"](_v, 104).ngClassUntouched; var currVal_207 = core["ɵnov"](_v, 104).ngClassTouched; var currVal_208 = core["ɵnov"](_v, 104).ngClassPristine; var currVal_209 = core["ɵnov"](_v, 104).ngClassDirty; var currVal_210 = core["ɵnov"](_v, 104).ngClassValid; var currVal_211 = core["ɵnov"](_v, 104).ngClassInvalid; var currVal_212 = core["ɵnov"](_v, 104).ngClassPending; _ck(_v, 99, 1, [currVal_199, currVal_200, currVal_201, currVal_202, currVal_203, currVal_204, currVal_205, currVal_206, currVal_207, currVal_208, currVal_209, currVal_210, currVal_211, currVal_212]); var currVal_217 = core["ɵnov"](_v, 107).disabled; var currVal_218 = core["ɵnov"](_v, 107).activeValue; _ck(_v, 106, 0, currVal_217, currVal_218); var currVal_229 = (_co.isLoading ? true : null); var currVal_230 = core["ɵnov"](_v, 118).ngClassUntouched; var currVal_231 = core["ɵnov"](_v, 118).ngClassTouched; var currVal_232 = core["ɵnov"](_v, 118).ngClassPristine; var currVal_233 = core["ɵnov"](_v, 118).ngClassDirty; var currVal_234 = core["ɵnov"](_v, 118).ngClassValid; var currVal_235 = core["ɵnov"](_v, 118).ngClassInvalid; var currVal_236 = core["ɵnov"](_v, 118).ngClassPending; var currVal_237 = core["ɵnov"](_v, 119).fullWidth; var currVal_238 = core["ɵnov"](_v, 119).tiny; var currVal_239 = core["ɵnov"](_v, 119).small; var currVal_240 = core["ɵnov"](_v, 119).medium; var currVal_241 = core["ɵnov"](_v, 119).large; var currVal_242 = core["ɵnov"](_v, 119).giant; var currVal_243 = core["ɵnov"](_v, 119).primary; var currVal_244 = core["ɵnov"](_v, 119).info; var currVal_245 = core["ɵnov"](_v, 119).success; var currVal_246 = core["ɵnov"](_v, 119).warning; var currVal_247 = core["ɵnov"](_v, 119).danger; var currVal_248 = core["ɵnov"](_v, 119).basic; var currVal_249 = core["ɵnov"](_v, 119).control; var currVal_250 = core["ɵnov"](_v, 119).rectangle; var currVal_251 = core["ɵnov"](_v, 119).semiRound; var currVal_252 = core["ɵnov"](_v, 119).round; _ck(_v, 112, 1, [currVal_229, currVal_230, currVal_231, currVal_232, currVal_233, currVal_234, currVal_235, currVal_236, currVal_237, currVal_238, currVal_239, currVal_240, currVal_241, currVal_242, currVal_243, currVal_244, currVal_245, currVal_246, currVal_247, currVal_248, currVal_249, currVal_250, currVal_251, currVal_252]); var currVal_261 = (_co.isLoading ? true : null); var currVal_262 = core["ɵnov"](_v, 130).ngClassUntouched; var currVal_263 = core["ɵnov"](_v, 130).ngClassTouched; var currVal_264 = core["ɵnov"](_v, 130).ngClassPristine; var currVal_265 = core["ɵnov"](_v, 130).ngClassDirty; var currVal_266 = core["ɵnov"](_v, 130).ngClassValid; var currVal_267 = core["ɵnov"](_v, 130).ngClassInvalid; var currVal_268 = core["ɵnov"](_v, 130).ngClassPending; var currVal_269 = core["ɵnov"](_v, 131).fullWidth; var currVal_270 = core["ɵnov"](_v, 131).tiny; var currVal_271 = core["ɵnov"](_v, 131).small; var currVal_272 = core["ɵnov"](_v, 131).medium; var currVal_273 = core["ɵnov"](_v, 131).large; var currVal_274 = core["ɵnov"](_v, 131).giant; var currVal_275 = core["ɵnov"](_v, 131).primary; var currVal_276 = core["ɵnov"](_v, 131).info; var currVal_277 = core["ɵnov"](_v, 131).success; var currVal_278 = core["ɵnov"](_v, 131).warning; var currVal_279 = core["ɵnov"](_v, 131).danger; var currVal_280 = core["ɵnov"](_v, 131).basic; var currVal_281 = core["ɵnov"](_v, 131).control; var currVal_282 = core["ɵnov"](_v, 131).rectangle; var currVal_283 = core["ɵnov"](_v, 131).semiRound; var currVal_284 = core["ɵnov"](_v, 131).round; _ck(_v, 124, 1, [currVal_261, currVal_262, currVal_263, currVal_264, currVal_265, currVal_266, currVal_267, currVal_268, currVal_269, currVal_270, currVal_271, currVal_272, currVal_273, currVal_274, currVal_275, currVal_276, currVal_277, currVal_278, currVal_279, currVal_280, currVal_281, currVal_282, currVal_283, currVal_284]); var currVal_293 = (_co.isLoading ? true : null); var currVal_294 = core["ɵnov"](_v, 142).ngClassUntouched; var currVal_295 = core["ɵnov"](_v, 142).ngClassTouched; var currVal_296 = core["ɵnov"](_v, 142).ngClassPristine; var currVal_297 = core["ɵnov"](_v, 142).ngClassDirty; var currVal_298 = core["ɵnov"](_v, 142).ngClassValid; var currVal_299 = core["ɵnov"](_v, 142).ngClassInvalid; var currVal_300 = core["ɵnov"](_v, 142).ngClassPending; var currVal_301 = core["ɵnov"](_v, 143).fullWidth; var currVal_302 = core["ɵnov"](_v, 143).tiny; var currVal_303 = core["ɵnov"](_v, 143).small; var currVal_304 = core["ɵnov"](_v, 143).medium; var currVal_305 = core["ɵnov"](_v, 143).large; var currVal_306 = core["ɵnov"](_v, 143).giant; var currVal_307 = core["ɵnov"](_v, 143).primary; var currVal_308 = core["ɵnov"](_v, 143).info; var currVal_309 = core["ɵnov"](_v, 143).success; var currVal_310 = core["ɵnov"](_v, 143).warning; var currVal_311 = core["ɵnov"](_v, 143).danger; var currVal_312 = core["ɵnov"](_v, 143).basic; var currVal_313 = core["ɵnov"](_v, 143).control; var currVal_314 = core["ɵnov"](_v, 143).rectangle; var currVal_315 = core["ɵnov"](_v, 143).semiRound; var currVal_316 = core["ɵnov"](_v, 143).round; _ck(_v, 136, 1, [currVal_293, currVal_294, currVal_295, currVal_296, currVal_297, currVal_298, currVal_299, currVal_300, currVal_301, currVal_302, currVal_303, currVal_304, currVal_305, currVal_306, currVal_307, currVal_308, currVal_309, currVal_310, currVal_311, currVal_312, currVal_313, currVal_314, currVal_315, currVal_316]); var currVal_322 = core["ɵnov"](_v, 149).primary; var currVal_323 = core["ɵnov"](_v, 149).success; var currVal_324 = core["ɵnov"](_v, 149).warning; var currVal_325 = core["ɵnov"](_v, 149).danger; var currVal_326 = core["ɵnov"](_v, 149).info; var currVal_327 = core["ɵnov"](_v, 149).basic; var currVal_328 = core["ɵnov"](_v, 149).control; var currVal_329 = core["ɵnov"](_v, 153).ngClassUntouched; var currVal_330 = core["ɵnov"](_v, 153).ngClassTouched; var currVal_331 = core["ɵnov"](_v, 153).ngClassPristine; var currVal_332 = core["ɵnov"](_v, 153).ngClassDirty; var currVal_333 = core["ɵnov"](_v, 153).ngClassValid; var currVal_334 = core["ɵnov"](_v, 153).ngClassInvalid; var currVal_335 = core["ɵnov"](_v, 153).ngClassPending; _ck(_v, 148, 1, [currVal_322, currVal_323, currVal_324, currVal_325, currVal_326, currVal_327, currVal_328, currVal_329, currVal_330, currVal_331, currVal_332, currVal_333, currVal_334, currVal_335]); var currVal_340 = core["ɵnov"](_v, 156).primary; var currVal_341 = core["ɵnov"](_v, 156).success; var currVal_342 = core["ɵnov"](_v, 156).warning; var currVal_343 = core["ɵnov"](_v, 156).danger; var currVal_344 = core["ɵnov"](_v, 156).info; var currVal_345 = core["ɵnov"](_v, 156).basic; var currVal_346 = core["ɵnov"](_v, 156).control; var currVal_347 = core["ɵnov"](_v, 160).ngClassUntouched; var currVal_348 = core["ɵnov"](_v, 160).ngClassTouched; var currVal_349 = core["ɵnov"](_v, 160).ngClassPristine; var currVal_350 = core["ɵnov"](_v, 160).ngClassDirty; var currVal_351 = core["ɵnov"](_v, 160).ngClassValid; var currVal_352 = core["ɵnov"](_v, 160).ngClassInvalid; var currVal_353 = core["ɵnov"](_v, 160).ngClassPending; _ck(_v, 155, 1, [currVal_340, currVal_341, currVal_342, currVal_343, currVal_344, currVal_345, currVal_346, currVal_347, currVal_348, currVal_349, currVal_350, currVal_351, currVal_352, currVal_353]); var currVal_360 = core["ɵnov"](_v, 167).disabled; var currVal_361 = core["ɵnov"](_v, 167).activeValue; _ck(_v, 166, 0, currVal_360, currVal_361); var currVal_370 = (_co.isLoading ? true : null); var currVal_371 = core["ɵnov"](_v, 178).ngClassUntouched; var currVal_372 = core["ɵnov"](_v, 178).ngClassTouched; var currVal_373 = core["ɵnov"](_v, 178).ngClassPristine; var currVal_374 = core["ɵnov"](_v, 178).ngClassDirty; var currVal_375 = core["ɵnov"](_v, 178).ngClassValid; var currVal_376 = core["ɵnov"](_v, 178).ngClassInvalid; var currVal_377 = core["ɵnov"](_v, 178).ngClassPending; var currVal_378 = core["ɵnov"](_v, 179).fullWidth; var currVal_379 = core["ɵnov"](_v, 179).tiny; var currVal_380 = core["ɵnov"](_v, 179).small; var currVal_381 = core["ɵnov"](_v, 179).medium; var currVal_382 = core["ɵnov"](_v, 179).large; var currVal_383 = core["ɵnov"](_v, 179).giant; var currVal_384 = core["ɵnov"](_v, 179).primary; var currVal_385 = core["ɵnov"](_v, 179).info; var currVal_386 = core["ɵnov"](_v, 179).success; var currVal_387 = core["ɵnov"](_v, 179).warning; var currVal_388 = core["ɵnov"](_v, 179).danger; var currVal_389 = core["ɵnov"](_v, 179).basic; var currVal_390 = core["ɵnov"](_v, 179).control; var currVal_391 = core["ɵnov"](_v, 179).rectangle; var currVal_392 = core["ɵnov"](_v, 179).semiRound; var currVal_393 = core["ɵnov"](_v, 179).round; _ck(_v, 172, 1, [currVal_370, currVal_371, currVal_372, currVal_373, currVal_374, currVal_375, currVal_376, currVal_377, currVal_378, currVal_379, currVal_380, currVal_381, currVal_382, currVal_383, currVal_384, currVal_385, currVal_386, currVal_387, currVal_388, currVal_389, currVal_390, currVal_391, currVal_392, currVal_393]); var currVal_402 = (_co.isLoading ? true : null); var currVal_403 = (core["ɵnov"](_v, 186).maxlength ? core["ɵnov"](_v, 186).maxlength : null); var currVal_404 = core["ɵnov"](_v, 191).ngClassUntouched; var currVal_405 = core["ɵnov"](_v, 191).ngClassTouched; var currVal_406 = core["ɵnov"](_v, 191).ngClassPristine; var currVal_407 = core["ɵnov"](_v, 191).ngClassDirty; var currVal_408 = core["ɵnov"](_v, 191).ngClassValid; var currVal_409 = core["ɵnov"](_v, 191).ngClassInvalid; var currVal_410 = core["ɵnov"](_v, 191).ngClassPending; var currVal_411 = core["ɵnov"](_v, 192).fullWidth; var currVal_412 = core["ɵnov"](_v, 192).tiny; var currVal_413 = core["ɵnov"](_v, 192).small; var currVal_414 = core["ɵnov"](_v, 192).medium; var currVal_415 = core["ɵnov"](_v, 192).large; var currVal_416 = core["ɵnov"](_v, 192).giant; var currVal_417 = core["ɵnov"](_v, 192).primary; var currVal_418 = core["ɵnov"](_v, 192).info; var currVal_419 = core["ɵnov"](_v, 192).success; var currVal_420 = core["ɵnov"](_v, 192).warning; var currVal_421 = core["ɵnov"](_v, 192).danger; var currVal_422 = core["ɵnov"](_v, 192).basic; var currVal_423 = core["ɵnov"](_v, 192).control; var currVal_424 = core["ɵnov"](_v, 192).rectangle; var currVal_425 = core["ɵnov"](_v, 192).semiRound; var currVal_426 = core["ɵnov"](_v, 192).round; _ck(_v, 184, 1, [currVal_402, currVal_403, currVal_404, currVal_405, currVal_406, currVal_407, currVal_408, currVal_409, currVal_410, currVal_411, currVal_412, currVal_413, currVal_414, currVal_415, currVal_416, currVal_417, currVal_418, currVal_419, currVal_420, currVal_421, currVal_422, currVal_423, currVal_424, currVal_425, currVal_426]); var currVal_431 = core["ɵnov"](_v, 195).primary; var currVal_432 = core["ɵnov"](_v, 195).success; var currVal_433 = core["ɵnov"](_v, 195).warning; var currVal_434 = core["ɵnov"](_v, 195).danger; var currVal_435 = core["ɵnov"](_v, 195).info; var currVal_436 = core["ɵnov"](_v, 195).basic; var currVal_437 = core["ɵnov"](_v, 195).control; var currVal_438 = core["ɵnov"](_v, 199).ngClassUntouched; var currVal_439 = core["ɵnov"](_v, 199).ngClassTouched; var currVal_440 = core["ɵnov"](_v, 199).ngClassPristine; var currVal_441 = core["ɵnov"](_v, 199).ngClassDirty; var currVal_442 = core["ɵnov"](_v, 199).ngClassValid; var currVal_443 = core["ɵnov"](_v, 199).ngClassInvalid; var currVal_444 = core["ɵnov"](_v, 199).ngClassPending; _ck(_v, 194, 1, [currVal_431, currVal_432, currVal_433, currVal_434, currVal_435, currVal_436, currVal_437, currVal_438, currVal_439, currVal_440, currVal_441, currVal_442, currVal_443, currVal_444]); var currVal_453 = ((_co.isLoading || (_co.form.get("discountWithMoneyPaymentValue").value === false)) ? true : null); var currVal_454 = (core["ɵnov"](_v, 206).maxlength ? core["ɵnov"](_v, 206).maxlength : null); var currVal_455 = core["ɵnov"](_v, 211).ngClassUntouched; var currVal_456 = core["ɵnov"](_v, 211).ngClassTouched; var currVal_457 = core["ɵnov"](_v, 211).ngClassPristine; var currVal_458 = core["ɵnov"](_v, 211).ngClassDirty; var currVal_459 = core["ɵnov"](_v, 211).ngClassValid; var currVal_460 = core["ɵnov"](_v, 211).ngClassInvalid; var currVal_461 = core["ɵnov"](_v, 211).ngClassPending; var currVal_462 = core["ɵnov"](_v, 212).fullWidth; var currVal_463 = core["ɵnov"](_v, 212).tiny; var currVal_464 = core["ɵnov"](_v, 212).small; var currVal_465 = core["ɵnov"](_v, 212).medium; var currVal_466 = core["ɵnov"](_v, 212).large; var currVal_467 = core["ɵnov"](_v, 212).giant; var currVal_468 = core["ɵnov"](_v, 212).primary; var currVal_469 = core["ɵnov"](_v, 212).info; var currVal_470 = core["ɵnov"](_v, 212).success; var currVal_471 = core["ɵnov"](_v, 212).warning; var currVal_472 = core["ɵnov"](_v, 212).danger; var currVal_473 = core["ɵnov"](_v, 212).basic; var currVal_474 = core["ɵnov"](_v, 212).control; var currVal_475 = core["ɵnov"](_v, 212).rectangle; var currVal_476 = core["ɵnov"](_v, 212).semiRound; var currVal_477 = core["ɵnov"](_v, 212).round; _ck(_v, 203, 1, [currVal_453, currVal_454, currVal_455, currVal_456, currVal_457, currVal_458, currVal_459, currVal_460, currVal_461, currVal_462, currVal_463, currVal_464, currVal_465, currVal_466, currVal_467, currVal_468, currVal_469, currVal_470, currVal_471, currVal_472, currVal_473, currVal_474, currVal_475, currVal_476, currVal_477]); var currVal_484 = core["ɵnov"](_v, 215).disabled; var currVal_485 = core["ɵnov"](_v, 215).activeValue; _ck(_v, 214, 0, currVal_484, currVal_485); var currVal_494 = (_co.isLoading ? true : null); var currVal_495 = (_co.hidePassword ? "password" : "text"); var currVal_496 = core["ɵnov"](_v, 230).ngClassUntouched; var currVal_497 = core["ɵnov"](_v, 230).ngClassTouched; var currVal_498 = core["ɵnov"](_v, 230).ngClassPristine; var currVal_499 = core["ɵnov"](_v, 230).ngClassDirty; var currVal_500 = core["ɵnov"](_v, 230).ngClassValid; var currVal_501 = core["ɵnov"](_v, 230).ngClassInvalid; var currVal_502 = core["ɵnov"](_v, 230).ngClassPending; var currVal_503 = core["ɵnov"](_v, 231).fullWidth; var currVal_504 = core["ɵnov"](_v, 231).tiny; var currVal_505 = core["ɵnov"](_v, 231).small; var currVal_506 = core["ɵnov"](_v, 231).medium; var currVal_507 = core["ɵnov"](_v, 231).large; var currVal_508 = core["ɵnov"](_v, 231).giant; var currVal_509 = core["ɵnov"](_v, 231).primary; var currVal_510 = core["ɵnov"](_v, 231).info; var currVal_511 = core["ɵnov"](_v, 231).success; var currVal_512 = core["ɵnov"](_v, 231).warning; var currVal_513 = core["ɵnov"](_v, 231).danger; var currVal_514 = core["ɵnov"](_v, 231).basic; var currVal_515 = core["ɵnov"](_v, 231).control; var currVal_516 = core["ɵnov"](_v, 231).rectangle; var currVal_517 = core["ɵnov"](_v, 231).semiRound; var currVal_518 = core["ɵnov"](_v, 231).round; _ck(_v, 225, 1, [currVal_494, currVal_495, currVal_496, currVal_497, currVal_498, currVal_499, currVal_500, currVal_501, currVal_502, currVal_503, currVal_504, currVal_505, currVal_506, currVal_507, currVal_508, currVal_509, currVal_510, currVal_511, currVal_512, currVal_513, currVal_514, currVal_515, currVal_516, currVal_517, currVal_518]); var currVal_523 = (_co.isLoading ? true : null); var currVal_524 = core["ɵnov"](_v, 233).filled; var currVal_525 = core["ɵnov"](_v, 233).outline; var currVal_526 = core["ɵnov"](_v, 233).ghost; var currVal_527 = core["ɵnov"](_v, 233).hero; var currVal_528 = core["ɵnov"](_v, 233).fullWidth; var currVal_529 = core["ɵnov"](_v, 233).disabled; var currVal_530 = core["ɵnov"](_v, 233).disabled; var currVal_531 = core["ɵnov"](_v, 233).tabbable; var currVal_532 = core["ɵnov"](_v, 233).tiny; var currVal_533 = core["ɵnov"](_v, 233).small; var currVal_534 = core["ɵnov"](_v, 233).medium; var currVal_535 = core["ɵnov"](_v, 233).large; var currVal_536 = core["ɵnov"](_v, 233).giant; var currVal_537 = core["ɵnov"](_v, 233).primary; var currVal_538 = core["ɵnov"](_v, 233).info; var currVal_539 = core["ɵnov"](_v, 233).success; var currVal_540 = core["ɵnov"](_v, 233).warning; var currVal_541 = core["ɵnov"](_v, 233).danger; var currVal_542 = core["ɵnov"](_v, 233).basic; var currVal_543 = core["ɵnov"](_v, 233).control; var currVal_544 = core["ɵnov"](_v, 233).rectangle; var currVal_545 = core["ɵnov"](_v, 233).round; var currVal_546 = core["ɵnov"](_v, 233).semiRound; var currVal_547 = core["ɵnov"](_v, 233).iconLeft; var currVal_548 = core["ɵnov"](_v, 233).iconRight; var currVal_549 = core["ɵnov"](_v, 233).transitions; _ck(_v, 232, 1, [currVal_523, currVal_524, currVal_525, currVal_526, currVal_527, currVal_528, currVal_529, currVal_530, currVal_531, currVal_532, currVal_533, currVal_534, currVal_535, currVal_536, currVal_537, currVal_538, currVal_539, currVal_540, currVal_541, currVal_542, currVal_543, currVal_544, currVal_545, currVal_546, currVal_547, currVal_548, currVal_549]); var currVal_555 = core["ɵnov"](_v, 241).title; var currVal_556 = core["ɵnov"](_v, 241).renderedIconHTML; _ck(_v, 237, 0, currVal_555, currVal_556); var currVal_563 = (_co.isLoading ? true : null); var currVal_564 = (_co.hideConfirmPassword ? "password" : "text"); var currVal_565 = core["ɵnov"](_v, 251).ngClassUntouched; var currVal_566 = core["ɵnov"](_v, 251).ngClassTouched; var currVal_567 = core["ɵnov"](_v, 251).ngClassPristine; var currVal_568 = core["ɵnov"](_v, 251).ngClassDirty; var currVal_569 = core["ɵnov"](_v, 251).ngClassValid; var currVal_570 = core["ɵnov"](_v, 251).ngClassInvalid; var currVal_571 = core["ɵnov"](_v, 251).ngClassPending; var currVal_572 = core["ɵnov"](_v, 252).fullWidth; var currVal_573 = core["ɵnov"](_v, 252).tiny; var currVal_574 = core["ɵnov"](_v, 252).small; var currVal_575 = core["ɵnov"](_v, 252).medium; var currVal_576 = core["ɵnov"](_v, 252).large; var currVal_577 = core["ɵnov"](_v, 252).giant; var currVal_578 = core["ɵnov"](_v, 252).primary; var currVal_579 = core["ɵnov"](_v, 252).info; var currVal_580 = core["ɵnov"](_v, 252).success; var currVal_581 = core["ɵnov"](_v, 252).warning; var currVal_582 = core["ɵnov"](_v, 252).danger; var currVal_583 = core["ɵnov"](_v, 252).basic; var currVal_584 = core["ɵnov"](_v, 252).control; var currVal_585 = core["ɵnov"](_v, 252).rectangle; var currVal_586 = core["ɵnov"](_v, 252).semiRound; var currVal_587 = core["ɵnov"](_v, 252).round; _ck(_v, 246, 1, [currVal_563, currVal_564, currVal_565, currVal_566, currVal_567, currVal_568, currVal_569, currVal_570, currVal_571, currVal_572, currVal_573, currVal_574, currVal_575, currVal_576, currVal_577, currVal_578, currVal_579, currVal_580, currVal_581, currVal_582, currVal_583, currVal_584, currVal_585, currVal_586, currVal_587]); var currVal_592 = (_co.isLoading ? true : null); var currVal_593 = core["ɵnov"](_v, 254).filled; var currVal_594 = core["ɵnov"](_v, 254).outline; var currVal_595 = core["ɵnov"](_v, 254).ghost; var currVal_596 = core["ɵnov"](_v, 254).hero; var currVal_597 = core["ɵnov"](_v, 254).fullWidth; var currVal_598 = core["ɵnov"](_v, 254).disabled; var currVal_599 = core["ɵnov"](_v, 254).disabled; var currVal_600 = core["ɵnov"](_v, 254).tabbable; var currVal_601 = core["ɵnov"](_v, 254).tiny; var currVal_602 = core["ɵnov"](_v, 254).small; var currVal_603 = core["ɵnov"](_v, 254).medium; var currVal_604 = core["ɵnov"](_v, 254).large; var currVal_605 = core["ɵnov"](_v, 254).giant; var currVal_606 = core["ɵnov"](_v, 254).primary; var currVal_607 = core["ɵnov"](_v, 254).info; var currVal_608 = core["ɵnov"](_v, 254).success; var currVal_609 = core["ɵnov"](_v, 254).warning; var currVal_610 = core["ɵnov"](_v, 254).danger; var currVal_611 = core["ɵnov"](_v, 254).basic; var currVal_612 = core["ɵnov"](_v, 254).control; var currVal_613 = core["ɵnov"](_v, 254).rectangle; var currVal_614 = core["ɵnov"](_v, 254).round; var currVal_615 = core["ɵnov"](_v, 254).semiRound; var currVal_616 = core["ɵnov"](_v, 254).iconLeft; var currVal_617 = core["ɵnov"](_v, 254).iconRight; var currVal_618 = core["ɵnov"](_v, 254).transitions; _ck(_v, 253, 1, [currVal_592, currVal_593, currVal_594, currVal_595, currVal_596, currVal_597, currVal_598, currVal_599, currVal_600, currVal_601, currVal_602, currVal_603, currVal_604, currVal_605, currVal_606, currVal_607, currVal_608, currVal_609, currVal_610, currVal_611, currVal_612, currVal_613, currVal_614, currVal_615, currVal_616, currVal_617, currVal_618]); var currVal_624 = core["ɵnov"](_v, 262).title; var currVal_625 = core["ɵnov"](_v, 262).renderedIconHTML; _ck(_v, 258, 0, currVal_624, currVal_625); var currVal_629 = ((_co.isLoading || (_co.activeTab === "ifood")) ? true : null); var currVal_630 = core["ɵnov"](_v, 267).filled; var currVal_631 = core["ɵnov"](_v, 267).outline; var currVal_632 = core["ɵnov"](_v, 267).ghost; var currVal_633 = core["ɵnov"](_v, 267).hero; var currVal_634 = core["ɵnov"](_v, 267).fullWidth; var currVal_635 = core["ɵnov"](_v, 267).disabled; var currVal_636 = core["ɵnov"](_v, 267).disabled; var currVal_637 = core["ɵnov"](_v, 267).tabbable; var currVal_638 = core["ɵnov"](_v, 267).tiny; var currVal_639 = core["ɵnov"](_v, 267).small; var currVal_640 = core["ɵnov"](_v, 267).medium; var currVal_641 = core["ɵnov"](_v, 267).large; var currVal_642 = core["ɵnov"](_v, 267).giant; var currVal_643 = core["ɵnov"](_v, 267).primary; var currVal_644 = core["ɵnov"](_v, 267).info; var currVal_645 = core["ɵnov"](_v, 267).success; var currVal_646 = core["ɵnov"](_v, 267).warning; var currVal_647 = core["ɵnov"](_v, 267).danger; var currVal_648 = core["ɵnov"](_v, 267).basic; var currVal_649 = core["ɵnov"](_v, 267).control; var currVal_650 = core["ɵnov"](_v, 267).rectangle; var currVal_651 = core["ɵnov"](_v, 267).round; var currVal_652 = core["ɵnov"](_v, 267).semiRound; var currVal_653 = core["ɵnov"](_v, 267).iconLeft; var currVal_654 = core["ɵnov"](_v, 267).iconRight; var currVal_655 = core["ɵnov"](_v, 267).transitions; _ck(_v, 266, 1, [currVal_629, currVal_630, currVal_631, currVal_632, currVal_633, currVal_634, currVal_635, currVal_636, currVal_637, currVal_638, currVal_639, currVal_640, currVal_641, currVal_642, currVal_643, currVal_644, currVal_645, currVal_646, currVal_647, currVal_648, currVal_649, currVal_650, currVal_651, currVal_652, currVal_653, currVal_654, currVal_655]); var currVal_657 = (_co.isLoading ? "Aguarde..." : "Salvar"); _ck(_v, 268, 0, currVal_657); }); }
function View_SettingsComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-settings", [], null, null, null, View_SettingsComponent_0, RenderType_SettingsComponent)), core["ɵdid"](1, 114688, null, 0, settings_component_SettingsComponent, [core["ChangeDetectorRef"], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */], request_service["a" /* RequestService */], fesm2015["Ld" /* NbToastrService */], fesm2015_forms["g" /* FormBuilder */], router["l" /* Router */], empresa_service["a" /* EmpresaService */], plano_service_PlanoService, produto_service["a" /* ProdutoService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var SettingsComponentNgFactory = core["ɵccf"]("omni-settings", settings_component_SettingsComponent, View_SettingsComponent_Host_0, {}, {}, []);


// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/sweetalert2-ngx-sweetalert2.ngfactory.js
var sweetalert2_ngx_sweetalert2_ngfactory = __webpack_require__("kExW");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/ngx-bootstrap-typeahead.ngfactory.js
var ngx_bootstrap_typeahead_ngfactory = __webpack_require__("SfUx");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/cashback-credit-dialog/cashback-credit-dialog.component.ngfactory.js + 1 modules
var cashback_credit_dialog_component_ngfactory = __webpack_require__("sKAB");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/category/category-quick-form-dialog/category-quick-form-dialog.component.ngfactory.js + 1 modules
var category_quick_form_dialog_component_ngfactory = __webpack_require__("iY9W");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/customization/edit-customization-value-dialog/edit-customization-value-dialog.component.ngfactory.js + 1 modules
var edit_customization_value_dialog_component_ngfactory = __webpack_require__("x9iD");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/edit-delivery-address-dialog/edit-delivery-address-dialog.component.ngfactory.js + 1 modules
var edit_delivery_address_dialog_component_ngfactory = __webpack_require__("EXuQ");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/extract-cashback-list-dialog/extract-cashback-list-dialog.component.ngfactory.js + 1 modules
var extract_cashback_list_dialog_component_ngfactory = __webpack_require__("ZjL+");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-detail-dialog/order-detail-dialog.component.ngfactory.js + 3 modules
var order_detail_dialog_component_ngfactory = __webpack_require__("lbLe");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-update-dialog/order-update-dialog.component.ngfactory.js + 1 modules
var order_update_dialog_component_ngfactory = __webpack_require__("/Cjm");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-edit-dialog/promotion-rule-edit-dialog.component.ngfactory.js + 1 modules
var promotion_rule_edit_dialog_component_ngfactory = __webpack_require__("AHux");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/view-picture-dialog/view-picture-dialog.component.ngfactory.js + 1 modules
var view_picture_dialog_component_ngfactory = __webpack_require__("YAEL");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-gift-edit-dialog/promotion-gift-edit-dialog.component.ngfactory.js + 1 modules
var promotion_gift_edit_dialog_component_ngfactory = __webpack_require__("RswS");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-view-dialog/promotion-rule-view-dialog.component.ngfactory.js + 1 modules
var promotion_rule_view_dialog_component_ngfactory = __webpack_require__("BRe2");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-feedback-dialog/order-feedback-dialog.component.ngfactory.js + 1 modules
var order_feedback_dialog_component_ngfactory = __webpack_require__("otmp");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/tutorial-dialog/tutorial-dialog.component.ngfactory.js + 1 modules
var tutorial_dialog_component_ngfactory = __webpack_require__("Uvoc");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/overlay.js
var overlay = __webpack_require__("QQfA");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/bidi.js
var bidi = __webpack_require__("IP0z");

// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/fesm2015/sweetalert2-ngx-sweetalert2.js
var sweetalert2_ngx_sweetalert2 = __webpack_require__("hvj1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/positioning/fesm2015/ngx-bootstrap-positioning.js
var ngx_bootstrap_positioning = __webpack_require__("2uy1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/component-loader/fesm2015/ngx-bootstrap-component-loader.js
var ngx_bootstrap_component_loader = __webpack_require__("z/SZ");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/fesm2015/ngx-bootstrap-typeahead.js + 2 modules
var ngx_bootstrap_typeahead = __webpack_require__("ZMeN");

// EXTERNAL MODULE: ./node_modules/br-mask/dist/app.module.js
var app_module = __webpack_require__("CbX2");

// EXTERNAL MODULE: ./src/app/shared/directives/directives.module.ts + 1 modules
var directives_module = __webpack_require__("yGOH");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/portal.js
var portal = __webpack_require__("zMNK");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/platform.js
var platform = __webpack_require__("/HVE");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/scrolling.js + 6 modules
var scrolling = __webpack_require__("hOhj");

// CONCATENATED MODULE: ./src/app/pages/company/settings/settings-routing.module.ts


const routes = [
    {
        path: '', component: settings_component_SettingsComponent,
    }
];
class SettingsRoutingModule {
}

// EXTERNAL MODULE: ./node_modules/angular2-chartjs/dist/chart.module.js
var chart_module = __webpack_require__("AE88");

// EXTERNAL MODULE: ./node_modules/@nebular/eva-icons/fesm2015/index.js
var eva_icons_fesm2015 = __webpack_require__("XoTT");

// EXTERNAL MODULE: ./node_modules/ngx-dropzone/fesm2015/ngx-dropzone.js
var ngx_dropzone = __webpack_require__("tq8E");

// EXTERNAL MODULE: ./src/app/shared/pipes/pipes.module.ts + 9 modules
var pipes_module = __webpack_require__("9Xeq");

// EXTERNAL MODULE: ./src/app/shared/ui/ui.module.ts + 6 modules
var ui_module = __webpack_require__("4zvT");

// CONCATENATED MODULE: ./src/app/pages/company/settings/settings.module.ngfactory.js
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SettingsModuleNgFactory", function() { return SettingsModuleNgFactory; });
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 












































var SettingsModuleNgFactory = core["ɵcmf"](SettingsModule, [], function (_l) { return core["ɵmod"]([core["ɵmpd"](512, core["ComponentFactoryResolver"], core["ɵCodegenComponentFactoryResolver"], [[8, [angular_fontawesome_ngfactory["b" /* FaIconComponentNgFactory */], angular_fontawesome_ngfactory["a" /* FaDuotoneIconComponentNgFactory */], router_ngfactory["a" /* ɵangular_packages_router_router_lNgFactory */], index_ngfactory["k" /* NbPopoverComponentNgFactory */], index_ngfactory["n" /* NbTooltipComponentNgFactory */], SettingsComponentNgFactory, sweetalert2_ngx_sweetalert2_ngfactory["b" /* SwalComponentNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["d" /* ɵcNgFactory */], index_ngfactory["h" /* NbContextMenuComponentNgFactory */], index_ngfactory["j" /* NbDialogContainerComponentNgFactory */], ngx_bootstrap_typeahead_ngfactory["a" /* TypeaheadContainerComponentNgFactory */], cashback_credit_dialog_component_ngfactory["a" /* CashbackCreditDialogComponentNgFactory */], category_quick_form_dialog_component_ngfactory["a" /* CategoryQuickFormDialogComponentNgFactory */], edit_customization_value_dialog_component_ngfactory["a" /* EditCustomizationValueDialogComponentNgFactory */], edit_delivery_address_dialog_component_ngfactory["a" /* EditDeliveryAddressDialogComponentNgFactory */], extract_cashback_list_dialog_component_ngfactory["a" /* ExtractCashbackListDialogComponentNgFactory */], order_detail_dialog_component_ngfactory["a" /* OrderDetailDialogComponentNgFactory */], order_update_dialog_component_ngfactory["a" /* OrderUpdateDialogComponentNgFactory */], promotion_rule_edit_dialog_component_ngfactory["a" /* PromotionRuleEditDialogComponentNgFactory */], view_picture_dialog_component_ngfactory["b" /* ViewPictureDialogComponentNgFactory */], promotion_gift_edit_dialog_component_ngfactory["a" /* PromotionGiftEditDialogComponentNgFactory */], promotion_rule_view_dialog_component_ngfactory["a" /* PromotionRuleViewDialogComponentNgFactory */], order_feedback_dialog_component_ngfactory["a" /* OrderFeedbackDialogComponentNgFactory */], tutorial_dialog_component_ngfactory["b" /* TutorialDialogComponentNgFactory */]]], [3, core["ComponentFactoryResolver"]], core["NgModuleRef"]]), core["ɵmpd"](4608, common["q" /* NgLocalization */], common["p" /* NgLocaleLocalization */], [core["LOCALE_ID"], [2, common["R" /* ɵangular_packages_common_common_a */]]]), core["ɵmpd"](4608, fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], []), core["ɵmpd"](4608, overlay["d" /* Overlay */], overlay["d" /* Overlay */], [overlay["i" /* ScrollStrategyOptions */], overlay["e" /* OverlayContainer */], core["ComponentFactoryResolver"], overlay["h" /* OverlayPositionBuilder */], overlay["f" /* OverlayKeyboardDispatcher */], core["Injector"], core["NgZone"], common["e" /* DOCUMENT */], bidi["b" /* Directionality */], [2, common["k" /* Location */]]]), core["ɵmpd"](5120, overlay["j" /* ɵc */], overlay["k" /* ɵd */], [overlay["d" /* Overlay */]]), core["ɵmpd"](4608, fesm2015_forms["g" /* FormBuilder */], fesm2015_forms["g" /* FormBuilder */], []), core["ɵmpd"](4608, sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], []), core["ɵmpd"](4608, ngx_bootstrap_positioning["a" /* PositioningService */], ngx_bootstrap_positioning["a" /* PositioningService */], [core["NgZone"], core["RendererFactory2"], core["PLATFORM_ID"]]), core["ɵmpd"](4608, ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], [core["ComponentFactoryResolver"], core["NgZone"], core["Injector"], ngx_bootstrap_positioning["a" /* PositioningService */], core["ApplicationRef"]]), core["ɵmpd"](4608, ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], []), core["ɵmpd"](1073742336, common["c" /* CommonModule */], common["c" /* CommonModule */], []), core["ɵmpd"](1073742336, app_module["a" /* BrMaskerModule */], app_module["a" /* BrMaskerModule */], []), core["ɵmpd"](1073742336, directives_module["a" /* DirectivesModule */], directives_module["a" /* DirectivesModule */], []), core["ɵmpd"](1073742336, angular_fontawesome["j" /* FontAwesomeModule */], angular_fontawesome["j" /* FontAwesomeModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], []), core["ɵmpd"](1073742336, fesm2015_forms["n" /* FormsModule */], fesm2015_forms["n" /* FormsModule */], []), core["ɵmpd"](1073742336, router["p" /* RouterModule */], router["p" /* RouterModule */], [[2, router["u" /* ɵangular_packages_router_router_a */]], [2, router["l" /* Router */]]]), core["ɵmpd"](1073742336, fesm2015["pe" /* ɵc */], fesm2015["pe" /* ɵc */], []), core["ɵmpd"](1073742336, fesm2015["M" /* NbButtonModule */], fesm2015["M" /* NbButtonModule */], []), core["ɵmpd"](1073742336, fesm2015["dc" /* NbIconModule */], fesm2015["dc" /* NbIconModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["Bb" /* NbCheckboxModule */], fesm2015["Bb" /* NbCheckboxModule */], []), core["ɵmpd"](1073742336, fesm2015["fc" /* NbInputModule */], fesm2015["fc" /* NbInputModule */], []), core["ɵmpd"](1073742336, bidi["a" /* BidiModule */], bidi["a" /* BidiModule */], []), core["ɵmpd"](1073742336, portal["f" /* PortalModule */], portal["f" /* PortalModule */], []), core["ɵmpd"](1073742336, platform["b" /* PlatformModule */], platform["b" /* PlatformModule */], []), core["ɵmpd"](1073742336, scrolling["b" /* ScrollingModule */], scrolling["b" /* ScrollingModule */], []), core["ɵmpd"](1073742336, overlay["g" /* OverlayModule */], overlay["g" /* OverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["pb" /* NbCdkMappingModule */], fesm2015["pb" /* NbCdkMappingModule */], []), core["ɵmpd"](1073742336, fesm2015["ob" /* NbCdkAdapterModule */], fesm2015["ob" /* NbCdkAdapterModule */], []), core["ɵmpd"](1073742336, fesm2015["Ec" /* NbOverlayModule */], fesm2015["Ec" /* NbOverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["Lc" /* NbPopoverModule */], fesm2015["Lc" /* NbPopoverModule */], []), core["ɵmpd"](1073742336, fesm2015["nb" /* NbCardModule */], fesm2015["nb" /* NbCardModule */], []), core["ɵmpd"](1073742336, fesm2015["kd" /* NbSelectModule */], fesm2015["kd" /* NbSelectModule */], []), core["ɵmpd"](1073742336, fesm2015["F" /* NbBadgeModule */], fesm2015["F" /* NbBadgeModule */], []), core["ɵmpd"](1073742336, fesm2015["Ed" /* NbTabsetModule */], fesm2015["Ed" /* NbTabsetModule */], []), core["ɵmpd"](1073742336, fesm2015["Qd" /* NbTooltipModule */], fesm2015["Qd" /* NbTooltipModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["x" /* ReactiveFormsModule */], fesm2015_forms["x" /* ReactiveFormsModule */], []), core["ɵmpd"](1073742336, SettingsRoutingModule, SettingsRoutingModule, []), core["ɵmpd"](1073742336, sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], []), core["ɵmpd"](1073742336, chart_module["ChartModule"], chart_module["ChartModule"], []), core["ɵmpd"](1073742336, fesm2015["D" /* NbAlertModule */], fesm2015["D" /* NbAlertModule */], []), core["ɵmpd"](1073742336, fesm2015["B" /* NbActionsModule */], fesm2015["B" /* NbActionsModule */], []), core["ɵmpd"](1073742336, fesm2015["vc" /* NbMenuModule */], fesm2015["vc" /* NbMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Gb" /* NbContextMenuModule */], fesm2015["Gb" /* NbContextMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Qb" /* NbDialogModule */], fesm2015["Qb" /* NbDialogModule */], []), core["ɵmpd"](1073742336, eva_icons_fesm2015["a" /* NbEvaIconsModule */], eva_icons_fesm2015["a" /* NbEvaIconsModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["rc" /* NbListModule */], fesm2015["rc" /* NbListModule */], []), core["ɵmpd"](1073742336, fesm2015["Vc" /* NbRadioModule */], fesm2015["Vc" /* NbRadioModule */], []), core["ɵmpd"](1073742336, fesm2015["fe" /* NbUserModule */], fesm2015["fe" /* NbUserModule */], []), core["ɵmpd"](1073742336, ngx_dropzone["c" /* NgxDropzoneModule */], ngx_dropzone["c" /* NgxDropzoneModule */], []), core["ɵmpd"](1073742336, pipes_module["a" /* PipesModule */], pipes_module["a" /* PipesModule */], []), core["ɵmpd"](1073742336, ngx_bootstrap_typeahead["d" /* TypeaheadModule */], ngx_bootstrap_typeahead["d" /* TypeaheadModule */], []), core["ɵmpd"](1073742336, ui_module["a" /* UiModule */], ui_module["a" /* UiModule */], []), core["ɵmpd"](1073742336, SettingsModule, SettingsModule, []), core["ɵmpd"](1024, router["j" /* ROUTES */], function () { return [[{ path: "", component: settings_component_SettingsComponent }]]; }, []), core["ɵmpd"](256, sweetalert2_ngx_sweetalert2["d" /* ɵa */], undefined, [])]); });



/***/ })

};;