exports.ids = [48];
exports.modules = {

/***/ "SVHF":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@angular/core/fesm2015/core.js
var core = __webpack_require__("8Y7J");

// CONCATENATED MODULE: ./src/app/pages/products/update-avaliability/update-avaliability.module.ts
class UpdateAvaliabilityModule {
}

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/angular-fontawesome.ngfactory.js
var angular_fontawesome_ngfactory = __webpack_require__("fNgX");

// EXTERNAL MODULE: ./node_modules/@angular/router/router.ngfactory.js
var router_ngfactory = __webpack_require__("pMnS");

// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/sweetalert2-ngx-sweetalert2.ngfactory.js
var sweetalert2_ngx_sweetalert2_ngfactory = __webpack_require__("kExW");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/pagination/pagination.component.ngfactory.js + 1 modules
var pagination_component_ngfactory = __webpack_require__("tHyn");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/pagination/pagination.component.ts
var pagination_component = __webpack_require__("HJd8");

// EXTERNAL MODULE: ./node_modules/@angular/forms/fesm2015/forms.js
var fesm2015_forms = __webpack_require__("s7LF");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/fesm2015/index.js + 5 modules
var fesm2015 = __webpack_require__("tKwJ");

// EXTERNAL MODULE: ./src/app/shared/directives/input-decimal.directive.ts
var input_decimal_directive = __webpack_require__("O7kp");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/index.ngfactory.js
var index_ngfactory = __webpack_require__("jXVt");

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/fesm2015/angular-fontawesome.js
var angular_fontawesome = __webpack_require__("Nv++");

// EXTERNAL MODULE: ./node_modules/@angular/platform-browser/fesm2015/platform-browser.js
var platform_browser = __webpack_require__("cUpR");

// EXTERNAL MODULE: ./node_modules/@angular/common/fesm2015/common.js
var common = __webpack_require__("SVse");

// EXTERNAL MODULE: ./src/app/shared/pipes/pizza-value.pipe.ts
var pizza_value_pipe = __webpack_require__("dYRt");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ngfactory.js + 1 modules
var page_title_component_ngfactory = __webpack_require__("laEC");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ts
var page_title_component = __webpack_require__("S4p5");

// EXTERNAL MODULE: ./src/app/shared/ui/filters/product-quick-filter/product-quick-filter.component.ngfactory.js
var product_quick_filter_component_ngfactory = __webpack_require__("x1+0");

// EXTERNAL MODULE: ./src/app/shared/ui/filters/product-quick-filter/product-quick-filter.component.ts
var product_quick_filter_component = __webpack_require__("/Wvl");

// EXTERNAL MODULE: ./src/app/shared/services/alert.service.ts
var alert_service = __webpack_require__("Cmua");

// EXTERNAL MODULE: ./src/app/shared/services/auth.service.ts + 3 modules
var auth_service = __webpack_require__("IYfF");

// EXTERNAL MODULE: ./src/app/shared/services/empresa.service.ts
var empresa_service = __webpack_require__("x715");

// EXTERNAL MODULE: ./src/app/shared/services/categorias.service.ts
var categorias_service = __webpack_require__("uWRN");

// EXTERNAL MODULE: ./src/app/shared/services/messages.service.ts + 1 modules
var messages_service = __webpack_require__("N7YL");

// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ngfactory.js + 1 modules
var form_container_component_ngfactory = __webpack_require__("+aW9");

// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ts
var form_container_component = __webpack_require__("NX1Y");

// EXTERNAL MODULE: ./src/app/shared/ui/no-content/no-content.component.ngfactory.js + 1 modules
var no_content_component_ngfactory = __webpack_require__("hARC");

// EXTERNAL MODULE: ./src/app/shared/ui/no-content/no-content.component.ts
var no_content_component = __webpack_require__("o220");

// EXTERNAL MODULE: ./src/app/shared/ui/inline-loader/inline-loader.component.ngfactory.js
var inline_loader_component_ngfactory = __webpack_require__("T9fw");

// EXTERNAL MODULE: ./src/app/shared/ui/inline-loader/inline-loader.component.ts
var inline_loader_component = __webpack_require__("IGDG");

// EXTERNAL MODULE: ./node_modules/tslib/tslib.js
var tslib = __webpack_require__("zOht");

// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/index.js
var free_solid_svg_icons = __webpack_require__("YTkO");

// EXTERNAL MODULE: ./src/app/shared/consts/actions.ts
var actions = __webpack_require__("CIyo");

// EXTERNAL MODULE: ./src/app/shared/consts/order-options.ts
var order_options = __webpack_require__("a7yC");

// EXTERNAL MODULE: ./src/app/shared/models/produto.ts
var produto = __webpack_require__("ei91");

// EXTERNAL MODULE: ./src/app/shared/utils/array.util.ts
var array_util = __webpack_require__("+Qmw");

// EXTERNAL MODULE: ./src/app/shared/utils/number.util.ts
var number_util = __webpack_require__("qzEW");

// CONCATENATED MODULE: ./src/app/pages/products/update-avaliability/update-avaliability.component.ts








class update_avaliability_component_UpdateAvaliabilityComponent {
    constructor(fb, router, alertService, authService, companyService, productService, messagesService, requestService, toastrService) {
        this.fb = fb;
        this.router = router;
        this.alertService = alertService;
        this.authService = authService;
        this.companyService = companyService;
        this.productService = productService;
        this.messagesService = messagesService;
        this.requestService = requestService;
        this.toastrService = toastrService;
        this.confirmMessage = '';
        this.currentPage = 1;
        this.datasource = [];
        this.goToPage = 1;
        this.hasCaster = false;
        this.hasStockControl = false;
        this.isLoading = false;
        this.isRefreshing = false;
        this.lastViewedPage = 1;
        this.searchCriteria = [];
        this.selectedProducts = [];
        this.demoMessage = '';
        this.demoMessage = this.messagesService.getMessage('MSG.INFO.012');
        this.loggedUser = this.authService.loggedUser;
        this.companyService.companyId = this.authService.loggedUser.id;
        this.productService.companyId = this.authService.loggedUser.id;
    }
    get editIcon() {
        return free_solid_svg_icons["faEdit"];
    }
    get formData() {
        return this.form.getRawValue();
    }
    get productsField() {
        return this.form.get('products');
    }
    get allAvaliableCaster() {
        return this.form.get('allAvaliableCaster');
    }
    get allIsLackField() {
        return this.form.get('allIsLack');
    }
    get allToDeleteField() {
        return this.form.get('allToDelete');
    }
    get allUnlimitedStockField() {
        return this.form.get('allUnlimitedStock');
    }
    get shoppingBagIcon() {
        return free_solid_svg_icons["faShoppingBag"];
    }
    get trashIcon() {
        return free_solid_svg_icons["faTrash"];
    }
    ngOnInit() {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            this.initForm();
            this.hasStockControl = this.companyService.hasStockControl(this.authService.loggedUser);
            this.hasCaster = yield this.companyService.getCompanyConfig('config-ativar-rodizio').toPromise()
                .then(config => config.valor === '1');
            this.list();
        });
    }
    checkAllAvaliableCaster() {
        this.allAvaliableCaster.setValue(this.productsField.controls.filter(control => control.get('avaliableCaster').value === true).length === this.productsField.controls.length);
    }
    checkAllIsLackState() {
        this.allIsLackField.setValue(this.productsField.controls.filter(control => control.get('isLack').value === true).length === this.productsField.controls.length);
    }
    checkAllUnlimitedStockState() {
        this.allUnlimitedStockField.setValue(this.productsField.controls.filter(control => control.get('unlimitedStock').value === true).length === this.productsField.controls.length);
    }
    checkRemoveAllState() {
        this.form.get('allToDelete').setValue(this.productsField.controls.filter(control => control.get('toDelete').value === true).length === this.productsField.controls.length);
    }
    changePage(page) {
        if (this.currentPage !== +page) {
            this.goToPage = +page;
            if (this.productsField.controls.some(control => control.dirty || control.touched)) {
                this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.018'), (result) => {
                    if (result.value) {
                        this.justChangePage();
                        return;
                    }
                    this.paginationRef.navigate(this.lastViewedPage);
                });
            }
            else {
                this.justChangePage();
            }
        }
    }
    changeProductQuantity(event, index) {
        this.datasource[index].item.estoqueAlterado = event.target.value || null;
    }
    edit(productId) {
        this.router.navigate([`admin/products/product/${productId}/edit`], {
            queryParams: { action: actions["a" /* ACTIONS */].UPDATE_AVALIABILITY }
        });
    }
    getLastViewedPage(page) {
        this.lastViewedPage = page;
    }
    inDemoMode() {
        if (this.loggedUser.usuario.demonstracao) {
            this.alertService.info(this.demoMessage);
            return true;
        }
        return false;
    }
    justChangePage() {
        this.currentPage = this.goToPage;
        this.list();
    }
    list() {
        this.initForm();
        this.datasource = [];
        this.loadState();
        this.productService.filter(this.searchCriteria, this.currentPage, ['nome', 'valor'], order_options["a" /* ORDER_OPTIONS */].ASCENDING, '40').subscribe(resultSet => {
            this.loadState();
            this.resultSet = resultSet;
            this.resultSet.content.forEach(product => this.datasource.push({ item: product, itemMenu: null }));
            this.populateForm();
        }, (resp) => {
            this.loadState();
            this.requestService.handleError(resp, this.toastrService);
        });
    }
    remove(product) {
        this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.007', ['Produto', product.item.nome]), (result) => {
            if (result.value) {
                if (this.inDemoMode()) {
                    return;
                }
                this.productService.delete(product.item.id).subscribe(() => {
                    if (this.datasource.length === 1) {
                        this.datasource = [];
                        this.currentPage = 1;
                    }
                    this.list();
                    this.changePage(this.currentPage);
                    this.alertService.success(this.messagesService.getMessage('MSG.SUCESSO.022', ['Produto']));
                }, (resp) => {
                    this.requestService.handleError(resp, this.toastrService);
                });
            }
        });
    }
    setConfirmMessage() {
    }
    submit() {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            const isOpenedStore = yield this.companyService.isCompanyOpened(this.authService.loggedUser.id)
                .toPromise().then(opened => opened)
                .catch(() => false);
            if (isOpenedStore) {
                this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.061'), (result) => {
                    if (!result.dismiss)
                        this.updateAvaliability();
                });
                return;
            }
            this.updateAvaliability();
        });
    }
    toggleCheckAllUnlimitedStock(event) {
        this.productsField.controls.forEach(control => {
            control.get('unlimitedStock').setValue(event.target.checked);
            if (event.target.checked) {
                control.get('newStock').setValue('');
            }
        });
    }
    toggleCheckAllAvaliableCaster(event) {
        this.productsField.controls.forEach(control => control.get('avaliableCaster')
            .setValue(event.target.checked));
    }
    toggleCheckAvaliableCaster(event, index) {
        this.productsField.controls[index].get('avaliableCaster').setValue(event.target.checked);
        this.checkAllAvaliableCaster();
    }
    toggleCheckAllIsLack(event) {
        this.productsField.controls.forEach(control => control.get('isLack')
            .setValue(event.target.checked));
    }
    toggleCheckIsLack(event, index) {
        this.productsField.controls[index].get('isLack').setValue(event.target.checked);
        this.checkAllIsLackState();
    }
    toggleCheckRemove(event, index) {
        this.productsField.controls[index].get('toDelete').setValue(event.target.checked);
        this.checkRemoveAllState();
    }
    toggleCheckRemoveAll(event) {
        this.productsField.controls.forEach(control => control.get('toDelete').setValue(event.target.checked));
    }
    toggleCheckUnlimitedStock(event, index) {
        this.productsField.controls[index].get('unlimitedStock').setValue(event.target.checked);
        if (event.target.checked) {
            this.productsField.controls[index].get('newStock').setValue(null);
        }
        this.checkAllUnlimitedStockState();
    }
    updateProductsFilter(filterList) {
        this.searchCriteria = [];
        this.currentPage = 1;
        this.form.patchValue({
            allUnlimitedStock: false,
            allIsLack: false,
            allAvaliableCaster: false,
            allToDelete: false
        });
        filterList.forEach(filterItem => this.searchCriteria.push(`${filterItem.key}${filterItem.operator}${filterItem.value}`));
        if (array_util["a" /* ArrayUtil */].isEmpty(this.searchCriteria)) {
            this.currentPage = 1;
            if (this.paginationRef) {
                this.paginationRef.currentPage = this.currentPage;
            }
        }
        this.list();
    }
    initForm() {
        this.form = this.fb.group({
            allUnlimitedStock: [false],
            allIsLack: [false],
            allAvaliableCaster: [false],
            allToDelete: [false],
            products: this.fb.array([])
        });
    }
    loadRefreshState() {
        this.isRefreshing = !this.isRefreshing;
    }
    loadState() {
        this.isLoading = !this.isLoading;
    }
    populateForm() {
        this.productsField.clear();
        this.datasource.forEach(data => {
            this.productsField.push(this.fb.group({
                id: data.item.id,
                currentStock: [data.item.estoque],
                newStock: [''],
                unlimitedStock: [data.item.estoqueIlimitado],
                isLack: [data.item.emFalta],
                avaliableCaster: [data.item.disponivelParaORodizio],
                toDelete: [false]
            }));
        });
        this.checkAllIsLackState();
        this.checkRemoveAllState();
        if (this.hasStockControl) {
            this.checkAllUnlimitedStockState();
        }
    }
    populateProducts() {
        return this.productsField.controls.map(control => {
            const product = new produto["a" /* Produto */](control.get('id').value);
            if (this.hasStockControl) {
                if ((control.get('newStock').value === '0,0' || control.get('newStock').value === '0,00')
                    && control.get('unlimitedStock').value === false) {
                    control.get('isLack').setValue(true);
                }
                product.estoque = !control.get('newStock').value
                    ? control.get('currentStock').value || 0
                    : number_util["a" /* NumberUtil */].parseDecimal(control.get('newStock').value);
                product.estoqueIlimitado = control.get('unlimitedStock').value;
            }
            product.emFalta = control.get('isLack').value;
            product.disponivelParaORodizio = control.get('avaliableCaster').value;
            product.excluido = control.get('toDelete').value;
            return product;
        });
    }
    updateAvaliability() {
        const products = this.populateProducts();
        this.loadRefreshState();
        this.productService.updateAll(products).subscribe(() => {
            this.loadRefreshState();
            this.alertService.success(this.messagesService.getMessage('MSG.SUCESSO.032', ['Produto(s)']));
            this.list();
        }, (resp) => {
            this.requestService.handleError(resp, this.toastrService);
            this.loadRefreshState();
        });
    }
}

// EXTERNAL MODULE: ./node_modules/@angular/router/fesm2015/router.js + 5 modules
var router = __webpack_require__("iInd");

// EXTERNAL MODULE: ./src/app/shared/services/produto.service.ts
var produto_service = __webpack_require__("RVWZ");

// EXTERNAL MODULE: ./src/app/shared/services/request.service.ts
var request_service = __webpack_require__("a9NN");

// CONCATENATED MODULE: ./src/app/pages/products/update-avaliability/update-avaliability.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 































var styles_UpdateAvaliabilityComponent = [];
var RenderType_UpdateAvaliabilityComponent = core["ɵcrt"]({ encapsulation: 2, styles: styles_UpdateAvaliabilityComponent, data: {} });

function View_UpdateAvaliabilityComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-pagination", [], null, [[null, "pageChange"], [null, "lastViewedPage"], [null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("pageChange" === en)) {
        var pd_1 = (_co.changePage($event) !== false);
        ad = (pd_1 && ad);
    } if (("lastViewedPage" === en)) {
        var pd_2 = (_co.getLastViewedPage($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, pagination_component_ngfactory["b" /* View_PaginationComponent_0 */], pagination_component_ngfactory["a" /* RenderType_PaginationComponent */])), core["ɵdid"](1, 114688, [[1, 4], ["pagination", 4]], 0, pagination_component["a" /* PaginationComponent */], [], { currentPage: [0, "currentPage"], totalPages: [1, "totalPages"] }, { pageChange: "pageChange", lastViewedPage: "lastViewedPage" })], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.currentPage; var currVal_1 = _co.resultSet.totalPages; _ck(_v, 1, 0, currVal_0, currVal_1); }, null); }
function View_UpdateAvaliabilityComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "th", [["class", "text-primary w-15"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Atualizado Em"]))], null, null); }
function View_UpdateAvaliabilityComponent_4(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "th", [["class", "text-primary text-right w-5"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Qtd. em Estoque"]))], null, null); }
function View_UpdateAvaliabilityComponent_5(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "th", [["class", "text-primary text-right w-5"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Nova Qtd. em Estoque"]))], null, null); }
function View_UpdateAvaliabilityComponent_6(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "th", [["class", "text-primary text-center w-5"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Estoque Ilimitado"]))], null, null); }
function View_UpdateAvaliabilityComponent_7(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "th", [["class", "text-primary text-center w-5"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Dispon\u00EDvel p/ Rod\u00EDzio"]))], null, null); }
function View_UpdateAvaliabilityComponent_8(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 6, "th", [["class", "text-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 5, "input", [["tabindex", "-1"], ["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 2).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 2).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("change" === en)) {
        var pd_2 = (_co.toggleCheckAllUnlimitedStock($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](2, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](4, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](6, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null)], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.allUnlimitedStockField; _ck(_v, 4, 0, currVal_7); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 6).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 6).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 6).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 6).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 6).ngClassValid; var currVal_5 = core["ɵnov"](_v, 6).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 6).ngClassPending; _ck(_v, 1, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); }); }
function View_UpdateAvaliabilityComponent_9(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 6, "th", [["class", "text-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 5, "input", [["tabindex", "-1"], ["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 2).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 2).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("change" === en)) {
        var pd_2 = (_co.toggleCheckAllAvaliableCaster($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](2, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](4, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](6, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null)], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.allAvaliableCaster; _ck(_v, 4, 0, currVal_7); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 6).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 6).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 6).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 6).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 6).ngClassValid; var currVal_5 = core["ɵnov"](_v, 6).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 6).ngClassPending; _ck(_v, 1, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); }); }
function View_UpdateAvaliabilityComponent_12(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 3, "td", [["class", "w-15"]], null, null, null, null, null)), (_l()(), core["ɵted"](1, null, [" ", " \u00E0s ", " "])), core["ɵppd"](2, 2), core["ɵppd"](3, 2)], null, function (_ck, _v) { var currVal_0 = core["ɵunv"](_v, 1, 0, _ck(_v, 2, 0, core["ɵnov"](_v.parent.parent.parent.parent, 0), _v.parent.context.$implicit.item.dataHoraUltimaAtualizacao, "dd/MM/yyyy")); var currVal_1 = core["ɵunv"](_v, 1, 1, _ck(_v, 3, 0, core["ɵnov"](_v.parent.parent.parent.parent, 0), _v.parent.context.$implicit.item.dataHoraUltimaAtualizacao, " HH:mm")); _ck(_v, 1, 0, currVal_0, currVal_1); }); }
function View_UpdateAvaliabilityComponent_13(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "td", [["class", "w-5 text-right"]], null, null, null, null, null)), (_l()(), core["ɵted"](1, null, [" ", " "])), core["ɵppd"](2, 2)], null, function (_ck, _v) { var currVal_0 = core["ɵunv"](_v, 1, 0, _ck(_v, 2, 0, core["ɵnov"](_v.parent.parent.parent.parent, 1), _v.parent.context.$implicit.item.valor, "1.2-2")); _ck(_v, 1, 0, currVal_0); }); }
function View_UpdateAvaliabilityComponent_14(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "td", [["class", "w-5 text-right"]], null, null, null, null, null)), (_l()(), core["ɵted"](1, null, [" ", " "])), core["ɵppd"](2, 1)], null, function (_ck, _v) { var currVal_0 = core["ɵunv"](_v, 1, 0, _ck(_v, 2, 0, core["ɵnov"](_v.parent.parent.parent.parent, 2), _v.parent.context.$implicit.item)); _ck(_v, 1, 0, currVal_0); }); }
function View_UpdateAvaliabilityComponent_15(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "td", [["class", "w-10 text-right"]], null, null, null, null, null)), (_l()(), core["ɵted"](1, null, [" ", " "])), core["ɵppd"](2, 2)], null, function (_ck, _v) { var currVal_0 = core["ɵunv"](_v, 1, 0, _ck(_v, 2, 0, core["ɵnov"](_v.parent.parent.parent.parent, 1), _v.parent.context.$implicit.item.estoque, (_v.parent.context.$implicit.item.vendaPorFracao ? "1.2-2" : "1.0-0"))); _ck(_v, 1, 0, currVal_0); }); }
function View_UpdateAvaliabilityComponent_16(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 12, "td", [["class", "w-10"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, null, null)), core["ɵdid"](1, 212992, null, 0, fesm2015_forms["m" /* FormGroupName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["m" /* FormGroupName */]]), core["ɵdid"](3, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](4, 0, null, null, 8, "input", [["fieldSize", "small"], ["formControlName", "newStock"], ["fullWidth", ""], ["nbInput", ""], ["omniInputDecimal", ""], ["placeholder", "0,00"], ["status", "primary"], ["type", "text"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"], [null, "keyup"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 5)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 5).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 5)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 5)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } if (("keyup" === en)) {
        var pd_4 = (core["ɵnov"](_v, 12).onInput($event) !== false);
        ad = (pd_4 && ad);
    } if (("blur" === en)) {
        var pd_5 = (core["ɵnov"](_v, 12).onBlur() !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](5, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](7, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](9, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](10, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { fieldSize: [0, "fieldSize"], status: [1, "status"], fullWidth: [2, "fullWidth"] }, null), core["ɵdid"](11, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵdid"](12, 16384, null, 0, input_decimal_directive["a" /* InputDecimalDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_7 = _v.parent.context.index; _ck(_v, 1, 0, currVal_7); var currVal_31 = "newStock"; _ck(_v, 7, 0, currVal_31); var currVal_32 = "small"; var currVal_33 = "primary"; var currVal_34 = ""; _ck(_v, 10, 0, currVal_32, currVal_33, currVal_34); var currVal_35 = _co.productsField.controls[_v.parent.context.index].get("newStock"); _ck(_v, 11, 0, currVal_35); var currVal_36 = _co.productsField.controls[_v.parent.context.index].get("newStock"); _ck(_v, 12, 0, currVal_36); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 3).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 3).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 3).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 3).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 3).ngClassValid; var currVal_5 = core["ɵnov"](_v, 3).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 3).ngClassPending; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_8 = core["ɵnov"](_v, 9).ngClassUntouched; var currVal_9 = core["ɵnov"](_v, 9).ngClassTouched; var currVal_10 = core["ɵnov"](_v, 9).ngClassPristine; var currVal_11 = core["ɵnov"](_v, 9).ngClassDirty; var currVal_12 = core["ɵnov"](_v, 9).ngClassValid; var currVal_13 = core["ɵnov"](_v, 9).ngClassInvalid; var currVal_14 = core["ɵnov"](_v, 9).ngClassPending; var currVal_15 = core["ɵnov"](_v, 10).fullWidth; var currVal_16 = core["ɵnov"](_v, 10).tiny; var currVal_17 = core["ɵnov"](_v, 10).small; var currVal_18 = core["ɵnov"](_v, 10).medium; var currVal_19 = core["ɵnov"](_v, 10).large; var currVal_20 = core["ɵnov"](_v, 10).giant; var currVal_21 = core["ɵnov"](_v, 10).primary; var currVal_22 = core["ɵnov"](_v, 10).info; var currVal_23 = core["ɵnov"](_v, 10).success; var currVal_24 = core["ɵnov"](_v, 10).warning; var currVal_25 = core["ɵnov"](_v, 10).danger; var currVal_26 = core["ɵnov"](_v, 10).basic; var currVal_27 = core["ɵnov"](_v, 10).control; var currVal_28 = core["ɵnov"](_v, 10).rectangle; var currVal_29 = core["ɵnov"](_v, 10).semiRound; var currVal_30 = core["ɵnov"](_v, 10).round; _ck(_v, 4, 1, [currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30]); }); }
function View_UpdateAvaliabilityComponent_17(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 10, "td", [["class", "text-center w-5"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, null, null)), core["ɵdid"](1, 212992, null, 0, fesm2015_forms["m" /* FormGroupName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["m" /* FormGroupName */]]), core["ɵdid"](3, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](4, 0, null, null, 6, "input", [["formControlName", "unlimitedStock"], ["tabindex", "-1"], ["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 5).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 5).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("change" === en)) {
        var pd_2 = (_co.toggleCheckUnlimitedStock($event, _v.parent.context.index) !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](5, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](7, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](9, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](10, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_7 = _v.parent.context.index; _ck(_v, 1, 0, currVal_7); var currVal_15 = "unlimitedStock"; _ck(_v, 7, 0, currVal_15); var currVal_16 = _co.productsField.controls[_v.parent.context.index].get("unlimitedStock"); _ck(_v, 10, 0, currVal_16); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 3).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 3).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 3).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 3).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 3).ngClassValid; var currVal_5 = core["ɵnov"](_v, 3).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 3).ngClassPending; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_8 = core["ɵnov"](_v, 9).ngClassUntouched; var currVal_9 = core["ɵnov"](_v, 9).ngClassTouched; var currVal_10 = core["ɵnov"](_v, 9).ngClassPristine; var currVal_11 = core["ɵnov"](_v, 9).ngClassDirty; var currVal_12 = core["ɵnov"](_v, 9).ngClassValid; var currVal_13 = core["ɵnov"](_v, 9).ngClassInvalid; var currVal_14 = core["ɵnov"](_v, 9).ngClassPending; _ck(_v, 4, 0, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14); }); }
function View_UpdateAvaliabilityComponent_18(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 9, "td", [["class", "text-center w-5"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, null, null)), core["ɵdid"](1, 212992, null, 0, fesm2015_forms["m" /* FormGroupName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["m" /* FormGroupName */]]), core["ɵdid"](3, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](4, 0, null, null, 5, "input", [["formControlName", "avaliableCaster"], ["tabindex", "-1"], ["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 5).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 5).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("change" === en)) {
        var pd_2 = (_co.toggleCheckAvaliableCaster($event, _v.parent.context.index) !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](5, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](7, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](9, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null)], function (_ck, _v) { var currVal_7 = _v.parent.context.index; _ck(_v, 1, 0, currVal_7); var currVal_15 = "avaliableCaster"; _ck(_v, 7, 0, currVal_15); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 3).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 3).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 3).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 3).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 3).ngClassValid; var currVal_5 = core["ɵnov"](_v, 3).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 3).ngClassPending; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_8 = core["ɵnov"](_v, 9).ngClassUntouched; var currVal_9 = core["ɵnov"](_v, 9).ngClassTouched; var currVal_10 = core["ɵnov"](_v, 9).ngClassPristine; var currVal_11 = core["ɵnov"](_v, 9).ngClassDirty; var currVal_12 = core["ɵnov"](_v, 9).ngClassValid; var currVal_13 = core["ɵnov"](_v, 9).ngClassInvalid; var currVal_14 = core["ɵnov"](_v, 9).ngClassPending; _ck(_v, 4, 0, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14); }); }
function View_UpdateAvaliabilityComponent_11(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 48, "tr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 11, "td", [], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 10, "div", [["class", "d-flex flex-row align-items-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 3, "button", [["ghost", ""], ["nbButton", ""], ["size", "small"], ["status", "danger"], ["tabindex", "-1"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 4).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.remove(_v.context.$implicit) !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](4, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], ghost: [2, "ghost"] }, null), (_l()(), core["ɵeld"](5, 0, null, 0, 1, "fa-icon", [["class", "ng-fa-icon"], ["size", "lg"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵdid"](6, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"], size: [1, "size"] }, null), (_l()(), core["ɵeld"](7, 0, null, null, 3, "button", [["ghost", ""], ["nbButton", ""], ["size", "small"], ["status", "primary"], ["tabindex", "-1"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 8).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.edit(_v.context.$implicit.item.id) !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](8, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], ghost: [2, "ghost"] }, null), (_l()(), core["ɵeld"](9, 0, null, 0, 1, "fa-icon", [["class", "ng-fa-icon"], ["size", "lg"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵdid"](10, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"], size: [1, "size"] }, null), (_l()(), core["ɵeld"](11, 0, null, null, 1, "div", [["class", "flex-grow-1"]], null, null, null, null, null)), (_l()(), core["ɵted"](12, null, [" ", " "])), (_l()(), core["ɵeld"](13, 0, null, null, 1, "td", [], null, null, null, null, null)), (_l()(), core["ɵted"](14, null, ["", ""])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_12)), core["ɵdid"](16, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_13)), core["ɵdid"](18, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_14)), core["ɵdid"](20, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_15)), core["ɵdid"](22, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_16)), core["ɵdid"](24, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_17)), core["ɵdid"](26, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](27, 0, null, null, 9, "td", [["class", "text-center w-5"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, null, null)), core["ɵdid"](28, 212992, null, 0, fesm2015_forms["m" /* FormGroupName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["m" /* FormGroupName */]]), core["ɵdid"](30, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](31, 0, null, null, 5, "input", [["formControlName", "isLack"], ["tabindex", "-1"], ["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 32).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 32).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("change" === en)) {
        var pd_2 = (_co.toggleCheckIsLack($event, _v.context.index) !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](32, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](34, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](36, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_18)), core["ɵdid"](38, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](39, 0, null, null, 9, "td", [["class", "text-center w-5"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, null, null)), core["ɵdid"](40, 212992, null, 0, fesm2015_forms["m" /* FormGroupName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["m" /* FormGroupName */]]), core["ɵdid"](42, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](43, 0, null, null, 5, "input", [["formControlName", "toDelete"], ["tabindex", "-1"], ["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 44).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 44).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("change" === en)) {
        var pd_2 = (_co.toggleCheckRemove($event, _v.context.index) !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](44, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](46, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](48, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null)], function (_ck, _v) { var _co = _v.component; var currVal_26 = "small"; var currVal_27 = "danger"; var currVal_28 = ""; _ck(_v, 4, 0, currVal_26, currVal_27, currVal_28); var currVal_31 = _co.trashIcon; var currVal_32 = "lg"; _ck(_v, 6, 0, currVal_31, currVal_32); var currVal_59 = "small"; var currVal_60 = "primary"; var currVal_61 = ""; _ck(_v, 8, 0, currVal_59, currVal_60, currVal_61); var currVal_64 = _co.editIcon; var currVal_65 = "lg"; _ck(_v, 10, 0, currVal_64, currVal_65); var currVal_68 = !_co.hasStockControl; _ck(_v, 16, 0, currVal_68); var currVal_69 = !_v.context.$implicit.item.vendaPorTamanho; _ck(_v, 18, 0, currVal_69); var currVal_70 = _v.context.$implicit.item.vendaPorTamanho; _ck(_v, 20, 0, currVal_70); var currVal_71 = _co.hasStockControl; _ck(_v, 22, 0, currVal_71); var currVal_72 = _co.hasStockControl; _ck(_v, 24, 0, currVal_72); var currVal_73 = _co.hasStockControl; _ck(_v, 26, 0, currVal_73); var currVal_81 = _v.context.index; _ck(_v, 28, 0, currVal_81); var currVal_89 = "isLack"; _ck(_v, 34, 0, currVal_89); var currVal_90 = _co.hasCaster; _ck(_v, 38, 0, currVal_90); var currVal_98 = _v.context.index; _ck(_v, 40, 0, currVal_98); var currVal_106 = "toDelete"; _ck(_v, 46, 0, currVal_106); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 4).filled; var currVal_1 = core["ɵnov"](_v, 4).outline; var currVal_2 = core["ɵnov"](_v, 4).ghost; var currVal_3 = core["ɵnov"](_v, 4).hero; var currVal_4 = core["ɵnov"](_v, 4).fullWidth; var currVal_5 = core["ɵnov"](_v, 4).disabled; var currVal_6 = core["ɵnov"](_v, 4).disabled; var currVal_7 = core["ɵnov"](_v, 4).tabbable; var currVal_8 = core["ɵnov"](_v, 4).tiny; var currVal_9 = core["ɵnov"](_v, 4).small; var currVal_10 = core["ɵnov"](_v, 4).medium; var currVal_11 = core["ɵnov"](_v, 4).large; var currVal_12 = core["ɵnov"](_v, 4).giant; var currVal_13 = core["ɵnov"](_v, 4).primary; var currVal_14 = core["ɵnov"](_v, 4).info; var currVal_15 = core["ɵnov"](_v, 4).success; var currVal_16 = core["ɵnov"](_v, 4).warning; var currVal_17 = core["ɵnov"](_v, 4).danger; var currVal_18 = core["ɵnov"](_v, 4).basic; var currVal_19 = core["ɵnov"](_v, 4).control; var currVal_20 = core["ɵnov"](_v, 4).rectangle; var currVal_21 = core["ɵnov"](_v, 4).round; var currVal_22 = core["ɵnov"](_v, 4).semiRound; var currVal_23 = core["ɵnov"](_v, 4).iconLeft; var currVal_24 = core["ɵnov"](_v, 4).iconRight; var currVal_25 = core["ɵnov"](_v, 4).transitions; _ck(_v, 3, 1, [currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25]); var currVal_29 = core["ɵnov"](_v, 6).title; var currVal_30 = core["ɵnov"](_v, 6).renderedIconHTML; _ck(_v, 5, 0, currVal_29, currVal_30); var currVal_33 = core["ɵnov"](_v, 8).filled; var currVal_34 = core["ɵnov"](_v, 8).outline; var currVal_35 = core["ɵnov"](_v, 8).ghost; var currVal_36 = core["ɵnov"](_v, 8).hero; var currVal_37 = core["ɵnov"](_v, 8).fullWidth; var currVal_38 = core["ɵnov"](_v, 8).disabled; var currVal_39 = core["ɵnov"](_v, 8).disabled; var currVal_40 = core["ɵnov"](_v, 8).tabbable; var currVal_41 = core["ɵnov"](_v, 8).tiny; var currVal_42 = core["ɵnov"](_v, 8).small; var currVal_43 = core["ɵnov"](_v, 8).medium; var currVal_44 = core["ɵnov"](_v, 8).large; var currVal_45 = core["ɵnov"](_v, 8).giant; var currVal_46 = core["ɵnov"](_v, 8).primary; var currVal_47 = core["ɵnov"](_v, 8).info; var currVal_48 = core["ɵnov"](_v, 8).success; var currVal_49 = core["ɵnov"](_v, 8).warning; var currVal_50 = core["ɵnov"](_v, 8).danger; var currVal_51 = core["ɵnov"](_v, 8).basic; var currVal_52 = core["ɵnov"](_v, 8).control; var currVal_53 = core["ɵnov"](_v, 8).rectangle; var currVal_54 = core["ɵnov"](_v, 8).round; var currVal_55 = core["ɵnov"](_v, 8).semiRound; var currVal_56 = core["ɵnov"](_v, 8).iconLeft; var currVal_57 = core["ɵnov"](_v, 8).iconRight; var currVal_58 = core["ɵnov"](_v, 8).transitions; _ck(_v, 7, 1, [currVal_33, currVal_34, currVal_35, currVal_36, currVal_37, currVal_38, currVal_39, currVal_40, currVal_41, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58]); var currVal_62 = core["ɵnov"](_v, 10).title; var currVal_63 = core["ɵnov"](_v, 10).renderedIconHTML; _ck(_v, 9, 0, currVal_62, currVal_63); var currVal_66 = _v.context.$implicit.item.nome; _ck(_v, 12, 0, currVal_66); var currVal_67 = _v.context.$implicit.item.categoria.descricao; _ck(_v, 14, 0, currVal_67); var currVal_74 = core["ɵnov"](_v, 30).ngClassUntouched; var currVal_75 = core["ɵnov"](_v, 30).ngClassTouched; var currVal_76 = core["ɵnov"](_v, 30).ngClassPristine; var currVal_77 = core["ɵnov"](_v, 30).ngClassDirty; var currVal_78 = core["ɵnov"](_v, 30).ngClassValid; var currVal_79 = core["ɵnov"](_v, 30).ngClassInvalid; var currVal_80 = core["ɵnov"](_v, 30).ngClassPending; _ck(_v, 27, 0, currVal_74, currVal_75, currVal_76, currVal_77, currVal_78, currVal_79, currVal_80); var currVal_82 = core["ɵnov"](_v, 36).ngClassUntouched; var currVal_83 = core["ɵnov"](_v, 36).ngClassTouched; var currVal_84 = core["ɵnov"](_v, 36).ngClassPristine; var currVal_85 = core["ɵnov"](_v, 36).ngClassDirty; var currVal_86 = core["ɵnov"](_v, 36).ngClassValid; var currVal_87 = core["ɵnov"](_v, 36).ngClassInvalid; var currVal_88 = core["ɵnov"](_v, 36).ngClassPending; _ck(_v, 31, 0, currVal_82, currVal_83, currVal_84, currVal_85, currVal_86, currVal_87, currVal_88); var currVal_91 = core["ɵnov"](_v, 42).ngClassUntouched; var currVal_92 = core["ɵnov"](_v, 42).ngClassTouched; var currVal_93 = core["ɵnov"](_v, 42).ngClassPristine; var currVal_94 = core["ɵnov"](_v, 42).ngClassDirty; var currVal_95 = core["ɵnov"](_v, 42).ngClassValid; var currVal_96 = core["ɵnov"](_v, 42).ngClassInvalid; var currVal_97 = core["ɵnov"](_v, 42).ngClassPending; _ck(_v, 39, 0, currVal_91, currVal_92, currVal_93, currVal_94, currVal_95, currVal_96, currVal_97); var currVal_99 = core["ɵnov"](_v, 48).ngClassUntouched; var currVal_100 = core["ɵnov"](_v, 48).ngClassTouched; var currVal_101 = core["ɵnov"](_v, 48).ngClassPristine; var currVal_102 = core["ɵnov"](_v, 48).ngClassDirty; var currVal_103 = core["ɵnov"](_v, 48).ngClassValid; var currVal_104 = core["ɵnov"](_v, 48).ngClassInvalid; var currVal_105 = core["ɵnov"](_v, 48).ngClassPending; _ck(_v, 43, 0, currVal_99, currVal_100, currVal_101, currVal_102, currVal_103, currVal_104, currVal_105); }); }
function View_UpdateAvaliabilityComponent_10(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 5, "tbody", [["formArrayName", "products"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, null, null)), core["ɵdid"](1, 212992, null, 0, fesm2015_forms["f" /* FormArrayName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["f" /* FormArrayName */]]), core["ɵdid"](3, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_11)), core["ɵdid"](5, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_7 = "products"; _ck(_v, 1, 0, currVal_7); var currVal_8 = _co.datasource; _ck(_v, 5, 0, currVal_8); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 3).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 3).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 3).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 3).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 3).ngClassValid; var currVal_5 = core["ɵnov"](_v, 3).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 3).ngClassPending; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); }); }
function View_UpdateAvaliabilityComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 47, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 46, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 45, "table", [["class", "table table-bordered table-sm table-hover table-striped mb-0"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 42, "thead", [], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 20, "tr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](5, 0, null, null, 1, "th", [["class", "text-primary w-25"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Produto"])), (_l()(), core["ɵeld"](7, 0, null, null, 1, "th", [["class", "text-primary w-15"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Categoria"])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_3)), core["ɵdid"](10, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](11, 0, null, null, 1, "th", [["class", "text-primary text-right w-5"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Valor de Venda"])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_4)), core["ɵdid"](14, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_5)), core["ɵdid"](16, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_6)), core["ɵdid"](18, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](19, 0, null, null, 1, "th", [["class", "text-primary text-center w-5"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Em Falta"])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_7)), core["ɵdid"](22, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](23, 0, null, null, 1, "th", [["class", "text-primary text-center w-5"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Excluir Produto"])), (_l()(), core["ɵeld"](25, 0, null, null, 20, "tr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](26, 0, null, null, 1, "th", [["class", "text-right"]], [[1, "colspan", 0]], null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Selecionar Tudo"])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_8)), core["ɵdid"](29, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](30, 0, null, null, 6, "th", [["class", "text-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](31, 0, null, null, 5, "input", [["tabindex", "-1"], ["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 32).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 32).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("change" === en)) {
        var pd_2 = (_co.toggleCheckAllIsLack($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](32, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](34, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](36, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_9)), core["ɵdid"](38, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](39, 0, null, null, 6, "th", [["class", "text-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](40, 0, null, null, 5, "input", [["tabindex", "-1"], ["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 41).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 41).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("change" === en)) {
        var pd_2 = (_co.toggleCheckRemoveAll($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](41, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](43, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](45, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_10)), core["ɵdid"](47, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = !_co.hasStockControl; _ck(_v, 10, 0, currVal_0); var currVal_1 = _co.hasStockControl; _ck(_v, 14, 0, currVal_1); var currVal_2 = _co.hasStockControl; _ck(_v, 16, 0, currVal_2); var currVal_3 = _co.hasStockControl; _ck(_v, 18, 0, currVal_3); var currVal_4 = _co.hasCaster; _ck(_v, 22, 0, currVal_4); var currVal_6 = _co.hasStockControl; _ck(_v, 29, 0, currVal_6); var currVal_14 = _co.form.get("allIsLack"); _ck(_v, 34, 0, currVal_14); var currVal_15 = _co.hasCaster; _ck(_v, 38, 0, currVal_15); var currVal_23 = _co.allToDeleteField; _ck(_v, 43, 0, currVal_23); var currVal_24 = (_co.datasource.length > 0); _ck(_v, 47, 0, currVal_24); }, function (_ck, _v) { var _co = _v.component; var currVal_5 = (!_co.hasStockControl ? "4" : "5"); _ck(_v, 26, 0, currVal_5); var currVal_7 = core["ɵnov"](_v, 36).ngClassUntouched; var currVal_8 = core["ɵnov"](_v, 36).ngClassTouched; var currVal_9 = core["ɵnov"](_v, 36).ngClassPristine; var currVal_10 = core["ɵnov"](_v, 36).ngClassDirty; var currVal_11 = core["ɵnov"](_v, 36).ngClassValid; var currVal_12 = core["ɵnov"](_v, 36).ngClassInvalid; var currVal_13 = core["ɵnov"](_v, 36).ngClassPending; _ck(_v, 31, 0, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13); var currVal_16 = core["ɵnov"](_v, 45).ngClassUntouched; var currVal_17 = core["ɵnov"](_v, 45).ngClassTouched; var currVal_18 = core["ɵnov"](_v, 45).ngClassPristine; var currVal_19 = core["ɵnov"](_v, 45).ngClassDirty; var currVal_20 = core["ɵnov"](_v, 45).ngClassValid; var currVal_21 = core["ɵnov"](_v, 45).ngClassInvalid; var currVal_22 = core["ɵnov"](_v, 45).ngClassPending; _ck(_v, 40, 0, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22); }); }
function View_UpdateAvaliabilityComponent_19(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-pagination", [], null, [[null, "pageChange"], [null, "lastViewedPage"], [null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("pageChange" === en)) {
        var pd_1 = (_co.changePage($event) !== false);
        ad = (pd_1 && ad);
    } if (("lastViewedPage" === en)) {
        var pd_2 = (_co.getLastViewedPage($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, pagination_component_ngfactory["b" /* View_PaginationComponent_0 */], pagination_component_ngfactory["a" /* RenderType_PaginationComponent */])), core["ɵdid"](1, 114688, [[1, 4], ["pagination", 4]], 0, pagination_component["a" /* PaginationComponent */], [], { currentPage: [0, "currentPage"], totalPages: [1, "totalPages"] }, { pageChange: "pageChange", lastViewedPage: "lastViewedPage" })], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.currentPage; var currVal_1 = _co.resultSet.totalPages; _ck(_v, 1, 0, currVal_0, currVal_1); }, null); }
function View_UpdateAvaliabilityComponent_0(_l) { return core["ɵvid"](0, [core["ɵpid"](0, common["f" /* DatePipe */], [core["LOCALE_ID"]]), core["ɵpid"](0, common["g" /* DecimalPipe */], [core["LOCALE_ID"]]), core["ɵpid"](0, pizza_value_pipe["a" /* PizzaValuePipe */], []), core["ɵqud"](671088640, 1, { paginationRef: 0 }), (_l()(), core["ɵeld"](4, 0, null, null, 29, "form", [["novalidate", ""]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "submit"], [null, "reset"]], function (_v, en, $event) { var ad = true; if (("submit" === en)) {
        var pd_0 = (core["ɵnov"](_v, 6).onSubmit($event) !== false);
        ad = (pd_0 && ad);
    } if (("reset" === en)) {
        var pd_1 = (core["ɵnov"](_v, 6).onReset() !== false);
        ad = (pd_1 && ad);
    } return ad; }, null, null)), core["ɵdid"](5, 16384, null, 0, fesm2015_forms["D" /* ɵangular_packages_forms_forms_z */], [], null, null), core["ɵdid"](6, 540672, null, 0, fesm2015_forms["l" /* FormGroupDirective */], [[8, null], [8, null]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["l" /* FormGroupDirective */]]), core["ɵdid"](8, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](9, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](10, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](11, 0, null, null, 1, "omni-page-title", [["pageTitle", "Atualizar Disponibilidade"], ["tutorialTag", "produtos-atualizar-disponibilidade"]], null, null, null, page_title_component_ngfactory["b" /* View_PageTitleComponent_0 */], page_title_component_ngfactory["a" /* RenderType_PageTitleComponent */])), core["ɵdid"](12, 114688, null, 0, page_title_component["a" /* PageTitleComponent */], [fesm2015["Rb" /* NbDialogService */]], { icon: [0, "icon"], tutorial: [1, "tutorial"], tutorialTag: [2, "tutorialTag"], pageTitle: [3, "pageTitle"] }, null), (_l()(), core["ɵeld"](13, 0, null, null, 20, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](14, 0, null, null, 19, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](15, 0, null, null, 1, "omni-product-quick-filter", [], null, [[null, "updateFilter"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("updateFilter" === en)) {
        var pd_0 = (_co.updateProductsFilter($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, product_quick_filter_component_ngfactory["b" /* View_ProductQuickFilterComponent_0 */], product_quick_filter_component_ngfactory["a" /* RenderType_ProductQuickFilterComponent */])), core["ɵdid"](16, 114688, null, 0, product_quick_filter_component["a" /* ProductQuickFilterComponent */], [fesm2015_forms["g" /* FormBuilder */], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], empresa_service["a" /* EmpresaService */], categorias_service["a" /* CategoriasService */], messages_service["a" /* MessagesService */]], { resultSet: [0, "resultSet"] }, { updateFilter: "updateFilter" }), (_l()(), core["ɵeld"](17, 0, null, null, 16, "omni-form-container", [], null, null, null, form_container_component_ngfactory["b" /* View_FormContainerComponent_0 */], form_container_component_ngfactory["a" /* RenderType_FormContainerComponent */])), core["ɵdid"](18, 114688, null, 0, form_container_component["a" /* FormContainerComponent */], [alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */]], { showBackButton: [0, "showBackButton"], showRequiredInfo: [1, "showRequiredInfo"] }, null), (_l()(), core["ɵeld"](19, 0, null, 1, 10, "div", [["class", "form-content"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_1)), core["ɵdid"](21, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_2)), core["ɵdid"](23, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](24, 0, null, null, 1, "omni-no-content", [["message", "Nenhum produto encontrado!"]], null, null, null, no_content_component_ngfactory["b" /* View_NoContentComponent_0 */], no_content_component_ngfactory["a" /* RenderType_NoContentComponent */])), core["ɵdid"](25, 114688, null, 0, no_content_component["a" /* NoContentComponent */], [], { isEmpty: [0, "isEmpty"], message: [1, "message"] }, null), (_l()(), core["ɵeld"](26, 0, null, null, 1, "omni-inline-loader", [["label", "Carregando produtos..."]], null, null, null, inline_loader_component_ngfactory["b" /* View_InlineLoaderComponent_0 */], inline_loader_component_ngfactory["a" /* RenderType_InlineLoaderComponent */])), core["ɵdid"](27, 114688, null, 0, inline_loader_component["a" /* InlineLoaderComponent */], [], { label: [0, "label"], refreshState: [1, "refreshState"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_UpdateAvaliabilityComponent_19)), core["ɵdid"](29, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](30, 0, null, 3, 3, "div", [["class", "form-footer mr-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](31, 0, null, null, 2, "button", [["nbButton", ""], ["status", "success"], ["type", "submit"]], [[1, "disabled", 0], [2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 32).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.submit() !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](32, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"] }, null), (_l()(), core["ɵted"](33, 0, [" ", " "]))], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.form; _ck(_v, 6, 0, currVal_7); var currVal_8 = _co.shoppingBagIcon; var currVal_9 = true; var currVal_10 = "produtos-atualizar-disponibilidade"; var currVal_11 = "Atualizar Disponibilidade"; _ck(_v, 12, 0, currVal_8, currVal_9, currVal_10, currVal_11); var currVal_12 = _co.resultSet; _ck(_v, 16, 0, currVal_12); var currVal_13 = false; var currVal_14 = false; _ck(_v, 18, 0, currVal_13, currVal_14); var currVal_15 = (!_co.isLoading && (((_co.resultSet == null) ? null : _co.resultSet.totalPages) > 1)); _ck(_v, 21, 0, currVal_15); var currVal_16 = (!_co.isLoading && (_co.datasource.length > 0)); _ck(_v, 23, 0, currVal_16); var currVal_17 = ((_co.datasource.length === 0) && !_co.isLoading); var currVal_18 = "Nenhum produto encontrado!"; _ck(_v, 25, 0, currVal_17, currVal_18); var currVal_19 = "Carregando produtos..."; var currVal_20 = _co.isLoading; _ck(_v, 27, 0, currVal_19, currVal_20); var currVal_21 = (!_co.isLoading && (((_co.resultSet == null) ? null : _co.resultSet.totalPages) > 1)); _ck(_v, 29, 0, currVal_21); var currVal_49 = "success"; _ck(_v, 32, 0, currVal_49); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 8).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 8).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 8).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 8).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 8).ngClassValid; var currVal_5 = core["ɵnov"](_v, 8).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 8).ngClassPending; _ck(_v, 4, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_22 = ((_co.isLoading || (_co.datasource.length === 0)) ? true : null); var currVal_23 = core["ɵnov"](_v, 32).filled; var currVal_24 = core["ɵnov"](_v, 32).outline; var currVal_25 = core["ɵnov"](_v, 32).ghost; var currVal_26 = core["ɵnov"](_v, 32).hero; var currVal_27 = core["ɵnov"](_v, 32).fullWidth; var currVal_28 = core["ɵnov"](_v, 32).disabled; var currVal_29 = core["ɵnov"](_v, 32).disabled; var currVal_30 = core["ɵnov"](_v, 32).tabbable; var currVal_31 = core["ɵnov"](_v, 32).tiny; var currVal_32 = core["ɵnov"](_v, 32).small; var currVal_33 = core["ɵnov"](_v, 32).medium; var currVal_34 = core["ɵnov"](_v, 32).large; var currVal_35 = core["ɵnov"](_v, 32).giant; var currVal_36 = core["ɵnov"](_v, 32).primary; var currVal_37 = core["ɵnov"](_v, 32).info; var currVal_38 = core["ɵnov"](_v, 32).success; var currVal_39 = core["ɵnov"](_v, 32).warning; var currVal_40 = core["ɵnov"](_v, 32).danger; var currVal_41 = core["ɵnov"](_v, 32).basic; var currVal_42 = core["ɵnov"](_v, 32).control; var currVal_43 = core["ɵnov"](_v, 32).rectangle; var currVal_44 = core["ɵnov"](_v, 32).round; var currVal_45 = core["ɵnov"](_v, 32).semiRound; var currVal_46 = core["ɵnov"](_v, 32).iconLeft; var currVal_47 = core["ɵnov"](_v, 32).iconRight; var currVal_48 = core["ɵnov"](_v, 32).transitions; _ck(_v, 31, 1, [currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34, currVal_35, currVal_36, currVal_37, currVal_38, currVal_39, currVal_40, currVal_41, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48]); var currVal_50 = (_co.isRefreshing ? "Aguarde..." : "Salvar"); _ck(_v, 33, 0, currVal_50); }); }
function View_UpdateAvaliabilityComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-update-avaliability", [], null, null, null, View_UpdateAvaliabilityComponent_0, RenderType_UpdateAvaliabilityComponent)), core["ɵdid"](1, 114688, null, 0, update_avaliability_component_UpdateAvaliabilityComponent, [fesm2015_forms["g" /* FormBuilder */], router["l" /* Router */], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], empresa_service["a" /* EmpresaService */], produto_service["a" /* ProdutoService */], messages_service["a" /* MessagesService */], request_service["a" /* RequestService */], fesm2015["Ld" /* NbToastrService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var UpdateAvaliabilityComponentNgFactory = core["ɵccf"]("omni-update-avaliability", update_avaliability_component_UpdateAvaliabilityComponent, View_UpdateAvaliabilityComponent_Host_0, {}, {}, []);


// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/ngx-bootstrap-typeahead.ngfactory.js
var ngx_bootstrap_typeahead_ngfactory = __webpack_require__("SfUx");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/cashback-credit-dialog/cashback-credit-dialog.component.ngfactory.js + 1 modules
var cashback_credit_dialog_component_ngfactory = __webpack_require__("sKAB");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/category/category-quick-form-dialog/category-quick-form-dialog.component.ngfactory.js + 1 modules
var category_quick_form_dialog_component_ngfactory = __webpack_require__("iY9W");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/customization/edit-customization-value-dialog/edit-customization-value-dialog.component.ngfactory.js + 1 modules
var edit_customization_value_dialog_component_ngfactory = __webpack_require__("x9iD");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/edit-delivery-address-dialog/edit-delivery-address-dialog.component.ngfactory.js + 1 modules
var edit_delivery_address_dialog_component_ngfactory = __webpack_require__("EXuQ");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/extract-cashback-list-dialog/extract-cashback-list-dialog.component.ngfactory.js + 1 modules
var extract_cashback_list_dialog_component_ngfactory = __webpack_require__("ZjL+");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-detail-dialog/order-detail-dialog.component.ngfactory.js + 3 modules
var order_detail_dialog_component_ngfactory = __webpack_require__("lbLe");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-update-dialog/order-update-dialog.component.ngfactory.js + 1 modules
var order_update_dialog_component_ngfactory = __webpack_require__("/Cjm");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-edit-dialog/promotion-rule-edit-dialog.component.ngfactory.js + 1 modules
var promotion_rule_edit_dialog_component_ngfactory = __webpack_require__("AHux");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/view-picture-dialog/view-picture-dialog.component.ngfactory.js + 1 modules
var view_picture_dialog_component_ngfactory = __webpack_require__("YAEL");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-gift-edit-dialog/promotion-gift-edit-dialog.component.ngfactory.js + 1 modules
var promotion_gift_edit_dialog_component_ngfactory = __webpack_require__("RswS");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-view-dialog/promotion-rule-view-dialog.component.ngfactory.js + 1 modules
var promotion_rule_view_dialog_component_ngfactory = __webpack_require__("BRe2");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-feedback-dialog/order-feedback-dialog.component.ngfactory.js + 1 modules
var order_feedback_dialog_component_ngfactory = __webpack_require__("otmp");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/tutorial-dialog/tutorial-dialog.component.ngfactory.js + 1 modules
var tutorial_dialog_component_ngfactory = __webpack_require__("Uvoc");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/overlay.js
var overlay = __webpack_require__("QQfA");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/bidi.js
var bidi = __webpack_require__("IP0z");

// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/fesm2015/sweetalert2-ngx-sweetalert2.js
var sweetalert2_ngx_sweetalert2 = __webpack_require__("hvj1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/positioning/fesm2015/ngx-bootstrap-positioning.js
var ngx_bootstrap_positioning = __webpack_require__("2uy1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/component-loader/fesm2015/ngx-bootstrap-component-loader.js
var ngx_bootstrap_component_loader = __webpack_require__("z/SZ");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/fesm2015/ngx-bootstrap-typeahead.js + 2 modules
var ngx_bootstrap_typeahead = __webpack_require__("ZMeN");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/portal.js
var portal = __webpack_require__("zMNK");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/platform.js
var platform = __webpack_require__("/HVE");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/scrolling.js + 6 modules
var scrolling = __webpack_require__("hOhj");

// EXTERNAL MODULE: ./src/app/shared/pipes/pipes.module.ts + 9 modules
var pipes_module = __webpack_require__("9Xeq");

// EXTERNAL MODULE: ./src/app/shared/guards/auth.guard.ts
var auth_guard = __webpack_require__("LjFu");

// CONCATENATED MODULE: ./src/app/pages/products/update-avaliability/update-avaliability-routing.module.ts



const routes = [
    { path: '', component: update_avaliability_component_UpdateAvaliabilityComponent, canActivate: [auth_guard["a" /* AuthGuard */]] }
];
class UpdateAvaliabilityRoutingModule {
}

// EXTERNAL MODULE: ./node_modules/br-mask/dist/app.module.js
var app_module = __webpack_require__("CbX2");

// EXTERNAL MODULE: ./node_modules/angular2-chartjs/dist/chart.module.js
var chart_module = __webpack_require__("AE88");

// EXTERNAL MODULE: ./src/app/shared/directives/directives.module.ts + 1 modules
var directives_module = __webpack_require__("yGOH");

// EXTERNAL MODULE: ./node_modules/@nebular/eva-icons/fesm2015/index.js
var eva_icons_fesm2015 = __webpack_require__("XoTT");

// EXTERNAL MODULE: ./node_modules/ngx-dropzone/fesm2015/ngx-dropzone.js
var ngx_dropzone = __webpack_require__("tq8E");

// EXTERNAL MODULE: ./src/app/shared/ui/ui.module.ts + 6 modules
var ui_module = __webpack_require__("4zvT");

// CONCATENATED MODULE: ./src/app/pages/products/update-avaliability/update-avaliability.module.ngfactory.js
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UpdateAvaliabilityModuleNgFactory", function() { return UpdateAvaliabilityModuleNgFactory; });
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 













































var UpdateAvaliabilityModuleNgFactory = core["ɵcmf"](UpdateAvaliabilityModule, [], function (_l) { return core["ɵmod"]([core["ɵmpd"](512, core["ComponentFactoryResolver"], core["ɵCodegenComponentFactoryResolver"], [[8, [angular_fontawesome_ngfactory["b" /* FaIconComponentNgFactory */], angular_fontawesome_ngfactory["a" /* FaDuotoneIconComponentNgFactory */], router_ngfactory["a" /* ɵangular_packages_router_router_lNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["b" /* SwalComponentNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["d" /* ɵcNgFactory */], UpdateAvaliabilityComponentNgFactory, index_ngfactory["h" /* NbContextMenuComponentNgFactory */], index_ngfactory["j" /* NbDialogContainerComponentNgFactory */], index_ngfactory["k" /* NbPopoverComponentNgFactory */], index_ngfactory["n" /* NbTooltipComponentNgFactory */], ngx_bootstrap_typeahead_ngfactory["a" /* TypeaheadContainerComponentNgFactory */], cashback_credit_dialog_component_ngfactory["a" /* CashbackCreditDialogComponentNgFactory */], category_quick_form_dialog_component_ngfactory["a" /* CategoryQuickFormDialogComponentNgFactory */], edit_customization_value_dialog_component_ngfactory["a" /* EditCustomizationValueDialogComponentNgFactory */], edit_delivery_address_dialog_component_ngfactory["a" /* EditDeliveryAddressDialogComponentNgFactory */], extract_cashback_list_dialog_component_ngfactory["a" /* ExtractCashbackListDialogComponentNgFactory */], order_detail_dialog_component_ngfactory["a" /* OrderDetailDialogComponentNgFactory */], order_update_dialog_component_ngfactory["a" /* OrderUpdateDialogComponentNgFactory */], promotion_rule_edit_dialog_component_ngfactory["a" /* PromotionRuleEditDialogComponentNgFactory */], view_picture_dialog_component_ngfactory["b" /* ViewPictureDialogComponentNgFactory */], promotion_gift_edit_dialog_component_ngfactory["a" /* PromotionGiftEditDialogComponentNgFactory */], promotion_rule_view_dialog_component_ngfactory["a" /* PromotionRuleViewDialogComponentNgFactory */], order_feedback_dialog_component_ngfactory["a" /* OrderFeedbackDialogComponentNgFactory */], tutorial_dialog_component_ngfactory["b" /* TutorialDialogComponentNgFactory */]]], [3, core["ComponentFactoryResolver"]], core["NgModuleRef"]]), core["ɵmpd"](4608, common["q" /* NgLocalization */], common["p" /* NgLocaleLocalization */], [core["LOCALE_ID"], [2, common["R" /* ɵangular_packages_common_common_a */]]]), core["ɵmpd"](4608, fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], []), core["ɵmpd"](4608, overlay["d" /* Overlay */], overlay["d" /* Overlay */], [overlay["i" /* ScrollStrategyOptions */], overlay["e" /* OverlayContainer */], core["ComponentFactoryResolver"], overlay["h" /* OverlayPositionBuilder */], overlay["f" /* OverlayKeyboardDispatcher */], core["Injector"], core["NgZone"], common["e" /* DOCUMENT */], bidi["b" /* Directionality */], [2, common["k" /* Location */]]]), core["ɵmpd"](5120, overlay["j" /* ɵc */], overlay["k" /* ɵd */], [overlay["d" /* Overlay */]]), core["ɵmpd"](4608, fesm2015_forms["g" /* FormBuilder */], fesm2015_forms["g" /* FormBuilder */], []), core["ɵmpd"](4608, sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], []), core["ɵmpd"](4608, ngx_bootstrap_positioning["a" /* PositioningService */], ngx_bootstrap_positioning["a" /* PositioningService */], [core["NgZone"], core["RendererFactory2"], core["PLATFORM_ID"]]), core["ɵmpd"](4608, ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], [core["ComponentFactoryResolver"], core["NgZone"], core["Injector"], ngx_bootstrap_positioning["a" /* PositioningService */], core["ApplicationRef"]]), core["ɵmpd"](4608, ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], []), core["ɵmpd"](1073742336, common["c" /* CommonModule */], common["c" /* CommonModule */], []), core["ɵmpd"](1073742336, angular_fontawesome["j" /* FontAwesomeModule */], angular_fontawesome["j" /* FontAwesomeModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], []), core["ɵmpd"](1073742336, fesm2015_forms["n" /* FormsModule */], fesm2015_forms["n" /* FormsModule */], []), core["ɵmpd"](1073742336, router["p" /* RouterModule */], router["p" /* RouterModule */], [[2, router["u" /* ɵangular_packages_router_router_a */]], [2, router["l" /* Router */]]]), core["ɵmpd"](1073742336, fesm2015["pe" /* ɵc */], fesm2015["pe" /* ɵc */], []), core["ɵmpd"](1073742336, fesm2015["M" /* NbButtonModule */], fesm2015["M" /* NbButtonModule */], []), core["ɵmpd"](1073742336, fesm2015["dc" /* NbIconModule */], fesm2015["dc" /* NbIconModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["nb" /* NbCardModule */], fesm2015["nb" /* NbCardModule */], []), core["ɵmpd"](1073742336, fesm2015["Bb" /* NbCheckboxModule */], fesm2015["Bb" /* NbCheckboxModule */], []), core["ɵmpd"](1073742336, fesm2015["fc" /* NbInputModule */], fesm2015["fc" /* NbInputModule */], []), core["ɵmpd"](1073742336, bidi["a" /* BidiModule */], bidi["a" /* BidiModule */], []), core["ɵmpd"](1073742336, portal["f" /* PortalModule */], portal["f" /* PortalModule */], []), core["ɵmpd"](1073742336, platform["b" /* PlatformModule */], platform["b" /* PlatformModule */], []), core["ɵmpd"](1073742336, scrolling["b" /* ScrollingModule */], scrolling["b" /* ScrollingModule */], []), core["ɵmpd"](1073742336, overlay["g" /* OverlayModule */], overlay["g" /* OverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["pb" /* NbCdkMappingModule */], fesm2015["pb" /* NbCdkMappingModule */], []), core["ɵmpd"](1073742336, fesm2015["ob" /* NbCdkAdapterModule */], fesm2015["ob" /* NbCdkAdapterModule */], []), core["ɵmpd"](1073742336, fesm2015["Ec" /* NbOverlayModule */], fesm2015["Ec" /* NbOverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["kd" /* NbSelectModule */], fesm2015["kd" /* NbSelectModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["x" /* ReactiveFormsModule */], fesm2015_forms["x" /* ReactiveFormsModule */], []), core["ɵmpd"](1073742336, pipes_module["a" /* PipesModule */], pipes_module["a" /* PipesModule */], []), core["ɵmpd"](1073742336, sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], []), core["ɵmpd"](1073742336, UpdateAvaliabilityRoutingModule, UpdateAvaliabilityRoutingModule, []), core["ɵmpd"](1073742336, app_module["a" /* BrMaskerModule */], app_module["a" /* BrMaskerModule */], []), core["ɵmpd"](1073742336, chart_module["ChartModule"], chart_module["ChartModule"], []), core["ɵmpd"](1073742336, directives_module["a" /* DirectivesModule */], directives_module["a" /* DirectivesModule */], []), core["ɵmpd"](1073742336, fesm2015["D" /* NbAlertModule */], fesm2015["D" /* NbAlertModule */], []), core["ɵmpd"](1073742336, fesm2015["F" /* NbBadgeModule */], fesm2015["F" /* NbBadgeModule */], []), core["ɵmpd"](1073742336, fesm2015["B" /* NbActionsModule */], fesm2015["B" /* NbActionsModule */], []), core["ɵmpd"](1073742336, fesm2015["vc" /* NbMenuModule */], fesm2015["vc" /* NbMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Gb" /* NbContextMenuModule */], fesm2015["Gb" /* NbContextMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Qb" /* NbDialogModule */], fesm2015["Qb" /* NbDialogModule */], []), core["ɵmpd"](1073742336, eva_icons_fesm2015["a" /* NbEvaIconsModule */], eva_icons_fesm2015["a" /* NbEvaIconsModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["rc" /* NbListModule */], fesm2015["rc" /* NbListModule */], []), core["ɵmpd"](1073742336, fesm2015["Lc" /* NbPopoverModule */], fesm2015["Lc" /* NbPopoverModule */], []), core["ɵmpd"](1073742336, fesm2015["Vc" /* NbRadioModule */], fesm2015["Vc" /* NbRadioModule */], []), core["ɵmpd"](1073742336, fesm2015["Ed" /* NbTabsetModule */], fesm2015["Ed" /* NbTabsetModule */], []), core["ɵmpd"](1073742336, fesm2015["Qd" /* NbTooltipModule */], fesm2015["Qd" /* NbTooltipModule */], []), core["ɵmpd"](1073742336, fesm2015["fe" /* NbUserModule */], fesm2015["fe" /* NbUserModule */], []), core["ɵmpd"](1073742336, ngx_dropzone["c" /* NgxDropzoneModule */], ngx_dropzone["c" /* NgxDropzoneModule */], []), core["ɵmpd"](1073742336, ngx_bootstrap_typeahead["d" /* TypeaheadModule */], ngx_bootstrap_typeahead["d" /* TypeaheadModule */], []), core["ɵmpd"](1073742336, ui_module["a" /* UiModule */], ui_module["a" /* UiModule */], []), core["ɵmpd"](1073742336, UpdateAvaliabilityModule, UpdateAvaliabilityModule, []), core["ɵmpd"](1024, router["j" /* ROUTES */], function () { return [[{ path: "", component: update_avaliability_component_UpdateAvaliabilityComponent, canActivate: [auth_guard["a" /* AuthGuard */]] }]]; }, []), core["ɵmpd"](256, sweetalert2_ngx_sweetalert2["d" /* ɵa */], undefined, [])]); });



/***/ })

};;