exports.ids = [25];
exports.modules = {

/***/ "KRuj":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@angular/core/fesm2015/core.js
var core = __webpack_require__("8Y7J");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category.module.ts
class CustomizationCategoryModule {
}

// EXTERNAL MODULE: ./node_modules/@angular/router/router.ngfactory.js
var router_ngfactory = __webpack_require__("pMnS");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/grid-label/grid-label.component.ngfactory.js
var grid_label_component_ngfactory = __webpack_require__("3xHq");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/grid-label/grid-label.component.ts
var grid_label_component = __webpack_require__("uddK");

// EXTERNAL MODULE: ./src/app/shared/ui/dropdown-menu/dropdown-menu.component.ngfactory.js
var dropdown_menu_component_ngfactory = __webpack_require__("QM7m");

// EXTERNAL MODULE: ./src/app/shared/ui/dropdown-menu/dropdown-menu.component.ts + 1 modules
var dropdown_menu_component = __webpack_require__("jEJX");

// EXTERNAL MODULE: ./node_modules/@angular/common/fesm2015/common.js
var common = __webpack_require__("SVse");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/pagination/pagination.component.ngfactory.js + 1 modules
var pagination_component_ngfactory = __webpack_require__("tHyn");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/pagination/pagination.component.ts
var pagination_component = __webpack_require__("HJd8");

// EXTERNAL MODULE: ./src/app/shared/pipes/yes-no.pipe.ts
var yes_no_pipe = __webpack_require__("KnEs");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ngfactory.js + 1 modules
var page_title_component_ngfactory = __webpack_require__("laEC");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ts
var page_title_component = __webpack_require__("S4p5");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/fesm2015/index.js + 5 modules
var fesm2015 = __webpack_require__("tKwJ");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/index.ngfactory.js
var index_ngfactory = __webpack_require__("jXVt");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/filter/filter.component.ngfactory.js
var filter_component_ngfactory = __webpack_require__("vtHt");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/filter/filter.component.ts
var filter_component = __webpack_require__("4J+U");

// EXTERNAL MODULE: ./src/app/shared/ui/inline-loader/inline-loader.component.ngfactory.js
var inline_loader_component_ngfactory = __webpack_require__("T9fw");

// EXTERNAL MODULE: ./src/app/shared/ui/inline-loader/inline-loader.component.ts
var inline_loader_component = __webpack_require__("IGDG");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/form-filter/form-filter.component.ngfactory.js + 1 modules
var form_filter_component_ngfactory = __webpack_require__("OQs5");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/form-filter/form-filter.component.ts
var form_filter_component = __webpack_require__("/gwA");

// EXTERNAL MODULE: ./node_modules/@angular/forms/fesm2015/forms.js
var fesm2015_forms = __webpack_require__("s7LF");

// EXTERNAL MODULE: ./src/app/shared/ui/field/field.component.ngfactory.js + 1 modules
var field_component_ngfactory = __webpack_require__("jZyr");

// EXTERNAL MODULE: ./src/app/shared/ui/field/field.component.ts
var field_component = __webpack_require__("jaPl");

// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-form-filter-component.ts
var base_form_filter_component = __webpack_require__("4ILO");

// EXTERNAL MODULE: ./src/app/shared/utils/null.util.ts
var null_util = __webpack_require__("5tvI");

// EXTERNAL MODULE: ./src/app/shared/utils/number.util.ts
var number_util = __webpack_require__("qzEW");

// EXTERNAL MODULE: ./src/app/shared/consts/query-operators.ts
var query_operators = __webpack_require__("AtRd");

// EXTERNAL MODULE: ./src/app/shared/utils/string.util.ts
var string_util = __webpack_require__("8n1d");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category-filter/customization-filter.component.ts







class customization_filter_component_CustomizationCategoryFilterComponent extends base_form_filter_component["a" /* BaseFormFilterComponent */] {
    constructor(cd, fb, authService, categoriasService) {
        super();
        this.cd = cd;
        this.fb = fb;
        this.authService = authService;
        this.categoriasService = categoriasService;
        this.categoriasService.companyId = this.authService.loggedUser.id;
    }
    ngDoCheck() {
        if (this.comboCategory && this.comboCategory.options.length > 0) {
            this.comboCategory.selected = this.selectedCategory;
            this.cd.markForCheck();
        }
    }
    ngOnInit() {
        this.initForm();
        this.loadFormData();
    }
    applyFilter() {
        this.filters = [];
        this.formFilter.patchValue({
            categoriaId: this.selectedCategory,
            multiOpcional: this.selectedMultiOptional,
            subProduto: this.selectedSubProduct
        });
        const form = this.formFilter.getRawValue();
        if (!string_util["a" /* StringUtil */].isBlank(form.descricao)) {
            this.filters.push({
                key: 'descricao',
                label: 'Descrição',
                operator: query_operators["a" /* QUERY_OPERATORS */].EQUALS,
                value: form.descricao,
                tagValue: form.descricao
            });
        }
        if (number_util["a" /* NumberUtil */].isNotNullOrZero(form.categoriaId)) {
            const category = this.getCategoryById(form.categoriaId);
            this.filters.push({
                key: 'categoriaId',
                label: 'Categoria',
                operator: query_operators["a" /* QUERY_OPERATORS */].EQUALS,
                value: form.categoriaId,
                tagValue: category.label
            });
        }
        if (null_util["a" /* NullUtil */].isNotNull(form.multiOpcional)) {
            this.filters.push({
                key: 'multiOpcional',
                label: 'Permite selecionar mais de uma opção?',
                operator: query_operators["a" /* QUERY_OPERATORS */].EQUALS,
                value: form.multiOpcional,
                tagValue: form.multiOpcional ? 'Sim' : 'Não'
            });
        }
        if (null_util["a" /* NullUtil */].isNotNull(form.subProduto)) {
            this.filters.push({
                key: 'subProduto',
                label: 'É um opcional de produtos?',
                operator: query_operators["a" /* QUERY_OPERATORS */].EQUALS,
                value: form.subProduto,
                tagValue: form.subProduto ? 'Sim' : 'Não'
            });
        }
        this.saveFilterState(this.filters);
        this.doFilter.emit(this.filters);
    }
    initForm() {
        this.formFilter = this.fb.group({
            descricao: [''],
            categoriaId: [''],
            multiOpcional: [],
            subProduto: ['']
        });
    }
    resetFilter() {
        this.filters = [];
        this.doFilter.emit(this.filters);
    }
    refreshFilterState() {
        if (this.getFilterState()) {
            this.getFilterState().criterias.forEach((criteria) => {
                switch (criteria.key) {
                    case 'categoriaId':
                        this.selectedCategory = +criteria.value;
                        break;
                    case 'multiOpcional':
                        this.selectedMultiOptional = criteria.value;
                        break;
                    case 'subProduto':
                        this.selectedSubProduct = criteria.value;
                        break;
                    default:
                        break;
                }
                this.formFilter.get(criteria.key).setValue(criteria.value);
            });
        }
    }
    loadFormData() {
        this.categories = [];
        this.multiSelectableOptions = [];
        this.subProductOptions = [];
        this.categoriasService.findAllExceptMasterCategories().subscribe(categories => {
            categories.forEach(category => {
                const masterCategory = `${null_util["a" /* NullUtil */].isNotNull(category.categoriaPai) ? category.categoriaPai.descricao + ' - ' : ''}`;
                this.categories.push({
                    label: `${masterCategory}${category.descricao}`,
                    value: category.id
                });
            });
            this.cd.markForCheck();
        });
        const radioOptions = [
            { label: 'Sim', value: true },
            { label: 'Não', value: false }
        ];
        radioOptions.map(option => {
            this.multiSelectableOptions.push(option);
            this.subProductOptions.push(option);
        });
        this.refreshFilterState();
    }
    getCategoryById(value) {
        return this.categories.filter(category => category.value === value)[0];
    }
}

// EXTERNAL MODULE: ./src/app/shared/services/auth.service.ts + 3 modules
var auth_service = __webpack_require__("IYfF");

// EXTERNAL MODULE: ./src/app/shared/services/categorias.service.ts
var categorias_service = __webpack_require__("uWRN");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category-filter/customization-filter.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 










var styles_CustomizationCategoryFilterComponent = [];
var RenderType_CustomizationCategoryFilterComponent = core["ɵcrt"]({ encapsulation: 2, styles: styles_CustomizationCategoryFilterComponent, data: {} });

function View_CustomizationCategoryFilterComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-option", [], [[2, "selected", null], [1, "disabled", 0], [8, "tabIndex", 0]], [[null, "click"], [null, "keydown.space"], [null, "keydown.enter"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("keydown.space" === en)) {
        var pd_1 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_1 && ad);
    } if (("keydown.enter" === en)) {
        var pd_2 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, index_ngfactory["Z" /* View_NbOptionComponent_0 */], index_ngfactory["C" /* RenderType_NbOptionComponent */])), core["ɵdid"](1, 180224, [[3, 4]], 0, fesm2015["yc" /* NbOptionComponent */], [fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], core["ElementRef"], core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, ["", ""]))], function (_ck, _v) { var currVal_3 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).selectedClass; var currVal_1 = core["ɵnov"](_v, 1).disabledAttribute; var currVal_2 = core["ɵnov"](_v, 1).tabindex; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2); var currVal_4 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_4); }); }
function View_CustomizationCategoryFilterComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], null, null, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](1, 49152, [[5, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_7 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_7); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).isPrimary; var currVal_1 = core["ɵnov"](_v, 1).isSuccess; var currVal_2 = core["ɵnov"](_v, 1).isWarning; var currVal_3 = core["ɵnov"](_v, 1).isDanger; var currVal_4 = core["ɵnov"](_v, 1).isInfo; var currVal_5 = core["ɵnov"](_v, 1).isBasic; var currVal_6 = core["ɵnov"](_v, 1).isControl; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_8 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_8); }); }
function View_CustomizationCategoryFilterComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], null, null, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](1, 49152, [[6, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_7 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_7); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).isPrimary; var currVal_1 = core["ɵnov"](_v, 1).isSuccess; var currVal_2 = core["ɵnov"](_v, 1).isWarning; var currVal_3 = core["ɵnov"](_v, 1).isDanger; var currVal_4 = core["ɵnov"](_v, 1).isInfo; var currVal_5 = core["ɵnov"](_v, 1).isBasic; var currVal_6 = core["ɵnov"](_v, 1).isControl; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_8 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_8); }); }
function View_CustomizationCategoryFilterComponent_0(_l) { return core["ɵvid"](2, [core["ɵqud"](402653184, 1, { formFilterRef: 0 }), core["ɵqud"](671088640, 2, { comboCategory: 0 }), (_l()(), core["ɵeld"](2, 0, null, null, 60, "form", [["novalidate", ""]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "ngSubmit"], [null, "submit"], [null, "reset"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("submit" === en)) {
        var pd_0 = (core["ɵnov"](_v, 4).onSubmit($event) !== false);
        ad = (pd_0 && ad);
    } if (("reset" === en)) {
        var pd_1 = (core["ɵnov"](_v, 4).onReset() !== false);
        ad = (pd_1 && ad);
    } if (("ngSubmit" === en)) {
        var pd_2 = (_co.onSubmit() !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](3, 16384, null, 0, fesm2015_forms["D" /* ɵangular_packages_forms_forms_z */], [], null, null), core["ɵdid"](4, 540672, null, 0, fesm2015_forms["l" /* FormGroupDirective */], [[8, null], [8, null]], { form: [0, "form"] }, { ngSubmit: "ngSubmit" }), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["l" /* FormGroupDirective */]]), core["ɵdid"](6, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](7, 0, null, null, 55, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](8, 0, null, null, 54, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](9, 0, null, null, 9, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](10, 0, null, null, 8, "omni-field", [["field", "descricao"], ["label", "Descri\u00E7\u00E3o"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](11, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](12, 0, null, 0, 6, "input", [["formControlName", "descricao"], ["fullWidth", ""], ["name", "descricao"], ["nbInput", ""], ["placeholder", "Informe a Descri\u00E7\u00E3o"], ["status", "primary"], ["type", "text"]], [[8, "readOnly", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 13)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 13).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 13)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 13)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](13, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](15, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](17, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](18, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](19, 0, null, null, 16, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](20, 0, null, null, 15, "omni-field", [["field", "categoriaId"], ["label", "Categoria"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](21, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](22, 0, null, 0, 13, "nb-select", [["formControlName", "categoriaId"], ["fullWidth", ""], ["placeholder", "Selecione a Categoria"], ["status", "primary"]], [[2, "appearance-outline", null], [2, "appearance-filled", null], [2, "appearance-hero", null], [2, "full-width", null], [2, "open", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "selectedChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("selectedChange" === en)) {
        var pd_0 = ((_co.selectedCategory = $event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["db" /* View_NbSelectComponent_0 */], index_ngfactory["G" /* RenderType_NbSelectComponent */])), core["ɵdid"](23, 5423104, [[2, 4]], 2, fesm2015["id" /* NbSelectComponent */], [fesm2015["g" /* NB_DOCUMENT */], fesm2015["Gc" /* NbOverlayService */], core["ElementRef"], fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], core["ChangeDetectorRef"], fesm2015["qe" /* ɵd */]], { status: [0, "status"], fullWidth: [1, "fullWidth"], placeholder: [2, "placeholder"], selected: [3, "selected"] }, { selectedChange: "selectedChange" }), core["ɵqud"](603979776, 3, { options: 1 }), core["ɵqud"](603979776, 4, { customLabel: 0 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](27, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](29, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵprd"](2048, null, fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], null, [fesm2015["id" /* NbSelectComponent */]]), (_l()(), core["ɵeld"](31, 0, null, 1, 2, "nb-option", [], [[2, "selected", null], [1, "disabled", 0], [8, "tabIndex", 0]], [[null, "click"], [null, "keydown.space"], [null, "keydown.enter"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 32).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("keydown.space" === en)) {
        var pd_1 = (core["ɵnov"](_v, 32).onClick($event) !== false);
        ad = (pd_1 && ad);
    } if (("keydown.enter" === en)) {
        var pd_2 = (core["ɵnov"](_v, 32).onClick($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, index_ngfactory["Z" /* View_NbOptionComponent_0 */], index_ngfactory["C" /* RenderType_NbOptionComponent */])), core["ɵdid"](32, 180224, [[3, 4]], 0, fesm2015["yc" /* NbOptionComponent */], [fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], core["ElementRef"], core["ChangeDetectorRef"]], null, null), (_l()(), core["ɵted"](-1, 0, ["Todas as Categorias"])), (_l()(), core["ɵand"](16777216, null, 1, 1, null, View_CustomizationCategoryFilterComponent_1)), core["ɵdid"](35, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](36, 0, null, null, 8, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](37, 0, null, null, 7, "omni-field", [["endLabelChar", "?"], ["field", "multiOpcional"], ["label", "Permite selecionar mais de uma op\u00E7\u00E3o"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](38, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], endLabelChar: [3, "endLabelChar"] }, null), (_l()(), core["ɵeld"](39, 0, null, 0, 5, "nb-radio-group", [["class", "d-flex flex-row"], ["name", "rg-multioptional"], ["status", "primary"]], null, [[null, "valueChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("valueChange" === en)) {
        var pd_0 = ((_co.selectedMultiOptional = $event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["cb" /* View_NbRadioGroupComponent_0 */], index_ngfactory["F" /* RenderType_NbRadioGroupComponent */])), core["ɵprd"](5120, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Uc" /* NbRadioGroupComponent */]]), core["ɵdid"](41, 1228800, null, 1, fesm2015["Uc" /* NbRadioGroupComponent */], [core["ElementRef"], core["PLATFORM_ID"], fesm2015["g" /* NB_DOCUMENT */]], { value: [0, "value"], name: [1, "name"], status: [2, "status"] }, { valueChange: "valueChange" }), core["ɵqud"](603979776, 5, { radios: 1 }), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_CustomizationCategoryFilterComponent_2)), core["ɵdid"](44, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](45, 0, null, null, 8, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](46, 0, null, null, 7, "omni-field", [["endLabelChar", "?"], ["field", "subProduto"], ["label", "\u00C9 um opcional de produtos"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](47, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], endLabelChar: [3, "endLabelChar"] }, null), (_l()(), core["ɵeld"](48, 0, null, 0, 5, "nb-radio-group", [["class", "d-flex flex-row"], ["name", "rg-sub-product"], ["status", "primary"]], null, [[null, "valueChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("valueChange" === en)) {
        var pd_0 = ((_co.selectedSubProduct = $event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["cb" /* View_NbRadioGroupComponent_0 */], index_ngfactory["F" /* RenderType_NbRadioGroupComponent */])), core["ɵprd"](5120, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Uc" /* NbRadioGroupComponent */]]), core["ɵdid"](50, 1228800, null, 1, fesm2015["Uc" /* NbRadioGroupComponent */], [core["ElementRef"], core["PLATFORM_ID"], fesm2015["g" /* NB_DOCUMENT */]], { value: [0, "value"], name: [1, "name"], status: [2, "status"] }, { valueChange: "valueChange" }), core["ɵqud"](603979776, 6, { radios: 1 }), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_CustomizationCategoryFilterComponent_3)), core["ɵdid"](53, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](54, 0, null, null, 0, "hr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](55, 0, null, null, 3, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](56, 0, null, null, 2, "button", [["fullWidth", ""], ["nbButton", ""], ["status", "primary"], ["type", "submit"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 57).onClick($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](57, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"], fullWidth: [1, "fullWidth"], disabled: [2, "disabled"] }, null), (_l()(), core["ɵted"](-1, 0, [" Pesquisar "])), (_l()(), core["ɵeld"](59, 0, null, null, 3, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](60, 0, null, null, 2, "button", [["fullWidth", ""], ["nbButton", ""], ["status", "primary"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 61).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.onResetFilter() !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](61, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"], outline: [1, "outline"], fullWidth: [2, "fullWidth"], disabled: [3, "disabled"] }, null), (_l()(), core["ɵted"](-1, 0, [" Limpar "]))], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.formFilter; _ck(_v, 4, 0, currVal_7); var currVal_8 = "descricao"; var currVal_9 = _co.formFilter; var currVal_10 = "Descri\u00E7\u00E3o"; _ck(_v, 11, 0, currVal_8, currVal_9, currVal_10); var currVal_35 = "descricao"; _ck(_v, 15, 0, currVal_35); var currVal_36 = "primary"; var currVal_37 = ""; _ck(_v, 18, 0, currVal_36, currVal_37); var currVal_38 = "categoriaId"; var currVal_39 = _co.formFilter; var currVal_40 = "Categoria"; _ck(_v, 21, 0, currVal_38, currVal_39, currVal_40); var currVal_68 = "primary"; var currVal_69 = ""; var currVal_70 = "Selecione a Categoria"; var currVal_71 = _co.selectedCategory; _ck(_v, 23, 0, currVal_68, currVal_69, currVal_70, currVal_71); var currVal_72 = "categoriaId"; _ck(_v, 27, 0, currVal_72); var currVal_76 = _co.categories; _ck(_v, 35, 0, currVal_76); var currVal_77 = "multiOpcional"; var currVal_78 = _co.formFilter; var currVal_79 = "Permite selecionar mais de uma op\u00E7\u00E3o"; var currVal_80 = "?"; _ck(_v, 38, 0, currVal_77, currVal_78, currVal_79, currVal_80); var currVal_81 = _co.selectedMultiOptional; var currVal_82 = "rg-multioptional"; var currVal_83 = "primary"; _ck(_v, 41, 0, currVal_81, currVal_82, currVal_83); var currVal_84 = _co.multiSelectableOptions; _ck(_v, 44, 0, currVal_84); var currVal_85 = "subProduto"; var currVal_86 = _co.formFilter; var currVal_87 = "\u00C9 um opcional de produtos"; var currVal_88 = "?"; _ck(_v, 47, 0, currVal_85, currVal_86, currVal_87, currVal_88); var currVal_89 = _co.selectedSubProduct; var currVal_90 = "rg-sub-product"; var currVal_91 = "primary"; _ck(_v, 50, 0, currVal_89, currVal_90, currVal_91); var currVal_92 = _co.subProductOptions; _ck(_v, 53, 0, currVal_92); var currVal_119 = "primary"; var currVal_120 = ""; var currVal_121 = _co.isDisabled; _ck(_v, 57, 0, currVal_119, currVal_120, currVal_121); var currVal_148 = "primary"; var currVal_149 = true; var currVal_150 = ""; var currVal_151 = _co.isDisabled; _ck(_v, 61, 0, currVal_148, currVal_149, currVal_150, currVal_151); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 6).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 6).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 6).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 6).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 6).ngClassValid; var currVal_5 = core["ɵnov"](_v, 6).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 6).ngClassPending; _ck(_v, 2, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_11 = _co.isDisabled; var currVal_12 = core["ɵnov"](_v, 17).ngClassUntouched; var currVal_13 = core["ɵnov"](_v, 17).ngClassTouched; var currVal_14 = core["ɵnov"](_v, 17).ngClassPristine; var currVal_15 = core["ɵnov"](_v, 17).ngClassDirty; var currVal_16 = core["ɵnov"](_v, 17).ngClassValid; var currVal_17 = core["ɵnov"](_v, 17).ngClassInvalid; var currVal_18 = core["ɵnov"](_v, 17).ngClassPending; var currVal_19 = core["ɵnov"](_v, 18).fullWidth; var currVal_20 = core["ɵnov"](_v, 18).tiny; var currVal_21 = core["ɵnov"](_v, 18).small; var currVal_22 = core["ɵnov"](_v, 18).medium; var currVal_23 = core["ɵnov"](_v, 18).large; var currVal_24 = core["ɵnov"](_v, 18).giant; var currVal_25 = core["ɵnov"](_v, 18).primary; var currVal_26 = core["ɵnov"](_v, 18).info; var currVal_27 = core["ɵnov"](_v, 18).success; var currVal_28 = core["ɵnov"](_v, 18).warning; var currVal_29 = core["ɵnov"](_v, 18).danger; var currVal_30 = core["ɵnov"](_v, 18).basic; var currVal_31 = core["ɵnov"](_v, 18).control; var currVal_32 = core["ɵnov"](_v, 18).rectangle; var currVal_33 = core["ɵnov"](_v, 18).semiRound; var currVal_34 = core["ɵnov"](_v, 18).round; _ck(_v, 12, 1, [currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34]); var currVal_41 = core["ɵnov"](_v, 23).outline; var currVal_42 = core["ɵnov"](_v, 23).filled; var currVal_43 = core["ɵnov"](_v, 23).hero; var currVal_44 = core["ɵnov"](_v, 23).fullWidth; var currVal_45 = core["ɵnov"](_v, 23).isOpen; var currVal_46 = core["ɵnov"](_v, 23).tiny; var currVal_47 = core["ɵnov"](_v, 23).small; var currVal_48 = core["ɵnov"](_v, 23).medium; var currVal_49 = core["ɵnov"](_v, 23).large; var currVal_50 = core["ɵnov"](_v, 23).giant; var currVal_51 = core["ɵnov"](_v, 23).primary; var currVal_52 = core["ɵnov"](_v, 23).info; var currVal_53 = core["ɵnov"](_v, 23).success; var currVal_54 = core["ɵnov"](_v, 23).warning; var currVal_55 = core["ɵnov"](_v, 23).danger; var currVal_56 = core["ɵnov"](_v, 23).basic; var currVal_57 = core["ɵnov"](_v, 23).control; var currVal_58 = core["ɵnov"](_v, 23).rectangle; var currVal_59 = core["ɵnov"](_v, 23).round; var currVal_60 = core["ɵnov"](_v, 23).semiRound; var currVal_61 = core["ɵnov"](_v, 29).ngClassUntouched; var currVal_62 = core["ɵnov"](_v, 29).ngClassTouched; var currVal_63 = core["ɵnov"](_v, 29).ngClassPristine; var currVal_64 = core["ɵnov"](_v, 29).ngClassDirty; var currVal_65 = core["ɵnov"](_v, 29).ngClassValid; var currVal_66 = core["ɵnov"](_v, 29).ngClassInvalid; var currVal_67 = core["ɵnov"](_v, 29).ngClassPending; _ck(_v, 22, 1, [currVal_41, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58, currVal_59, currVal_60, currVal_61, currVal_62, currVal_63, currVal_64, currVal_65, currVal_66, currVal_67]); var currVal_73 = core["ɵnov"](_v, 32).selectedClass; var currVal_74 = core["ɵnov"](_v, 32).disabledAttribute; var currVal_75 = core["ɵnov"](_v, 32).tabindex; _ck(_v, 31, 0, currVal_73, currVal_74, currVal_75); var currVal_93 = core["ɵnov"](_v, 57).filled; var currVal_94 = core["ɵnov"](_v, 57).outline; var currVal_95 = core["ɵnov"](_v, 57).ghost; var currVal_96 = core["ɵnov"](_v, 57).hero; var currVal_97 = core["ɵnov"](_v, 57).fullWidth; var currVal_98 = core["ɵnov"](_v, 57).disabled; var currVal_99 = core["ɵnov"](_v, 57).disabled; var currVal_100 = core["ɵnov"](_v, 57).tabbable; var currVal_101 = core["ɵnov"](_v, 57).tiny; var currVal_102 = core["ɵnov"](_v, 57).small; var currVal_103 = core["ɵnov"](_v, 57).medium; var currVal_104 = core["ɵnov"](_v, 57).large; var currVal_105 = core["ɵnov"](_v, 57).giant; var currVal_106 = core["ɵnov"](_v, 57).primary; var currVal_107 = core["ɵnov"](_v, 57).info; var currVal_108 = core["ɵnov"](_v, 57).success; var currVal_109 = core["ɵnov"](_v, 57).warning; var currVal_110 = core["ɵnov"](_v, 57).danger; var currVal_111 = core["ɵnov"](_v, 57).basic; var currVal_112 = core["ɵnov"](_v, 57).control; var currVal_113 = core["ɵnov"](_v, 57).rectangle; var currVal_114 = core["ɵnov"](_v, 57).round; var currVal_115 = core["ɵnov"](_v, 57).semiRound; var currVal_116 = core["ɵnov"](_v, 57).iconLeft; var currVal_117 = core["ɵnov"](_v, 57).iconRight; var currVal_118 = core["ɵnov"](_v, 57).transitions; _ck(_v, 56, 1, [currVal_93, currVal_94, currVal_95, currVal_96, currVal_97, currVal_98, currVal_99, currVal_100, currVal_101, currVal_102, currVal_103, currVal_104, currVal_105, currVal_106, currVal_107, currVal_108, currVal_109, currVal_110, currVal_111, currVal_112, currVal_113, currVal_114, currVal_115, currVal_116, currVal_117, currVal_118]); var currVal_122 = core["ɵnov"](_v, 61).filled; var currVal_123 = core["ɵnov"](_v, 61).outline; var currVal_124 = core["ɵnov"](_v, 61).ghost; var currVal_125 = core["ɵnov"](_v, 61).hero; var currVal_126 = core["ɵnov"](_v, 61).fullWidth; var currVal_127 = core["ɵnov"](_v, 61).disabled; var currVal_128 = core["ɵnov"](_v, 61).disabled; var currVal_129 = core["ɵnov"](_v, 61).tabbable; var currVal_130 = core["ɵnov"](_v, 61).tiny; var currVal_131 = core["ɵnov"](_v, 61).small; var currVal_132 = core["ɵnov"](_v, 61).medium; var currVal_133 = core["ɵnov"](_v, 61).large; var currVal_134 = core["ɵnov"](_v, 61).giant; var currVal_135 = core["ɵnov"](_v, 61).primary; var currVal_136 = core["ɵnov"](_v, 61).info; var currVal_137 = core["ɵnov"](_v, 61).success; var currVal_138 = core["ɵnov"](_v, 61).warning; var currVal_139 = core["ɵnov"](_v, 61).danger; var currVal_140 = core["ɵnov"](_v, 61).basic; var currVal_141 = core["ɵnov"](_v, 61).control; var currVal_142 = core["ɵnov"](_v, 61).rectangle; var currVal_143 = core["ɵnov"](_v, 61).round; var currVal_144 = core["ɵnov"](_v, 61).semiRound; var currVal_145 = core["ɵnov"](_v, 61).iconLeft; var currVal_146 = core["ɵnov"](_v, 61).iconRight; var currVal_147 = core["ɵnov"](_v, 61).transitions; _ck(_v, 60, 1, [currVal_122, currVal_123, currVal_124, currVal_125, currVal_126, currVal_127, currVal_128, currVal_129, currVal_130, currVal_131, currVal_132, currVal_133, currVal_134, currVal_135, currVal_136, currVal_137, currVal_138, currVal_139, currVal_140, currVal_141, currVal_142, currVal_143, currVal_144, currVal_145, currVal_146, currVal_147]); }); }
function View_CustomizationCategoryFilterComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customization-category-filter", [], null, null, null, View_CustomizationCategoryFilterComponent_0, RenderType_CustomizationCategoryFilterComponent)), core["ɵdid"](1, 376832, null, 0, customization_filter_component_CustomizationCategoryFilterComponent, [core["ChangeDetectorRef"], fesm2015_forms["g" /* FormBuilder */], auth_service["a" /* AuthService */], categorias_service["a" /* CategoriasService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomizationCategoryFilterComponentNgFactory = core["ɵccf"]("omni-customization-category-filter", customization_filter_component_CustomizationCategoryFilterComponent, View_CustomizationCategoryFilterComponent_Host_0, { pageId: "pageId", currentPage: "currentPage" }, { doFilter: "doFilter" }, []);


// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/index.js
var free_solid_svg_icons = __webpack_require__("YTkO");

// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-list-component.ts
var base_list_component = __webpack_require__("Ki94");

// EXTERNAL MODULE: ./src/app/shared/consts/actions.ts
var actions = __webpack_require__("CIyo");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category-list/customization-category-list.component.ts





class customization_category_list_component_CustomizationCategoryListComponent extends base_list_component["a" /* BaseListComponent */] {
    constructor(router, customizationService, menuService, navExtrasService, requestService, toastrService, alertService, authService, messagesService) {
        super(alertService, authService, messagesService);
        this.router = router;
        this.customizationService = customizationService;
        this.menuService = menuService;
        this.navExtrasService = navExtrasService;
        this.requestService = requestService;
        this.toastrService = toastrService;
        this.confirmMessage = '';
        this.feedbackMessage = '';
        this.pageId = 'customizationList';
        this.customizationService.companyId = this.authService.loggedUser.id;
    }
    get layerIcon() {
        return free_solid_svg_icons["faLayerGroup"];
    }
    ngOnInit() {
        this.loadFilterState();
        this.feedbackMessage = this.messagesService.getMessage('MSG.SUCESSO.023', ['Opcional por Categoria']);
        this.list();
        this.initGridContextMenu();
    }
    applyFilters(filterList) {
        this.currentPage = 1;
        this.filterList = filterList;
        this.formFilterRef.closeForm();
        this.customizationFilterRef.updateFormFilter(this.filterList);
        this.addCriteria();
    }
    delete() {
        if (this.inDemoMode()) {
            return;
        }
        this.loadState();
        this.customizationService.delete(this.customization.id).subscribe(() => {
            this.loadState();
            if (this.datasource.length === 1) {
                this.datasource = [];
                this.currentPage = 1;
            }
            this.changePage(this.currentPage);
            this.alertService.success(this.feedbackMessage);
        }, (resp) => {
            this.loadState();
            this.toastrService.danger(resp.error.message);
        });
    }
    edit(id) {
        if (id && id > 0) {
            this.router.navigate([`admin/products/customization/category/${id}/edit`]);
        }
        else {
            this.router.navigate([`admin/products/customization/category/new`]);
        }
    }
    initGridContextMenu() {
        this.menuService.onItemClick().subscribe(menu => {
            const data = menu.item.data;
            if (data && data.action) {
                switch (data.action) {
                    case actions["a" /* ACTIONS */].DELETE:
                        this.customization = data.customization;
                        this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.008', ['Opcional por Categoria', this.customization.descricao]), result => {
                            if (result.value) {
                                this.delete();
                            }
                        });
                        break;
                    case actions["a" /* ACTIONS */].DUPLICATE:
                        this.navExtrasService.setExtras(data.customization.id);
                        this.router.navigate(['admin/products/customization/category/new']);
                        break;
                }
            }
        });
    }
    list() {
        this.datasource = [];
        this.isLoading = true;
        this.searchCriteria.push(`excluido${query_operators["a" /* QUERY_OPERATORS */].EQUALS}false`);
        this.customizationService.filter(this.searchCriteria, this.currentPage, ['descricao']).subscribe(resultSet => {
            this.resultSet = resultSet;
            this.resultSet.content.forEach(customization => {
                const item = {
                    item: customization,
                    itemMenu: this.makeMenu(customization)
                };
                this.datasource.push(item);
            });
        }, (resp) => this.requestService.handleError(resp, this.toastrService), () => this.isLoading = false);
    }
    makeMenu(customization) {
        return [
            { icon: 'edit', title: 'Editar', link: `admin/products/customization/category/${customization.id}/edit` },
            { icon: 'copy', title: 'Duplicar', data: { action: actions["a" /* ACTIONS */].DUPLICATE, customization } },
            { icon: 'trash', title: 'Excluir', data: { action: actions["a" /* ACTIONS */].DELETE, customization } }
        ];
    }
    setConfirmMessage() {
    }
}

// EXTERNAL MODULE: ./node_modules/@angular/router/fesm2015/router.js + 5 modules
var router = __webpack_require__("iInd");

// EXTERNAL MODULE: ./src/app/shared/services/personalizacao.service.ts
var personalizacao_service = __webpack_require__("3XQ/");

// EXTERNAL MODULE: ./src/app/shared/services/nav-extras.service.ts
var nav_extras_service = __webpack_require__("JmCY");

// EXTERNAL MODULE: ./src/app/shared/services/request.service.ts
var request_service = __webpack_require__("a9NN");

// EXTERNAL MODULE: ./src/app/shared/services/alert.service.ts
var alert_service = __webpack_require__("Cmua");

// EXTERNAL MODULE: ./src/app/shared/services/messages.service.ts + 1 modules
var messages_service = __webpack_require__("N7YL");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category-list/customization-category-list.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 































var styles_CustomizationCategoryListComponent = [];
var RenderType_CustomizationCategoryListComponent = core["ɵcrt"]({ encapsulation: 2, styles: styles_CustomizationCategoryListComponent, data: {} });

function View_CustomizationCategoryListComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "omni-grid-label", [["class", "mr-2"], ["label", "Permite selecionar no m\u00EDnimo"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](1, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " ", " "]))], function (_ck, _v) { var currVal_0 = "Permite selecionar no m\u00EDnimo"; _ck(_v, 1, 0, currVal_0); }, function (_ck, _v) { var currVal_1 = _v.parent.context.$implicit.item.quantidadeMinimaPermitida; var currVal_2 = ((_v.parent.context.$implicit.item.quantidadeMinimaPermitida === 1) ? "op\u00E7\u00E3o" : "op\u00E7\u00F5es"); _ck(_v, 2, 0, currVal_1, currVal_2); }); }
function View_CustomizationCategoryListComponent_4(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "omni-grid-label", [["label", "Permite selecionar at\u00E9"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](1, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " ", " "]))], function (_ck, _v) { var currVal_0 = "Permite selecionar at\u00E9"; _ck(_v, 1, 0, currVal_0); }, function (_ck, _v) { var currVal_1 = _v.parent.context.$implicit.item.quantidadePermitida; var currVal_2 = ((_v.parent.context.$implicit.item.quantidadePermitida === 1) ? "op\u00E7\u00E3o" : "op\u00E7\u00F5es"); _ck(_v, 2, 0, currVal_1, currVal_2); }); }
function View_CustomizationCategoryListComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 47, "div", [["class", "col-12 col-sm-12 col-md-12 col-lg-6 mb-2 pr-1 pl-1"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 46, "div", [["class", "card card-grid"]], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 6, "div", [["class", "card-title"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 5, "div", [["class", "d-flex flex-row align-items-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 2, "div", [["class", "flex-grow-1"]], null, null, null, null, null)), (_l()(), core["ɵeld"](5, 0, null, null, 1, "h5", [], null, null, null, null, null)), (_l()(), core["ɵted"](6, null, ["", ""])), (_l()(), core["ɵeld"](7, 0, null, null, 1, "omni-dropdown-menu", [], null, null, null, dropdown_menu_component_ngfactory["b" /* View_DropdownMenuComponent_0 */], dropdown_menu_component_ngfactory["a" /* RenderType_DropdownMenuComponent */])), core["ɵdid"](8, 114688, null, 0, dropdown_menu_component["a" /* DropdownMenuComponent */], [], { optionsList: [0, "optionsList"] }, null), (_l()(), core["ɵeld"](9, 0, null, null, 38, "div", [["class", "card-body"]], null, null, null, null, null)), (_l()(), core["ɵeld"](10, 0, null, null, 37, "div", [["class", "d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](11, 0, null, null, 6, "div", [["class", "d-flex flex-row justify-content-between flex-wrap  mb-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](12, 0, null, null, 2, "omni-grid-label", [["class", "pr-5"], ["label", "Categoria"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](13, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](14, 0, [" ", " "])), (_l()(), core["ɵeld"](15, 0, null, null, 2, "omni-grid-label", [["class", "pr-2"], ["label", "Pr\u00F3ximo opcional"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](16, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](17, 0, [" ", " "])), (_l()(), core["ɵeld"](18, 0, null, null, 24, "div", [["class", "d-flex flex-column"]], [[2, "mb-2", null]], null, null, null, null)), (_l()(), core["ɵeld"](19, 0, null, null, 3, "omni-grid-label", [["class", "mb-2"], ["endLabelChar", "?"], ["label", "Permite selecionar mais de uma op\u00E7\u00E3o"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](20, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], endLabelChar: [1, "endLabelChar"] }, null), (_l()(), core["ɵted"](21, 0, [" ", " "])), core["ɵppd"](22, 1), (_l()(), core["ɵeld"](23, 0, null, null, 3, "omni-grid-label", [["class", "mb-2"], ["endLabelChar", "?"], ["label", "\u00C9 um opcional de produtos"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](24, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], endLabelChar: [1, "endLabelChar"] }, null), (_l()(), core["ɵted"](25, 0, [" ", " "])), core["ɵppd"](26, 1), (_l()(), core["ɵeld"](27, 0, null, null, 3, "omni-grid-label", [["class", "mb-2"], ["endLabelChar", "?"], ["label", "Os produtos s\u00E3o vendidos por kg"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](28, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], endLabelChar: [1, "endLabelChar"] }, null), (_l()(), core["ɵted"](29, 0, [" ", " "])), core["ɵppd"](30, 1), (_l()(), core["ɵeld"](31, 0, null, null, 3, "omni-grid-label", [["class", "mb-2"], ["endLabelChar", "?"], ["label", "A sele\u00E7\u00E3o do opcional \u00E9 obrigat\u00F3ria"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](32, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], endLabelChar: [1, "endLabelChar"] }, null), (_l()(), core["ɵted"](33, 0, [" ", " "])), core["ɵppd"](34, 1), (_l()(), core["ɵeld"](35, 0, null, null, 3, "omni-grid-label", [["class", "mb-2"], ["endLabelChar", "?"], ["label", "Permite selecionar mais de uma op\u00E7\u00E3o"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](36, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], endLabelChar: [1, "endLabelChar"] }, null), (_l()(), core["ɵted"](37, 0, [" ", " "])), core["ɵppd"](38, 1), (_l()(), core["ɵeld"](39, 0, null, null, 3, "omni-grid-label", [["endLabelChar", "?"], ["label", "Opcional \u00E9 quantitativo"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](40, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], endLabelChar: [1, "endLabelChar"] }, null), (_l()(), core["ɵted"](41, 0, [" ", " "])), core["ɵppd"](42, 1), (_l()(), core["ɵeld"](43, 0, null, null, 4, "div", [["class", "d-flex flex-row align-items-center justify-content-between"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomizationCategoryListComponent_3)), core["ɵdid"](45, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomizationCategoryListComponent_4)), core["ɵdid"](47, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null)], function (_ck, _v) { var currVal_1 = _v.context.$implicit.itemMenu; _ck(_v, 8, 0, currVal_1); var currVal_2 = "Categoria"; _ck(_v, 13, 0, currVal_2); var currVal_4 = "Pr\u00F3ximo opcional"; _ck(_v, 16, 0, currVal_4); var currVal_7 = "Permite selecionar mais de uma op\u00E7\u00E3o"; var currVal_8 = "?"; _ck(_v, 20, 0, currVal_7, currVal_8); var currVal_10 = "\u00C9 um opcional de produtos"; var currVal_11 = "?"; _ck(_v, 24, 0, currVal_10, currVal_11); var currVal_13 = "Os produtos s\u00E3o vendidos por kg"; var currVal_14 = "?"; _ck(_v, 28, 0, currVal_13, currVal_14); var currVal_16 = "A sele\u00E7\u00E3o do opcional \u00E9 obrigat\u00F3ria"; var currVal_17 = "?"; _ck(_v, 32, 0, currVal_16, currVal_17); var currVal_19 = "Permite selecionar mais de uma op\u00E7\u00E3o"; var currVal_20 = "?"; _ck(_v, 36, 0, currVal_19, currVal_20); var currVal_22 = "Opcional \u00E9 quantitativo"; var currVal_23 = "?"; _ck(_v, 40, 0, currVal_22, currVal_23); var currVal_25 = _v.context.$implicit.item.quantidadeMinimaPermitida; _ck(_v, 45, 0, currVal_25); var currVal_26 = _v.context.$implicit.item.quantidadePermitida; _ck(_v, 47, 0, currVal_26); }, function (_ck, _v) { var currVal_0 = _v.context.$implicit.item.descricao; _ck(_v, 6, 0, currVal_0); var currVal_3 = _v.context.$implicit.item.categoria.descricao; _ck(_v, 14, 0, currVal_3); var currVal_5 = (((_v.context.$implicit.item.proximaPersonalizacao == null) ? null : _v.context.$implicit.item.proximaPersonalizacao.descricao) || "Nenhum"); _ck(_v, 17, 0, currVal_5); var currVal_6 = _v.context.$implicit.item.quantidadePermitida; _ck(_v, 18, 0, currVal_6); var currVal_9 = core["ɵunv"](_v, 21, 0, _ck(_v, 22, 0, core["ɵnov"](_v.parent.parent, 0), _v.context.$implicit.item.multiOpcional)); _ck(_v, 21, 0, currVal_9); var currVal_12 = core["ɵunv"](_v, 25, 0, _ck(_v, 26, 0, core["ɵnov"](_v.parent.parent, 0), _v.context.$implicit.item.subProduto)); _ck(_v, 25, 0, currVal_12); var currVal_15 = core["ɵunv"](_v, 29, 0, _ck(_v, 30, 0, core["ɵnov"](_v.parent.parent, 0), _v.context.$implicit.item.subProduto)); _ck(_v, 29, 0, currVal_15); var currVal_18 = core["ɵunv"](_v, 33, 0, _ck(_v, 34, 0, core["ɵnov"](_v.parent.parent, 0), _v.context.$implicit.item.obrigatoria)); _ck(_v, 33, 0, currVal_18); var currVal_21 = core["ɵunv"](_v, 37, 0, _ck(_v, 38, 0, core["ɵnov"](_v.parent.parent, 0), _v.context.$implicit.item.multiOpcional)); _ck(_v, 37, 0, currVal_21); var currVal_24 = core["ɵunv"](_v, 41, 0, _ck(_v, 42, 0, core["ɵnov"](_v.parent.parent, 0), _v.context.$implicit.item.quantitativa)); _ck(_v, 41, 0, currVal_24); }); }
function View_CustomizationCategoryListComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "div", [["class", "d-flex align-items-stretch flex-wrap mt-2"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomizationCategoryListComponent_2)), core["ɵdid"](2, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.datasource; _ck(_v, 2, 0, currVal_0); }, null); }
function View_CustomizationCategoryListComponent_5(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-pagination", [], null, [[null, "pageChange"], [null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("pageChange" === en)) {
        var pd_1 = (_co.changePage($event) !== false);
        ad = (pd_1 && ad);
    } return ad; }, pagination_component_ngfactory["b" /* View_PaginationComponent_0 */], pagination_component_ngfactory["a" /* RenderType_PaginationComponent */])), core["ɵdid"](1, 114688, null, 0, pagination_component["a" /* PaginationComponent */], [], { currentPage: [0, "currentPage"], totalPages: [1, "totalPages"] }, { pageChange: "pageChange" })], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.currentPage; var currVal_1 = _co.resultSet.totalPages; _ck(_v, 1, 0, currVal_0, currVal_1); }, null); }
function View_CustomizationCategoryListComponent_0(_l) { return core["ɵvid"](0, [core["ɵpid"](0, yes_no_pipe["a" /* YesNoPipe */], []), core["ɵqud"](671088640, 1, { formFilterRef: 0 }), core["ɵqud"](671088640, 2, { customizationFilterRef: 0 }), (_l()(), core["ɵeld"](3, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](5, 0, null, null, 1, "omni-page-title", [["pageTitle", "Opcionais de Categoria"], ["tutorialTag", "produtos-personalizacao-categoria-listar"]], null, null, null, page_title_component_ngfactory["b" /* View_PageTitleComponent_0 */], page_title_component_ngfactory["a" /* RenderType_PageTitleComponent */])), core["ɵdid"](6, 114688, null, 0, page_title_component["a" /* PageTitleComponent */], [fesm2015["Rb" /* NbDialogService */]], { icon: [0, "icon"], tutorial: [1, "tutorial"], tutorialTag: [2, "tutorialTag"], pageTitle: [3, "pageTitle"] }, null), (_l()(), core["ɵeld"](7, 0, null, null, 13, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](8, 0, null, null, 12, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](9, 0, null, null, 11, "nb-card", [], [[2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "accent", null], [2, "accent-primary", null], [2, "accent-info", null], [2, "accent-success", null], [2, "accent-warning", null], [2, "accent-danger", null], [2, "accent-basic", null], [2, "accent-control", null]], null, null, index_ngfactory["O" /* View_NbCardComponent_0 */], index_ngfactory["r" /* RenderType_NbCardComponent */])), core["ɵdid"](10, 49152, null, 0, fesm2015["jb" /* NbCardComponent */], [], null, null), (_l()(), core["ɵeld"](11, 0, null, 1, 9, "nb-card-body", [["class", "flat-body"]], null, null, null, index_ngfactory["N" /* View_NbCardBodyComponent_0 */], index_ngfactory["q" /* RenderType_NbCardBodyComponent */])), core["ɵdid"](12, 49152, null, 0, fesm2015["ib" /* NbCardBodyComponent */], [], null, null), (_l()(), core["ɵeld"](13, 0, null, 0, 1, "omni-filter", [["labelNewButton", "Nova"]], null, [[null, "resultSetChange"], [null, "newButtonClick"], [null, "filterButtonClick"], [null, "updateFilterList"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("resultSetChange" === en)) {
        var pd_0 = ((_co.resultSet = $event) !== false);
        ad = (pd_0 && ad);
    } if (("newButtonClick" === en)) {
        var pd_1 = (_co.edit() !== false);
        ad = (pd_1 && ad);
    } if (("filterButtonClick" === en)) {
        var pd_2 = (_co.showFormFilter() !== false);
        ad = (pd_2 && ad);
    } if (("updateFilterList" === en)) {
        var pd_3 = (_co.applyFilters($event) !== false);
        ad = (pd_3 && ad);
    } return ad; }, filter_component_ngfactory["b" /* View_FilterComponent_0 */], filter_component_ngfactory["a" /* RenderType_FilterComponent */])), core["ɵdid"](14, 114688, null, 0, filter_component["a" /* FilterComponent */], [], { filterList: [0, "filterList"], labelNewButton: [1, "labelNewButton"], resultSet: [2, "resultSet"] }, { filterButtonClick: "filterButtonClick", newButtonClick: "newButtonClick", resultSetChange: "resultSetChange", updateFilterList: "updateFilterList" }), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_CustomizationCategoryListComponent_1)), core["ɵdid"](16, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_CustomizationCategoryListComponent_5)), core["ɵdid"](18, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](19, 0, null, 0, 1, "omni-inline-loader", [["label", "Obtendo os Opcioanis dos Produtos..."]], null, null, null, inline_loader_component_ngfactory["b" /* View_InlineLoaderComponent_0 */], inline_loader_component_ngfactory["a" /* RenderType_InlineLoaderComponent */])), core["ɵdid"](20, 114688, null, 0, inline_loader_component["a" /* InlineLoaderComponent */], [], { label: [0, "label"], refreshState: [1, "refreshState"] }, null), (_l()(), core["ɵeld"](21, 0, null, null, 3, "omni-form-filter", [], null, [["window", "keyup"], [null, "click"]], function (_v, en, $event) { var ad = true; if (("window:keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 22).onEscape($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (core["ɵnov"](_v, 22).onClick($event) !== false);
        ad = (pd_1 && ad);
    } return ad; }, form_filter_component_ngfactory["b" /* View_FormFilterComponent_0 */], form_filter_component_ngfactory["a" /* RenderType_FormFilterComponent */])), core["ɵdid"](22, 49152, [[1, 4], ["formFilter", 4]], 0, form_filter_component["a" /* FormFilterComponent */], [], null, null), (_l()(), core["ɵeld"](23, 0, null, 0, 1, "omni-customization-category-filter", [], null, [[null, "doFilter"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("doFilter" === en)) {
        var pd_0 = (_co.applyFilters($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, View_CustomizationCategoryFilterComponent_0, RenderType_CustomizationCategoryFilterComponent)), core["ɵdid"](24, 376832, [[2, 4], ["customizationFilter", 4]], 0, customization_filter_component_CustomizationCategoryFilterComponent, [core["ChangeDetectorRef"], fesm2015_forms["g" /* FormBuilder */], auth_service["a" /* AuthService */], categorias_service["a" /* CategoriasService */]], { pageId: [0, "pageId"], currentPage: [1, "currentPage"] }, { doFilter: "doFilter" })], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.layerIcon; var currVal_1 = true; var currVal_2 = "produtos-personalizacao-categoria-listar"; var currVal_3 = "Opcionais de Categoria"; _ck(_v, 6, 0, currVal_0, currVal_1, currVal_2, currVal_3); var currVal_24 = _co.filterList; var currVal_25 = "Nova"; var currVal_26 = _co.resultSet; _ck(_v, 14, 0, currVal_24, currVal_25, currVal_26); var currVal_27 = ((_co.datasource.length > 0) && !_co.isLoading); _ck(_v, 16, 0, currVal_27); var currVal_28 = ((((_co.resultSet == null) ? null : _co.resultSet.totalPages) > 1) && !_co.isLoading); _ck(_v, 18, 0, currVal_28); var currVal_29 = "Obtendo os Opcioanis dos Produtos..."; var currVal_30 = _co.isLoading; _ck(_v, 20, 0, currVal_29, currVal_30); var currVal_31 = _co.pageId; var currVal_32 = _co.currentPage; _ck(_v, 24, 0, currVal_31, currVal_32); }, function (_ck, _v) { var currVal_4 = core["ɵnov"](_v, 10).tiny; var currVal_5 = core["ɵnov"](_v, 10).small; var currVal_6 = core["ɵnov"](_v, 10).medium; var currVal_7 = core["ɵnov"](_v, 10).large; var currVal_8 = core["ɵnov"](_v, 10).giant; var currVal_9 = core["ɵnov"](_v, 10).primary; var currVal_10 = core["ɵnov"](_v, 10).info; var currVal_11 = core["ɵnov"](_v, 10).success; var currVal_12 = core["ɵnov"](_v, 10).warning; var currVal_13 = core["ɵnov"](_v, 10).danger; var currVal_14 = core["ɵnov"](_v, 10).basic; var currVal_15 = core["ɵnov"](_v, 10).control; var currVal_16 = core["ɵnov"](_v, 10).hasAccent; var currVal_17 = core["ɵnov"](_v, 10).primaryAccent; var currVal_18 = core["ɵnov"](_v, 10).infoAccent; var currVal_19 = core["ɵnov"](_v, 10).successAccent; var currVal_20 = core["ɵnov"](_v, 10).warningAccent; var currVal_21 = core["ɵnov"](_v, 10).dangerAccent; var currVal_22 = core["ɵnov"](_v, 10).basicAccent; var currVal_23 = core["ɵnov"](_v, 10).controlAccent; _ck(_v, 9, 1, [currVal_4, currVal_5, currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23]); }); }
function View_CustomizationCategoryListComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customization-category-list", [], null, null, null, View_CustomizationCategoryListComponent_0, RenderType_CustomizationCategoryListComponent)), core["ɵdid"](1, 114688, null, 0, customization_category_list_component_CustomizationCategoryListComponent, [router["l" /* Router */], personalizacao_service["a" /* PersonalizacaoService */], fesm2015["wc" /* NbMenuService */], nav_extras_service["a" /* NavExtrasService */], request_service["a" /* RequestService */], fesm2015["Ld" /* NbToastrService */], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomizationCategoryListComponentNgFactory = core["ɵccf"]("omni-customization-category-list", customization_category_list_component_CustomizationCategoryListComponent, View_CustomizationCategoryListComponent_Host_0, {}, {}, []);


// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category-edit/customization-category-edit.component.scss.shim.ngstyle.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 
var styles = ["h3[_ngcontent-%COMP%]{color:var(--color-primary-default)}"];


// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ngfactory.js + 1 modules
var form_container_component_ngfactory = __webpack_require__("+aW9");

// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ts
var form_container_component = __webpack_require__("NX1Y");

// EXTERNAL MODULE: ./src/app/shared/ui/typeahead/typeahead.component.ngfactory.js + 1 modules
var typeahead_component_ngfactory = __webpack_require__("Edsu");

// EXTERNAL MODULE: ./src/app/shared/ui/typeahead/typeahead.component.ts
var typeahead_component = __webpack_require__("O0Or");

// EXTERNAL MODULE: ./src/app/shared/services/autocomplete.service.ts
var autocomplete_service = __webpack_require__("jQB5");

// EXTERNAL MODULE: ./src/app/shared/directives/input-integer.directive.ts
var input_integer_directive = __webpack_require__("CwyO");

// EXTERNAL MODULE: ./src/app/shared/ui/customization-value-form/customization-value-form.component.ngfactory.js + 1 modules
var customization_value_form_component_ngfactory = __webpack_require__("Rwov");

// EXTERNAL MODULE: ./src/app/shared/ui/customization-value-form/customization-value-form.component.ts
var customization_value_form_component = __webpack_require__("RNEA");

// EXTERNAL MODULE: ./node_modules/tslib/tslib.js
var tslib = __webpack_require__("zOht");

// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-form.component.ts
var base_form_component = __webpack_require__("rduj");

// EXTERNAL MODULE: ./src/app/shared/consts/autocomplete-entity.ts
var autocomplete_entity = __webpack_require__("MRXr");

// EXTERNAL MODULE: ./src/app/shared/enums/controle-estoque.ts
var controle_estoque = __webpack_require__("++8y");

// EXTERNAL MODULE: ./src/app/shared/models/categoria-do-produto.ts + 1 modules
var categoria_do_produto = __webpack_require__("k6QP");

// EXTERNAL MODULE: ./src/app/shared/models/resource.ts
var resource = __webpack_require__("05o1");

// CONCATENATED MODULE: ./src/app/shared/models/personalizacao.ts

/**
 * Classe definida para mapear a entidade "opcionais".
 * @author Vinicius <vinicius@escolpi.com.br>
 */
class personalizacao_Personalizacao extends resource["a" /* Resource */] {
    constructor(id) {
        super();
        this.id = id || null;
    }
}

// EXTERNAL MODULE: ./src/app/shared/models/valor-da-personalizacao.ts
var valor_da_personalizacao = __webpack_require__("CcGB");

// EXTERNAL MODULE: ./src/app/shared/utils/array.util.ts
var array_util = __webpack_require__("+Qmw");

// EXTERNAL MODULE: ./src/app/shared/utils/form.util.ts
var form_util = __webpack_require__("3oxm");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category-edit/customization-category-edit.component.ts
















class customization_category_edit_component_CustomizationCategoryEditComponent extends base_form_component["a" /* BaseFormComponent */] {
    constructor(activeRoute, fb, router, companyService, customizationService, navExtrasService, alertService, authService, messagesService, requestService, toastrService) {
        super(alertService, authService, messagesService, requestService, toastrService);
        this.activeRoute = activeRoute;
        this.fb = fb;
        this.router = router;
        this.companyService = companyService;
        this.customizationService = customizationService;
        this.navExtrasService = navExtrasService;
        this.activeTab = 'info-basicas';
        this.confirmChangeFractionatedSubProduct = false;
        this.confirmChangeType = false;
        this.confirmMessage = '';
        this.hasCustomizationValueStock = false;
        this.hasStockControl = false;
    }
    get categoryEntity() {
        return autocomplete_entity["a" /* AUTOCOMPLETE_ENTITY */].CATEGORIA_DO_PRODUTO;
    }
    get categoryField() {
        return this.form.get('categoryId');
    }
    get fractionatedSubProductField() {
        return this.form.get('fractionatedSubProduct');
    }
    get hasSelectedCategory() {
        return null_util["a" /* NullUtil */].isNotNull(this.formData.categoryId);
    }
    get isMultiSelectable() {
        return this.formData.multiSelectable;
    }
    get isSubProduct() {
        return this.formData.subProduct || false;
    }
    get nextCustomizationEntity() {
        return autocomplete_entity["a" /* AUTOCOMPLETE_ENTITY */].PERSONALIZACAO;
    }
    get nextCustomizationField() {
        return this.form.get('nextCustomizationId');
    }
    get layerIcon() {
        return free_solid_svg_icons["faLayerGroup"];
    }
    get productEntity() {
        return autocomplete_entity["a" /* AUTOCOMPLETE_ENTITY */].PRODUTO;
    }
    get subProductField() {
        return this.form.get('subProduct');
    }
    get values() {
        return this.form.get('values').value;
    }
    ngOnInit() {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            this.initForm();
            yield this.loadFormData();
        });
    }
    back() {
        this.router.navigate(['admin/products/customization/category']);
    }
    changeAllowedQuantityValues(checked) {
        if (!checked) {
            this.form.patchValue({
                minAllowedQuantity: '',
                allowedQuantity: ''
            });
        }
    }
    changeQuantityValues(checked) {
        if (!checked) {
            this.form.patchValue({
                minQuantity: '',
                maxQuantity: '',
                maxQuantityOptions: ''
            });
        }
    }
    changeValueType(subProduct) {
        if (subProduct) {
            this.form.get('fractionatedSubProduct').setValue(false);
        }
        if (this.values.controls.length > 0) {
            this.confirmMessage = this.messagesService.getMessage('MSG.CONFIRM.011');
            this.alertService.confirm(this.confirmMessage, result => {
                if (result.value) {
                    this.values.clear();
                    this.subProductField.setValue(subProduct);
                    return;
                }
                this.subProductField.setValue(!subProduct);
            });
            return;
        }
    }
    initForm() {
        this.form = this.fb.group({
            id: [''],
            description: ['', fesm2015_forms["z" /* Validators */].required],
            categoryId: ['', fesm2015_forms["z" /* Validators */].required],
            category: [''],
            nextCustomizationId: [''],
            nextCustomization: [''],
            multiSelectable: [false, fesm2015_forms["z" /* Validators */].required],
            allowedQuantity: [''],
            minAllowedQuantity: [''],
            mandatory: [false, fesm2015_forms["z" /* Validators */].required],
            values: [this.fb.array([])],
            delete: [false],
            checkAllMissing: [false],
            hasStockControl: [false],
            hasCustomizationValueStock: [false],
            quantitative: [false],
            minQuantity: [''],
            maxQuantity: [''],
            maxQuantityOptions: ['']
        });
        const radioOptions = [
            { label: 'Sim', value: true },
            { label: 'Não', value: false }
        ];
        this.mandatoryOptions = radioOptions.slice(0);
        this.multiSelectableOptions = radioOptions.slice(0);
        this.subProductOptions = radioOptions.slice(0);
        this.fractionatedSubProductOptions = radioOptions.slice(0);
    }
    loadFormData() {
        return tslib["__awaiter"](this, void 0, void 0, function* () {
            this.hasStockControl = this.authService.loggedUser.controleEstoque > controle_estoque["a" /* CONTROLE_DE_ESTOQUE */].SEM_CONTROLE.id;
            if (this.hasStockControl) {
                this.hasCustomizationValueStock = yield this.companyService.getCompanyConfig('config-estoque-personalizacoes')
                    .toPromise().then(config => config.valor === '1');
                this.form.get('hasStockControl').setValue(this.hasCustomizationValueStock);
            }
            const id = +this.activeRoute.snapshot.params.id || null;
            this.isEditing = id && id > 0;
            this.customizationService.companyId = this.authService.loggedUser.id;
            if (this.isEditing) {
                this.customizationService.get(id).subscribe(customization => {
                    if (null_util["a" /* NullUtil */].isNull(customization)) {
                        this.redirectWhenInvalid('Opcional por Categoria');
                        return;
                    }
                    this.populateForm(customization);
                }, (resp) => {
                    this.requestService.handleError(resp, this.toastrService);
                });
            }
            else {
                if (this.navExtrasService.getExtras() && this.navExtrasService.getExtras().length > 0) {
                    const customizationId = this.navExtrasService.getExtras()[0];
                    yield this.customizationService.getAsync(customizationId).then((customization) => {
                        customization.id = null;
                        customization.valoresDaPersonalizacao.forEach(valor => valor.id = null);
                        if (customization.subProduto) {
                            customization.valoresDaPersonalizacao = [];
                        }
                        this.populateForm(customization);
                        this.navExtrasService.resetExtras();
                    });
                }
            }
            this.feedbackMessage = this.messagesService.getMessage(!this.isEditing ? 'MSG.SUCESSO.019' : 'MSG.SUCESSO.021', ['Opcional por Categoria']);
        });
    }
    onTabChange(event) {
        this.activeTab = event.tabId;
    }
    showFeedback() { }
    submit() {
        form_util["a" /* FormUtil */].validateAllFormFields(this.form);
        if (this.form.invalid) {
            if (this.form.get('description').invalid || this.form.get('categoryId').invalid) {
                this.activeTab = 'infos-basicas';
            }
            return;
        }
        form_util["a" /* FormUtil */].trimAll(this.form);
        if (this.values.controls.length === 0) {
            this.toastrService.warning(this.messagesService.getMessage('MSG.ERRO.046'));
            this.activeTab = 'valores';
            return;
        }
        if (null_util["a" /* NullUtil */].isNull(this.category)) {
            this.toastrService.warning(this.messagesService.getMessage('MSG.ERRO.124', ['Categoria']));
            this.categoryField.setErrors({ invalidValue: true });
            this.categoryField.markAsDirty({ onlySelf: true });
            this.form.updateValueAndValidity();
            return;
        }
        if (!string_util["a" /* StringUtil */].isBlank(this.nextCustomizationField.value) && null_util["a" /* NullUtil */].isNull(this.nextCustomization)) {
            this.toastrService.warning(this.messagesService.getMessage('MSG.ERRO.124', ['Próximo Opcional']));
            this.nextCustomizationField.setErrors({ invalidValue: true });
            this.categoryField.markAsDirty({ onlySelf: true });
            this.form.updateValueAndValidity();
            return;
        }
        form_util["a" /* FormUtil */].trimAll(this.form);
        const customization = this.populateCustomization();
        this.loadState();
        if (!this.isEditing) {
            this.customizationService.create(customization).subscribe(() => {
                this.alertService.success(this.feedbackMessage, result => {
                    if (result.value) {
                        this.back();
                    }
                });
            }, (resp) => {
                this.loadState();
                this.requestService.handleError(resp, this.toastrService);
            });
        }
        else {
            this.customizationService.update(customization).subscribe(() => {
                this.alertService.success(this.feedbackMessage, result => {
                    if (result.value) {
                        this.back();
                    }
                });
            }, (resp) => {
                this.loadState();
                this.requestService.handleError(resp, this.toastrService);
            });
        }
    }
    updateCategory(category) {
        this.category = category;
        this.form.patchValue({
            categoryId: +category.value,
            category: category.label
        });
    }
    updateFractionatedSubProduct(confirm) {
        this.confirmChangeFractionatedSubProduct = confirm;
    }
    updateConfirmChangeType(confirm) {
        this.confirmChangeType = confirm;
    }
    updateNextCustomization(customization) {
        this.form.patchValue({
            nextCustomizationId: +customization.value,
            nextCustomization: customization.label
        });
    }
    populateCustomization() {
        const customization = new personalizacao_Personalizacao();
        customization.id = this.formData.id || null;
        customization.excluido = this.formData.delete;
        customization.descricao = this.formData.description;
        customization.categoria = customization.categoria = new categoria_do_produto["a" /* CategoriaDoProduto */](+this.category.value);
        customization.proximaPersonalizacaoId = this.nextCustomization ? +this.nextCustomization.value : null;
        customization.obrigatoria = this.formData.mandatory;
        customization.multiOpcional = this.formData.multiSelectable;
        customization.quantidadeMinimaPermitida = this.formData.minAllowedQuantity;
        customization.quantidadePermitida = this.formData.allowedQuantity;
        customization.subProduto = false;
        customization.subProdutoFracionado = false;
        customization.quantitativa = this.formData.quantitative;
        customization.quantidadeMinima = this.formData.minQuantity;
        customization.quantidadeMaxima = this.formData.maxQuantity;
        customization.quantidadeMaximaDeOpcoes = this.formData.maxQuantityOptions;
        customization.valoresDaPersonalizacao = this.populateCustomizationValues();
        return customization;
    }
    populateCustomizationValues() {
        const customizationValues = [];
        this.values.controls.forEach(control => {
            const value = new valor_da_personalizacao["a" /* ValorDaPersonalizacao */]();
            value.id = control.get('id').value || null;
            value.descricao = control.get('description').value;
            value.emFalta = control.get('isMissing').value || false;
            value.personalizacao = new personalizacao_Personalizacao(control.get('customizationId').value || null);
            value.excluido = false;
            value.valor = number_util["a" /* NumberUtil */].parseNumber(control.get('value').value);
            value.estoque = +control.get('stock').value;
            value.estoqueIlimitado = control.get('unlimitedStock').value;
            customizationValues.push(value);
        });
        return customizationValues;
    }
    populateForm(customization) {
        this.form.patchValue({
            id: customization.id || null,
            description: customization.descricao,
            categoryId: customization.categoria ? customization.categoria.id : '',
            category: customization.categoria ? customization.categoria.descricao : '',
            nextCustomizationId: customization.proximaPersonalizacaoId || '',
            nextCustomization: customization.proximaPersonalizacao ? customization.proximaPersonalizacao.descricao : '',
            multiSelectable: customization.multiOpcional,
            allowedQuantity: customization.quantidadePermitida,
            minAllowedQuantity: customization.quantidadeMinimaPermitida,
            mandatory: customization.obrigatoria || false,
            hasStockControl: this.hasStockControl,
            hasCustomizationValueStock: this.hasCustomizationValueStock,
            quantitative: customization.quantitativa || false,
            minQuantity: customization.quantidadeMinima,
            maxQuantity: customization.quantidadeMaxima,
            maxQuantityOptions: customization.quantidadeMaximaDeOpcoes
        });
        this.category = {};
        this.category.value = this.formData.categoryId;
        this.category.label = this.formData.category;
        this.confirmChangeFractionatedSubProduct = customization.subProdutoFracionado;
        if (this.formData.nextCustomizationId) {
            this.nextCustomization = {};
            this.nextCustomization.value = this.formData.nextCustomizationId;
            this.nextCustomization.label = this.formData.nextCustomization;
        }
        array_util["a" /* ArrayUtil */].sortCollection(customization.valoresDaPersonalizacao, 'descricao').forEach(value => {
            this.values.controls.push(this.fb.group({
                id: [value.id || null],
                description: [value.descricao],
                value: [Object(common["D" /* formatNumber */])((value.valor || 0), 'pt-BR', '1.2-2')],
                isMissing: [value.emFalta || false],
                customizationId: [customization.id],
                deleted: [false],
                stock: [value.estoque || 0],
                unlimitedStock: [value.estoqueIlimitado || false]
            }));
        });
    }
}

// EXTERNAL MODULE: ./src/app/shared/services/empresa.service.ts
var empresa_service = __webpack_require__("x715");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category-edit/customization-category-edit.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 



























var styles_CustomizationCategoryEditComponent = [styles];
var RenderType_CustomizationCategoryEditComponent = core["ɵcrt"]({ encapsulation: 0, styles: styles_CustomizationCategoryEditComponent, data: {} });

function View_CustomizationCategoryEditComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], null, null, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](1, 49152, [[2, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_7 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_7); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).isPrimary; var currVal_1 = core["ɵnov"](_v, 1).isSuccess; var currVal_2 = core["ɵnov"](_v, 1).isWarning; var currVal_3 = core["ɵnov"](_v, 1).isDanger; var currVal_4 = core["ɵnov"](_v, 1).isInfo; var currVal_5 = core["ɵnov"](_v, 1).isBasic; var currVal_6 = core["ɵnov"](_v, 1).isControl; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_8 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_8); }); }
function View_CustomizationCategoryEditComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (_co.changeAllowedQuantityValues(_v.context.$implicit.value) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](1, 49152, [[3, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_7 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_7); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).isPrimary; var currVal_1 = core["ɵnov"](_v, 1).isSuccess; var currVal_2 = core["ɵnov"](_v, 1).isWarning; var currVal_3 = core["ɵnov"](_v, 1).isDanger; var currVal_4 = core["ɵnov"](_v, 1).isInfo; var currVal_5 = core["ɵnov"](_v, 1).isBasic; var currVal_6 = core["ɵnov"](_v, 1).isControl; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_8 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_8); }); }
function View_CustomizationCategoryEditComponent_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 167, "form", [["novalidate", ""]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "ngSubmit"], [null, "submit"], [null, "reset"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("submit" === en)) {
        var pd_0 = (core["ɵnov"](_v, 2).onSubmit($event) !== false);
        ad = (pd_0 && ad);
    } if (("reset" === en)) {
        var pd_1 = (core["ɵnov"](_v, 2).onReset() !== false);
        ad = (pd_1 && ad);
    } if (("ngSubmit" === en)) {
        var pd_2 = (_co.submit() !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](1, 16384, null, 0, fesm2015_forms["D" /* ɵangular_packages_forms_forms_z */], [], null, null), core["ɵdid"](2, 540672, null, 0, fesm2015_forms["l" /* FormGroupDirective */], [[8, null], [8, null]], { form: [0, "form"] }, { ngSubmit: "ngSubmit" }), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["l" /* FormGroupDirective */]]), core["ɵdid"](4, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](5, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](6, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 1, "omni-page-title", [["tutorialTag", "produtos-personalizacao-categoria-editar"]], null, null, null, page_title_component_ngfactory["b" /* View_PageTitleComponent_0 */], page_title_component_ngfactory["a" /* RenderType_PageTitleComponent */])), core["ɵdid"](8, 114688, null, 0, page_title_component["a" /* PageTitleComponent */], [fesm2015["Rb" /* NbDialogService */]], { icon: [0, "icon"], tutorial: [1, "tutorial"], tutorialTag: [2, "tutorialTag"], pageTitle: [3, "pageTitle"] }, null), (_l()(), core["ɵeld"](9, 0, null, null, 158, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](10, 0, null, null, 157, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](11, 0, null, null, 156, "omni-form-container", [], null, [[null, "backButtonClick"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("backButtonClick" === en)) {
        var pd_0 = (_co.back() !== false);
        ad = (pd_0 && ad);
    } return ad; }, form_container_component_ngfactory["b" /* View_FormContainerComponent_0 */], form_container_component_ngfactory["a" /* RenderType_FormContainerComponent */])), core["ɵdid"](12, 114688, null, 0, form_container_component["a" /* FormContainerComponent */], [alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */]], { isLoading: [0, "isLoading"], hasYOverflow: [1, "hasYOverflow"] }, { backButtonClick: "backButtonClick" }), (_l()(), core["ɵeld"](13, 0, null, 1, 150, "div", [["class", "form-content"]], null, null, null, null, null)), (_l()(), core["ɵeld"](14, 0, null, null, 149, "nb-tabset", [], [[2, "full-width", null]], [[null, "changeTab"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("changeTab" === en)) {
        var pd_0 = (_co.onTabChange($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["gb" /* View_NbTabsetComponent_0 */], index_ngfactory["J" /* RenderType_NbTabsetComponent */])), core["ɵdid"](15, 1097728, null, 1, fesm2015["Dd" /* NbTabsetComponent */], [router["a" /* ActivatedRoute */], core["ChangeDetectorRef"]], null, { changeTab: "changeTab" }), core["ɵqud"](603979776, 1, { tabs: 1 }), (_l()(), core["ɵeld"](17, 0, null, 0, 142, "nb-tab", [["responsive", ""], ["tabIcon", "info"], ["tabId", "infos-basicas"], ["tabTitle", "Info. B\u00E1sicas"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](18, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](19, 0, null, 0, 22, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](20, 0, null, null, 11, "div", [["class", "form-group col-12 col-sm-12 col-md-6"]], null, null, null, null, null)), (_l()(), core["ɵeld"](21, 0, null, null, 10, "omni-field", [["field", "description"], ["label", "Descri\u00E7\u00E3o"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](22, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"], validOnSubmit: [4, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](23, 0, null, 0, 8, "input", [["formControlName", "description"], ["fullWidth", ""], ["maxlength", "150"], ["name", "description"], ["nbInput", ""], ["placeholder", "Informe a descri\u00E7\u00E3o do opcional"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 24)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 24).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 24)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 24)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](24, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](25, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](28, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](30, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](31, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](32, 0, null, null, 9, "div", [["class", "form-group col-12 col-sm-12 col-md-6"]], null, null, null, null, null)), (_l()(), core["ɵeld"](33, 0, null, null, 8, "omni-field", [["field", "categoryId"], ["label", "Categoria"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](34, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"], validOnSubmit: [4, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](35, 0, null, 0, 6, "omni-typeahead", [["ngDefaultControl", ""], ["placeholder", "Informe a descri\u00E7\u00E3o da categoria para pesquisar..."]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "valueChange"], [null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 36)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 36).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 36)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 36)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } if (("valueChange" === en)) {
        var pd_4 = ((_co.category = $event) !== false);
        ad = (pd_4 && ad);
    } return ad; }, typeahead_component_ngfactory["b" /* View_TypeaheadComponent_0 */], typeahead_component_ngfactory["a" /* RenderType_TypeaheadComponent */])), core["ɵdid"](36, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](38, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](40, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](41, 114688, null, 0, typeahead_component["a" /* TypeaheadComponent */], [auth_service["a" /* AuthService */], autocomplete_service["a" /* AutoCompleteService */]], { form: [0, "form"], formControl: [1, "formControl"], entityType: [2, "entityType"], isLoading: [3, "isLoading"], placeholder: [4, "placeholder"], value: [5, "value"] }, { valueChange: "valueChange" }), (_l()(), core["ɵeld"](42, 0, null, 0, 22, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](43, 0, null, null, 9, "div", [["class", "form-group col-12 col-sm-12 col-md-6"]], null, null, null, null, null)), (_l()(), core["ɵeld"](44, 0, null, null, 8, "omni-field", [["field", "nextCustomizationId"], ["label", "Pr\u00F3ximo Opcional"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](45, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { disabled: [0, "disabled"], field: [1, "field"], form: [2, "form"], label: [3, "label"] }, null), (_l()(), core["ɵeld"](46, 0, null, 0, 6, "omni-typeahead", [["ngDefaultControl", ""], ["placeholder", "Informe o pr\u00F3ximo opcional para pesquisar..."]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "valueChange"], [null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 47)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 47).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 47)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 47)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } if (("valueChange" === en)) {
        var pd_4 = ((_co.nextCustomization = $event) !== false);
        ad = (pd_4 && ad);
    } return ad; }, typeahead_component_ngfactory["b" /* View_TypeaheadComponent_0 */], typeahead_component_ngfactory["a" /* RenderType_TypeaheadComponent */])), core["ɵdid"](47, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](49, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](51, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](52, 114688, null, 0, typeahead_component["a" /* TypeaheadComponent */], [auth_service["a" /* AuthService */], autocomplete_service["a" /* AutoCompleteService */]], { form: [0, "form"], formControl: [1, "formControl"], disabled: [2, "disabled"], entityType: [3, "entityType"], extraParam: [4, "extraParam"], isLoading: [5, "isLoading"], placeholder: [6, "placeholder"], value: [7, "value"] }, { valueChange: "valueChange" }), (_l()(), core["ɵeld"](53, 0, null, null, 11, "div", [["class", "form-group col-12 col-sm-6 col-md-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](54, 0, null, null, 10, "omni-field", [["endLabelChar", "?"], ["field", "mandatory"], ["label", "A sele\u00E7\u00E3o do opcional \u00E9 obrigat\u00F3ria"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](55, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], endLabelChar: [3, "endLabelChar"], required: [4, "required"], validOnSubmit: [5, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](56, 0, null, 0, 8, "nb-radio-group", [["class", "d-flex flex-row"], ["formControlName", "mandatory"], ["name", "mandatory-group"], ["status", "primary"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["cb" /* View_NbRadioGroupComponent_0 */], index_ngfactory["F" /* RenderType_NbRadioGroupComponent */])), core["ɵdid"](57, 1228800, null, 1, fesm2015["Uc" /* NbRadioGroupComponent */], [core["ElementRef"], core["PLATFORM_ID"], fesm2015["g" /* NB_DOCUMENT */]], { name: [0, "name"], disabled: [1, "disabled"], status: [2, "status"] }, null), core["ɵqud"](603979776, 2, { radios: 1 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Uc" /* NbRadioGroupComponent */]]), core["ɵdid"](60, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](62, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_CustomizationCategoryEditComponent_1)), core["ɵdid"](64, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](65, 0, null, 0, 38, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](66, 0, null, null, 11, "div", [["class", "form-group col-12 col-sm-6 col-md-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](67, 0, null, null, 10, "omni-field", [["endLabelChar", "?"], ["field", "multiSelectable"], ["label", "Permite selecionar mais de uma op\u00E7\u00E3o"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](68, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], endLabelChar: [3, "endLabelChar"], required: [4, "required"], validOnSubmit: [5, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](69, 0, null, 0, 8, "nb-radio-group", [["class", "d-flex flex-row"], ["formControlName", "multiSelectable"], ["name", "multiselectable-group"], ["status", "primary"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["cb" /* View_NbRadioGroupComponent_0 */], index_ngfactory["F" /* RenderType_NbRadioGroupComponent */])), core["ɵdid"](70, 1228800, null, 1, fesm2015["Uc" /* NbRadioGroupComponent */], [core["ElementRef"], core["PLATFORM_ID"], fesm2015["g" /* NB_DOCUMENT */]], { name: [0, "name"], disabled: [1, "disabled"], status: [2, "status"] }, null), core["ɵqud"](603979776, 3, { radios: 1 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Uc" /* NbRadioGroupComponent */]]), core["ɵdid"](73, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](75, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_CustomizationCategoryEditComponent_2)), core["ɵdid"](77, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](78, 0, null, null, 12, "div", [["class", "form-group col-sm-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](79, 0, null, null, 11, "omni-field", [["field", "minAllowedQuantity"], ["label", "Permite selecionar no m\u00EDnimo"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](80, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { disabled: [0, "disabled"], field: [1, "field"], form: [2, "form"], label: [3, "label"], validOnSubmit: [4, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](81, 0, null, 0, 9, "input", [["fullWidth", ""], ["maxlength", "3"], ["nbInput", ""], ["omniInputInteger", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 82).onInput($event.target) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 82).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 83)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 83).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 83)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 83)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](82, 16384, null, 0, input_integer_directive["a" /* InputIntegerDirective */], [core["ElementRef"]], null, null), core["ɵdid"](83, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](84, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](87, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](89, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](90, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](91, 0, null, null, 12, "div", [["class", "form-group col-sm-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](92, 0, null, null, 11, "omni-field", [["field", "allowedQuantity"], ["label", "Permite selecionar at\u00E9"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](93, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { disabled: [0, "disabled"], field: [1, "field"], form: [2, "form"], label: [3, "label"], validOnSubmit: [4, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](94, 0, null, 0, 9, "input", [["fullWidth", ""], ["maxlength", "3"], ["nbInput", ""], ["omniInputInteger", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 95).onInput($event.target) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 95).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 96)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 96).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 96)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 96)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](95, 16384, null, 0, input_integer_directive["a" /* InputIntegerDirective */], [core["ElementRef"]], null, null), core["ɵdid"](96, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](97, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](100, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](102, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](103, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](104, 0, null, 0, 55, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](105, 0, null, null, 15, "div", [["class", "col-12 col-sm-6 col-md-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](106, 0, null, null, 14, "omni-field", [["endLabelChar", "?"], ["field", "quantitative"], ["label", "O Opcional \u00E9 quantitativo"], ["tooltipText", "Permite o cliente adicionar um item do opcional mais de uma vez."]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](107, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], endLabelChar: [3, "endLabelChar"], required: [4, "required"], showTooltip: [5, "showTooltip"], tooltipText: [6, "tooltipText"], validOnSubmit: [7, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](108, 0, null, 0, 12, "nb-radio-group", [["class", "d-flex flex-row"], ["formControlName", "quantitative"], ["name", "quantitative-group"], ["status", "primary"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["cb" /* View_NbRadioGroupComponent_0 */], index_ngfactory["F" /* RenderType_NbRadioGroupComponent */])), core["ɵdid"](109, 1228800, null, 1, fesm2015["Uc" /* NbRadioGroupComponent */], [core["ElementRef"], core["PLATFORM_ID"], fesm2015["g" /* NB_DOCUMENT */]], { name: [0, "name"], disabled: [1, "disabled"], status: [2, "status"] }, null), core["ɵqud"](603979776, 4, { radios: 1 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Uc" /* NbRadioGroupComponent */]]), core["ɵdid"](112, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"], isDisabled: [1, "isDisabled"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](114, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](115, 0, null, 0, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (_co.changeQuantityValues(true) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](116, 49152, [[4, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](-1, 0, [" Sim "])), (_l()(), core["ɵeld"](118, 0, null, 0, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (_co.changeQuantityValues(false) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](119, 49152, [[4, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](-1, 0, [" N\u00E3o "])), (_l()(), core["ɵeld"](121, 0, null, null, 12, "div", [["class", "form-group col-sm-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](122, 0, null, null, 11, "omni-field", [["field", "minQuantity"], ["label", "Quantidade m\u00EDnima"], ["tooltipText", "\n                                            A quantidade m\u00EDnima de itens que poder\u00E1 ser adicionado por op\u00E7\u00E3o do opcional.\n                                            Caso n\u00E3o informado, a quantidade m\u00EDnima n\u00E3o obrigar\u00E1 a sele\u00E7\u00E3o de op\u00E7\u00F5es do adicional.\n                                        "]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](123, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { disabled: [0, "disabled"], field: [1, "field"], form: [2, "form"], label: [3, "label"], showTooltip: [4, "showTooltip"], tooltipText: [5, "tooltipText"], validOnSubmit: [6, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](124, 0, null, 0, 9, "input", [["fullWidth", ""], ["maxlength", "3"], ["nbInput", ""], ["omniInputInteger", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 125).onInput($event.target) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 125).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 126)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 126).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 126)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 126)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](125, 16384, null, 0, input_integer_directive["a" /* InputIntegerDirective */], [core["ElementRef"]], null, null), core["ɵdid"](126, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](127, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](130, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](132, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](133, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](134, 0, null, null, 12, "div", [["class", "form-group col-sm-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](135, 0, null, null, 11, "omni-field", [["field", "maxQuantity"], ["label", "Quantidade m\u00E1xima"], ["tooltipText", "\n                                            Quantidade m\u00E1xima de itens que poder\u00E1 ser adicionado por op\u00E7\u00E3o do opcional.\n                                            Caso n\u00E3o informado, a quantidade m\u00E1xima n\u00E3o seja informada.\n                                        "]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](136, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { disabled: [0, "disabled"], field: [1, "field"], form: [2, "form"], label: [3, "label"], showTooltip: [4, "showTooltip"], tooltipText: [5, "tooltipText"], validOnSubmit: [6, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](137, 0, null, 0, 9, "input", [["fullWidth", ""], ["maxlength", "3"], ["nbInput", ""], ["omniInputInteger", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 138).onInput($event.target) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 138).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 139)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 139).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 139)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 139)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](138, 16384, null, 0, input_integer_directive["a" /* InputIntegerDirective */], [core["ElementRef"]], null, null), core["ɵdid"](139, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](140, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](143, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](145, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](146, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](147, 0, null, null, 12, "div", [["class", "form-group col-sm-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](148, 0, null, null, 11, "omni-field", [["field", "maxQuantityOptions"], ["label", "Limite de op\u00E7\u00F5es"], ["tooltipText", "\n                                            Informa at\u00E9 quantas op\u00E7\u00F5es do opcional o cliente poder\u00E1 incluir no item do pedido.\n                                            Ser\u00E1 ilimitado caso n\u00E3o seja informado.\n                                        "]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](149, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { disabled: [0, "disabled"], field: [1, "field"], form: [2, "form"], label: [3, "label"], showTooltip: [4, "showTooltip"], tooltipText: [5, "tooltipText"], validOnSubmit: [6, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](150, 0, null, 0, 9, "input", [["fullWidth", ""], ["maxlength", "3"], ["nbInput", ""], ["omniInputInteger", ""], ["placeholder", "0"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 151).onInput($event.target) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 151).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 152)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 152).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 152)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 152)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](151, 16384, null, 0, input_integer_directive["a" /* InputIntegerDirective */], [core["ElementRef"]], null, null), core["ɵdid"](152, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](153, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](156, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](158, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](159, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), (_l()(), core["ɵeld"](160, 0, null, 0, 3, "nb-tab", [["responsive", ""], ["tabIcon", "list"], ["tabId", "valores"], ["tabTitle", "Op\u00E7\u00F5es"]], [[2, "disabled", null], [2, "content-active", null]], null, null, index_ngfactory["fb" /* View_NbTabComponent_0 */], index_ngfactory["I" /* RenderType_NbTabComponent */])), core["ɵdid"](161, 49152, [[1, 4]], 0, fesm2015["Ad" /* NbTabComponent */], [], { tabTitle: [0, "tabTitle"], tabId: [1, "tabId"], tabIcon: [2, "tabIcon"], responsive: [3, "responsive"], active: [4, "active"] }, null), (_l()(), core["ɵeld"](162, 0, null, 0, 1, "omni-customization-value-form", [], null, [[null, "formChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("formChange" === en)) {
        var pd_0 = ((_co.form = $event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, customization_value_form_component_ngfactory["b" /* View_CustomizationValueFormComponent_0 */], customization_value_form_component_ngfactory["a" /* RenderType_CustomizationValueFormComponent */])), core["ɵdid"](163, 49152, null, 0, customization_value_form_component["a" /* CustomizationValueFormComponent */], [fesm2015_forms["g" /* FormBuilder */], fesm2015["Rb" /* NbDialogService */], messages_service["a" /* MessagesService */], fesm2015["Ld" /* NbToastrService */]], { form: [0, "form"] }, { formChange: "formChange" }), (_l()(), core["ɵeld"](164, 0, null, 3, 3, "div", [["class", "form-footer"]], null, null, null, null, null)), (_l()(), core["ɵeld"](165, 0, null, null, 2, "button", [["nbButton", ""], ["status", "success"], ["type", "submit"]], [[1, "disabled", 0], [2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 166).onClick($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](166, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"] }, null), (_l()(), core["ɵted"](167, 0, [" ", " "]))], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.form; _ck(_v, 2, 0, currVal_7); var currVal_8 = _co.layerIcon; var currVal_9 = true; var currVal_10 = "produtos-personalizacao-categoria-editar"; var currVal_11 = core["ɵinlineInterpolate"](1, "", (_co.isEditing ? "Editar" : "Novo"), " Opcional por Categoria"); _ck(_v, 8, 0, currVal_8, currVal_9, currVal_10, currVal_11); var currVal_12 = _co.isLoading; var currVal_13 = false; _ck(_v, 12, 0, currVal_12, currVal_13); var currVal_17 = "Info. B\u00E1sicas"; var currVal_18 = "infos-basicas"; var currVal_19 = "info"; var currVal_20 = ""; var currVal_21 = (_co.activeTab === "infos-basicas"); _ck(_v, 18, 0, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21); var currVal_22 = "description"; var currVal_23 = _co.form; var currVal_24 = "Descri\u00E7\u00E3o"; var currVal_25 = true; var currVal_26 = true; _ck(_v, 22, 0, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26); var currVal_52 = "150"; _ck(_v, 25, 0, currVal_52); var currVal_53 = "description"; _ck(_v, 28, 0, currVal_53); var currVal_54 = "primary"; var currVal_55 = ""; _ck(_v, 31, 0, currVal_54, currVal_55); var currVal_56 = "categoryId"; var currVal_57 = _co.form; var currVal_58 = "Categoria"; var currVal_59 = true; var currVal_60 = true; _ck(_v, 34, 0, currVal_56, currVal_57, currVal_58, currVal_59, currVal_60); var currVal_68 = _co.categoryField; _ck(_v, 38, 0, currVal_68); var currVal_69 = _co.form; var currVal_70 = _co.categoryField; var currVal_71 = _co.categoryEntity; var currVal_72 = _co.isLoading; var currVal_73 = "Informe a descri\u00E7\u00E3o da categoria para pesquisar..."; var currVal_74 = _co.category; _ck(_v, 41, 0, currVal_69, currVal_70, currVal_71, currVal_72, currVal_73, currVal_74); var currVal_75 = !_co.hasSelectedCategory; var currVal_76 = "nextCustomizationId"; var currVal_77 = _co.form; var currVal_78 = "Pr\u00F3ximo Opcional"; _ck(_v, 45, 0, currVal_75, currVal_76, currVal_77, currVal_78); var currVal_86 = _co.nextCustomizationField; var currVal_87 = !_co.hasSelectedCategory; _ck(_v, 49, 0, currVal_86, currVal_87); var currVal_88 = _co.form; var currVal_89 = _co.nextCustomizationField; var currVal_90 = !_co.hasSelectedCategory; var currVal_91 = _co.nextCustomizationEntity; var currVal_92 = ((_co.category == null) ? null : _co.category.value); var currVal_93 = _co.isLoading; var currVal_94 = "Informe o pr\u00F3ximo opcional para pesquisar..."; var currVal_95 = _co.nextCustomization; _ck(_v, 52, 0, currVal_88, currVal_89, currVal_90, currVal_91, currVal_92, currVal_93, currVal_94, currVal_95); var currVal_96 = "mandatory"; var currVal_97 = _co.form; var currVal_98 = "A sele\u00E7\u00E3o do opcional \u00E9 obrigat\u00F3ria"; var currVal_99 = "?"; var currVal_100 = true; var currVal_101 = true; _ck(_v, 55, 0, currVal_96, currVal_97, currVal_98, currVal_99, currVal_100, currVal_101); var currVal_109 = "mandatory-group"; var currVal_110 = _co.isLoading; var currVal_111 = "primary"; _ck(_v, 57, 0, currVal_109, currVal_110, currVal_111); var currVal_112 = "mandatory"; var currVal_113 = _co.isLoading; _ck(_v, 60, 0, currVal_112, currVal_113); var currVal_114 = _co.mandatoryOptions; _ck(_v, 64, 0, currVal_114); var currVal_115 = "multiSelectable"; var currVal_116 = _co.form; var currVal_117 = "Permite selecionar mais de uma op\u00E7\u00E3o"; var currVal_118 = "?"; var currVal_119 = true; var currVal_120 = true; _ck(_v, 68, 0, currVal_115, currVal_116, currVal_117, currVal_118, currVal_119, currVal_120); var currVal_128 = "multiselectable-group"; var currVal_129 = _co.isLoading; var currVal_130 = "primary"; _ck(_v, 70, 0, currVal_128, currVal_129, currVal_130); var currVal_131 = "multiSelectable"; var currVal_132 = _co.isLoading; _ck(_v, 73, 0, currVal_131, currVal_132); var currVal_133 = _co.multiSelectableOptions; _ck(_v, 77, 0, currVal_133); var currVal_134 = !_co.isMultiSelectable; var currVal_135 = "minAllowedQuantity"; var currVal_136 = _co.form; var currVal_137 = "Permite selecionar no m\u00EDnimo"; var currVal_138 = true; _ck(_v, 80, 0, currVal_134, currVal_135, currVal_136, currVal_137, currVal_138); var currVal_165 = "3"; _ck(_v, 84, 0, currVal_165); var currVal_166 = _co.form.get("minAllowedQuantity"); _ck(_v, 87, 0, currVal_166); var currVal_167 = "primary"; var currVal_168 = ""; _ck(_v, 90, 0, currVal_167, currVal_168); var currVal_169 = !_co.isMultiSelectable; var currVal_170 = "allowedQuantity"; var currVal_171 = _co.form; var currVal_172 = "Permite selecionar at\u00E9"; var currVal_173 = true; _ck(_v, 93, 0, currVal_169, currVal_170, currVal_171, currVal_172, currVal_173); var currVal_200 = "3"; _ck(_v, 97, 0, currVal_200); var currVal_201 = _co.form.get("allowedQuantity"); _ck(_v, 100, 0, currVal_201); var currVal_202 = "primary"; var currVal_203 = ""; _ck(_v, 103, 0, currVal_202, currVal_203); var currVal_204 = "quantitative"; var currVal_205 = _co.form; var currVal_206 = "O Opcional \u00E9 quantitativo"; var currVal_207 = "?"; var currVal_208 = true; var currVal_209 = true; var currVal_210 = "Permite o cliente adicionar um item do opcional mais de uma vez."; var currVal_211 = true; _ck(_v, 107, 0, currVal_204, currVal_205, currVal_206, currVal_207, currVal_208, currVal_209, currVal_210, currVal_211); var currVal_219 = "quantitative-group"; var currVal_220 = _co.isLoading; var currVal_221 = "primary"; _ck(_v, 109, 0, currVal_219, currVal_220, currVal_221); var currVal_222 = "quantitative"; var currVal_223 = _co.isLoading; _ck(_v, 112, 0, currVal_222, currVal_223); var currVal_231 = true; _ck(_v, 116, 0, currVal_231); var currVal_239 = false; _ck(_v, 119, 0, currVal_239); var currVal_240 = !_co.formData.quantitative; var currVal_241 = "minQuantity"; var currVal_242 = _co.form; var currVal_243 = "Quantidade m\u00EDnima"; var currVal_244 = true; var currVal_245 = "\n                                            A quantidade m\u00EDnima de itens que poder\u00E1 ser adicionado por op\u00E7\u00E3o do opcional.\n                                            Caso n\u00E3o informado, a quantidade m\u00EDnima n\u00E3o obrigar\u00E1 a sele\u00E7\u00E3o de op\u00E7\u00F5es do adicional.\n                                        "; var currVal_246 = true; _ck(_v, 123, 0, currVal_240, currVal_241, currVal_242, currVal_243, currVal_244, currVal_245, currVal_246); var currVal_272 = "3"; _ck(_v, 127, 0, currVal_272); var currVal_273 = _co.form.get("minQuantity"); _ck(_v, 130, 0, currVal_273); var currVal_274 = "primary"; var currVal_275 = ""; _ck(_v, 133, 0, currVal_274, currVal_275); var currVal_276 = !_co.formData.quantitative; var currVal_277 = "maxQuantity"; var currVal_278 = _co.form; var currVal_279 = "Quantidade m\u00E1xima"; var currVal_280 = true; var currVal_281 = "\n                                            Quantidade m\u00E1xima de itens que poder\u00E1 ser adicionado por op\u00E7\u00E3o do opcional.\n                                            Caso n\u00E3o informado, a quantidade m\u00E1xima n\u00E3o seja informada.\n                                        "; var currVal_282 = true; _ck(_v, 136, 0, currVal_276, currVal_277, currVal_278, currVal_279, currVal_280, currVal_281, currVal_282); var currVal_308 = "3"; _ck(_v, 140, 0, currVal_308); var currVal_309 = _co.form.get("maxQuantity"); _ck(_v, 143, 0, currVal_309); var currVal_310 = "primary"; var currVal_311 = ""; _ck(_v, 146, 0, currVal_310, currVal_311); var currVal_312 = !_co.formData.quantitative; var currVal_313 = "maxQuantityOptions"; var currVal_314 = _co.form; var currVal_315 = "Limite de op\u00E7\u00F5es"; var currVal_316 = true; var currVal_317 = "\n                                            Informa at\u00E9 quantas op\u00E7\u00F5es do opcional o cliente poder\u00E1 incluir no item do pedido.\n                                            Ser\u00E1 ilimitado caso n\u00E3o seja informado.\n                                        "; var currVal_318 = true; _ck(_v, 149, 0, currVal_312, currVal_313, currVal_314, currVal_315, currVal_316, currVal_317, currVal_318); var currVal_344 = "3"; _ck(_v, 153, 0, currVal_344); var currVal_345 = _co.form.get("maxQuantityOptions"); _ck(_v, 156, 0, currVal_345); var currVal_346 = "primary"; var currVal_347 = ""; _ck(_v, 159, 0, currVal_346, currVal_347); var currVal_350 = "Op\u00E7\u00F5es"; var currVal_351 = "valores"; var currVal_352 = "list"; var currVal_353 = ""; var currVal_354 = (_co.activeTab === "valores"); _ck(_v, 161, 0, currVal_350, currVal_351, currVal_352, currVal_353, currVal_354); var currVal_355 = _co.form; _ck(_v, 163, 0, currVal_355); var currVal_383 = "success"; _ck(_v, 166, 0, currVal_383); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 4).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 4).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 4).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 4).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 4).ngClassValid; var currVal_5 = core["ɵnov"](_v, 4).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 4).ngClassPending; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_14 = core["ɵnov"](_v, 15).fullWidthValue; _ck(_v, 14, 0, currVal_14); var currVal_15 = core["ɵnov"](_v, 18).disabled; var currVal_16 = core["ɵnov"](_v, 18).activeValue; _ck(_v, 17, 0, currVal_15, currVal_16); var currVal_27 = (_co.isLoading ? true : null); var currVal_28 = (core["ɵnov"](_v, 25).maxlength ? core["ɵnov"](_v, 25).maxlength : null); var currVal_29 = core["ɵnov"](_v, 30).ngClassUntouched; var currVal_30 = core["ɵnov"](_v, 30).ngClassTouched; var currVal_31 = core["ɵnov"](_v, 30).ngClassPristine; var currVal_32 = core["ɵnov"](_v, 30).ngClassDirty; var currVal_33 = core["ɵnov"](_v, 30).ngClassValid; var currVal_34 = core["ɵnov"](_v, 30).ngClassInvalid; var currVal_35 = core["ɵnov"](_v, 30).ngClassPending; var currVal_36 = core["ɵnov"](_v, 31).fullWidth; var currVal_37 = core["ɵnov"](_v, 31).tiny; var currVal_38 = core["ɵnov"](_v, 31).small; var currVal_39 = core["ɵnov"](_v, 31).medium; var currVal_40 = core["ɵnov"](_v, 31).large; var currVal_41 = core["ɵnov"](_v, 31).giant; var currVal_42 = core["ɵnov"](_v, 31).primary; var currVal_43 = core["ɵnov"](_v, 31).info; var currVal_44 = core["ɵnov"](_v, 31).success; var currVal_45 = core["ɵnov"](_v, 31).warning; var currVal_46 = core["ɵnov"](_v, 31).danger; var currVal_47 = core["ɵnov"](_v, 31).basic; var currVal_48 = core["ɵnov"](_v, 31).control; var currVal_49 = core["ɵnov"](_v, 31).rectangle; var currVal_50 = core["ɵnov"](_v, 31).semiRound; var currVal_51 = core["ɵnov"](_v, 31).round; _ck(_v, 23, 1, [currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34, currVal_35, currVal_36, currVal_37, currVal_38, currVal_39, currVal_40, currVal_41, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51]); var currVal_61 = core["ɵnov"](_v, 40).ngClassUntouched; var currVal_62 = core["ɵnov"](_v, 40).ngClassTouched; var currVal_63 = core["ɵnov"](_v, 40).ngClassPristine; var currVal_64 = core["ɵnov"](_v, 40).ngClassDirty; var currVal_65 = core["ɵnov"](_v, 40).ngClassValid; var currVal_66 = core["ɵnov"](_v, 40).ngClassInvalid; var currVal_67 = core["ɵnov"](_v, 40).ngClassPending; _ck(_v, 35, 0, currVal_61, currVal_62, currVal_63, currVal_64, currVal_65, currVal_66, currVal_67); var currVal_79 = core["ɵnov"](_v, 51).ngClassUntouched; var currVal_80 = core["ɵnov"](_v, 51).ngClassTouched; var currVal_81 = core["ɵnov"](_v, 51).ngClassPristine; var currVal_82 = core["ɵnov"](_v, 51).ngClassDirty; var currVal_83 = core["ɵnov"](_v, 51).ngClassValid; var currVal_84 = core["ɵnov"](_v, 51).ngClassInvalid; var currVal_85 = core["ɵnov"](_v, 51).ngClassPending; _ck(_v, 46, 0, currVal_79, currVal_80, currVal_81, currVal_82, currVal_83, currVal_84, currVal_85); var currVal_102 = core["ɵnov"](_v, 62).ngClassUntouched; var currVal_103 = core["ɵnov"](_v, 62).ngClassTouched; var currVal_104 = core["ɵnov"](_v, 62).ngClassPristine; var currVal_105 = core["ɵnov"](_v, 62).ngClassDirty; var currVal_106 = core["ɵnov"](_v, 62).ngClassValid; var currVal_107 = core["ɵnov"](_v, 62).ngClassInvalid; var currVal_108 = core["ɵnov"](_v, 62).ngClassPending; _ck(_v, 56, 0, currVal_102, currVal_103, currVal_104, currVal_105, currVal_106, currVal_107, currVal_108); var currVal_121 = core["ɵnov"](_v, 75).ngClassUntouched; var currVal_122 = core["ɵnov"](_v, 75).ngClassTouched; var currVal_123 = core["ɵnov"](_v, 75).ngClassPristine; var currVal_124 = core["ɵnov"](_v, 75).ngClassDirty; var currVal_125 = core["ɵnov"](_v, 75).ngClassValid; var currVal_126 = core["ɵnov"](_v, 75).ngClassInvalid; var currVal_127 = core["ɵnov"](_v, 75).ngClassPending; _ck(_v, 69, 0, currVal_121, currVal_122, currVal_123, currVal_124, currVal_125, currVal_126, currVal_127); var currVal_139 = (!_co.isMultiSelectable ? true : null); var currVal_140 = (_co.isLoading ? true : null); var currVal_141 = (core["ɵnov"](_v, 84).maxlength ? core["ɵnov"](_v, 84).maxlength : null); var currVal_142 = core["ɵnov"](_v, 89).ngClassUntouched; var currVal_143 = core["ɵnov"](_v, 89).ngClassTouched; var currVal_144 = core["ɵnov"](_v, 89).ngClassPristine; var currVal_145 = core["ɵnov"](_v, 89).ngClassDirty; var currVal_146 = core["ɵnov"](_v, 89).ngClassValid; var currVal_147 = core["ɵnov"](_v, 89).ngClassInvalid; var currVal_148 = core["ɵnov"](_v, 89).ngClassPending; var currVal_149 = core["ɵnov"](_v, 90).fullWidth; var currVal_150 = core["ɵnov"](_v, 90).tiny; var currVal_151 = core["ɵnov"](_v, 90).small; var currVal_152 = core["ɵnov"](_v, 90).medium; var currVal_153 = core["ɵnov"](_v, 90).large; var currVal_154 = core["ɵnov"](_v, 90).giant; var currVal_155 = core["ɵnov"](_v, 90).primary; var currVal_156 = core["ɵnov"](_v, 90).info; var currVal_157 = core["ɵnov"](_v, 90).success; var currVal_158 = core["ɵnov"](_v, 90).warning; var currVal_159 = core["ɵnov"](_v, 90).danger; var currVal_160 = core["ɵnov"](_v, 90).basic; var currVal_161 = core["ɵnov"](_v, 90).control; var currVal_162 = core["ɵnov"](_v, 90).rectangle; var currVal_163 = core["ɵnov"](_v, 90).semiRound; var currVal_164 = core["ɵnov"](_v, 90).round; _ck(_v, 81, 1, [currVal_139, currVal_140, currVal_141, currVal_142, currVal_143, currVal_144, currVal_145, currVal_146, currVal_147, currVal_148, currVal_149, currVal_150, currVal_151, currVal_152, currVal_153, currVal_154, currVal_155, currVal_156, currVal_157, currVal_158, currVal_159, currVal_160, currVal_161, currVal_162, currVal_163, currVal_164]); var currVal_174 = (!_co.isMultiSelectable ? true : null); var currVal_175 = (_co.isLoading ? true : null); var currVal_176 = (core["ɵnov"](_v, 97).maxlength ? core["ɵnov"](_v, 97).maxlength : null); var currVal_177 = core["ɵnov"](_v, 102).ngClassUntouched; var currVal_178 = core["ɵnov"](_v, 102).ngClassTouched; var currVal_179 = core["ɵnov"](_v, 102).ngClassPristine; var currVal_180 = core["ɵnov"](_v, 102).ngClassDirty; var currVal_181 = core["ɵnov"](_v, 102).ngClassValid; var currVal_182 = core["ɵnov"](_v, 102).ngClassInvalid; var currVal_183 = core["ɵnov"](_v, 102).ngClassPending; var currVal_184 = core["ɵnov"](_v, 103).fullWidth; var currVal_185 = core["ɵnov"](_v, 103).tiny; var currVal_186 = core["ɵnov"](_v, 103).small; var currVal_187 = core["ɵnov"](_v, 103).medium; var currVal_188 = core["ɵnov"](_v, 103).large; var currVal_189 = core["ɵnov"](_v, 103).giant; var currVal_190 = core["ɵnov"](_v, 103).primary; var currVal_191 = core["ɵnov"](_v, 103).info; var currVal_192 = core["ɵnov"](_v, 103).success; var currVal_193 = core["ɵnov"](_v, 103).warning; var currVal_194 = core["ɵnov"](_v, 103).danger; var currVal_195 = core["ɵnov"](_v, 103).basic; var currVal_196 = core["ɵnov"](_v, 103).control; var currVal_197 = core["ɵnov"](_v, 103).rectangle; var currVal_198 = core["ɵnov"](_v, 103).semiRound; var currVal_199 = core["ɵnov"](_v, 103).round; _ck(_v, 94, 1, [currVal_174, currVal_175, currVal_176, currVal_177, currVal_178, currVal_179, currVal_180, currVal_181, currVal_182, currVal_183, currVal_184, currVal_185, currVal_186, currVal_187, currVal_188, currVal_189, currVal_190, currVal_191, currVal_192, currVal_193, currVal_194, currVal_195, currVal_196, currVal_197, currVal_198, currVal_199]); var currVal_212 = core["ɵnov"](_v, 114).ngClassUntouched; var currVal_213 = core["ɵnov"](_v, 114).ngClassTouched; var currVal_214 = core["ɵnov"](_v, 114).ngClassPristine; var currVal_215 = core["ɵnov"](_v, 114).ngClassDirty; var currVal_216 = core["ɵnov"](_v, 114).ngClassValid; var currVal_217 = core["ɵnov"](_v, 114).ngClassInvalid; var currVal_218 = core["ɵnov"](_v, 114).ngClassPending; _ck(_v, 108, 0, currVal_212, currVal_213, currVal_214, currVal_215, currVal_216, currVal_217, currVal_218); var currVal_224 = core["ɵnov"](_v, 116).isPrimary; var currVal_225 = core["ɵnov"](_v, 116).isSuccess; var currVal_226 = core["ɵnov"](_v, 116).isWarning; var currVal_227 = core["ɵnov"](_v, 116).isDanger; var currVal_228 = core["ɵnov"](_v, 116).isInfo; var currVal_229 = core["ɵnov"](_v, 116).isBasic; var currVal_230 = core["ɵnov"](_v, 116).isControl; _ck(_v, 115, 0, currVal_224, currVal_225, currVal_226, currVal_227, currVal_228, currVal_229, currVal_230); var currVal_232 = core["ɵnov"](_v, 119).isPrimary; var currVal_233 = core["ɵnov"](_v, 119).isSuccess; var currVal_234 = core["ɵnov"](_v, 119).isWarning; var currVal_235 = core["ɵnov"](_v, 119).isDanger; var currVal_236 = core["ɵnov"](_v, 119).isInfo; var currVal_237 = core["ɵnov"](_v, 119).isBasic; var currVal_238 = core["ɵnov"](_v, 119).isControl; _ck(_v, 118, 0, currVal_232, currVal_233, currVal_234, currVal_235, currVal_236, currVal_237, currVal_238); var currVal_247 = ((!_co.formData.quantitative || _co.isLoading) ? true : null); var currVal_248 = (core["ɵnov"](_v, 127).maxlength ? core["ɵnov"](_v, 127).maxlength : null); var currVal_249 = core["ɵnov"](_v, 132).ngClassUntouched; var currVal_250 = core["ɵnov"](_v, 132).ngClassTouched; var currVal_251 = core["ɵnov"](_v, 132).ngClassPristine; var currVal_252 = core["ɵnov"](_v, 132).ngClassDirty; var currVal_253 = core["ɵnov"](_v, 132).ngClassValid; var currVal_254 = core["ɵnov"](_v, 132).ngClassInvalid; var currVal_255 = core["ɵnov"](_v, 132).ngClassPending; var currVal_256 = core["ɵnov"](_v, 133).fullWidth; var currVal_257 = core["ɵnov"](_v, 133).tiny; var currVal_258 = core["ɵnov"](_v, 133).small; var currVal_259 = core["ɵnov"](_v, 133).medium; var currVal_260 = core["ɵnov"](_v, 133).large; var currVal_261 = core["ɵnov"](_v, 133).giant; var currVal_262 = core["ɵnov"](_v, 133).primary; var currVal_263 = core["ɵnov"](_v, 133).info; var currVal_264 = core["ɵnov"](_v, 133).success; var currVal_265 = core["ɵnov"](_v, 133).warning; var currVal_266 = core["ɵnov"](_v, 133).danger; var currVal_267 = core["ɵnov"](_v, 133).basic; var currVal_268 = core["ɵnov"](_v, 133).control; var currVal_269 = core["ɵnov"](_v, 133).rectangle; var currVal_270 = core["ɵnov"](_v, 133).semiRound; var currVal_271 = core["ɵnov"](_v, 133).round; _ck(_v, 124, 1, [currVal_247, currVal_248, currVal_249, currVal_250, currVal_251, currVal_252, currVal_253, currVal_254, currVal_255, currVal_256, currVal_257, currVal_258, currVal_259, currVal_260, currVal_261, currVal_262, currVal_263, currVal_264, currVal_265, currVal_266, currVal_267, currVal_268, currVal_269, currVal_270, currVal_271]); var currVal_283 = ((!_co.formData.quantitative || _co.isLoading) ? true : null); var currVal_284 = (core["ɵnov"](_v, 140).maxlength ? core["ɵnov"](_v, 140).maxlength : null); var currVal_285 = core["ɵnov"](_v, 145).ngClassUntouched; var currVal_286 = core["ɵnov"](_v, 145).ngClassTouched; var currVal_287 = core["ɵnov"](_v, 145).ngClassPristine; var currVal_288 = core["ɵnov"](_v, 145).ngClassDirty; var currVal_289 = core["ɵnov"](_v, 145).ngClassValid; var currVal_290 = core["ɵnov"](_v, 145).ngClassInvalid; var currVal_291 = core["ɵnov"](_v, 145).ngClassPending; var currVal_292 = core["ɵnov"](_v, 146).fullWidth; var currVal_293 = core["ɵnov"](_v, 146).tiny; var currVal_294 = core["ɵnov"](_v, 146).small; var currVal_295 = core["ɵnov"](_v, 146).medium; var currVal_296 = core["ɵnov"](_v, 146).large; var currVal_297 = core["ɵnov"](_v, 146).giant; var currVal_298 = core["ɵnov"](_v, 146).primary; var currVal_299 = core["ɵnov"](_v, 146).info; var currVal_300 = core["ɵnov"](_v, 146).success; var currVal_301 = core["ɵnov"](_v, 146).warning; var currVal_302 = core["ɵnov"](_v, 146).danger; var currVal_303 = core["ɵnov"](_v, 146).basic; var currVal_304 = core["ɵnov"](_v, 146).control; var currVal_305 = core["ɵnov"](_v, 146).rectangle; var currVal_306 = core["ɵnov"](_v, 146).semiRound; var currVal_307 = core["ɵnov"](_v, 146).round; _ck(_v, 137, 1, [currVal_283, currVal_284, currVal_285, currVal_286, currVal_287, currVal_288, currVal_289, currVal_290, currVal_291, currVal_292, currVal_293, currVal_294, currVal_295, currVal_296, currVal_297, currVal_298, currVal_299, currVal_300, currVal_301, currVal_302, currVal_303, currVal_304, currVal_305, currVal_306, currVal_307]); var currVal_319 = ((!_co.formData.quantitative || _co.isLoading) ? true : null); var currVal_320 = (core["ɵnov"](_v, 153).maxlength ? core["ɵnov"](_v, 153).maxlength : null); var currVal_321 = core["ɵnov"](_v, 158).ngClassUntouched; var currVal_322 = core["ɵnov"](_v, 158).ngClassTouched; var currVal_323 = core["ɵnov"](_v, 158).ngClassPristine; var currVal_324 = core["ɵnov"](_v, 158).ngClassDirty; var currVal_325 = core["ɵnov"](_v, 158).ngClassValid; var currVal_326 = core["ɵnov"](_v, 158).ngClassInvalid; var currVal_327 = core["ɵnov"](_v, 158).ngClassPending; var currVal_328 = core["ɵnov"](_v, 159).fullWidth; var currVal_329 = core["ɵnov"](_v, 159).tiny; var currVal_330 = core["ɵnov"](_v, 159).small; var currVal_331 = core["ɵnov"](_v, 159).medium; var currVal_332 = core["ɵnov"](_v, 159).large; var currVal_333 = core["ɵnov"](_v, 159).giant; var currVal_334 = core["ɵnov"](_v, 159).primary; var currVal_335 = core["ɵnov"](_v, 159).info; var currVal_336 = core["ɵnov"](_v, 159).success; var currVal_337 = core["ɵnov"](_v, 159).warning; var currVal_338 = core["ɵnov"](_v, 159).danger; var currVal_339 = core["ɵnov"](_v, 159).basic; var currVal_340 = core["ɵnov"](_v, 159).control; var currVal_341 = core["ɵnov"](_v, 159).rectangle; var currVal_342 = core["ɵnov"](_v, 159).semiRound; var currVal_343 = core["ɵnov"](_v, 159).round; _ck(_v, 150, 1, [currVal_319, currVal_320, currVal_321, currVal_322, currVal_323, currVal_324, currVal_325, currVal_326, currVal_327, currVal_328, currVal_329, currVal_330, currVal_331, currVal_332, currVal_333, currVal_334, currVal_335, currVal_336, currVal_337, currVal_338, currVal_339, currVal_340, currVal_341, currVal_342, currVal_343]); var currVal_348 = core["ɵnov"](_v, 161).disabled; var currVal_349 = core["ɵnov"](_v, 161).activeValue; _ck(_v, 160, 0, currVal_348, currVal_349); var currVal_356 = (_co.isLoading ? true : null); var currVal_357 = core["ɵnov"](_v, 166).filled; var currVal_358 = core["ɵnov"](_v, 166).outline; var currVal_359 = core["ɵnov"](_v, 166).ghost; var currVal_360 = core["ɵnov"](_v, 166).hero; var currVal_361 = core["ɵnov"](_v, 166).fullWidth; var currVal_362 = core["ɵnov"](_v, 166).disabled; var currVal_363 = core["ɵnov"](_v, 166).disabled; var currVal_364 = core["ɵnov"](_v, 166).tabbable; var currVal_365 = core["ɵnov"](_v, 166).tiny; var currVal_366 = core["ɵnov"](_v, 166).small; var currVal_367 = core["ɵnov"](_v, 166).medium; var currVal_368 = core["ɵnov"](_v, 166).large; var currVal_369 = core["ɵnov"](_v, 166).giant; var currVal_370 = core["ɵnov"](_v, 166).primary; var currVal_371 = core["ɵnov"](_v, 166).info; var currVal_372 = core["ɵnov"](_v, 166).success; var currVal_373 = core["ɵnov"](_v, 166).warning; var currVal_374 = core["ɵnov"](_v, 166).danger; var currVal_375 = core["ɵnov"](_v, 166).basic; var currVal_376 = core["ɵnov"](_v, 166).control; var currVal_377 = core["ɵnov"](_v, 166).rectangle; var currVal_378 = core["ɵnov"](_v, 166).round; var currVal_379 = core["ɵnov"](_v, 166).semiRound; var currVal_380 = core["ɵnov"](_v, 166).iconLeft; var currVal_381 = core["ɵnov"](_v, 166).iconRight; var currVal_382 = core["ɵnov"](_v, 166).transitions; _ck(_v, 165, 1, [currVal_356, currVal_357, currVal_358, currVal_359, currVal_360, currVal_361, currVal_362, currVal_363, currVal_364, currVal_365, currVal_366, currVal_367, currVal_368, currVal_369, currVal_370, currVal_371, currVal_372, currVal_373, currVal_374, currVal_375, currVal_376, currVal_377, currVal_378, currVal_379, currVal_380, currVal_381, currVal_382]); var currVal_384 = (_co.isLoading ? "Aguarde..." : "Salvar"); _ck(_v, 167, 0, currVal_384); }); }
function View_CustomizationCategoryEditComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customization-category-edit", [], null, null, null, View_CustomizationCategoryEditComponent_0, RenderType_CustomizationCategoryEditComponent)), core["ɵdid"](1, 114688, null, 0, customization_category_edit_component_CustomizationCategoryEditComponent, [router["a" /* ActivatedRoute */], fesm2015_forms["g" /* FormBuilder */], router["l" /* Router */], empresa_service["a" /* EmpresaService */], personalizacao_service["a" /* PersonalizacaoService */], nav_extras_service["a" /* NavExtrasService */], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */], request_service["a" /* RequestService */], fesm2015["Ld" /* NbToastrService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomizationCategoryEditComponentNgFactory = core["ɵccf"]("omni-customization-category-edit", customization_category_edit_component_CustomizationCategoryEditComponent, View_CustomizationCategoryEditComponent_Host_0, {}, {}, []);


// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/angular-fontawesome.ngfactory.js
var angular_fontawesome_ngfactory = __webpack_require__("fNgX");

// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/sweetalert2-ngx-sweetalert2.ngfactory.js
var sweetalert2_ngx_sweetalert2_ngfactory = __webpack_require__("kExW");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/ngx-bootstrap-typeahead.ngfactory.js
var ngx_bootstrap_typeahead_ngfactory = __webpack_require__("SfUx");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/cashback-credit-dialog/cashback-credit-dialog.component.ngfactory.js + 1 modules
var cashback_credit_dialog_component_ngfactory = __webpack_require__("sKAB");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/category/category-quick-form-dialog/category-quick-form-dialog.component.ngfactory.js + 1 modules
var category_quick_form_dialog_component_ngfactory = __webpack_require__("iY9W");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/customization/edit-customization-value-dialog/edit-customization-value-dialog.component.ngfactory.js + 1 modules
var edit_customization_value_dialog_component_ngfactory = __webpack_require__("x9iD");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/edit-delivery-address-dialog/edit-delivery-address-dialog.component.ngfactory.js + 1 modules
var edit_delivery_address_dialog_component_ngfactory = __webpack_require__("EXuQ");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/extract-cashback-list-dialog/extract-cashback-list-dialog.component.ngfactory.js + 1 modules
var extract_cashback_list_dialog_component_ngfactory = __webpack_require__("ZjL+");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-detail-dialog/order-detail-dialog.component.ngfactory.js + 3 modules
var order_detail_dialog_component_ngfactory = __webpack_require__("lbLe");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-update-dialog/order-update-dialog.component.ngfactory.js + 1 modules
var order_update_dialog_component_ngfactory = __webpack_require__("/Cjm");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-edit-dialog/promotion-rule-edit-dialog.component.ngfactory.js + 1 modules
var promotion_rule_edit_dialog_component_ngfactory = __webpack_require__("AHux");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/view-picture-dialog/view-picture-dialog.component.ngfactory.js + 1 modules
var view_picture_dialog_component_ngfactory = __webpack_require__("YAEL");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-gift-edit-dialog/promotion-gift-edit-dialog.component.ngfactory.js + 1 modules
var promotion_gift_edit_dialog_component_ngfactory = __webpack_require__("RswS");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-view-dialog/promotion-rule-view-dialog.component.ngfactory.js + 1 modules
var promotion_rule_view_dialog_component_ngfactory = __webpack_require__("BRe2");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-feedback-dialog/order-feedback-dialog.component.ngfactory.js + 1 modules
var order_feedback_dialog_component_ngfactory = __webpack_require__("otmp");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/tutorial-dialog/tutorial-dialog.component.ngfactory.js + 1 modules
var tutorial_dialog_component_ngfactory = __webpack_require__("Uvoc");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/overlay.js
var overlay = __webpack_require__("QQfA");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/bidi.js
var bidi = __webpack_require__("IP0z");

// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/fesm2015/sweetalert2-ngx-sweetalert2.js
var sweetalert2_ngx_sweetalert2 = __webpack_require__("hvj1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/positioning/fesm2015/ngx-bootstrap-positioning.js
var ngx_bootstrap_positioning = __webpack_require__("2uy1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/component-loader/fesm2015/ngx-bootstrap-component-loader.js
var ngx_bootstrap_component_loader = __webpack_require__("z/SZ");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/fesm2015/ngx-bootstrap-typeahead.js + 2 modules
var ngx_bootstrap_typeahead = __webpack_require__("ZMeN");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category-routing.module.ts



const routes = [
    { path: '', component: customization_category_list_component_CustomizationCategoryListComponent },
    { path: 'new', component: customization_category_edit_component_CustomizationCategoryEditComponent },
    { path: ':id/edit', component: customization_category_edit_component_CustomizationCategoryEditComponent }
];
class CustomizationCategoryRoutingModule {
}

// EXTERNAL MODULE: ./src/app/shared/directives/directives.module.ts + 1 modules
var directives_module = __webpack_require__("yGOH");

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/fesm2015/angular-fontawesome.js
var angular_fontawesome = __webpack_require__("Nv++");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/portal.js
var portal = __webpack_require__("zMNK");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/platform.js
var platform = __webpack_require__("/HVE");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/scrolling.js + 6 modules
var scrolling = __webpack_require__("hOhj");

// EXTERNAL MODULE: ./node_modules/br-mask/dist/app.module.js
var app_module = __webpack_require__("CbX2");

// EXTERNAL MODULE: ./node_modules/angular2-chartjs/dist/chart.module.js
var chart_module = __webpack_require__("AE88");

// EXTERNAL MODULE: ./node_modules/@nebular/eva-icons/fesm2015/index.js
var eva_icons_fesm2015 = __webpack_require__("XoTT");

// EXTERNAL MODULE: ./node_modules/ngx-dropzone/fesm2015/ngx-dropzone.js
var ngx_dropzone = __webpack_require__("tq8E");

// EXTERNAL MODULE: ./src/app/shared/pipes/pipes.module.ts + 9 modules
var pipes_module = __webpack_require__("9Xeq");

// EXTERNAL MODULE: ./src/app/shared/ui/ui.module.ts + 6 modules
var ui_module = __webpack_require__("4zvT");

// CONCATENATED MODULE: ./src/app/pages/products/customizations/customization-category/customization-category.module.ngfactory.js
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomizationCategoryModuleNgFactory", function() { return CustomizationCategoryModuleNgFactory; });
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 














































var CustomizationCategoryModuleNgFactory = core["ɵcmf"](CustomizationCategoryModule, [], function (_l) { return core["ɵmod"]([core["ɵmpd"](512, core["ComponentFactoryResolver"], core["ɵCodegenComponentFactoryResolver"], [[8, [router_ngfactory["a" /* ɵangular_packages_router_router_lNgFactory */], CustomizationCategoryListComponentNgFactory, CustomizationCategoryEditComponentNgFactory, angular_fontawesome_ngfactory["b" /* FaIconComponentNgFactory */], angular_fontawesome_ngfactory["a" /* FaDuotoneIconComponentNgFactory */], index_ngfactory["m" /* NbToastrContainerComponentNgFactory */], index_ngfactory["l" /* NbToastComponentNgFactory */], index_ngfactory["n" /* NbTooltipComponentNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["b" /* SwalComponentNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["d" /* ɵcNgFactory */], index_ngfactory["h" /* NbContextMenuComponentNgFactory */], index_ngfactory["j" /* NbDialogContainerComponentNgFactory */], index_ngfactory["k" /* NbPopoverComponentNgFactory */], ngx_bootstrap_typeahead_ngfactory["a" /* TypeaheadContainerComponentNgFactory */], cashback_credit_dialog_component_ngfactory["a" /* CashbackCreditDialogComponentNgFactory */], category_quick_form_dialog_component_ngfactory["a" /* CategoryQuickFormDialogComponentNgFactory */], edit_customization_value_dialog_component_ngfactory["a" /* EditCustomizationValueDialogComponentNgFactory */], edit_delivery_address_dialog_component_ngfactory["a" /* EditDeliveryAddressDialogComponentNgFactory */], extract_cashback_list_dialog_component_ngfactory["a" /* ExtractCashbackListDialogComponentNgFactory */], order_detail_dialog_component_ngfactory["a" /* OrderDetailDialogComponentNgFactory */], order_update_dialog_component_ngfactory["a" /* OrderUpdateDialogComponentNgFactory */], promotion_rule_edit_dialog_component_ngfactory["a" /* PromotionRuleEditDialogComponentNgFactory */], view_picture_dialog_component_ngfactory["b" /* ViewPictureDialogComponentNgFactory */], promotion_gift_edit_dialog_component_ngfactory["a" /* PromotionGiftEditDialogComponentNgFactory */], promotion_rule_view_dialog_component_ngfactory["a" /* PromotionRuleViewDialogComponentNgFactory */], order_feedback_dialog_component_ngfactory["a" /* OrderFeedbackDialogComponentNgFactory */], tutorial_dialog_component_ngfactory["b" /* TutorialDialogComponentNgFactory */]]], [3, core["ComponentFactoryResolver"]], core["NgModuleRef"]]), core["ɵmpd"](4608, common["q" /* NgLocalization */], common["p" /* NgLocaleLocalization */], [core["LOCALE_ID"], [2, common["R" /* ɵangular_packages_common_common_a */]]]), core["ɵmpd"](4608, fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], []), core["ɵmpd"](4608, overlay["d" /* Overlay */], overlay["d" /* Overlay */], [overlay["i" /* ScrollStrategyOptions */], overlay["e" /* OverlayContainer */], core["ComponentFactoryResolver"], overlay["h" /* OverlayPositionBuilder */], overlay["f" /* OverlayKeyboardDispatcher */], core["Injector"], core["NgZone"], common["e" /* DOCUMENT */], bidi["b" /* Directionality */], [2, common["k" /* Location */]]]), core["ɵmpd"](5120, overlay["j" /* ɵc */], overlay["k" /* ɵd */], [overlay["d" /* Overlay */]]), core["ɵmpd"](4608, fesm2015_forms["g" /* FormBuilder */], fesm2015_forms["g" /* FormBuilder */], []), core["ɵmpd"](4608, sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], []), core["ɵmpd"](4608, ngx_bootstrap_positioning["a" /* PositioningService */], ngx_bootstrap_positioning["a" /* PositioningService */], [core["NgZone"], core["RendererFactory2"], core["PLATFORM_ID"]]), core["ɵmpd"](4608, ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], [core["ComponentFactoryResolver"], core["NgZone"], core["Injector"], ngx_bootstrap_positioning["a" /* PositioningService */], core["ApplicationRef"]]), core["ɵmpd"](4608, ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], []), core["ɵmpd"](1073742336, common["c" /* CommonModule */], common["c" /* CommonModule */], []), core["ɵmpd"](1073742336, router["p" /* RouterModule */], router["p" /* RouterModule */], [[2, router["u" /* ɵangular_packages_router_router_a */]], [2, router["l" /* Router */]]]), core["ɵmpd"](1073742336, CustomizationCategoryRoutingModule, CustomizationCategoryRoutingModule, []), core["ɵmpd"](1073742336, directives_module["a" /* DirectivesModule */], directives_module["a" /* DirectivesModule */], []), core["ɵmpd"](1073742336, angular_fontawesome["j" /* FontAwesomeModule */], angular_fontawesome["j" /* FontAwesomeModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], []), core["ɵmpd"](1073742336, fesm2015_forms["n" /* FormsModule */], fesm2015_forms["n" /* FormsModule */], []), core["ɵmpd"](1073742336, fesm2015["pe" /* ɵc */], fesm2015["pe" /* ɵc */], []), core["ɵmpd"](1073742336, fesm2015["M" /* NbButtonModule */], fesm2015["M" /* NbButtonModule */], []), core["ɵmpd"](1073742336, fesm2015["dc" /* NbIconModule */], fesm2015["dc" /* NbIconModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["nb" /* NbCardModule */], fesm2015["nb" /* NbCardModule */], []), core["ɵmpd"](1073742336, fesm2015["fc" /* NbInputModule */], fesm2015["fc" /* NbInputModule */], []), core["ɵmpd"](1073742336, fesm2015["Bb" /* NbCheckboxModule */], fesm2015["Bb" /* NbCheckboxModule */], []), core["ɵmpd"](1073742336, fesm2015["Vc" /* NbRadioModule */], fesm2015["Vc" /* NbRadioModule */], []), core["ɵmpd"](1073742336, bidi["a" /* BidiModule */], bidi["a" /* BidiModule */], []), core["ɵmpd"](1073742336, portal["f" /* PortalModule */], portal["f" /* PortalModule */], []), core["ɵmpd"](1073742336, platform["b" /* PlatformModule */], platform["b" /* PlatformModule */], []), core["ɵmpd"](1073742336, scrolling["b" /* ScrollingModule */], scrolling["b" /* ScrollingModule */], []), core["ɵmpd"](1073742336, overlay["g" /* OverlayModule */], overlay["g" /* OverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["pb" /* NbCdkMappingModule */], fesm2015["pb" /* NbCdkMappingModule */], []), core["ɵmpd"](1073742336, fesm2015["ob" /* NbCdkAdapterModule */], fesm2015["ob" /* NbCdkAdapterModule */], []), core["ɵmpd"](1073742336, fesm2015["Ec" /* NbOverlayModule */], fesm2015["Ec" /* NbOverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["kd" /* NbSelectModule */], fesm2015["kd" /* NbSelectModule */], []), core["ɵmpd"](1073742336, fesm2015["F" /* NbBadgeModule */], fesm2015["F" /* NbBadgeModule */], []), core["ɵmpd"](1073742336, fesm2015["Ed" /* NbTabsetModule */], fesm2015["Ed" /* NbTabsetModule */], []), core["ɵmpd"](1073742336, fesm2015["Kd" /* NbToastrModule */], fesm2015["Kd" /* NbToastrModule */], []), core["ɵmpd"](1073742336, fesm2015["Qd" /* NbTooltipModule */], fesm2015["Qd" /* NbTooltipModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["x" /* ReactiveFormsModule */], fesm2015_forms["x" /* ReactiveFormsModule */], []), core["ɵmpd"](1073742336, sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], []), core["ɵmpd"](1073742336, app_module["a" /* BrMaskerModule */], app_module["a" /* BrMaskerModule */], []), core["ɵmpd"](1073742336, chart_module["ChartModule"], chart_module["ChartModule"], []), core["ɵmpd"](1073742336, fesm2015["D" /* NbAlertModule */], fesm2015["D" /* NbAlertModule */], []), core["ɵmpd"](1073742336, fesm2015["B" /* NbActionsModule */], fesm2015["B" /* NbActionsModule */], []), core["ɵmpd"](1073742336, fesm2015["vc" /* NbMenuModule */], fesm2015["vc" /* NbMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Gb" /* NbContextMenuModule */], fesm2015["Gb" /* NbContextMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Qb" /* NbDialogModule */], fesm2015["Qb" /* NbDialogModule */], []), core["ɵmpd"](1073742336, eva_icons_fesm2015["a" /* NbEvaIconsModule */], eva_icons_fesm2015["a" /* NbEvaIconsModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["rc" /* NbListModule */], fesm2015["rc" /* NbListModule */], []), core["ɵmpd"](1073742336, fesm2015["Lc" /* NbPopoverModule */], fesm2015["Lc" /* NbPopoverModule */], []), core["ɵmpd"](1073742336, fesm2015["fe" /* NbUserModule */], fesm2015["fe" /* NbUserModule */], []), core["ɵmpd"](1073742336, ngx_dropzone["c" /* NgxDropzoneModule */], ngx_dropzone["c" /* NgxDropzoneModule */], []), core["ɵmpd"](1073742336, pipes_module["a" /* PipesModule */], pipes_module["a" /* PipesModule */], []), core["ɵmpd"](1073742336, ngx_bootstrap_typeahead["d" /* TypeaheadModule */], ngx_bootstrap_typeahead["d" /* TypeaheadModule */], []), core["ɵmpd"](1073742336, ui_module["a" /* UiModule */], ui_module["a" /* UiModule */], []), core["ɵmpd"](1073742336, CustomizationCategoryModule, CustomizationCategoryModule, []), core["ɵmpd"](1024, router["j" /* ROUTES */], function () { return [[{ path: "", component: customization_category_list_component_CustomizationCategoryListComponent }, { path: "new", component: customization_category_edit_component_CustomizationCategoryEditComponent }, { path: ":id/edit", component: customization_category_edit_component_CustomizationCategoryEditComponent }]]; }, []), core["ɵmpd"](256, sweetalert2_ngx_sweetalert2["d" /* ɵa */], undefined, [])]); });



/***/ })

};;