exports.ids = [21];
exports.modules = {

/***/ "HD6e":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@angular/core/fesm2015/core.js
var core = __webpack_require__("8Y7J");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers.module.ts
class CustomersModule {
}

// EXTERNAL MODULE: ./node_modules/@angular/router/router.ngfactory.js
var router_ngfactory = __webpack_require__("pMnS");

// EXTERNAL MODULE: ./src/app/shared/ui/badge/badge.component.ngfactory.js + 1 modules
var badge_component_ngfactory = __webpack_require__("mcHM");

// EXTERNAL MODULE: ./src/app/shared/ui/badge/badge.component.ts
var badge_component = __webpack_require__("C62Z");

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/angular-fontawesome.ngfactory.js
var angular_fontawesome_ngfactory = __webpack_require__("fNgX");

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/fesm2015/angular-fontawesome.js
var angular_fontawesome = __webpack_require__("Nv++");

// EXTERNAL MODULE: ./node_modules/@angular/platform-browser/fesm2015/platform-browser.js
var platform_browser = __webpack_require__("cUpR");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/grid-label/grid-label.component.ngfactory.js
var grid_label_component_ngfactory = __webpack_require__("3xHq");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/grid-label/grid-label.component.ts
var grid_label_component = __webpack_require__("uddK");

// EXTERNAL MODULE: ./node_modules/@angular/common/fesm2015/common.js
var common = __webpack_require__("SVse");

// EXTERNAL MODULE: ./src/app/shared/ui/dropdown-menu/dropdown-menu.component.ngfactory.js
var dropdown_menu_component_ngfactory = __webpack_require__("QM7m");

// EXTERNAL MODULE: ./src/app/shared/ui/dropdown-menu/dropdown-menu.component.ts + 1 modules
var dropdown_menu_component = __webpack_require__("jEJX");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/pagination/pagination.component.ngfactory.js + 1 modules
var pagination_component_ngfactory = __webpack_require__("tHyn");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/pagination/pagination.component.ts
var pagination_component = __webpack_require__("HJd8");

// EXTERNAL MODULE: ./src/app/shared/pipes/situacao.pipe.ts
var situacao_pipe = __webpack_require__("4B9u");

// EXTERNAL MODULE: ./src/app/shared/pipes/person-type.pipe.ts
var person_type_pipe = __webpack_require__("7A0q");

// EXTERNAL MODULE: ./src/app/shared/pipes/cpf-cnpj.pipe.ts
var cpf_cnpj_pipe = __webpack_require__("rK44");

// EXTERNAL MODULE: ./src/app/shared/pipes/address.pipe.ts
var address_pipe = __webpack_require__("Nd6I");

// EXTERNAL MODULE: ./src/app/shared/pipes/telefone.pipe.ts
var telefone_pipe = __webpack_require__("/8qz");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ngfactory.js + 1 modules
var page_title_component_ngfactory = __webpack_require__("laEC");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ts
var page_title_component = __webpack_require__("S4p5");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/fesm2015/index.js + 5 modules
var fesm2015 = __webpack_require__("tKwJ");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/index.ngfactory.js
var index_ngfactory = __webpack_require__("jXVt");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/filter/filter.component.ngfactory.js
var filter_component_ngfactory = __webpack_require__("vtHt");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/filter/filter.component.ts
var filter_component = __webpack_require__("4J+U");

// EXTERNAL MODULE: ./src/app/shared/ui/inline-loader/inline-loader.component.ngfactory.js
var inline_loader_component_ngfactory = __webpack_require__("T9fw");

// EXTERNAL MODULE: ./src/app/shared/ui/inline-loader/inline-loader.component.ts
var inline_loader_component = __webpack_require__("IGDG");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/form-filter/form-filter.component.ngfactory.js + 1 modules
var form_filter_component_ngfactory = __webpack_require__("OQs5");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/form-filter/form-filter.component.ts
var form_filter_component = __webpack_require__("/gwA");

// EXTERNAL MODULE: ./node_modules/@angular/forms/fesm2015/forms.js
var fesm2015_forms = __webpack_require__("s7LF");

// EXTERNAL MODULE: ./src/app/shared/ui/field/field.component.ngfactory.js + 1 modules
var field_component_ngfactory = __webpack_require__("jZyr");

// EXTERNAL MODULE: ./src/app/shared/ui/field/field.component.ts
var field_component = __webpack_require__("jaPl");

// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-form-filter-component.ts
var base_form_filter_component = __webpack_require__("4ILO");

// EXTERNAL MODULE: ./src/app/shared/consts/query-operators.ts
var query_operators = __webpack_require__("AtRd");

// EXTERNAL MODULE: ./src/app/shared/utils/string.util.ts
var string_util = __webpack_require__("8n1d");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-filter/customers-filter.component.ts





class customers_filter_component_CustomersFilterComponent extends base_form_filter_component["a" /* BaseFormFilterComponent */] {
    constructor(fb) {
        super();
        this.fb = fb;
    }
    ngOnInit() {
        this.initForm();
    }
    applyFilter() {
        this.filters = [];
        const form = this.formFilter.getRawValue();
        if (!string_util["a" /* StringUtil */].isBlank(form.nome)) {
            this.filters.push({
                key: 'nome',
                label: 'Nome',
                operator: query_operators["a" /* QUERY_OPERATORS */].EQUALS,
                value: this.formFilter.getRawValue().nome,
                tagValue: this.formFilter.getRawValue().nome
            });
        }
        if (!string_util["a" /* StringUtil */].isBlank(this.formData.ativo)) {
            this.filters.push({
                key: 'ativo',
                label: 'Cliente ativo?',
                operator: query_operators["a" /* QUERY_OPERATORS */].EQUALS,
                value: this.formData.ativo,
                tagValue: this.formData.ativo ? 'Sim' : 'Não'
            });
        }
        if (!string_util["a" /* StringUtil */].isBlank(this.formData.bloqueado)) {
            this.filters.push({
                key: 'bloqueado',
                label: 'Cliente bloqueado?',
                operator: query_operators["a" /* QUERY_OPERATORS */].EQUALS,
                value: this.formData.bloqueado,
                tagValue: this.formData.bloqueado ? 'Sim' : 'Não'
            });
        }
        this.saveFilterState(this.filters);
        this.doFilter.emit(this.filters);
    }
    initForm() {
        this.formFilter = this.fb.group({
            nome: ['', fesm2015_forms["z" /* Validators */].minLength(3)],
            ativo: [''],
            bloqueado: ['']
        });
        this.refreshFilterState();
    }
    refreshFilterState() {
        if (this.getFilterState()) {
            this.getFilterState().criterias.forEach((criteria) => this.formFilter.get(criteria.key).setValue(criteria.value));
        }
    }
    resetFilter() {
        this.filters = [];
        this.doFilter.emit(this.filters);
    }
}

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-filter/customers-filter.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 







var styles_CustomersFilterComponent = [];
var RenderType_CustomersFilterComponent = core["ɵcrt"]({ encapsulation: 2, styles: styles_CustomersFilterComponent, data: {} });

function View_CustomersFilterComponent_0(_l) { return core["ɵvid"](0, [core["ɵqud"](402653184, 1, { formFilterRef: 0 }), (_l()(), core["ɵeld"](1, 0, null, null, 57, "form", [["novalidate", ""]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "ngSubmit"], [null, "submit"], [null, "reset"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("submit" === en)) {
        var pd_0 = (core["ɵnov"](_v, 3).onSubmit($event) !== false);
        ad = (pd_0 && ad);
    } if (("reset" === en)) {
        var pd_1 = (core["ɵnov"](_v, 3).onReset() !== false);
        ad = (pd_1 && ad);
    } if (("ngSubmit" === en)) {
        var pd_2 = (_co.onSubmit() !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](2, 16384, null, 0, fesm2015_forms["D" /* ɵangular_packages_forms_forms_z */], [], null, null), core["ɵdid"](3, 540672, null, 0, fesm2015_forms["l" /* FormGroupDirective */], [[8, null], [8, null]], { form: [0, "form"] }, { ngSubmit: "ngSubmit" }), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["l" /* FormGroupDirective */]]), core["ɵdid"](5, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](6, 0, null, null, 52, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 51, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](8, 0, null, null, 9, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](9, 0, null, null, 8, "omni-field", [["field", "nome"], ["label", "Nome"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](10, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](11, 0, null, 0, 6, "input", [["formControlName", "nome"], ["fullWidth", ""], ["name", "nome"], ["nbInput", ""], ["placeholder", "Informe o Nome"], ["status", "primary"], ["type", "text"]], [[8, "readOnly", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 13)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 13).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 13)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 13)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](12, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](13, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](15, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](17, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](18, 0, null, null, 15, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](19, 0, null, null, 14, "omni-field", [["endLabelChar", "?"], ["field", "ativo"], ["label", "Cliente ativo"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](20, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], endLabelChar: [3, "endLabelChar"] }, null), (_l()(), core["ɵeld"](21, 0, null, 0, 12, "nb-radio-group", [["class", "d-flex flex-row align-items-center"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["cb" /* View_NbRadioGroupComponent_0 */], index_ngfactory["F" /* RenderType_NbRadioGroupComponent */])), core["ɵdid"](22, 1228800, null, 1, fesm2015["Uc" /* NbRadioGroupComponent */], [core["ElementRef"], core["PLATFORM_ID"], fesm2015["g" /* NB_DOCUMENT */]], null, null), core["ɵqud"](603979776, 2, { radios: 1 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Uc" /* NbRadioGroupComponent */]]), core["ɵdid"](25, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](27, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](28, 0, null, 0, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], null, null, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](29, 49152, [[2, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](-1, 0, ["Sim"])), (_l()(), core["ɵeld"](31, 0, null, 0, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], null, null, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](32, 49152, [[2, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](-1, 0, ["N\u00E3o"])), (_l()(), core["ɵeld"](34, 0, null, null, 15, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](35, 0, null, null, 14, "omni-field", [["endLabelChar", "?"], ["field", "bloqueado"], ["label", "Cliente bloqueado"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](36, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], endLabelChar: [3, "endLabelChar"] }, null), (_l()(), core["ɵeld"](37, 0, null, 0, 12, "nb-radio-group", [["class", "d-flex flex-row align-items-center"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], null, null, index_ngfactory["cb" /* View_NbRadioGroupComponent_0 */], index_ngfactory["F" /* RenderType_NbRadioGroupComponent */])), core["ɵdid"](38, 1228800, null, 1, fesm2015["Uc" /* NbRadioGroupComponent */], [core["ElementRef"], core["PLATFORM_ID"], fesm2015["g" /* NB_DOCUMENT */]], null, null), core["ɵqud"](603979776, 3, { radios: 1 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Uc" /* NbRadioGroupComponent */]]), core["ɵdid"](41, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](43, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](44, 0, null, 0, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], null, null, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](45, 49152, [[3, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](-1, 0, ["Sim"])), (_l()(), core["ɵeld"](47, 0, null, 0, 2, "nb-radio", [], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], null, null, index_ngfactory["bb" /* View_NbRadioComponent_0 */], index_ngfactory["E" /* RenderType_NbRadioComponent */])), core["ɵdid"](48, 49152, [[3, 4]], 0, fesm2015["Tc" /* NbRadioComponent */], [core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](-1, 0, ["N\u00E3o"])), (_l()(), core["ɵeld"](50, 0, null, null, 0, "hr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](51, 0, null, null, 3, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](52, 0, null, null, 2, "button", [["fullWidth", ""], ["nbButton", ""], ["status", "primary"], ["type", "submit"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 53).onClick($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](53, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"], fullWidth: [1, "fullWidth"], disabled: [2, "disabled"] }, null), (_l()(), core["ɵted"](-1, 0, [" Pesquisar "])), (_l()(), core["ɵeld"](55, 0, null, null, 3, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](56, 0, null, null, 2, "button", [["fullWidth", ""], ["nbButton", ""], ["status", "primary"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 57).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.onResetFilter() !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](57, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"], outline: [1, "outline"], fullWidth: [2, "fullWidth"], disabled: [3, "disabled"] }, null), (_l()(), core["ɵted"](-1, 0, [" Limpar "]))], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.formFilter; _ck(_v, 3, 0, currVal_7); var currVal_8 = "nome"; var currVal_9 = _co.formFilter; var currVal_10 = "Nome"; _ck(_v, 10, 0, currVal_8, currVal_9, currVal_10); var currVal_35 = "primary"; var currVal_36 = ""; _ck(_v, 12, 0, currVal_35, currVal_36); var currVal_37 = "nome"; _ck(_v, 15, 0, currVal_37); var currVal_38 = "ativo"; var currVal_39 = _co.formFilter; var currVal_40 = "Cliente ativo"; var currVal_41 = "?"; _ck(_v, 20, 0, currVal_38, currVal_39, currVal_40, currVal_41); var currVal_49 = _co.formFilter.get("ativo"); _ck(_v, 25, 0, currVal_49); var currVal_57 = true; _ck(_v, 29, 0, currVal_57); var currVal_65 = false; _ck(_v, 32, 0, currVal_65); var currVal_66 = "bloqueado"; var currVal_67 = _co.formFilter; var currVal_68 = "Cliente bloqueado"; var currVal_69 = "?"; _ck(_v, 36, 0, currVal_66, currVal_67, currVal_68, currVal_69); var currVal_77 = _co.formFilter.get("bloqueado"); _ck(_v, 41, 0, currVal_77); var currVal_85 = true; _ck(_v, 45, 0, currVal_85); var currVal_93 = false; _ck(_v, 48, 0, currVal_93); var currVal_120 = "primary"; var currVal_121 = ""; var currVal_122 = _co.isDisabled; _ck(_v, 53, 0, currVal_120, currVal_121, currVal_122); var currVal_149 = "primary"; var currVal_150 = true; var currVal_151 = ""; var currVal_152 = _co.isDisabled; _ck(_v, 57, 0, currVal_149, currVal_150, currVal_151, currVal_152); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 5).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 5).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 5).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 5).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 5).ngClassValid; var currVal_5 = core["ɵnov"](_v, 5).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 5).ngClassPending; _ck(_v, 1, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_11 = _co.isDisabled; var currVal_12 = core["ɵnov"](_v, 12).fullWidth; var currVal_13 = core["ɵnov"](_v, 12).tiny; var currVal_14 = core["ɵnov"](_v, 12).small; var currVal_15 = core["ɵnov"](_v, 12).medium; var currVal_16 = core["ɵnov"](_v, 12).large; var currVal_17 = core["ɵnov"](_v, 12).giant; var currVal_18 = core["ɵnov"](_v, 12).primary; var currVal_19 = core["ɵnov"](_v, 12).info; var currVal_20 = core["ɵnov"](_v, 12).success; var currVal_21 = core["ɵnov"](_v, 12).warning; var currVal_22 = core["ɵnov"](_v, 12).danger; var currVal_23 = core["ɵnov"](_v, 12).basic; var currVal_24 = core["ɵnov"](_v, 12).control; var currVal_25 = core["ɵnov"](_v, 12).rectangle; var currVal_26 = core["ɵnov"](_v, 12).semiRound; var currVal_27 = core["ɵnov"](_v, 12).round; var currVal_28 = core["ɵnov"](_v, 17).ngClassUntouched; var currVal_29 = core["ɵnov"](_v, 17).ngClassTouched; var currVal_30 = core["ɵnov"](_v, 17).ngClassPristine; var currVal_31 = core["ɵnov"](_v, 17).ngClassDirty; var currVal_32 = core["ɵnov"](_v, 17).ngClassValid; var currVal_33 = core["ɵnov"](_v, 17).ngClassInvalid; var currVal_34 = core["ɵnov"](_v, 17).ngClassPending; _ck(_v, 11, 1, [currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34]); var currVal_42 = core["ɵnov"](_v, 27).ngClassUntouched; var currVal_43 = core["ɵnov"](_v, 27).ngClassTouched; var currVal_44 = core["ɵnov"](_v, 27).ngClassPristine; var currVal_45 = core["ɵnov"](_v, 27).ngClassDirty; var currVal_46 = core["ɵnov"](_v, 27).ngClassValid; var currVal_47 = core["ɵnov"](_v, 27).ngClassInvalid; var currVal_48 = core["ɵnov"](_v, 27).ngClassPending; _ck(_v, 21, 0, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48); var currVal_50 = core["ɵnov"](_v, 29).isPrimary; var currVal_51 = core["ɵnov"](_v, 29).isSuccess; var currVal_52 = core["ɵnov"](_v, 29).isWarning; var currVal_53 = core["ɵnov"](_v, 29).isDanger; var currVal_54 = core["ɵnov"](_v, 29).isInfo; var currVal_55 = core["ɵnov"](_v, 29).isBasic; var currVal_56 = core["ɵnov"](_v, 29).isControl; _ck(_v, 28, 0, currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56); var currVal_58 = core["ɵnov"](_v, 32).isPrimary; var currVal_59 = core["ɵnov"](_v, 32).isSuccess; var currVal_60 = core["ɵnov"](_v, 32).isWarning; var currVal_61 = core["ɵnov"](_v, 32).isDanger; var currVal_62 = core["ɵnov"](_v, 32).isInfo; var currVal_63 = core["ɵnov"](_v, 32).isBasic; var currVal_64 = core["ɵnov"](_v, 32).isControl; _ck(_v, 31, 0, currVal_58, currVal_59, currVal_60, currVal_61, currVal_62, currVal_63, currVal_64); var currVal_70 = core["ɵnov"](_v, 43).ngClassUntouched; var currVal_71 = core["ɵnov"](_v, 43).ngClassTouched; var currVal_72 = core["ɵnov"](_v, 43).ngClassPristine; var currVal_73 = core["ɵnov"](_v, 43).ngClassDirty; var currVal_74 = core["ɵnov"](_v, 43).ngClassValid; var currVal_75 = core["ɵnov"](_v, 43).ngClassInvalid; var currVal_76 = core["ɵnov"](_v, 43).ngClassPending; _ck(_v, 37, 0, currVal_70, currVal_71, currVal_72, currVal_73, currVal_74, currVal_75, currVal_76); var currVal_78 = core["ɵnov"](_v, 45).isPrimary; var currVal_79 = core["ɵnov"](_v, 45).isSuccess; var currVal_80 = core["ɵnov"](_v, 45).isWarning; var currVal_81 = core["ɵnov"](_v, 45).isDanger; var currVal_82 = core["ɵnov"](_v, 45).isInfo; var currVal_83 = core["ɵnov"](_v, 45).isBasic; var currVal_84 = core["ɵnov"](_v, 45).isControl; _ck(_v, 44, 0, currVal_78, currVal_79, currVal_80, currVal_81, currVal_82, currVal_83, currVal_84); var currVal_86 = core["ɵnov"](_v, 48).isPrimary; var currVal_87 = core["ɵnov"](_v, 48).isSuccess; var currVal_88 = core["ɵnov"](_v, 48).isWarning; var currVal_89 = core["ɵnov"](_v, 48).isDanger; var currVal_90 = core["ɵnov"](_v, 48).isInfo; var currVal_91 = core["ɵnov"](_v, 48).isBasic; var currVal_92 = core["ɵnov"](_v, 48).isControl; _ck(_v, 47, 0, currVal_86, currVal_87, currVal_88, currVal_89, currVal_90, currVal_91, currVal_92); var currVal_94 = core["ɵnov"](_v, 53).filled; var currVal_95 = core["ɵnov"](_v, 53).outline; var currVal_96 = core["ɵnov"](_v, 53).ghost; var currVal_97 = core["ɵnov"](_v, 53).hero; var currVal_98 = core["ɵnov"](_v, 53).fullWidth; var currVal_99 = core["ɵnov"](_v, 53).disabled; var currVal_100 = core["ɵnov"](_v, 53).disabled; var currVal_101 = core["ɵnov"](_v, 53).tabbable; var currVal_102 = core["ɵnov"](_v, 53).tiny; var currVal_103 = core["ɵnov"](_v, 53).small; var currVal_104 = core["ɵnov"](_v, 53).medium; var currVal_105 = core["ɵnov"](_v, 53).large; var currVal_106 = core["ɵnov"](_v, 53).giant; var currVal_107 = core["ɵnov"](_v, 53).primary; var currVal_108 = core["ɵnov"](_v, 53).info; var currVal_109 = core["ɵnov"](_v, 53).success; var currVal_110 = core["ɵnov"](_v, 53).warning; var currVal_111 = core["ɵnov"](_v, 53).danger; var currVal_112 = core["ɵnov"](_v, 53).basic; var currVal_113 = core["ɵnov"](_v, 53).control; var currVal_114 = core["ɵnov"](_v, 53).rectangle; var currVal_115 = core["ɵnov"](_v, 53).round; var currVal_116 = core["ɵnov"](_v, 53).semiRound; var currVal_117 = core["ɵnov"](_v, 53).iconLeft; var currVal_118 = core["ɵnov"](_v, 53).iconRight; var currVal_119 = core["ɵnov"](_v, 53).transitions; _ck(_v, 52, 1, [currVal_94, currVal_95, currVal_96, currVal_97, currVal_98, currVal_99, currVal_100, currVal_101, currVal_102, currVal_103, currVal_104, currVal_105, currVal_106, currVal_107, currVal_108, currVal_109, currVal_110, currVal_111, currVal_112, currVal_113, currVal_114, currVal_115, currVal_116, currVal_117, currVal_118, currVal_119]); var currVal_123 = core["ɵnov"](_v, 57).filled; var currVal_124 = core["ɵnov"](_v, 57).outline; var currVal_125 = core["ɵnov"](_v, 57).ghost; var currVal_126 = core["ɵnov"](_v, 57).hero; var currVal_127 = core["ɵnov"](_v, 57).fullWidth; var currVal_128 = core["ɵnov"](_v, 57).disabled; var currVal_129 = core["ɵnov"](_v, 57).disabled; var currVal_130 = core["ɵnov"](_v, 57).tabbable; var currVal_131 = core["ɵnov"](_v, 57).tiny; var currVal_132 = core["ɵnov"](_v, 57).small; var currVal_133 = core["ɵnov"](_v, 57).medium; var currVal_134 = core["ɵnov"](_v, 57).large; var currVal_135 = core["ɵnov"](_v, 57).giant; var currVal_136 = core["ɵnov"](_v, 57).primary; var currVal_137 = core["ɵnov"](_v, 57).info; var currVal_138 = core["ɵnov"](_v, 57).success; var currVal_139 = core["ɵnov"](_v, 57).warning; var currVal_140 = core["ɵnov"](_v, 57).danger; var currVal_141 = core["ɵnov"](_v, 57).basic; var currVal_142 = core["ɵnov"](_v, 57).control; var currVal_143 = core["ɵnov"](_v, 57).rectangle; var currVal_144 = core["ɵnov"](_v, 57).round; var currVal_145 = core["ɵnov"](_v, 57).semiRound; var currVal_146 = core["ɵnov"](_v, 57).iconLeft; var currVal_147 = core["ɵnov"](_v, 57).iconRight; var currVal_148 = core["ɵnov"](_v, 57).transitions; _ck(_v, 56, 1, [currVal_123, currVal_124, currVal_125, currVal_126, currVal_127, currVal_128, currVal_129, currVal_130, currVal_131, currVal_132, currVal_133, currVal_134, currVal_135, currVal_136, currVal_137, currVal_138, currVal_139, currVal_140, currVal_141, currVal_142, currVal_143, currVal_144, currVal_145, currVal_146, currVal_147, currVal_148]); }); }
function View_CustomersFilterComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customers-filter", [], null, null, null, View_CustomersFilterComponent_0, RenderType_CustomersFilterComponent)), core["ɵdid"](1, 114688, null, 0, customers_filter_component_CustomersFilterComponent, [fesm2015_forms["g" /* FormBuilder */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomersFilterComponentNgFactory = core["ɵccf"]("omni-customers-filter", customers_filter_component_CustomersFilterComponent, View_CustomersFilterComponent_Host_0, { pageId: "pageId", currentPage: "currentPage" }, { doFilter: "doFilter" }, []);


// EXTERNAL MODULE: ./node_modules/@fortawesome/free-regular-svg-icons/index.js
var free_regular_svg_icons = __webpack_require__("c/eB");

// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/index.js
var free_solid_svg_icons = __webpack_require__("YTkO");

// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-list-component.ts
var base_list_component = __webpack_require__("Ki94");

// EXTERNAL MODULE: ./src/app/shared/consts/actions.ts
var actions = __webpack_require__("CIyo");

// EXTERNAL MODULE: ./src/app/shared/consts/order-options.ts
var order_options = __webpack_require__("a7yC");

// EXTERNAL MODULE: ./src/app/shared/utils/number.util.ts
var number_util = __webpack_require__("qzEW");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-list/customers-list.component.ts







class customers_list_component_CustomersListComponent extends base_list_component["a" /* BaseListComponent */] {
    constructor(router, companyService, customerService, dataService, menuService, requestService, toastrService, alertService, authService, messagesService) {
        super(alertService, authService, messagesService);
        this.router = router;
        this.companyService = companyService;
        this.customerService = customerService;
        this.dataService = dataService;
        this.menuService = menuService;
        this.requestService = requestService;
        this.toastrService = toastrService;
        this.confirmMessage = '';
        this.faBan = free_solid_svg_icons["faBan"];
        this.faUser = free_regular_svg_icons["faUser"];
        this.feedbackMessage = '';
        this.hasOnlinePayment = false;
        this.pageId = 'customerList';
        this.companyService.companyId = this.authService.loggedUser.id;
        this.customerService.companyId = this.authService.loggedUser.id;
    }
    ngOnInit() {
        this.loadFilterState();
        this.list();
        this.initGridContextMenu();
    }
    applyFilters(filterList) {
        this.currentPage = 1;
        this.filterList = filterList;
        this.formFilterRef.closeForm();
        this.addCriteria();
    }
    block() {
        if (this.inDemoMode(this.messagesService.getMessage('MSG.INFO.014'))) {
            return;
        }
        this.loadState();
        this.customerService.blockOrUnblockCustomer(this.customer).subscribe(() => {
            this.loadState();
            this.toastrService.success(this.messagesService.getMessage(this.customer.usuario.bloqueado ? 'MSG.SUCESSO.026' : 'MSG.SUCESSO.025', [this.customer.nome]));
            this.list();
        }, (resp) => {
            this.loadState();
            this.requestService.handleError(resp, this.toastrService);
        });
    }
    lockOnlinePaymentReceivement() {
        if (this.inDemoMode(this.messagesService.getMessage('MSG.INFO.014'))) {
            return;
        }
        this.loadState();
        this.customerService.lockOnlinePaymentReceivement(this.customer.id).subscribe(() => {
            this.toastrService.success(this.messagesService.getMessage('MSG.SUCESSO.046', [this.customer.nome, !this.customer.pagamentoOnlineBloqueado ? 'bloqueado' : 'desbloqueado']));
            this.list();
        }, (resp) => {
            this.loadState();
            this.requestService.handleError(resp, this.toastrService);
        });
    }
    delete() {
    }
    edit(id) {
        if (number_util["a" /* NumberUtil */].isNotNullOrZero(id)) {
            this.router.navigate([`admin/wholesale/customers/${id}/edit`]);
        }
        else {
            this.router.navigate([`admin/wholesale/customers/new`]);
        }
    }
    getCustomerStatus(status) {
        return this.customerService.getCustomerStatus(status);
    }
    initGridContextMenu() {
        this.menuService.onItemClick().subscribe(menu => {
            const data = menu.item.data;
            if (data && data.action) {
                this.customer = data.entity;
                switch (data.action) {
                    case actions["a" /* ACTIONS */].BLOCK:
                        this.setConfirmMessage();
                        this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.015', [
                            this.customer.usuario.bloqueado ? 'desbloquear' : 'bloquear', this.customer.nome
                        ]), result => {
                            if (result.value) {
                                this.block();
                            }
                        });
                        break;
                    case actions["a" /* ACTIONS */].LOCK:
                        this.setConfirmMessage();
                        this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.038', [this.customer.nome]), result => {
                            if (result.value) {
                                this.lockOnlinePaymentReceivement();
                            }
                        });
                        break;
                    case actions["a" /* ACTIONS */].SHOW_PURCHASE_HISTORY:
                        this.dataService.setExtras('backToCustomerWholesale', true);
                        this.router.navigate([`admin/consult/order-history/${this.customer.id}/customer`]);
                        break;
                }
            }
        });
    }
    list() {
        this.datasource = [];
        this.isLoading = true;
        this.searchCriteria.push('onlyConcentreCustomers:true');
        this.customerService.filter(this.searchCriteria, this.currentPage, ['nome', 'id'], order_options["a" /* ORDER_OPTIONS */].ASCENDING).subscribe(resultSet => {
            this.resultSet = resultSet;
            this.resultSet.content.forEach(customer => {
                const item = {
                    item: customer,
                    itemMenu: this.makeMenu(customer)
                };
                this.datasource.push(item);
            }, (resp) => this.requestService.handleError(resp, this.toastrService));
        }, (resp) => this.requestService.handleError(resp, this.toastrService), () => this.isLoading = false);
    }
    makeMenu(customer) {
        const menuItems = [{
                icon: 'edit', title: 'Editar', link: `admin/wholesale/customers/${customer.id}/edit`
            }, {
                icon: 'toggle-right-outline',
                title: customer.usuario.bloqueado
                    ? 'Desbloquear usuário'
                    : 'Bloquear usuário',
                data: { action: actions["a" /* ACTIONS */].BLOCK, entity: customer }
            }];
        if (this.hasOnlinePayment) {
            menuItems.push({
                icon: 'toggle-right-outline',
                title: customer.pagamentoOnlineBloqueado
                    ? 'Desbloquear receb. de Pagamento'
                    : 'Bloquear receb. de Pagamento',
                data: { action: actions["a" /* ACTIONS */].LOCK, entity: customer }
            });
        }
        menuItems.push({
            icon: 'layers',
            title: 'Historico de Pedidos',
            link: `admin/consult/order-history/${customer.id}/customer`
        });
        return menuItems;
    }
    setConfirmMessage() { }
}

// EXTERNAL MODULE: ./node_modules/@angular/router/fesm2015/router.js + 5 modules
var fesm2015_router = __webpack_require__("iInd");

// EXTERNAL MODULE: ./src/app/shared/services/empresa.service.ts
var empresa_service = __webpack_require__("x715");

// EXTERNAL MODULE: ./src/app/shared/services/cliente.service.ts
var cliente_service = __webpack_require__("eCBd");

// EXTERNAL MODULE: ./src/app/shared/services/nav-extras.service.ts
var nav_extras_service = __webpack_require__("JmCY");

// EXTERNAL MODULE: ./src/app/shared/services/request.service.ts
var request_service = __webpack_require__("a9NN");

// EXTERNAL MODULE: ./src/app/shared/services/alert.service.ts
var alert_service = __webpack_require__("Cmua");

// EXTERNAL MODULE: ./src/app/shared/services/auth.service.ts + 3 modules
var auth_service = __webpack_require__("IYfF");

// EXTERNAL MODULE: ./src/app/shared/services/messages.service.ts + 1 modules
var messages_service = __webpack_require__("N7YL");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-list/customers-list.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 








































var styles_CustomersListComponent = [];
var RenderType_CustomersListComponent = core["ɵcrt"]({ encapsulation: 2, styles: styles_CustomersListComponent, data: {} });

function View_CustomersListComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-badge", [["class", "ml-3"], ["status", "danger"], ["text", "Recebimento de Pgto. on-line bloqueado"]], null, null, null, badge_component_ngfactory["b" /* View_BadgeComponent_0 */], badge_component_ngfactory["a" /* RenderType_BadgeComponent */])), core["ɵdid"](1, 49152, null, 0, badge_component["a" /* BadgeComponent */], [], { status: [0, "status"], text: [1, "text"] }, null)], function (_ck, _v) { var currVal_0 = "danger"; var currVal_1 = "Recebimento de Pgto. on-line bloqueado"; _ck(_v, 1, 0, currVal_0, currVal_1); }, null); }
function View_CustomersListComponent_4(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "span", [["class", "ml-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 1, "fa-icon", [["class", "text-danger ng-fa-icon"], ["size", "lg"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵdid"](2, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"], size: [1, "size"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_2 = _co.faBan; var currVal_3 = "lg"; _ck(_v, 2, 0, currVal_2, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 2).title; var currVal_1 = core["ɵnov"](_v, 2).renderedIconHTML; _ck(_v, 1, 0, currVal_0, currVal_1); }); }
function View_CustomersListComponent_5(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 3, "omni-grid-label", [["label", "C\u00F3digo do PDV"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](1, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵeld"](2, 0, null, 0, 1, "span", [["class", "text-danger"]], null, null, null, null, null)), (_l()(), core["ɵted"](3, null, [" ", " "]))], function (_ck, _v) { var currVal_0 = "C\u00F3digo do PDV"; _ck(_v, 1, 0, currVal_0); }, function (_ck, _v) { var currVal_1 = _v.parent.context.$implicit.item.codigoDoPdv; _ck(_v, 3, 0, currVal_1); }); }
function View_CustomersListComponent_6(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "span", [], null, null, null, null, null)), (_l()(), core["ɵted"](1, null, [" ", " "])), core["ɵppd"](2, 1)], null, function (_ck, _v) { var currVal_0 = core["ɵunv"](_v, 1, 0, _ck(_v, 2, 0, core["ɵnov"](_v.parent.parent.parent, 3), _v.parent.context.$implicit.item.enderecosDeEntrega[0])); _ck(_v, 1, 0, currVal_0); }); }
function View_CustomersListComponent_7(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 3, "omni-grid-label", [["label", "Data de Nascimento"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](1, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], inline: [1, "inline"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "])), core["ɵppd"](3, 2)], function (_ck, _v) { var currVal_0 = "Data de Nascimento"; var currVal_1 = false; _ck(_v, 1, 0, currVal_0, currVal_1); }, function (_ck, _v) { var currVal_2 = core["ɵunv"](_v, 2, 0, _ck(_v, 3, 0, core["ɵnov"](_v.parent.parent.parent, 5), _v.parent.context.$implicit.item.dataNascimento, "dd/MM/yyyy")); _ck(_v, 2, 0, currVal_2); }); }
function View_CustomersListComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 43, "div", [["class", "col-12 col-sm-12 col-md-12 col-lg-6 mb-2 pr-1 pl-1"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 42, "div", [["class", "card card-grid"]], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 14, "div", [["class", "card-title"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 13, "div", [["class", "d-flex flex-row align-items-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 10, "div", [["class", "flex-grow-1"]], null, null, null, null, null)), (_l()(), core["ɵeld"](5, 0, null, null, 9, "div", [["class", "d-flex flex-row align-items-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](6, 0, null, null, 1, "h5", [], null, null, null, null, null)), (_l()(), core["ɵted"](7, null, ["", ""])), (_l()(), core["ɵeld"](8, 0, null, null, 2, "omni-badge", [["class", "ml-3"]], null, null, null, badge_component_ngfactory["b" /* View_BadgeComponent_0 */], badge_component_ngfactory["a" /* RenderType_BadgeComponent */])), core["ɵdid"](9, 49152, null, 0, badge_component["a" /* BadgeComponent */], [], { status: [0, "status"], text: [1, "text"] }, null), core["ɵppd"](10, 1), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersListComponent_3)), core["ɵdid"](12, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersListComponent_4)), core["ɵdid"](14, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](15, 0, null, null, 1, "omni-dropdown-menu", [], null, null, null, dropdown_menu_component_ngfactory["b" /* View_DropdownMenuComponent_0 */], dropdown_menu_component_ngfactory["a" /* RenderType_DropdownMenuComponent */])), core["ɵdid"](16, 114688, null, 0, dropdown_menu_component["a" /* DropdownMenuComponent */], [], { optionsList: [0, "optionsList"] }, null), (_l()(), core["ɵeld"](17, 0, null, null, 26, "div", [["class", "card-body"]], null, null, null, null, null)), (_l()(), core["ɵeld"](18, 0, null, null, 25, "div", [["class", "d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](19, 0, null, null, 10, "div", [["class", "d-flex justify-content-between"]], null, null, null, null, null)), (_l()(), core["ɵeld"](20, 0, null, null, 3, "omni-grid-label", [["label", "Tipo de Pessoa"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](21, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](22, 0, [" ", " "])), core["ɵppd"](23, 1), (_l()(), core["ɵeld"](24, 0, null, null, 3, "omni-grid-label", [["label", "CPF/CNPJ"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](25, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](26, 0, [" ", " "])), core["ɵppd"](27, 1), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersListComponent_5)), core["ɵdid"](29, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](30, 0, null, null, 3, "omni-grid-label", [["label", "Endere\u00E7o"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](31, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_CustomersListComponent_6)), core["ɵdid"](33, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](34, 0, null, null, 9, "div", [["class", "d-flex justify-content-between"]], null, null, null, null, null)), (_l()(), core["ɵeld"](35, 0, null, null, 3, "omni-grid-label", [["label", "Telefone"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](36, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], inline: [1, "inline"] }, null), (_l()(), core["ɵted"](37, 0, [" ", " "])), core["ɵppd"](38, 1), (_l()(), core["ɵeld"](39, 0, null, null, 2, "omni-grid-label", [["class", "pl-2 pr-2"], ["label", "E-mail"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](40, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], inline: [1, "inline"] }, null), (_l()(), core["ɵted"](41, 0, [" ", " "])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersListComponent_7)), core["ɵdid"](43, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_1 = _co.getCustomerStatus(_v.context.$implicit.item.ativo); var currVal_2 = core["ɵunv"](_v, 9, 1, _ck(_v, 10, 0, core["ɵnov"](_v.parent.parent, 0), _v.context.$implicit.item.ativo)); _ck(_v, 9, 0, currVal_1, currVal_2); var currVal_3 = _v.context.$implicit.item.pagamentoOnlineBloqueado; _ck(_v, 12, 0, currVal_3); var currVal_4 = _v.context.$implicit.item.usuario.bloqueado; _ck(_v, 14, 0, currVal_4); var currVal_5 = _v.context.$implicit.itemMenu; _ck(_v, 16, 0, currVal_5); var currVal_6 = "Tipo de Pessoa"; _ck(_v, 21, 0, currVal_6); var currVal_8 = "CPF/CNPJ"; _ck(_v, 25, 0, currVal_8); var currVal_10 = _v.context.$implicit.item.codigoDoPdv; _ck(_v, 29, 0, currVal_10); var currVal_11 = "Endere\u00E7o"; _ck(_v, 31, 0, currVal_11); var currVal_12 = (_v.context.$implicit.item.enderecosDeEntrega && (_v.context.$implicit.item.enderecosDeEntrega.length > 0)); _ck(_v, 33, 0, currVal_12); var currVal_13 = "Telefone"; var currVal_14 = false; _ck(_v, 36, 0, currVal_13, currVal_14); var currVal_16 = "E-mail"; var currVal_17 = false; _ck(_v, 40, 0, currVal_16, currVal_17); var currVal_19 = _v.context.$implicit.item.dataNascimento; _ck(_v, 43, 0, currVal_19); }, function (_ck, _v) { var currVal_0 = _v.context.$implicit.item.nome; _ck(_v, 7, 0, currVal_0); var currVal_7 = core["ɵunv"](_v, 22, 0, _ck(_v, 23, 0, core["ɵnov"](_v.parent.parent, 1), _v.context.$implicit.item.tipoPessoa)); _ck(_v, 22, 0, currVal_7); var currVal_9 = core["ɵunv"](_v, 26, 0, _ck(_v, 27, 0, core["ɵnov"](_v.parent.parent, 2), _v.context.$implicit.item.cpf)); _ck(_v, 26, 0, currVal_9); var currVal_15 = core["ɵunv"](_v, 37, 0, _ck(_v, 38, 0, core["ɵnov"](_v.parent.parent, 4), _v.context.$implicit.item.telefone)); _ck(_v, 37, 0, currVal_15); var currVal_18 = _v.context.$implicit.item.usuario.login; _ck(_v, 41, 0, currVal_18); }); }
function View_CustomersListComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "div", [["class", "d-flex align-items-stretch flex-wrap mt-2"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersListComponent_2)), core["ɵdid"](2, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.datasource; _ck(_v, 2, 0, currVal_0); }, null); }
function View_CustomersListComponent_8(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-pagination", [], null, [[null, "pageChange"], [null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("pageChange" === en)) {
        var pd_1 = (_co.changePage($event) !== false);
        ad = (pd_1 && ad);
    } return ad; }, pagination_component_ngfactory["b" /* View_PaginationComponent_0 */], pagination_component_ngfactory["a" /* RenderType_PaginationComponent */])), core["ɵdid"](1, 114688, null, 0, pagination_component["a" /* PaginationComponent */], [], { currentPage: [0, "currentPage"], totalPages: [1, "totalPages"] }, { pageChange: "pageChange" })], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.currentPage; var currVal_1 = _co.resultSet.totalPages; _ck(_v, 1, 0, currVal_0, currVal_1); }, null); }
function View_CustomersListComponent_0(_l) { return core["ɵvid"](0, [core["ɵpid"](0, situacao_pipe["a" /* SituacaoPipe */], []), core["ɵpid"](0, person_type_pipe["a" /* PersonTypePipe */], []), core["ɵpid"](0, cpf_cnpj_pipe["a" /* CpfCnpjPipe */], []), core["ɵpid"](0, address_pipe["a" /* AddressPipe */], []), core["ɵpid"](0, telefone_pipe["a" /* TelefonePipe */], []), core["ɵpid"](0, common["f" /* DatePipe */], [core["LOCALE_ID"]]), core["ɵqud"](671088640, 1, { formFilterRef: 0 }), (_l()(), core["ɵeld"](7, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](8, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](9, 0, null, null, 1, "omni-page-title", [["pageTitle", "Clientes"], ["tutorialTag", "wholesale-cliente-listar"]], null, null, null, page_title_component_ngfactory["b" /* View_PageTitleComponent_0 */], page_title_component_ngfactory["a" /* RenderType_PageTitleComponent */])), core["ɵdid"](10, 114688, null, 0, page_title_component["a" /* PageTitleComponent */], [fesm2015["Rb" /* NbDialogService */]], { icon: [0, "icon"], tutorial: [1, "tutorial"], tutorialTag: [2, "tutorialTag"], pageTitle: [3, "pageTitle"] }, null), (_l()(), core["ɵeld"](11, 0, null, null, 14, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](12, 0, null, null, 13, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](13, 0, null, null, 12, "nb-card", [], [[2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "accent", null], [2, "accent-primary", null], [2, "accent-info", null], [2, "accent-success", null], [2, "accent-warning", null], [2, "accent-danger", null], [2, "accent-basic", null], [2, "accent-control", null]], null, null, index_ngfactory["O" /* View_NbCardComponent_0 */], index_ngfactory["r" /* RenderType_NbCardComponent */])), core["ɵdid"](14, 49152, null, 0, fesm2015["jb" /* NbCardComponent */], [], null, null), (_l()(), core["ɵeld"](15, 0, null, 1, 10, "nb-card-body", [["class", "flat-body"]], null, null, null, index_ngfactory["N" /* View_NbCardBodyComponent_0 */], index_ngfactory["q" /* RenderType_NbCardBodyComponent */])), core["ɵdid"](16, 49152, null, 0, fesm2015["ib" /* NbCardBodyComponent */], [], null, null), (_l()(), core["ɵeld"](17, 0, null, 0, 8, "div", [["class", "d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](18, 0, null, null, 1, "omni-filter", [], null, [[null, "resultSetChange"], [null, "newButtonClick"], [null, "filterButtonClick"], [null, "updateFilterList"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("resultSetChange" === en)) {
        var pd_0 = ((_co.resultSet = $event) !== false);
        ad = (pd_0 && ad);
    } if (("newButtonClick" === en)) {
        var pd_1 = (_co.edit() !== false);
        ad = (pd_1 && ad);
    } if (("filterButtonClick" === en)) {
        var pd_2 = (_co.showFormFilter() !== false);
        ad = (pd_2 && ad);
    } if (("updateFilterList" === en)) {
        var pd_3 = (_co.applyFilters($event) !== false);
        ad = (pd_3 && ad);
    } return ad; }, filter_component_ngfactory["b" /* View_FilterComponent_0 */], filter_component_ngfactory["a" /* RenderType_FilterComponent */])), core["ɵdid"](19, 114688, null, 0, filter_component["a" /* FilterComponent */], [], { filterList: [0, "filterList"], resultSet: [1, "resultSet"] }, { filterButtonClick: "filterButtonClick", newButtonClick: "newButtonClick", resultSetChange: "resultSetChange", updateFilterList: "updateFilterList" }), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersListComponent_1)), core["ɵdid"](21, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersListComponent_8)), core["ɵdid"](23, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](24, 0, null, null, 1, "omni-inline-loader", [["label", "Listando Clientes..."]], null, null, null, inline_loader_component_ngfactory["b" /* View_InlineLoaderComponent_0 */], inline_loader_component_ngfactory["a" /* RenderType_InlineLoaderComponent */])), core["ɵdid"](25, 114688, null, 0, inline_loader_component["a" /* InlineLoaderComponent */], [], { label: [0, "label"], refreshState: [1, "refreshState"] }, null), (_l()(), core["ɵeld"](26, 0, null, null, 3, "omni-form-filter", [], null, [["window", "keyup"], [null, "click"]], function (_v, en, $event) { var ad = true; if (("window:keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 27).onEscape($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (core["ɵnov"](_v, 27).onClick($event) !== false);
        ad = (pd_1 && ad);
    } return ad; }, form_filter_component_ngfactory["b" /* View_FormFilterComponent_0 */], form_filter_component_ngfactory["a" /* RenderType_FormFilterComponent */])), core["ɵdid"](27, 49152, [[1, 4], ["formFilter", 4]], 0, form_filter_component["a" /* FormFilterComponent */], [], null, null), (_l()(), core["ɵeld"](28, 0, null, 0, 1, "omni-customers-filter", [], null, [[null, "doFilter"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("doFilter" === en)) {
        var pd_0 = (_co.applyFilters($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, View_CustomersFilterComponent_0, RenderType_CustomersFilterComponent)), core["ɵdid"](29, 114688, [["customerFilter", 4]], 0, customers_filter_component_CustomersFilterComponent, [fesm2015_forms["g" /* FormBuilder */]], { pageId: [0, "pageId"], currentPage: [1, "currentPage"] }, { doFilter: "doFilter" })], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.faUser; var currVal_1 = true; var currVal_2 = "wholesale-cliente-listar"; var currVal_3 = "Clientes"; _ck(_v, 10, 0, currVal_0, currVal_1, currVal_2, currVal_3); var currVal_24 = _co.filterList; var currVal_25 = _co.resultSet; _ck(_v, 19, 0, currVal_24, currVal_25); var currVal_26 = ((_co.datasource.length > 0) && !_co.isLoading); _ck(_v, 21, 0, currVal_26); var currVal_27 = ((((_co.resultSet == null) ? null : _co.resultSet.totalPages) > 1) && !_co.isLoading); _ck(_v, 23, 0, currVal_27); var currVal_28 = "Listando Clientes..."; var currVal_29 = _co.isLoading; _ck(_v, 25, 0, currVal_28, currVal_29); var currVal_30 = _co.pageId; var currVal_31 = _co.currentPage; _ck(_v, 29, 0, currVal_30, currVal_31); }, function (_ck, _v) { var currVal_4 = core["ɵnov"](_v, 14).tiny; var currVal_5 = core["ɵnov"](_v, 14).small; var currVal_6 = core["ɵnov"](_v, 14).medium; var currVal_7 = core["ɵnov"](_v, 14).large; var currVal_8 = core["ɵnov"](_v, 14).giant; var currVal_9 = core["ɵnov"](_v, 14).primary; var currVal_10 = core["ɵnov"](_v, 14).info; var currVal_11 = core["ɵnov"](_v, 14).success; var currVal_12 = core["ɵnov"](_v, 14).warning; var currVal_13 = core["ɵnov"](_v, 14).danger; var currVal_14 = core["ɵnov"](_v, 14).basic; var currVal_15 = core["ɵnov"](_v, 14).control; var currVal_16 = core["ɵnov"](_v, 14).hasAccent; var currVal_17 = core["ɵnov"](_v, 14).primaryAccent; var currVal_18 = core["ɵnov"](_v, 14).infoAccent; var currVal_19 = core["ɵnov"](_v, 14).successAccent; var currVal_20 = core["ɵnov"](_v, 14).warningAccent; var currVal_21 = core["ɵnov"](_v, 14).dangerAccent; var currVal_22 = core["ɵnov"](_v, 14).basicAccent; var currVal_23 = core["ɵnov"](_v, 14).controlAccent; _ck(_v, 13, 1, [currVal_4, currVal_5, currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23]); }); }
function View_CustomersListComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customers-list", [], null, null, null, View_CustomersListComponent_0, RenderType_CustomersListComponent)), core["ɵdid"](1, 114688, null, 0, customers_list_component_CustomersListComponent, [fesm2015_router["l" /* Router */], empresa_service["a" /* EmpresaService */], cliente_service["a" /* ClienteService */], nav_extras_service["a" /* NavExtrasService */], fesm2015["wc" /* NbMenuService */], request_service["a" /* RequestService */], fesm2015["Ld" /* NbToastrService */], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomersListComponentNgFactory = core["ɵccf"]("omni-customers-list", customers_list_component_CustomersListComponent, View_CustomersListComponent_Host_0, {}, {}, []);


// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ngfactory.js + 1 modules
var form_container_component_ngfactory = __webpack_require__("+aW9");

// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ts
var form_container_component = __webpack_require__("NX1Y");

// EXTERNAL MODULE: ./src/app/shared/directives/input-phone.directive.ts
var input_phone_directive = __webpack_require__("bB9G");

// EXTERNAL MODULE: ./src/app/shared/directives/input-cpf-cnpj.directive.ts
var input_cpf_cnpj_directive = __webpack_require__("8kGa");

// EXTERNAL MODULE: ./src/app/shared/directives/input-integer.directive.ts
var input_integer_directive = __webpack_require__("CwyO");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-delivery-address-edit/customers-delivery-address-edit.component.scss.shim.ngstyle.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 
var styles = ["h3[_ngcontent-%COMP%]{color:var(--color-primary-default)}"];


// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/edit-delivery-address-dialog/edit-delivery-address-dialog.component.ngfactory.js + 1 modules
var edit_delivery_address_dialog_component_ngfactory = __webpack_require__("EXuQ");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/edit-delivery-address-dialog/edit-delivery-address-dialog.component.ts
var edit_delivery_address_dialog_component = __webpack_require__("ASa5");

// EXTERNAL MODULE: ./src/app/shared/services/consulta-cep.service.ts
var consulta_cep_service = __webpack_require__("AEiv");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-delivery-address-edit/customers-delivery-address-edit.component.ts


class customers_delivery_address_edit_component_CustomerDeliveryAddressEditComponent {
    constructor(fb, dialogService, messagesService, toastrService) {
        this.fb = fb;
        this.dialogService = dialogService;
        this.messagesService = messagesService;
        this.toastrService = toastrService;
        this.isLoading = false;
        this.formChange = new core["EventEmitter"]();
    }
    get addresses() {
        return this.form.get('deliveryAddresses').value;
    }
    get editIcon() {
        return free_solid_svg_icons["faEdit"];
    }
    get removeIcon() {
        return free_solid_svg_icons["faTrash"];
    }
    get starIcon() {
        return free_solid_svg_icons["faStar"];
    }
    ngOnInit() {
    }
    editAddress(address, index) {
        this.addressEditDialog.populateForm(address, index);
        this.openEditAddressDialog();
    }
    openEditAddressDialog() {
        this.addressEditDialog.dialogRef = this.dialogService.open(this.addressEditDialog.dialogTemplateRef, {
            hasScroll: false
        });
    }
    removeAll() {
        this.addresses.clear();
        this.onChangeForm();
    }
    remove(index) {
        this.toastrService.info(this.messagesService.getMessage('MSG.SUCESSO.022', ['Endereço de Entrega']));
        this.addresses.controls.splice(index, 1);
    }
    updateAddress(addressForm) {
        const isEditing = addressForm.get('index').value >= 0;
        if (isEditing) {
            this.addresses.controls[addressForm.get('index').value].patchValue({
                id: addressForm.get('id').value,
                customerId: addressForm.get('customerId').value,
                cityId: addressForm.get('cityId').value,
                cityName: addressForm.get('cityName').value,
                cityIbgeId: addressForm.get('cityIbgeId').value,
                uf: addressForm.get('uf').value,
                cep: addressForm.get('cep').value,
                address: addressForm.get('address').value,
                number: addressForm.get('number').value,
                neighborhood: addressForm.get('neighborhood').value,
                complement: addressForm.get('complement').value,
                description: addressForm.get('description').value,
                reference: addressForm.get('reference').value,
                mainAddress: addressForm.get('mainAddress').value
            });
            if (addressForm.get('mainAddress').value === true) {
                this.addresses.controls.filter((control, idx) => addressForm.get('index').value !== idx).forEach(control => {
                    control.get('mainAddress').setValue(false);
                });
            }
        }
        else {
            this.addresses.push(this.fb.group({
                id: addressForm.get('id').value,
                customerId: addressForm.get('customerId').value,
                cityId: addressForm.get('cityId').value,
                cityName: addressForm.get('cityName').value,
                cityIbgeId: addressForm.get('cityIbgeId').value,
                uf: addressForm.get('uf').value,
                cep: addressForm.get('cep').value,
                address: addressForm.get('address').value,
                number: addressForm.get('number').value,
                neighborhood: addressForm.get('neighborhood').value,
                complement: addressForm.get('complement').value,
                description: addressForm.get('description').value,
                reference: addressForm.get('reference').value,
                mainAddress: addressForm.get('mainAddress').value
            }));
        }
        this.onChangeForm();
    }
    onChangeForm() {
        this.formChange.emit(this.form);
    }
}

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-delivery-address-edit/customers-delivery-address-edit.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 
















var styles_CustomerDeliveryAddressEditComponent = [styles];
var RenderType_CustomerDeliveryAddressEditComponent = core["ɵcrt"]({ encapsulation: 0, styles: styles_CustomerDeliveryAddressEditComponent, data: {} });

function View_CustomerDeliveryAddressEditComponent_4(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 4, "fa-icon", [["class", "text-warning ng-fa-icon"], ["nbTooltip", "Endere\u00E7o Principal"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵdid"](1, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"] }, null), core["ɵprd"](512, null, fesm2015["Tb" /* NbDynamicOverlay */], fesm2015["Tb" /* NbDynamicOverlay */], [fesm2015["Gc" /* NbOverlayService */], core["ComponentFactoryResolver"], core["NgZone"], fesm2015["Bc" /* NbOverlayContainer */]]), core["ɵprd"](512, null, fesm2015["Ub" /* NbDynamicOverlayHandler */], fesm2015["Ub" /* NbDynamicOverlayHandler */], [fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], fesm2015["Tb" /* NbDynamicOverlay */]]), core["ɵdid"](4, 4931584, null, 0, fesm2015["Pd" /* NbTooltipDirective */], [core["ElementRef"], fesm2015["Ub" /* NbDynamicOverlayHandler */]], { content: [0, "content"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_2 = _co.starIcon; _ck(_v, 1, 0, currVal_2); var currVal_3 = "Endere\u00E7o Principal"; _ck(_v, 4, 0, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).title; var currVal_1 = core["ɵnov"](_v, 1).renderedIconHTML; _ck(_v, 0, 0, currVal_0, currVal_1); }); }
function View_CustomerDeliveryAddressEditComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 3, "h3", [], null, null, null, null, null)), (_l()(), core["ɵted"](1, null, [" ", " "])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomerDeliveryAddressEditComponent_4)), core["ɵdid"](3, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null)], function (_ck, _v) { var currVal_1 = (_v.parent.context.$implicit.get("mainAddress").value === true); _ck(_v, 3, 0, currVal_1); }, function (_ck, _v) { var currVal_0 = _v.parent.context.$implicit.get("description").value; _ck(_v, 1, 0, currVal_0); }); }
function View_CustomerDeliveryAddressEditComponent_5(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "omni-grid-label", [["label", "Complemento"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](1, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_0 = "Complemento"; _ck(_v, 1, 0, currVal_0); }, function (_ck, _v) { var currVal_1 = _v.parent.context.$implicit.get("complement").value; _ck(_v, 2, 0, currVal_1); }); }
function View_CustomerDeliveryAddressEditComponent_6(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "omni-grid-label", [["label", "Ponto de Refer\u00EAncia"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](1, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_0 = "Ponto de Refer\u00EAncia"; _ck(_v, 1, 0, currVal_0); }, function (_ck, _v) { var currVal_1 = _v.parent.context.$implicit.get("reference").value; _ck(_v, 2, 0, currVal_1); }); }
function View_CustomerDeliveryAddressEditComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 39, "div", [["class", "col-12 col-sm-12 col-md-12 col-lg-6 mb-2 pr-1 pl-1"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 38, "div", [["class", "card card-grid"]], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 18, "div", [["class", "card-title"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 17, "div", [["class", "d-flex flex-row align-items-center justify-content-between w-100"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomerDeliveryAddressEditComponent_3)), core["ɵdid"](5, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](6, 0, null, null, 14, "div", [["class", "d-flex align-items-center justify-content-end"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 6, "button", [["class", "mr-2"], ["nbButton", ""], ["nbTooltip", "Editar Endere\u00E7o"], ["size", "small"], ["status", "primary"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 8).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.editAddress(_v.context.$implicit, _v.context.index) !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](8, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], outline: [2, "outline"] }, null), core["ɵprd"](512, null, fesm2015["Tb" /* NbDynamicOverlay */], fesm2015["Tb" /* NbDynamicOverlay */], [fesm2015["Gc" /* NbOverlayService */], core["ComponentFactoryResolver"], core["NgZone"], fesm2015["Bc" /* NbOverlayContainer */]]), core["ɵprd"](512, null, fesm2015["Ub" /* NbDynamicOverlayHandler */], fesm2015["Ub" /* NbDynamicOverlayHandler */], [fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], fesm2015["Tb" /* NbDynamicOverlay */]]), core["ɵdid"](11, 4931584, null, 0, fesm2015["Pd" /* NbTooltipDirective */], [core["ElementRef"], fesm2015["Ub" /* NbDynamicOverlayHandler */]], { content: [0, "content"] }, null), (_l()(), core["ɵeld"](12, 0, null, 0, 1, "fa-icon", [["class", "ng-fa-icon"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵdid"](13, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"] }, null), (_l()(), core["ɵeld"](14, 0, null, null, 6, "button", [["nbButton", ""], ["nbTooltip", "Excluir Endere\u00E7o"], ["size", "small"], ["status", "danger"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 15).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.remove(_v.context.index) !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](15, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], outline: [2, "outline"] }, null), core["ɵprd"](512, null, fesm2015["Tb" /* NbDynamicOverlay */], fesm2015["Tb" /* NbDynamicOverlay */], [fesm2015["Gc" /* NbOverlayService */], core["ComponentFactoryResolver"], core["NgZone"], fesm2015["Bc" /* NbOverlayContainer */]]), core["ɵprd"](512, null, fesm2015["Ub" /* NbDynamicOverlayHandler */], fesm2015["Ub" /* NbDynamicOverlayHandler */], [fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], fesm2015["Tb" /* NbDynamicOverlay */]]), core["ɵdid"](18, 4931584, null, 0, fesm2015["Pd" /* NbTooltipDirective */], [core["ElementRef"], fesm2015["Ub" /* NbDynamicOverlayHandler */]], { content: [0, "content"] }, null), (_l()(), core["ɵeld"](19, 0, null, 0, 1, "fa-icon", [["class", "ng-fa-icon"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵdid"](20, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"] }, null), (_l()(), core["ɵeld"](21, 0, null, null, 18, "div", [["class", "card-body"]], null, null, null, null, null)), (_l()(), core["ɵeld"](22, 0, null, null, 17, "div", [["class", "d-flex flex-row align-items-start"]], null, null, null, null, null)), (_l()(), core["ɵeld"](23, 0, null, null, 16, "div", [["class", "d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](24, 0, null, null, 2, "omni-grid-label", [["label", "CEP"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](25, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](26, 0, [" ", " "])), (_l()(), core["ɵeld"](27, 0, null, null, 2, "omni-grid-label", [["label", "Endere\u00E7o"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](28, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](29, 0, [" ", ", ", " "])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomerDeliveryAddressEditComponent_5)), core["ɵdid"](31, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](32, 0, null, null, 2, "omni-grid-label", [["label", "Bairro"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](33, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](34, 0, [" ", " "])), (_l()(), core["ɵeld"](35, 0, null, null, 2, "omni-grid-label", [["label", "Munic\u00EDpio"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](36, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵted"](37, 0, [" ", "/", " "])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomerDeliveryAddressEditComponent_6)), core["ɵdid"](39, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = _v.context.$implicit.get("description").value; _ck(_v, 5, 0, currVal_0); var currVal_27 = "small"; var currVal_28 = "primary"; var currVal_29 = true; _ck(_v, 8, 0, currVal_27, currVal_28, currVal_29); var currVal_30 = "Editar Endere\u00E7o"; _ck(_v, 11, 0, currVal_30); var currVal_33 = _co.editIcon; _ck(_v, 13, 0, currVal_33); var currVal_60 = "small"; var currVal_61 = "danger"; var currVal_62 = true; _ck(_v, 15, 0, currVal_60, currVal_61, currVal_62); var currVal_63 = "Excluir Endere\u00E7o"; _ck(_v, 18, 0, currVal_63); var currVal_66 = _co.removeIcon; _ck(_v, 20, 0, currVal_66); var currVal_67 = "CEP"; _ck(_v, 25, 0, currVal_67); var currVal_69 = "Endere\u00E7o"; _ck(_v, 28, 0, currVal_69); var currVal_72 = _v.context.$implicit.get("complement").value; _ck(_v, 31, 0, currVal_72); var currVal_73 = "Bairro"; _ck(_v, 33, 0, currVal_73); var currVal_75 = "Munic\u00EDpio"; _ck(_v, 36, 0, currVal_75); var currVal_78 = _v.context.$implicit.get("reference").value; _ck(_v, 39, 0, currVal_78); }, function (_ck, _v) { var currVal_1 = core["ɵnov"](_v, 8).filled; var currVal_2 = core["ɵnov"](_v, 8).outline; var currVal_3 = core["ɵnov"](_v, 8).ghost; var currVal_4 = core["ɵnov"](_v, 8).hero; var currVal_5 = core["ɵnov"](_v, 8).fullWidth; var currVal_6 = core["ɵnov"](_v, 8).disabled; var currVal_7 = core["ɵnov"](_v, 8).disabled; var currVal_8 = core["ɵnov"](_v, 8).tabbable; var currVal_9 = core["ɵnov"](_v, 8).tiny; var currVal_10 = core["ɵnov"](_v, 8).small; var currVal_11 = core["ɵnov"](_v, 8).medium; var currVal_12 = core["ɵnov"](_v, 8).large; var currVal_13 = core["ɵnov"](_v, 8).giant; var currVal_14 = core["ɵnov"](_v, 8).primary; var currVal_15 = core["ɵnov"](_v, 8).info; var currVal_16 = core["ɵnov"](_v, 8).success; var currVal_17 = core["ɵnov"](_v, 8).warning; var currVal_18 = core["ɵnov"](_v, 8).danger; var currVal_19 = core["ɵnov"](_v, 8).basic; var currVal_20 = core["ɵnov"](_v, 8).control; var currVal_21 = core["ɵnov"](_v, 8).rectangle; var currVal_22 = core["ɵnov"](_v, 8).round; var currVal_23 = core["ɵnov"](_v, 8).semiRound; var currVal_24 = core["ɵnov"](_v, 8).iconLeft; var currVal_25 = core["ɵnov"](_v, 8).iconRight; var currVal_26 = core["ɵnov"](_v, 8).transitions; _ck(_v, 7, 1, [currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26]); var currVal_31 = core["ɵnov"](_v, 13).title; var currVal_32 = core["ɵnov"](_v, 13).renderedIconHTML; _ck(_v, 12, 0, currVal_31, currVal_32); var currVal_34 = core["ɵnov"](_v, 15).filled; var currVal_35 = core["ɵnov"](_v, 15).outline; var currVal_36 = core["ɵnov"](_v, 15).ghost; var currVal_37 = core["ɵnov"](_v, 15).hero; var currVal_38 = core["ɵnov"](_v, 15).fullWidth; var currVal_39 = core["ɵnov"](_v, 15).disabled; var currVal_40 = core["ɵnov"](_v, 15).disabled; var currVal_41 = core["ɵnov"](_v, 15).tabbable; var currVal_42 = core["ɵnov"](_v, 15).tiny; var currVal_43 = core["ɵnov"](_v, 15).small; var currVal_44 = core["ɵnov"](_v, 15).medium; var currVal_45 = core["ɵnov"](_v, 15).large; var currVal_46 = core["ɵnov"](_v, 15).giant; var currVal_47 = core["ɵnov"](_v, 15).primary; var currVal_48 = core["ɵnov"](_v, 15).info; var currVal_49 = core["ɵnov"](_v, 15).success; var currVal_50 = core["ɵnov"](_v, 15).warning; var currVal_51 = core["ɵnov"](_v, 15).danger; var currVal_52 = core["ɵnov"](_v, 15).basic; var currVal_53 = core["ɵnov"](_v, 15).control; var currVal_54 = core["ɵnov"](_v, 15).rectangle; var currVal_55 = core["ɵnov"](_v, 15).round; var currVal_56 = core["ɵnov"](_v, 15).semiRound; var currVal_57 = core["ɵnov"](_v, 15).iconLeft; var currVal_58 = core["ɵnov"](_v, 15).iconRight; var currVal_59 = core["ɵnov"](_v, 15).transitions; _ck(_v, 14, 1, [currVal_34, currVal_35, currVal_36, currVal_37, currVal_38, currVal_39, currVal_40, currVal_41, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58, currVal_59]); var currVal_64 = core["ɵnov"](_v, 20).title; var currVal_65 = core["ɵnov"](_v, 20).renderedIconHTML; _ck(_v, 19, 0, currVal_64, currVal_65); var currVal_68 = _v.context.$implicit.get("cep").value; _ck(_v, 26, 0, currVal_68); var currVal_70 = _v.context.$implicit.get("address").value; var currVal_71 = _v.context.$implicit.get("number").value; _ck(_v, 29, 0, currVal_70, currVal_71); var currVal_74 = _v.context.$implicit.get("neighborhood").value; _ck(_v, 34, 0, currVal_74); var currVal_76 = _v.context.$implicit.get("cityName").value; var currVal_77 = _v.context.$implicit.get("uf").value; _ck(_v, 37, 0, currVal_76, currVal_77); }); }
function View_CustomerDeliveryAddressEditComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "div", [["class", "d-flex align-items-stretch flex-wrap mt-2"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomerDeliveryAddressEditComponent_2)), core["ɵdid"](2, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.addresses.controls; _ck(_v, 2, 0, currVal_0); }, null); }
function View_CustomerDeliveryAddressEditComponent_7(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 3, "div", [["class", "card"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 2, "div", [["class", "card-body text-muted text-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 1, "em", [], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Nenhum Endere\u00E7o de entrega incluso at\u00E9 o momento"]))], null, null); }
function View_CustomerDeliveryAddressEditComponent_0(_l) { return core["ɵvid"](0, [core["ɵqud"](671088640, 1, { addressEditDialog: 0 }), (_l()(), core["ɵeld"](1, 0, null, null, 25, "form", [["novalidate", ""]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "submit"], [null, "reset"]], function (_v, en, $event) { var ad = true; if (("submit" === en)) {
        var pd_0 = (core["ɵnov"](_v, 3).onSubmit($event) !== false);
        ad = (pd_0 && ad);
    } if (("reset" === en)) {
        var pd_1 = (core["ɵnov"](_v, 3).onReset() !== false);
        ad = (pd_1 && ad);
    } return ad; }, null, null)), core["ɵdid"](2, 16384, null, 0, fesm2015_forms["D" /* ɵangular_packages_forms_forms_z */], [], null, null), core["ɵdid"](3, 540672, null, 0, fesm2015_forms["l" /* FormGroupDirective */], [[8, null], [8, null]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["l" /* FormGroupDirective */]]), core["ɵdid"](5, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](6, 0, null, null, 20, "div", [["class", "card mt-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 19, "div", [["class", "card-body flat-body"]], null, null, null, null, null)), (_l()(), core["ɵeld"](8, 0, null, null, 12, "div", [["class", "d-flex flex-row align-items-baseline justify-content-between"]], null, null, null, null, null)), (_l()(), core["ɵeld"](9, 0, null, null, 4, "div", [], null, null, null, null, null)), (_l()(), core["ɵeld"](10, 0, null, null, 1, "h3", [], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Endere\u00E7os de Entrega"])), (_l()(), core["ɵeld"](12, 0, null, null, 1, "p", [["class", "text-muted"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, [" Adicione uma mais op\u00E7\u00F5es de endere\u00E7o de entrega do cliente. "])), (_l()(), core["ɵeld"](14, 0, null, null, 6, "div", [["class", "d-flex align-itens-end justify-content-end"]], null, null, null, null, null)), (_l()(), core["ɵeld"](15, 0, null, null, 2, "button", [["class", "mr-2"], ["nbButton", ""], ["size", "small"], ["status", "primary"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 16).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.openEditAddressDialog() !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](16, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], outline: [2, "outline"] }, null), (_l()(), core["ɵted"](-1, 0, [" Novo Endere\u00E7o "])), (_l()(), core["ɵeld"](18, 0, null, null, 2, "button", [["nbButton", ""], ["size", "small"], ["status", "danger"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 19).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.removeAll() !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](19, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], outline: [2, "outline"], disabled: [3, "disabled"] }, null), (_l()(), core["ɵted"](-1, 0, [" Excluir Todos "])), (_l()(), core["ɵeld"](21, 0, null, null, 5, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](22, 0, null, null, 4, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomerDeliveryAddressEditComponent_1)), core["ɵdid"](24, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomerDeliveryAddressEditComponent_7)), core["ɵdid"](26, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](27, 0, null, null, 1, "omni-edit-delivery-address-dialog", [], null, [[null, "saveDeliveryAddress"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("saveDeliveryAddress" === en)) {
        var pd_0 = (_co.updateAddress($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, edit_delivery_address_dialog_component_ngfactory["c" /* View_EditDeliveryAddressDialogComponent_0 */], edit_delivery_address_dialog_component_ngfactory["b" /* RenderType_EditDeliveryAddressDialogComponent */])), core["ɵdid"](28, 114688, [[1, 4], ["deliveryAddressEditDialog", 4]], 0, edit_delivery_address_dialog_component["a" /* EditDeliveryAddressDialogComponent */], [fesm2015_forms["g" /* FormBuilder */], consulta_cep_service["a" /* ConsultaCepService */], messages_service["a" /* MessagesService */], fesm2015["Ld" /* NbToastrService */]], null, { saveDeliveryAddress: "saveDeliveryAddress" })], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.form; _ck(_v, 3, 0, currVal_7); var currVal_34 = "small"; var currVal_35 = "primary"; var currVal_36 = true; _ck(_v, 16, 0, currVal_34, currVal_35, currVal_36); var currVal_63 = "small"; var currVal_64 = "danger"; var currVal_65 = true; var currVal_66 = ((((_co.addresses == null) ? null : ((_co.addresses.controls == null) ? null : _co.addresses.controls.length)) === 0) ? true : null); _ck(_v, 19, 0, currVal_63, currVal_64, currVal_65, currVal_66); var currVal_67 = (((_co.addresses == null) ? null : ((_co.addresses.controls == null) ? null : _co.addresses.controls.length)) > 0); _ck(_v, 24, 0, currVal_67); var currVal_68 = (((_co.addresses == null) ? null : ((_co.addresses.controls == null) ? null : _co.addresses.controls.length)) === 0); _ck(_v, 26, 0, currVal_68); _ck(_v, 28, 0); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 5).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 5).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 5).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 5).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 5).ngClassValid; var currVal_5 = core["ɵnov"](_v, 5).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 5).ngClassPending; _ck(_v, 1, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_8 = core["ɵnov"](_v, 16).filled; var currVal_9 = core["ɵnov"](_v, 16).outline; var currVal_10 = core["ɵnov"](_v, 16).ghost; var currVal_11 = core["ɵnov"](_v, 16).hero; var currVal_12 = core["ɵnov"](_v, 16).fullWidth; var currVal_13 = core["ɵnov"](_v, 16).disabled; var currVal_14 = core["ɵnov"](_v, 16).disabled; var currVal_15 = core["ɵnov"](_v, 16).tabbable; var currVal_16 = core["ɵnov"](_v, 16).tiny; var currVal_17 = core["ɵnov"](_v, 16).small; var currVal_18 = core["ɵnov"](_v, 16).medium; var currVal_19 = core["ɵnov"](_v, 16).large; var currVal_20 = core["ɵnov"](_v, 16).giant; var currVal_21 = core["ɵnov"](_v, 16).primary; var currVal_22 = core["ɵnov"](_v, 16).info; var currVal_23 = core["ɵnov"](_v, 16).success; var currVal_24 = core["ɵnov"](_v, 16).warning; var currVal_25 = core["ɵnov"](_v, 16).danger; var currVal_26 = core["ɵnov"](_v, 16).basic; var currVal_27 = core["ɵnov"](_v, 16).control; var currVal_28 = core["ɵnov"](_v, 16).rectangle; var currVal_29 = core["ɵnov"](_v, 16).round; var currVal_30 = core["ɵnov"](_v, 16).semiRound; var currVal_31 = core["ɵnov"](_v, 16).iconLeft; var currVal_32 = core["ɵnov"](_v, 16).iconRight; var currVal_33 = core["ɵnov"](_v, 16).transitions; _ck(_v, 15, 1, [currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33]); var currVal_37 = core["ɵnov"](_v, 19).filled; var currVal_38 = core["ɵnov"](_v, 19).outline; var currVal_39 = core["ɵnov"](_v, 19).ghost; var currVal_40 = core["ɵnov"](_v, 19).hero; var currVal_41 = core["ɵnov"](_v, 19).fullWidth; var currVal_42 = core["ɵnov"](_v, 19).disabled; var currVal_43 = core["ɵnov"](_v, 19).disabled; var currVal_44 = core["ɵnov"](_v, 19).tabbable; var currVal_45 = core["ɵnov"](_v, 19).tiny; var currVal_46 = core["ɵnov"](_v, 19).small; var currVal_47 = core["ɵnov"](_v, 19).medium; var currVal_48 = core["ɵnov"](_v, 19).large; var currVal_49 = core["ɵnov"](_v, 19).giant; var currVal_50 = core["ɵnov"](_v, 19).primary; var currVal_51 = core["ɵnov"](_v, 19).info; var currVal_52 = core["ɵnov"](_v, 19).success; var currVal_53 = core["ɵnov"](_v, 19).warning; var currVal_54 = core["ɵnov"](_v, 19).danger; var currVal_55 = core["ɵnov"](_v, 19).basic; var currVal_56 = core["ɵnov"](_v, 19).control; var currVal_57 = core["ɵnov"](_v, 19).rectangle; var currVal_58 = core["ɵnov"](_v, 19).round; var currVal_59 = core["ɵnov"](_v, 19).semiRound; var currVal_60 = core["ɵnov"](_v, 19).iconLeft; var currVal_61 = core["ɵnov"](_v, 19).iconRight; var currVal_62 = core["ɵnov"](_v, 19).transitions; _ck(_v, 18, 1, [currVal_37, currVal_38, currVal_39, currVal_40, currVal_41, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58, currVal_59, currVal_60, currVal_61, currVal_62]); }); }
function View_CustomerDeliveryAddressEditComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customers-delivery-address-edit", [], null, null, null, View_CustomerDeliveryAddressEditComponent_0, RenderType_CustomerDeliveryAddressEditComponent)), core["ɵdid"](1, 114688, null, 0, customers_delivery_address_edit_component_CustomerDeliveryAddressEditComponent, [fesm2015_forms["g" /* FormBuilder */], fesm2015["Rb" /* NbDialogService */], messages_service["a" /* MessagesService */], fesm2015["Ld" /* NbToastrService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomerDeliveryAddressEditComponentNgFactory = core["ɵccf"]("omni-customers-delivery-address-edit", customers_delivery_address_edit_component_CustomerDeliveryAddressEditComponent, View_CustomerDeliveryAddressEditComponent_Host_0, { form: "form", isLoading: "isLoading" }, { formChange: "formChange" }, []);


// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-form.component.ts
var base_form_component = __webpack_require__("rduj");

// EXTERNAL MODULE: ./src/app/shared/enums/perfil-do-usuario.ts
var perfil_do_usuario = __webpack_require__("a0Ve");

// EXTERNAL MODULE: ./src/app/shared/enums/tipo-pessoa.ts + 1 modules
var tipo_pessoa = __webpack_require__("YOi3");

// EXTERNAL MODULE: ./src/app/shared/models/empresa.ts
var empresa = __webpack_require__("n9sG");

// EXTERNAL MODULE: ./src/app/shared/models/resource.ts
var resource = __webpack_require__("05o1");

// CONCATENATED MODULE: ./src/app/shared/models/cliente.ts


class cliente_Cliente extends resource["a" /* Resource */] {
    constructor() {
        super();
        this.empresa = new empresa["a" /* Empresa */]();
        this.enderecosDeEntrega = [];
    }
}

// EXTERNAL MODULE: ./src/app/shared/models/municipio.ts
var municipio = __webpack_require__("B3gF");

// CONCATENATED MODULE: ./src/app/shared/models/endereco-de-entrega.ts



class endereco_de_entrega_EnderecoDeEntrega extends resource["a" /* Resource */] {
    constructor() {
        super();
        this.municipio = new municipio["a" /* Municipio */]();
        this.cliente = new cliente_Cliente();
        this.enderecoPrincipal = false;
    }
}

// EXTERNAL MODULE: ./src/app/shared/models/perfil.ts
var perfil = __webpack_require__("iqQw");

// EXTERNAL MODULE: ./src/app/shared/models/usuario.ts
var usuario = __webpack_require__("iufN");

// EXTERNAL MODULE: ./src/app/shared/utils/array.util.ts
var array_util = __webpack_require__("+Qmw");

// EXTERNAL MODULE: ./src/app/shared/validators/cep.validator.ts
var cep_validator = __webpack_require__("HRgg");

// CONCATENATED MODULE: ./src/app/shared/validators/cpf-cnpj.validator.ts

function CpfCnpjValidator(control) {
    if (control.value && !string_util["a" /* StringUtil */].isBlank(control.value)) {
        const validation = { invalidCpfCnpj: true };
        const value = string_util["a" /* StringUtil */].removeNonNumericChars(control.value);
        if (string_util["a" /* StringUtil */].isBlank(value)) {
            return validation;
        }
        if (value.length <= 11) {
            return validateCpf(control, validation);
        }
        if (value.length > 11 && value.length <= 14) {
            return validateCnpj(control, validation);
        }
    }
    return null;
}
function validateCpf(control, validation) {
    const cpf = string_util["a" /* StringUtil */].removeNonNumericChars(control.value);
    if (cpf === '') {
        return validation;
    }
    // Elimina CPFs invalidos conhecidos
    if (cpf.length !== 11 || string_util["a" /* StringUtil */].isRepeatedChars(cpf)) {
        return validation;
    }
    // Valida 1o digito
    let add = 0;
    for (let i = 0; i < 9; i++) {
        add += +cpf.charAt(i) * (10 - i);
    }
    let rev = 11 - (add % 11);
    if (rev === 10 || rev === 11) {
        rev = 0;
    }
    if (rev !== +cpf.charAt(9)) {
        return validation;
    }
    // Valida 2o digito
    add = 0;
    for (let i = 0; i < 10; i++) {
        add += +cpf.charAt(i) * (11 - i);
    }
    rev = 11 - (add % 11);
    if (rev === 10 || rev === 11) {
        rev = 0;
    }
    if (rev !== +cpf.charAt(10)) {
        return validation;
    }
    return null;
}
function validateCnpj(control, validation) {
    const cnpj = string_util["a" /* StringUtil */].removeNonNumericChars(control.value);
    if (cnpj === '') {
        return validation;
    }
    if (cnpj.length !== 14) {
        return validation;
    }
    if (string_util["a" /* StringUtil */].isRepeatedChars(cnpj)) {
        return validation;
    }
    let tamanho = cnpj.length - 2;
    let numeros = cnpj.substring(0, tamanho);
    const digitos = cnpj.substring(tamanho);
    let soma = 0;
    let pos = tamanho - 7;
    for (let i = tamanho; i >= 1; i--) {
        soma += +numeros.charAt(tamanho - i) * pos--;
        if (pos < 2) {
            pos = 9;
        }
    }
    let resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
    if (resultado !== +digitos.charAt(0)) {
        return validation;
    }
    tamanho = tamanho + 1;
    numeros = cnpj.substring(0, tamanho);
    soma = 0;
    pos = tamanho - 7;
    for (let i = tamanho; i >= 1; i--) {
        soma += +numeros.charAt(tamanho - i) * pos--;
        if (pos < 2) {
            pos = 9;
        }
    }
    resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
    if (resultado !== +digitos.charAt(1)) {
        return validation;
    }
    return null;
}

// CONCATENATED MODULE: ./src/app/shared/validators/full-name.validator.ts
function FullNameValidator(control) {
    if (control.value && control.value.trim().indexOf(' ') === -1) {
        return { invalidFullName: true };
    }
    return null;
}

// EXTERNAL MODULE: ./src/app/shared/validators/telefone.validator.ts
var telefone_validator = __webpack_require__("JAJw");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-edit/customers-edit.component.ts



















class customers_edit_component_CustomersEditComponent extends base_form_component["a" /* BaseFormComponent */] {
    constructor(fb, route, router, companyService, customerService, alertService, authService, messagesService, requestService, toastrService) {
        super(alertService, authService, messagesService, requestService, toastrService);
        this.fb = fb;
        this.route = route;
        this.router = router;
        this.companyService = companyService;
        this.customerService = customerService;
        this.errorPasswordMsg = '';
        this.hasOnlinePayment = false;
        this.isPasswordMandatory = false;
        this.personTypeOptions = [];
        this.customerService.companyId = this.authService.loggedUser.id;
    }
    get deliveryAddress() {
        return this.form.get('deliveryAddresses').value;
    }
    get userIcon() {
        return free_regular_svg_icons["faUser"];
    }
    ngOnInit() {
        this.initForm();
        this.loadOnlinePaymentConfig();
        this.loadFormData();
    }
    back() {
        this.router.navigate(['admin/wholesale/customers']);
    }
    isPerson() {
        return this.formData.personType === tipo_pessoa["a" /* TIPO_PESSOA */].FISICA.referencia;
    }
    initForm() {
        this.personTypeOptions.push({ label: tipo_pessoa["a" /* TIPO_PESSOA */].FISICA.descricao, value: tipo_pessoa["a" /* TIPO_PESSOA */].FISICA.referencia }, { label: tipo_pessoa["a" /* TIPO_PESSOA */].JURIDICA.descricao, value: tipo_pessoa["a" /* TIPO_PESSOA */].JURIDICA.referencia });
        this.form = this.fb.group({
            id: [''],
            companyId: [this.authService.loggedUser.id],
            profileId: [perfil_do_usuario["a" /* PERFIL_USUARIO */].CLIENTE.id],
            pdvCode: [''],
            personType: [tipo_pessoa["a" /* TIPO_PESSOA */].FISICA.referencia, fesm2015_forms["z" /* Validators */].required],
            observations: [''],
            cpfCnpj: ['', CpfCnpjValidator],
            name: ['', [fesm2015_forms["z" /* Validators */].required, FullNameValidator]],
            email: ['', [fesm2015_forms["z" /* Validators */].required, fesm2015_forms["z" /* Validators */].email]],
            phone: ['', [fesm2015_forms["z" /* Validators */].required, telefone_validator["a" /* TelefoneValidator */]]],
            active: [false],
            locked: [false],
            lockedOnlinePayment: [false],
            deleted: [false],
            password: [''],
            confirmPassword: [''],
            deliveryAddresses: [this.fb.array([])],
        });
    }
    loadFormData() {
        const id = +this.route.snapshot.params.id || null;
        this.isEditing = id && id > 0;
        if (this.isEditing) {
            this.loadState();
            this.customerService.get(id).subscribe(customer => {
                this.loadState();
                this.populateForm(customer);
            }, (resp) => {
                this.loadState();
                this.requestService.handleError(resp, this.toastrService);
            });
        }
        else {
            const validators = [
                fesm2015_forms["z" /* Validators */].required, fesm2015_forms["z" /* Validators */].minLength(8)
            ];
            this.form.get('password').setValidators(validators);
            this.form.get('confirmPassword').setValidators(validators);
            this.form.updateValueAndValidity();
            this.isPasswordMandatory = true;
        }
        this.feedbackMessage = this.messagesService.getMessage(!this.isEditing ? 'MSG.SUCESSO.018' : 'MSG.SUCESSO.020', ['Cliente']);
    }
    onChangePersonType() {
        this.form.get('cpfCnpj').setValue('');
    }
    showFeedback() {
    }
    submit() {
        if (this.inDemoMode(this.messagesService.getMessage('MSG.INFO.013'))) {
            return;
        }
        if (!string_util["a" /* StringUtil */].isBlank(this.formData.currentPassword) || !string_util["a" /* StringUtil */].isBlank(this.formData.password) ||
            !string_util["a" /* StringUtil */].isBlank(this.formData.confirmPassword)) {
            if (!this.validatePassword()) {
                return;
            }
        }
        const customer = this.populateCustomer();
        if (this.isEditing) {
            this.customerService.update(customer).subscribe(() => this.alertService.success(this.feedbackMessage, (result) => {
                this.loadState();
                if (result.value) {
                    this.back();
                }
            }), (resp) => {
                this.loadState();
                this.handleError(resp);
            });
        }
        else {
            this.customerService.create(customer).subscribe(() => this.alertService.success(this.feedbackMessage, (result) => {
                this.loadState();
                if (result.value) {
                    this.back();
                }
            }), (resp) => {
                this.loadState();
                this.handleError(resp);
            });
        }
    }
    loadOnlinePaymentConfig() {
        this.loadState();
        this.companyService.getCompanyConfig('config-faz-pagamento-online').subscribe(config => {
            this.loadState();
            this.hasOnlinePayment = config && config.valor === '1';
        }, (resp) => {
            this.loadState();
            this.requestService.handleError(resp, this.toastrService);
        });
    }
    populateCustomer() {
        const customer = new cliente_Cliente();
        customer.empresa = new empresa["a" /* Empresa */](this.formData.companyId);
        customer.id = this.formData.id || null;
        customer.nome = this.formData.name;
        customer.telefone = string_util["a" /* StringUtil */].removeNonNumericChars(this.formData.phone);
        customer.pagamentoOnlineBloqueado = this.formData.lockedOnlinePayment;
        customer.ativo = this.formData.active;
        customer.usuario = new usuario["a" /* Usuario */](this.formData.userId);
        customer.cpf = string_util["a" /* StringUtil */].removeAllSpecialChars(this.formData.cpfCnpj);
        customer.usuario.nome = this.formData.name;
        customer.usuario.login = this.formData.email;
        customer.usuario.senha = this.formData.password;
        customer.usuario.perfil = new perfil["a" /* Perfil */](perfil_do_usuario["a" /* PERFIL_USUARIO */].CLIENTE.id);
        customer.usuario.senha = this.formData.password;
        customer.usuario.confirmacaoSenha = this.formData.confirmPassword;
        customer.usuario.bloqueado = this.formData.locked;
        customer.codigoDoPdv = this.formData.pdvCode;
        customer.observacoes = this.formData.observations;
        customer.tipoPessoa = this.formData.personType;
        customer.enderecosDeEntrega = [];
        if (!array_util["a" /* ArrayUtil */].isEmpty(this.deliveryAddress.controls)) {
            this.deliveryAddress.controls.forEach(control => {
                const address = new endereco_de_entrega_EnderecoDeEntrega();
                address.id = control.get('id').value || null;
                address.cep = string_util["a" /* StringUtil */].removeAllSpecialChars(control.get('cep').value);
                address.logradouro = control.get('address').value;
                address.numero = control.get('number').value;
                address.bairro = control.get('neighborhood').value;
                address.complemento = control.get('complement').value;
                address.municipio = new municipio["a" /* Municipio */](control.get('cityId').value);
                address.municipio.ibgeId = control.get('cityIbgeId').value;
                address.descricao = control.get('description').value;
                address.pontoDeReferencia = control.get('reference').value;
                address.enderecoPrincipal = control.get('mainAddress').value || false;
                customer.enderecosDeEntrega.push(address);
            });
        }
        return customer;
    }
    populateForm(customer) {
        this.form.patchValue({
            id: customer.id,
            companyId: customer.empresa.id,
            profileId: customer.usuario.perfil.id,
            personType: customer.tipoPessoa,
            pdvCode: customer.codigoDoPdv,
            observations: customer.observacoes,
            userId: customer.usuario.id,
            cpfCnpj: customer.tipoPessoa === tipo_pessoa["a" /* TIPO_PESSOA */].FISICA.referencia
                ? string_util["a" /* StringUtil */].formatCpf(customer.cpf)
                : string_util["a" /* StringUtil */].formatCnpj(customer.cpf),
            name: customer.nome,
            email: customer.usuario.login,
            phone: string_util["a" /* StringUtil */].formatPhone(customer.telefone),
            active: customer.ativo,
            locked: customer.usuario.bloqueado,
            lockedOnlinePayment: customer.pagamentoOnlineBloqueado,
            deliveryAddress: [this.fb.array([])]
        });
        if (!array_util["a" /* ArrayUtil */].isEmpty(customer.enderecosDeEntrega)) {
            customer.enderecosDeEntrega = array_util["a" /* ArrayUtil */].sortCollection(customer.enderecosDeEntrega, 'enderecoPrincipal', order_options["a" /* ORDER_OPTIONS */].DESCENDING);
            customer.enderecosDeEntrega.forEach(address => {
                this.deliveryAddress.push(this.fb.group({
                    id: [address.id || null],
                    cityId: [address.municipio.id],
                    cityName: [address.municipio.nome],
                    uf: [address.municipio.uf],
                    cityIbgeId: [address.municipio.ibgeId],
                    customerId: [address.cliente.id],
                    description: [address.descricao],
                    cep: [string_util["a" /* StringUtil */].formatCep(address.cep), [fesm2015_forms["z" /* Validators */].required, cep_validator["a" /* CepValidator */]]],
                    address: [address.logradouro, fesm2015_forms["z" /* Validators */].required],
                    number: [address.numero, fesm2015_forms["z" /* Validators */].required],
                    neighborhood: [address.bairro, fesm2015_forms["z" /* Validators */].required],
                    complement: [address.complemento],
                    reference: [address.pontoDeReferencia],
                    mainAddress: [address.enderecoPrincipal || false]
                }));
            });
        }
    }
    validatePassword() {
        if (string_util["a" /* StringUtil */].isBlank(this.formData.password)) {
            this.toastrService.warning(this.messagesService.getMessage('MSG.ERRO.001', ['Senha']));
            return false;
        }
        if (string_util["a" /* StringUtil */].isBlank(this.formData.confirmPassword)) {
            this.toastrService.warning(this.messagesService.getMessage('MSG.ERRO.001', ['Confirmação da senha']));
            return false;
        }
        this.form.get('confirmPassword').setErrors((this.formData.password !== this.formData.confirmPassword) ? { invalid: true } : null);
        this.errorPasswordMsg = (this.formData.password !== this.formData.confirmPassword)
            ? this.messagesService.getMessage('MSG.ERRO.004') : '';
        if (this.formData.password !== this.formData.confirmPassword) {
            return false;
        }
        return true;
    }
}

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-edit/customers-edit.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 
























var styles_CustomersEditComponent = [];
var RenderType_CustomersEditComponent = core["ɵcrt"]({ encapsulation: 2, styles: styles_CustomersEditComponent, data: {} });

function View_CustomersEditComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "nb-option", [], [[2, "selected", null], [1, "disabled", 0], [8, "tabIndex", 0]], [[null, "click"], [null, "keydown.space"], [null, "keydown.enter"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("keydown.space" === en)) {
        var pd_1 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_1 && ad);
    } if (("keydown.enter" === en)) {
        var pd_2 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_2 && ad);
    } return ad; }, index_ngfactory["Z" /* View_NbOptionComponent_0 */], index_ngfactory["C" /* RenderType_NbOptionComponent */])), core["ɵdid"](1, 180224, [[1, 4]], 0, fesm2015["yc" /* NbOptionComponent */], [fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], core["ElementRef"], core["ChangeDetectorRef"]], { value: [0, "value"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "]))], function (_ck, _v) { var currVal_3 = _v.context.$implicit.value; _ck(_v, 1, 0, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 1).selectedClass; var currVal_1 = core["ɵnov"](_v, 1).disabledAttribute; var currVal_2 = core["ɵnov"](_v, 1).tabindex; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2); var currVal_4 = _v.context.$implicit.label; _ck(_v, 2, 0, currVal_4); }); }
function View_CustomersEditComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 7, "label", [["class", "checkbox-field"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 5, "input", [["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 2).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 2).onTouched() !== false);
        ad = (pd_1 && ad);
    } return ad; }, null, null)), core["ɵdid"](2, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](4, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](6, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, null, [" Bloquear pagamento online do cliente "]))], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.form.get("lockedOnlinePayment"); _ck(_v, 4, 0, currVal_7); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 6).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 6).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 6).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 6).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 6).ngClassValid; var currVal_5 = core["ɵnov"](_v, 6).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 6).ngClassPending; _ck(_v, 1, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); }); }
function View_CustomersEditComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 15, "div", [["class", "popover-page d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 1, "h6", [], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["C\u00F3digo do PDV"])), (_l()(), core["ɵeld"](3, 0, null, null, 4, "p", [["class", "text-justify"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, [" Trata-se de um c\u00F3digo de identifica\u00E7\u00E3o do cliente do sistema de PDV (Ponto de Venda) "])), (_l()(), core["ɵeld"](5, 0, null, null, 1, "strong", [["class", "text-primary"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Concentre \u2122"])), (_l()(), core["ɵted"](-1, null, [". Ignore este campo caso n\u00E3o utilize o Pedido Agora integrado ao PDV. "])), (_l()(), core["ɵeld"](8, 0, null, null, 7, "p", [["class", "text-justify"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, [" Clique "])), (_l()(), core["ɵeld"](10, 0, null, null, 1, "a", [["href", "https://www.escolpi.com/concentre-food"], ["target", "_blank"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["aqui"])), (_l()(), core["ɵted"](-1, null, [" para mais informa\u00E7\u00F5es sobre o "])), (_l()(), core["ɵeld"](13, 0, null, null, 1, "strong", [], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Concentre"])), (_l()(), core["ɵted"](-1, null, [". "]))], null, null); }
function View_CustomersEditComponent_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 150, "form", [["novalidate", ""]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "ngSubmit"], [null, "submit"], [null, "reset"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("submit" === en)) {
        var pd_0 = (core["ɵnov"](_v, 2).onSubmit($event) !== false);
        ad = (pd_0 && ad);
    } if (("reset" === en)) {
        var pd_1 = (core["ɵnov"](_v, 2).onReset() !== false);
        ad = (pd_1 && ad);
    } if (("ngSubmit" === en)) {
        var pd_2 = (_co.onSubmit() !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](1, 16384, null, 0, fesm2015_forms["D" /* ɵangular_packages_forms_forms_z */], [], null, null), core["ɵdid"](2, 540672, null, 0, fesm2015_forms["l" /* FormGroupDirective */], [[8, null], [8, null]], { form: [0, "form"] }, { ngSubmit: "ngSubmit" }), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["l" /* FormGroupDirective */]]), core["ɵdid"](4, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](5, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](6, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 1, "omni-page-title", [["tutorialTag", "wholesale-cliente-editar"]], null, null, null, page_title_component_ngfactory["b" /* View_PageTitleComponent_0 */], page_title_component_ngfactory["a" /* RenderType_PageTitleComponent */])), core["ɵdid"](8, 114688, null, 0, page_title_component["a" /* PageTitleComponent */], [fesm2015["Rb" /* NbDialogService */]], { icon: [0, "icon"], tutorial: [1, "tutorial"], tutorialTag: [2, "tutorialTag"], pageTitle: [3, "pageTitle"] }, null), (_l()(), core["ɵeld"](9, 0, null, null, 141, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](10, 0, null, null, 140, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](11, 0, null, null, 139, "omni-form-container", [], null, [[null, "backButtonClick"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("backButtonClick" === en)) {
        var pd_0 = (_co.back() !== false);
        ad = (pd_0 && ad);
    } return ad; }, form_container_component_ngfactory["b" /* View_FormContainerComponent_0 */], form_container_component_ngfactory["a" /* RenderType_FormContainerComponent */])), core["ɵdid"](12, 114688, null, 0, form_container_component["a" /* FormContainerComponent */], [alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */]], { isLoading: [0, "isLoading"] }, { backButtonClick: "backButtonClick" }), (_l()(), core["ɵeld"](13, 0, null, 1, 133, "div", [["class", "form-content"]], null, null, null, null, null)), (_l()(), core["ɵeld"](14, 0, null, null, 34, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](15, 0, null, null, 9, "div", [["class", "form-group col-12 col-md-6 col-lg-5"]], null, null, null, null, null)), (_l()(), core["ɵeld"](16, 0, null, null, 8, "omni-field", [["field", "name"], ["label", "Nome"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](17, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"], validOnSubmit: [4, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](18, 0, null, 0, 6, "input", [["formControlName", "name"], ["fullWidth", ""], ["nbInput", ""], ["placeholder", "Informe o nome completo do cliente"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 20)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 20).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 20)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 20)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](19, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](20, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](22, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](24, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](25, 0, null, null, 11, "div", [["class", "form-group col-12 col-sm-md-6 col-md-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](26, 0, null, null, 10, "omni-field", [["field", "email"], ["label", "E-mail (login)"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](27, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"], validOnSubmit: [4, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](28, 0, null, 0, 8, "input", [["formControlName", "email"], ["fullWidth", ""], ["maxlength", "150"], ["nbInput", ""], ["placeholder", "Informe o e-mail do cliente para o login"], ["status", "primary"], ["type", "email"]], [[1, "disabled", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 30)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 30).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 30)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 30)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](29, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](30, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](31, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](34, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](36, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](37, 0, null, null, 11, "div", [["class", "form-group col-12 col-md-6 col-lg-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](38, 0, null, null, 10, "omni-field", [["field", "phone"], ["label", "Telefone"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](39, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"], validOnSubmit: [4, "validOnSubmit"] }, null), (_l()(), core["ɵeld"](40, 0, null, 0, 8, "input", [["formControlName", "phone"], ["fullWidth", ""], ["nbInput", ""], ["omniInputPhone", ""], ["placeholder", "(99) 99999-9999"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 41).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 41).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 43)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 43).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 43)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 43)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](41, 16384, null, 0, input_phone_directive["a" /* InputPhoneDirective */], [core["ElementRef"]], { formControl: [0, "formControl"] }, null), core["ɵdid"](42, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](43, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](45, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](47, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](48, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](49, 0, null, null, 42, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](50, 0, null, null, 13, "div", [["class", "form-group col-12 col-sm-12 col-md-6 col-lg-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](51, 0, null, null, 12, "omni-field", [["field", "personType"], ["label", "Tipo de Pessoa"], ["placeholder", "Selecione o tipo de Pessoa"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](52, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"] }, null), (_l()(), core["ɵeld"](53, 0, null, 0, 10, "nb-select", [["fullWidth", ""], ["placeholder", "Selecione o tipo de Pessoa"], ["status", "primary"]], [[2, "appearance-outline", null], [2, "appearance-filled", null], [2, "appearance-hero", null], [2, "full-width", null], [2, "open", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "selectedChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("selectedChange" === en)) {
        var pd_0 = (_co.onChangePersonType() !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["db" /* View_NbSelectComponent_0 */], index_ngfactory["G" /* RenderType_NbSelectComponent */])), core["ɵprd"](6144, null, fesm2015["k" /* NB_SELECT_INJECTION_TOKEN */], null, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](55, 5423104, null, 2, fesm2015["id" /* NbSelectComponent */], [fesm2015["g" /* NB_DOCUMENT */], fesm2015["Gc" /* NbOverlayService */], core["ElementRef"], fesm2015["Oc" /* NbPositionBuilderService */], fesm2015["de" /* NbTriggerStrategyBuilderService */], core["ChangeDetectorRef"], fesm2015["qe" /* ɵd */]], { status: [0, "status"], fullWidth: [1, "fullWidth"], placeholder: [2, "placeholder"] }, { selectedChange: "selectedChange" }), core["ɵqud"](603979776, 1, { options: 1 }), core["ɵqud"](603979776, 2, { customLabel: 0 }), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["id" /* NbSelectComponent */]]), core["ɵdid"](59, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](61, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵand"](16777216, null, 1, 1, null, View_CustomersEditComponent_1)), core["ɵdid"](63, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null), (_l()(), core["ɵeld"](64, 0, null, null, 13, "div", [["class", "form-group col-12 col-sm-12 col-md-6 col-lg-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](65, 0, null, null, 12, "omni-field", [["field", "cpfCnpj"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](66, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"] }, null), (_l()(), core["ɵeld"](67, 0, null, 0, 10, "input", [["formControlName", "cpfCnpj"], ["fullWidth", ""], ["nbInput", ""], ["omniInputCpfCnpj", ""], ["status", "primary"], ["type", "text"]], [[8, "placeholder", 0], [1, "disabled", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "keyup"], [null, "focusout"], [null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 68).onInput($event) !== false);
        ad = (pd_0 && ad);
    } if (("focusout" === en)) {
        var pd_1 = (core["ɵnov"](_v, 68).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 70)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 70).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 70)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 70)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](68, 16384, null, 0, input_cpf_cnpj_directive["a" /* InputCpfCnpjDirective */], [core["ElementRef"]], null, null), core["ɵdid"](69, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](70, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](71, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](74, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](76, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](77, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](78, 0, null, null, 13, "div", [["class", "form-group col-12 col-sm-12 col-md-6 col-lg-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](79, 0, null, null, 12, "omni-field", [["field", "pdvCode"], ["label", "C\u00F3digo do PDV"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](80, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], showPopover: [3, "showPopover"], popoverTemplate: [4, "popoverTemplate"] }, null), (_l()(), core["ɵeld"](81, 0, null, 0, 10, "input", [["formControlName", "pdvCode"], ["fullWidth", ""], ["maxlength", "20"], ["nbInput", ""], ["omniInputInteger", ""], ["placeholder", "C\u00F3digo no Concentre"], ["status", "primary"], ["type", "text"]], [[1, "disabled", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [1, "maxlength", 0], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "keyup"], [null, "blur"], [null, "input"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 82).onInput($event.target) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 82).onBlur() !== false);
        ad = (pd_1 && ad);
    } if (("input" === en)) {
        var pd_2 = (core["ɵnov"](_v, 84)._handleInput($event.target.value) !== false);
        ad = (pd_2 && ad);
    } if (("blur" === en)) {
        var pd_3 = (core["ɵnov"](_v, 84).onTouched() !== false);
        ad = (pd_3 && ad);
    } if (("compositionstart" === en)) {
        var pd_4 = (core["ɵnov"](_v, 84)._compositionStart() !== false);
        ad = (pd_4 && ad);
    } if (("compositionend" === en)) {
        var pd_5 = (core["ɵnov"](_v, 84)._compositionEnd($event.target.value) !== false);
        ad = (pd_5 && ad);
    } return ad; }, null, null)), core["ɵdid"](82, 16384, null, 0, input_integer_directive["a" /* InputIntegerDirective */], [core["ElementRef"]], null, null), core["ɵdid"](83, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](84, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵdid"](85, 540672, null, 0, fesm2015_forms["o" /* MaxLengthValidator */], [], { maxlength: [0, "maxlength"] }, null), core["ɵprd"](1024, null, fesm2015_forms["p" /* NG_VALIDATORS */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["o" /* MaxLengthValidator */]]), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](88, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](90, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), core["ɵdid"](91, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[6, fesm2015_forms["p" /* NG_VALIDATORS */]], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), (_l()(), core["ɵeld"](92, 0, null, null, 50, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](93, 0, null, null, 9, "div", [["class", "form-group col-12 col-md-6 col-lg-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](94, 0, null, null, 8, "omni-field", [["field", "password"], ["label", "Nova Senha"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](95, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], required: [3, "required"] }, null), (_l()(), core["ɵeld"](96, 0, null, 0, 6, "input", [["formControlName", "password"], ["fullWidth", ""], ["nbInput", ""], ["placeholder", "Nova Senha"], ["status", "primary"], ["type", "password"]], [[1, "disabled", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 98)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 98).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 98)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 98)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](97, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](98, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](100, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](102, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](103, 0, null, null, 9, "div", [["class", "form-group col-12 col-md-6 col-lg-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](104, 0, null, null, 8, "omni-field", [["field", "confirmPassword"], ["label", "Confirme a senha"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](105, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"], errorMsg: [3, "errorMsg"], required: [4, "required"] }, null), (_l()(), core["ɵeld"](106, 0, null, 0, 6, "input", [["formControlName", "confirmPassword"], ["fullWidth", ""], ["nbInput", ""], ["placeholder", "Confirme a senha"], ["status", "primary"], ["type", "password"]], [[1, "disabled", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 108)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 108).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 108)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 108)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](107, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](108, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](110, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](112, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](113, 0, null, null, 19, "div", [["class", "col-12 mt-md-2 col-md-6 col-lg-4"]], null, null, null, null, null)), (_l()(), core["ɵeld"](114, 0, null, null, 18, "div", [["class", "d-flex w-100 flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](115, 0, null, null, 7, "label", [["class", "checkbox-field"]], null, null, null, null, null)), (_l()(), core["ɵeld"](116, 0, null, null, 5, "input", [["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 117).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 117).onTouched() !== false);
        ad = (pd_1 && ad);
    } return ad; }, null, null)), core["ɵdid"](117, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](119, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](121, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, null, [" Cliente ativo "])), (_l()(), core["ɵeld"](123, 0, null, null, 7, "label", [["class", "checkbox-field"]], null, null, null, null, null)), (_l()(), core["ɵeld"](124, 0, null, null, 5, "input", [["type", "checkbox"]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "change"], [null, "blur"]], function (_v, en, $event) { var ad = true; if (("change" === en)) {
        var pd_0 = (core["ɵnov"](_v, 125).onChange($event.target.checked) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 125).onTouched() !== false);
        ad = (pd_1 && ad);
    } return ad; }, null, null)), core["ɵdid"](125, 16384, null, 0, fesm2015_forms["c" /* CheckboxControlValueAccessor */], [core["Renderer2"], core["ElementRef"]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["c" /* CheckboxControlValueAccessor */]]), core["ɵdid"](127, 540672, null, 0, fesm2015_forms["i" /* FormControlDirective */], [[8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { form: [0, "form"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["i" /* FormControlDirective */]]), core["ɵdid"](129, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵted"](-1, null, [" Cliente bloqueado "])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersEditComponent_2)), core["ɵdid"](132, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](133, 0, null, null, 9, "div", [["class", "col-12 col-md-6 col-lg-8"]], null, null, null, null, null)), (_l()(), core["ɵeld"](134, 0, null, null, 8, "omni-field", [["field", "observations"], ["label", "Observa\u00E7\u00F5es"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](135, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](136, 0, null, 0, 6, "textarea", [["class", "no-resize"], ["cols", "120"], ["formControlName", "observations"], ["fullWidth", ""], ["nbInput", ""], ["placeholder", "Informe observa\u00E7\u00F5es sobre o relacionamento com este cliente"], ["rows", "3"], ["status", "primary"]], [[2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 138)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 138).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 138)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 138)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](137, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](138, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](140, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](142, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](143, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](144, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](145, 0, null, null, 1, "omni-customers-delivery-address-edit", [], null, [[null, "formChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("formChange" === en)) {
        var pd_0 = ((_co.form = $event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, View_CustomerDeliveryAddressEditComponent_0, RenderType_CustomerDeliveryAddressEditComponent)), core["ɵdid"](146, 114688, null, 0, customers_delivery_address_edit_component_CustomerDeliveryAddressEditComponent, [fesm2015_forms["g" /* FormBuilder */], fesm2015["Rb" /* NbDialogService */], messages_service["a" /* MessagesService */], fesm2015["Ld" /* NbToastrService */]], { form: [0, "form"], isLoading: [1, "isLoading"] }, { formChange: "formChange" }), (_l()(), core["ɵeld"](147, 0, null, 3, 3, "div", [["class", "form-footer"]], null, null, null, null, null)), (_l()(), core["ɵeld"](148, 0, null, null, 2, "button", [["nbButton", ""], ["status", "success"], ["type", "submit"]], [[1, "disabled", 0], [2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 149).onClick($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](149, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"] }, null), (_l()(), core["ɵted"](150, 0, [" ", " "])), (_l()(), core["ɵand"](0, [["pdvCodeTips", 2]], null, 0, null, View_CustomersEditComponent_3))], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.form; _ck(_v, 2, 0, currVal_7); var currVal_8 = _co.userIcon; var currVal_9 = true; var currVal_10 = "wholesale-cliente-editar"; var currVal_11 = ((_co.isEditing ? "Editar " : "Novo ") + " Cliente"); _ck(_v, 8, 0, currVal_8, currVal_9, currVal_10, currVal_11); var currVal_12 = _co.isLoading; _ck(_v, 12, 0, currVal_12); var currVal_13 = "name"; var currVal_14 = _co.form; var currVal_15 = "Nome"; var currVal_16 = true; var currVal_17 = true; _ck(_v, 17, 0, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17); var currVal_42 = "primary"; var currVal_43 = ""; _ck(_v, 19, 0, currVal_42, currVal_43); var currVal_44 = "name"; _ck(_v, 22, 0, currVal_44); var currVal_45 = "email"; var currVal_46 = _co.form; var currVal_47 = "E-mail (login)"; var currVal_48 = true; var currVal_49 = true; _ck(_v, 27, 0, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49); var currVal_75 = "primary"; var currVal_76 = ""; _ck(_v, 29, 0, currVal_75, currVal_76); var currVal_77 = "150"; _ck(_v, 31, 0, currVal_77); var currVal_78 = "email"; _ck(_v, 34, 0, currVal_78); var currVal_79 = "phone"; var currVal_80 = _co.form; var currVal_81 = "Telefone"; var currVal_82 = true; var currVal_83 = true; _ck(_v, 39, 0, currVal_79, currVal_80, currVal_81, currVal_82, currVal_83); var currVal_108 = _co.form.get("phone"); _ck(_v, 41, 0, currVal_108); var currVal_109 = "primary"; var currVal_110 = ""; _ck(_v, 42, 0, currVal_109, currVal_110); var currVal_111 = "phone"; _ck(_v, 45, 0, currVal_111); var currVal_112 = _co.form.get("phone"); _ck(_v, 48, 0, currVal_112); var currVal_113 = "personType"; var currVal_114 = _co.form; var currVal_115 = "Tipo de Pessoa"; var currVal_116 = true; _ck(_v, 52, 0, currVal_113, currVal_114, currVal_115, currVal_116); var currVal_144 = "primary"; var currVal_145 = ""; var currVal_146 = "Selecione o tipo de Pessoa"; _ck(_v, 55, 0, currVal_144, currVal_145, currVal_146); var currVal_147 = _co.form.get("personType"); _ck(_v, 59, 0, currVal_147); var currVal_148 = _co.personTypeOptions; _ck(_v, 63, 0, currVal_148); var currVal_149 = "cpfCnpj"; var currVal_150 = _co.form; var currVal_151 = (_co.isPerson() ? "CPF" : "CNPJ"); var currVal_152 = true; _ck(_v, 66, 0, currVal_149, currVal_150, currVal_151, currVal_152); var currVal_179 = "primary"; var currVal_180 = ""; _ck(_v, 69, 0, currVal_179, currVal_180); var currVal_181 = (_co.isPerson() ? "14" : "18"); _ck(_v, 71, 0, currVal_181); var currVal_182 = "cpfCnpj"; _ck(_v, 74, 0, currVal_182); var currVal_183 = _co.form.get("cpfCnpj"); _ck(_v, 77, 0, currVal_183); var currVal_184 = "pdvCode"; var currVal_185 = _co.form; var currVal_186 = "C\u00F3digo do PDV"; var currVal_187 = true; var currVal_188 = core["ɵnov"](_v, 151); _ck(_v, 80, 0, currVal_184, currVal_185, currVal_186, currVal_187, currVal_188); var currVal_214 = "primary"; var currVal_215 = ""; _ck(_v, 83, 0, currVal_214, currVal_215); var currVal_216 = "20"; _ck(_v, 85, 0, currVal_216); var currVal_217 = "pdvCode"; _ck(_v, 88, 0, currVal_217); var currVal_218 = _co.form.get("pdvCode"); _ck(_v, 91, 0, currVal_218); var currVal_219 = "password"; var currVal_220 = _co.form; var currVal_221 = "Nova Senha"; var currVal_222 = _co.isPasswordMandatory; _ck(_v, 95, 0, currVal_219, currVal_220, currVal_221, currVal_222); var currVal_247 = "primary"; var currVal_248 = ""; _ck(_v, 97, 0, currVal_247, currVal_248); var currVal_249 = "password"; _ck(_v, 100, 0, currVal_249); var currVal_250 = "confirmPassword"; var currVal_251 = _co.form; var currVal_252 = "Confirme a senha"; var currVal_253 = _co.errorPasswordMsg; var currVal_254 = _co.isPasswordMandatory; _ck(_v, 105, 0, currVal_250, currVal_251, currVal_252, currVal_253, currVal_254); var currVal_279 = "primary"; var currVal_280 = ""; _ck(_v, 107, 0, currVal_279, currVal_280); var currVal_281 = "confirmPassword"; _ck(_v, 110, 0, currVal_281); var currVal_289 = _co.form.get("active"); _ck(_v, 119, 0, currVal_289); var currVal_297 = _co.form.get("locked"); _ck(_v, 127, 0, currVal_297); var currVal_298 = _co.hasOnlinePayment; _ck(_v, 132, 0, currVal_298); var currVal_299 = "observations"; var currVal_300 = _co.form; var currVal_301 = "Observa\u00E7\u00F5es"; _ck(_v, 135, 0, currVal_299, currVal_300, currVal_301); var currVal_325 = "primary"; var currVal_326 = ""; _ck(_v, 137, 0, currVal_325, currVal_326); var currVal_327 = "observations"; _ck(_v, 140, 0, currVal_327); var currVal_328 = _co.form; var currVal_329 = _co.isLoading; _ck(_v, 146, 0, currVal_328, currVal_329); var currVal_357 = "success"; _ck(_v, 149, 0, currVal_357); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 4).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 4).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 4).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 4).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 4).ngClassValid; var currVal_5 = core["ɵnov"](_v, 4).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 4).ngClassPending; _ck(_v, 0, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_18 = (_co.isLoading ? true : null); var currVal_19 = core["ɵnov"](_v, 19).fullWidth; var currVal_20 = core["ɵnov"](_v, 19).tiny; var currVal_21 = core["ɵnov"](_v, 19).small; var currVal_22 = core["ɵnov"](_v, 19).medium; var currVal_23 = core["ɵnov"](_v, 19).large; var currVal_24 = core["ɵnov"](_v, 19).giant; var currVal_25 = core["ɵnov"](_v, 19).primary; var currVal_26 = core["ɵnov"](_v, 19).info; var currVal_27 = core["ɵnov"](_v, 19).success; var currVal_28 = core["ɵnov"](_v, 19).warning; var currVal_29 = core["ɵnov"](_v, 19).danger; var currVal_30 = core["ɵnov"](_v, 19).basic; var currVal_31 = core["ɵnov"](_v, 19).control; var currVal_32 = core["ɵnov"](_v, 19).rectangle; var currVal_33 = core["ɵnov"](_v, 19).semiRound; var currVal_34 = core["ɵnov"](_v, 19).round; var currVal_35 = core["ɵnov"](_v, 24).ngClassUntouched; var currVal_36 = core["ɵnov"](_v, 24).ngClassTouched; var currVal_37 = core["ɵnov"](_v, 24).ngClassPristine; var currVal_38 = core["ɵnov"](_v, 24).ngClassDirty; var currVal_39 = core["ɵnov"](_v, 24).ngClassValid; var currVal_40 = core["ɵnov"](_v, 24).ngClassInvalid; var currVal_41 = core["ɵnov"](_v, 24).ngClassPending; _ck(_v, 18, 1, [currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34, currVal_35, currVal_36, currVal_37, currVal_38, currVal_39, currVal_40, currVal_41]); var currVal_50 = (_co.isLoading ? true : null); var currVal_51 = core["ɵnov"](_v, 29).fullWidth; var currVal_52 = core["ɵnov"](_v, 29).tiny; var currVal_53 = core["ɵnov"](_v, 29).small; var currVal_54 = core["ɵnov"](_v, 29).medium; var currVal_55 = core["ɵnov"](_v, 29).large; var currVal_56 = core["ɵnov"](_v, 29).giant; var currVal_57 = core["ɵnov"](_v, 29).primary; var currVal_58 = core["ɵnov"](_v, 29).info; var currVal_59 = core["ɵnov"](_v, 29).success; var currVal_60 = core["ɵnov"](_v, 29).warning; var currVal_61 = core["ɵnov"](_v, 29).danger; var currVal_62 = core["ɵnov"](_v, 29).basic; var currVal_63 = core["ɵnov"](_v, 29).control; var currVal_64 = core["ɵnov"](_v, 29).rectangle; var currVal_65 = core["ɵnov"](_v, 29).semiRound; var currVal_66 = core["ɵnov"](_v, 29).round; var currVal_67 = (core["ɵnov"](_v, 31).maxlength ? core["ɵnov"](_v, 31).maxlength : null); var currVal_68 = core["ɵnov"](_v, 36).ngClassUntouched; var currVal_69 = core["ɵnov"](_v, 36).ngClassTouched; var currVal_70 = core["ɵnov"](_v, 36).ngClassPristine; var currVal_71 = core["ɵnov"](_v, 36).ngClassDirty; var currVal_72 = core["ɵnov"](_v, 36).ngClassValid; var currVal_73 = core["ɵnov"](_v, 36).ngClassInvalid; var currVal_74 = core["ɵnov"](_v, 36).ngClassPending; _ck(_v, 28, 1, [currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58, currVal_59, currVal_60, currVal_61, currVal_62, currVal_63, currVal_64, currVal_65, currVal_66, currVal_67, currVal_68, currVal_69, currVal_70, currVal_71, currVal_72, currVal_73, currVal_74]); var currVal_84 = (_co.isLoading ? true : null); var currVal_85 = core["ɵnov"](_v, 42).fullWidth; var currVal_86 = core["ɵnov"](_v, 42).tiny; var currVal_87 = core["ɵnov"](_v, 42).small; var currVal_88 = core["ɵnov"](_v, 42).medium; var currVal_89 = core["ɵnov"](_v, 42).large; var currVal_90 = core["ɵnov"](_v, 42).giant; var currVal_91 = core["ɵnov"](_v, 42).primary; var currVal_92 = core["ɵnov"](_v, 42).info; var currVal_93 = core["ɵnov"](_v, 42).success; var currVal_94 = core["ɵnov"](_v, 42).warning; var currVal_95 = core["ɵnov"](_v, 42).danger; var currVal_96 = core["ɵnov"](_v, 42).basic; var currVal_97 = core["ɵnov"](_v, 42).control; var currVal_98 = core["ɵnov"](_v, 42).rectangle; var currVal_99 = core["ɵnov"](_v, 42).semiRound; var currVal_100 = core["ɵnov"](_v, 42).round; var currVal_101 = core["ɵnov"](_v, 47).ngClassUntouched; var currVal_102 = core["ɵnov"](_v, 47).ngClassTouched; var currVal_103 = core["ɵnov"](_v, 47).ngClassPristine; var currVal_104 = core["ɵnov"](_v, 47).ngClassDirty; var currVal_105 = core["ɵnov"](_v, 47).ngClassValid; var currVal_106 = core["ɵnov"](_v, 47).ngClassInvalid; var currVal_107 = core["ɵnov"](_v, 47).ngClassPending; _ck(_v, 40, 1, [currVal_84, currVal_85, currVal_86, currVal_87, currVal_88, currVal_89, currVal_90, currVal_91, currVal_92, currVal_93, currVal_94, currVal_95, currVal_96, currVal_97, currVal_98, currVal_99, currVal_100, currVal_101, currVal_102, currVal_103, currVal_104, currVal_105, currVal_106, currVal_107]); var currVal_117 = core["ɵnov"](_v, 55).outline; var currVal_118 = core["ɵnov"](_v, 55).filled; var currVal_119 = core["ɵnov"](_v, 55).hero; var currVal_120 = core["ɵnov"](_v, 55).fullWidth; var currVal_121 = core["ɵnov"](_v, 55).isOpen; var currVal_122 = core["ɵnov"](_v, 55).tiny; var currVal_123 = core["ɵnov"](_v, 55).small; var currVal_124 = core["ɵnov"](_v, 55).medium; var currVal_125 = core["ɵnov"](_v, 55).large; var currVal_126 = core["ɵnov"](_v, 55).giant; var currVal_127 = core["ɵnov"](_v, 55).primary; var currVal_128 = core["ɵnov"](_v, 55).info; var currVal_129 = core["ɵnov"](_v, 55).success; var currVal_130 = core["ɵnov"](_v, 55).warning; var currVal_131 = core["ɵnov"](_v, 55).danger; var currVal_132 = core["ɵnov"](_v, 55).basic; var currVal_133 = core["ɵnov"](_v, 55).control; var currVal_134 = core["ɵnov"](_v, 55).rectangle; var currVal_135 = core["ɵnov"](_v, 55).round; var currVal_136 = core["ɵnov"](_v, 55).semiRound; var currVal_137 = core["ɵnov"](_v, 61).ngClassUntouched; var currVal_138 = core["ɵnov"](_v, 61).ngClassTouched; var currVal_139 = core["ɵnov"](_v, 61).ngClassPristine; var currVal_140 = core["ɵnov"](_v, 61).ngClassDirty; var currVal_141 = core["ɵnov"](_v, 61).ngClassValid; var currVal_142 = core["ɵnov"](_v, 61).ngClassInvalid; var currVal_143 = core["ɵnov"](_v, 61).ngClassPending; _ck(_v, 53, 1, [currVal_117, currVal_118, currVal_119, currVal_120, currVal_121, currVal_122, currVal_123, currVal_124, currVal_125, currVal_126, currVal_127, currVal_128, currVal_129, currVal_130, currVal_131, currVal_132, currVal_133, currVal_134, currVal_135, currVal_136, currVal_137, currVal_138, currVal_139, currVal_140, currVal_141, currVal_142, currVal_143]); var currVal_153 = core["ɵinlineInterpolate"](1, "Informe o ", (_co.isPerson() ? "CPF" : "CNPJ"), ""); var currVal_154 = (_co.isLoading ? true : null); var currVal_155 = core["ɵnov"](_v, 69).fullWidth; var currVal_156 = core["ɵnov"](_v, 69).tiny; var currVal_157 = core["ɵnov"](_v, 69).small; var currVal_158 = core["ɵnov"](_v, 69).medium; var currVal_159 = core["ɵnov"](_v, 69).large; var currVal_160 = core["ɵnov"](_v, 69).giant; var currVal_161 = core["ɵnov"](_v, 69).primary; var currVal_162 = core["ɵnov"](_v, 69).info; var currVal_163 = core["ɵnov"](_v, 69).success; var currVal_164 = core["ɵnov"](_v, 69).warning; var currVal_165 = core["ɵnov"](_v, 69).danger; var currVal_166 = core["ɵnov"](_v, 69).basic; var currVal_167 = core["ɵnov"](_v, 69).control; var currVal_168 = core["ɵnov"](_v, 69).rectangle; var currVal_169 = core["ɵnov"](_v, 69).semiRound; var currVal_170 = core["ɵnov"](_v, 69).round; var currVal_171 = (core["ɵnov"](_v, 71).maxlength ? core["ɵnov"](_v, 71).maxlength : null); var currVal_172 = core["ɵnov"](_v, 76).ngClassUntouched; var currVal_173 = core["ɵnov"](_v, 76).ngClassTouched; var currVal_174 = core["ɵnov"](_v, 76).ngClassPristine; var currVal_175 = core["ɵnov"](_v, 76).ngClassDirty; var currVal_176 = core["ɵnov"](_v, 76).ngClassValid; var currVal_177 = core["ɵnov"](_v, 76).ngClassInvalid; var currVal_178 = core["ɵnov"](_v, 76).ngClassPending; _ck(_v, 67, 1, [currVal_153, currVal_154, currVal_155, currVal_156, currVal_157, currVal_158, currVal_159, currVal_160, currVal_161, currVal_162, currVal_163, currVal_164, currVal_165, currVal_166, currVal_167, currVal_168, currVal_169, currVal_170, currVal_171, currVal_172, currVal_173, currVal_174, currVal_175, currVal_176, currVal_177, currVal_178]); var currVal_189 = (_co.isLoading ? true : null); var currVal_190 = core["ɵnov"](_v, 83).fullWidth; var currVal_191 = core["ɵnov"](_v, 83).tiny; var currVal_192 = core["ɵnov"](_v, 83).small; var currVal_193 = core["ɵnov"](_v, 83).medium; var currVal_194 = core["ɵnov"](_v, 83).large; var currVal_195 = core["ɵnov"](_v, 83).giant; var currVal_196 = core["ɵnov"](_v, 83).primary; var currVal_197 = core["ɵnov"](_v, 83).info; var currVal_198 = core["ɵnov"](_v, 83).success; var currVal_199 = core["ɵnov"](_v, 83).warning; var currVal_200 = core["ɵnov"](_v, 83).danger; var currVal_201 = core["ɵnov"](_v, 83).basic; var currVal_202 = core["ɵnov"](_v, 83).control; var currVal_203 = core["ɵnov"](_v, 83).rectangle; var currVal_204 = core["ɵnov"](_v, 83).semiRound; var currVal_205 = core["ɵnov"](_v, 83).round; var currVal_206 = (core["ɵnov"](_v, 85).maxlength ? core["ɵnov"](_v, 85).maxlength : null); var currVal_207 = core["ɵnov"](_v, 90).ngClassUntouched; var currVal_208 = core["ɵnov"](_v, 90).ngClassTouched; var currVal_209 = core["ɵnov"](_v, 90).ngClassPristine; var currVal_210 = core["ɵnov"](_v, 90).ngClassDirty; var currVal_211 = core["ɵnov"](_v, 90).ngClassValid; var currVal_212 = core["ɵnov"](_v, 90).ngClassInvalid; var currVal_213 = core["ɵnov"](_v, 90).ngClassPending; _ck(_v, 81, 1, [currVal_189, currVal_190, currVal_191, currVal_192, currVal_193, currVal_194, currVal_195, currVal_196, currVal_197, currVal_198, currVal_199, currVal_200, currVal_201, currVal_202, currVal_203, currVal_204, currVal_205, currVal_206, currVal_207, currVal_208, currVal_209, currVal_210, currVal_211, currVal_212, currVal_213]); var currVal_223 = (_co.isLoading ? true : null); var currVal_224 = core["ɵnov"](_v, 97).fullWidth; var currVal_225 = core["ɵnov"](_v, 97).tiny; var currVal_226 = core["ɵnov"](_v, 97).small; var currVal_227 = core["ɵnov"](_v, 97).medium; var currVal_228 = core["ɵnov"](_v, 97).large; var currVal_229 = core["ɵnov"](_v, 97).giant; var currVal_230 = core["ɵnov"](_v, 97).primary; var currVal_231 = core["ɵnov"](_v, 97).info; var currVal_232 = core["ɵnov"](_v, 97).success; var currVal_233 = core["ɵnov"](_v, 97).warning; var currVal_234 = core["ɵnov"](_v, 97).danger; var currVal_235 = core["ɵnov"](_v, 97).basic; var currVal_236 = core["ɵnov"](_v, 97).control; var currVal_237 = core["ɵnov"](_v, 97).rectangle; var currVal_238 = core["ɵnov"](_v, 97).semiRound; var currVal_239 = core["ɵnov"](_v, 97).round; var currVal_240 = core["ɵnov"](_v, 102).ngClassUntouched; var currVal_241 = core["ɵnov"](_v, 102).ngClassTouched; var currVal_242 = core["ɵnov"](_v, 102).ngClassPristine; var currVal_243 = core["ɵnov"](_v, 102).ngClassDirty; var currVal_244 = core["ɵnov"](_v, 102).ngClassValid; var currVal_245 = core["ɵnov"](_v, 102).ngClassInvalid; var currVal_246 = core["ɵnov"](_v, 102).ngClassPending; _ck(_v, 96, 1, [currVal_223, currVal_224, currVal_225, currVal_226, currVal_227, currVal_228, currVal_229, currVal_230, currVal_231, currVal_232, currVal_233, currVal_234, currVal_235, currVal_236, currVal_237, currVal_238, currVal_239, currVal_240, currVal_241, currVal_242, currVal_243, currVal_244, currVal_245, currVal_246]); var currVal_255 = (_co.isLoading ? true : null); var currVal_256 = core["ɵnov"](_v, 107).fullWidth; var currVal_257 = core["ɵnov"](_v, 107).tiny; var currVal_258 = core["ɵnov"](_v, 107).small; var currVal_259 = core["ɵnov"](_v, 107).medium; var currVal_260 = core["ɵnov"](_v, 107).large; var currVal_261 = core["ɵnov"](_v, 107).giant; var currVal_262 = core["ɵnov"](_v, 107).primary; var currVal_263 = core["ɵnov"](_v, 107).info; var currVal_264 = core["ɵnov"](_v, 107).success; var currVal_265 = core["ɵnov"](_v, 107).warning; var currVal_266 = core["ɵnov"](_v, 107).danger; var currVal_267 = core["ɵnov"](_v, 107).basic; var currVal_268 = core["ɵnov"](_v, 107).control; var currVal_269 = core["ɵnov"](_v, 107).rectangle; var currVal_270 = core["ɵnov"](_v, 107).semiRound; var currVal_271 = core["ɵnov"](_v, 107).round; var currVal_272 = core["ɵnov"](_v, 112).ngClassUntouched; var currVal_273 = core["ɵnov"](_v, 112).ngClassTouched; var currVal_274 = core["ɵnov"](_v, 112).ngClassPristine; var currVal_275 = core["ɵnov"](_v, 112).ngClassDirty; var currVal_276 = core["ɵnov"](_v, 112).ngClassValid; var currVal_277 = core["ɵnov"](_v, 112).ngClassInvalid; var currVal_278 = core["ɵnov"](_v, 112).ngClassPending; _ck(_v, 106, 1, [currVal_255, currVal_256, currVal_257, currVal_258, currVal_259, currVal_260, currVal_261, currVal_262, currVal_263, currVal_264, currVal_265, currVal_266, currVal_267, currVal_268, currVal_269, currVal_270, currVal_271, currVal_272, currVal_273, currVal_274, currVal_275, currVal_276, currVal_277, currVal_278]); var currVal_282 = core["ɵnov"](_v, 121).ngClassUntouched; var currVal_283 = core["ɵnov"](_v, 121).ngClassTouched; var currVal_284 = core["ɵnov"](_v, 121).ngClassPristine; var currVal_285 = core["ɵnov"](_v, 121).ngClassDirty; var currVal_286 = core["ɵnov"](_v, 121).ngClassValid; var currVal_287 = core["ɵnov"](_v, 121).ngClassInvalid; var currVal_288 = core["ɵnov"](_v, 121).ngClassPending; _ck(_v, 116, 0, currVal_282, currVal_283, currVal_284, currVal_285, currVal_286, currVal_287, currVal_288); var currVal_290 = core["ɵnov"](_v, 129).ngClassUntouched; var currVal_291 = core["ɵnov"](_v, 129).ngClassTouched; var currVal_292 = core["ɵnov"](_v, 129).ngClassPristine; var currVal_293 = core["ɵnov"](_v, 129).ngClassDirty; var currVal_294 = core["ɵnov"](_v, 129).ngClassValid; var currVal_295 = core["ɵnov"](_v, 129).ngClassInvalid; var currVal_296 = core["ɵnov"](_v, 129).ngClassPending; _ck(_v, 124, 0, currVal_290, currVal_291, currVal_292, currVal_293, currVal_294, currVal_295, currVal_296); var currVal_302 = core["ɵnov"](_v, 137).fullWidth; var currVal_303 = core["ɵnov"](_v, 137).tiny; var currVal_304 = core["ɵnov"](_v, 137).small; var currVal_305 = core["ɵnov"](_v, 137).medium; var currVal_306 = core["ɵnov"](_v, 137).large; var currVal_307 = core["ɵnov"](_v, 137).giant; var currVal_308 = core["ɵnov"](_v, 137).primary; var currVal_309 = core["ɵnov"](_v, 137).info; var currVal_310 = core["ɵnov"](_v, 137).success; var currVal_311 = core["ɵnov"](_v, 137).warning; var currVal_312 = core["ɵnov"](_v, 137).danger; var currVal_313 = core["ɵnov"](_v, 137).basic; var currVal_314 = core["ɵnov"](_v, 137).control; var currVal_315 = core["ɵnov"](_v, 137).rectangle; var currVal_316 = core["ɵnov"](_v, 137).semiRound; var currVal_317 = core["ɵnov"](_v, 137).round; var currVal_318 = core["ɵnov"](_v, 142).ngClassUntouched; var currVal_319 = core["ɵnov"](_v, 142).ngClassTouched; var currVal_320 = core["ɵnov"](_v, 142).ngClassPristine; var currVal_321 = core["ɵnov"](_v, 142).ngClassDirty; var currVal_322 = core["ɵnov"](_v, 142).ngClassValid; var currVal_323 = core["ɵnov"](_v, 142).ngClassInvalid; var currVal_324 = core["ɵnov"](_v, 142).ngClassPending; _ck(_v, 136, 1, [currVal_302, currVal_303, currVal_304, currVal_305, currVal_306, currVal_307, currVal_308, currVal_309, currVal_310, currVal_311, currVal_312, currVal_313, currVal_314, currVal_315, currVal_316, currVal_317, currVal_318, currVal_319, currVal_320, currVal_321, currVal_322, currVal_323, currVal_324]); var currVal_330 = (_co.isLoading ? true : null); var currVal_331 = core["ɵnov"](_v, 149).filled; var currVal_332 = core["ɵnov"](_v, 149).outline; var currVal_333 = core["ɵnov"](_v, 149).ghost; var currVal_334 = core["ɵnov"](_v, 149).hero; var currVal_335 = core["ɵnov"](_v, 149).fullWidth; var currVal_336 = core["ɵnov"](_v, 149).disabled; var currVal_337 = core["ɵnov"](_v, 149).disabled; var currVal_338 = core["ɵnov"](_v, 149).tabbable; var currVal_339 = core["ɵnov"](_v, 149).tiny; var currVal_340 = core["ɵnov"](_v, 149).small; var currVal_341 = core["ɵnov"](_v, 149).medium; var currVal_342 = core["ɵnov"](_v, 149).large; var currVal_343 = core["ɵnov"](_v, 149).giant; var currVal_344 = core["ɵnov"](_v, 149).primary; var currVal_345 = core["ɵnov"](_v, 149).info; var currVal_346 = core["ɵnov"](_v, 149).success; var currVal_347 = core["ɵnov"](_v, 149).warning; var currVal_348 = core["ɵnov"](_v, 149).danger; var currVal_349 = core["ɵnov"](_v, 149).basic; var currVal_350 = core["ɵnov"](_v, 149).control; var currVal_351 = core["ɵnov"](_v, 149).rectangle; var currVal_352 = core["ɵnov"](_v, 149).round; var currVal_353 = core["ɵnov"](_v, 149).semiRound; var currVal_354 = core["ɵnov"](_v, 149).iconLeft; var currVal_355 = core["ɵnov"](_v, 149).iconRight; var currVal_356 = core["ɵnov"](_v, 149).transitions; _ck(_v, 148, 1, [currVal_330, currVal_331, currVal_332, currVal_333, currVal_334, currVal_335, currVal_336, currVal_337, currVal_338, currVal_339, currVal_340, currVal_341, currVal_342, currVal_343, currVal_344, currVal_345, currVal_346, currVal_347, currVal_348, currVal_349, currVal_350, currVal_351, currVal_352, currVal_353, currVal_354, currVal_355, currVal_356]); var currVal_358 = (_co.isLoading ? "Aguarde..." : "Salvar"); _ck(_v, 150, 0, currVal_358); }); }
function View_CustomersEditComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customers-edit", [], null, null, null, View_CustomersEditComponent_0, RenderType_CustomersEditComponent)), core["ɵdid"](1, 114688, null, 0, customers_edit_component_CustomersEditComponent, [fesm2015_forms["g" /* FormBuilder */], fesm2015_router["a" /* ActivatedRoute */], fesm2015_router["l" /* Router */], empresa_service["a" /* EmpresaService */], cliente_service["a" /* ClienteService */], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */], request_service["a" /* RequestService */], fesm2015["Ld" /* NbToastrService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomersEditComponentNgFactory = core["ɵccf"]("omni-customers-edit", customers_edit_component_CustomersEditComponent, View_CustomersEditComponent_Host_0, {}, {}, []);


// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/sweetalert2-ngx-sweetalert2.ngfactory.js
var sweetalert2_ngx_sweetalert2_ngfactory = __webpack_require__("kExW");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/ngx-bootstrap-typeahead.ngfactory.js
var ngx_bootstrap_typeahead_ngfactory = __webpack_require__("SfUx");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/cashback-credit-dialog/cashback-credit-dialog.component.ngfactory.js + 1 modules
var cashback_credit_dialog_component_ngfactory = __webpack_require__("sKAB");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/category/category-quick-form-dialog/category-quick-form-dialog.component.ngfactory.js + 1 modules
var category_quick_form_dialog_component_ngfactory = __webpack_require__("iY9W");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/customization/edit-customization-value-dialog/edit-customization-value-dialog.component.ngfactory.js + 1 modules
var edit_customization_value_dialog_component_ngfactory = __webpack_require__("x9iD");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/extract-cashback-list-dialog/extract-cashback-list-dialog.component.ngfactory.js + 1 modules
var extract_cashback_list_dialog_component_ngfactory = __webpack_require__("ZjL+");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-detail-dialog/order-detail-dialog.component.ngfactory.js + 3 modules
var order_detail_dialog_component_ngfactory = __webpack_require__("lbLe");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-update-dialog/order-update-dialog.component.ngfactory.js + 1 modules
var order_update_dialog_component_ngfactory = __webpack_require__("/Cjm");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-edit-dialog/promotion-rule-edit-dialog.component.ngfactory.js + 1 modules
var promotion_rule_edit_dialog_component_ngfactory = __webpack_require__("AHux");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/view-picture-dialog/view-picture-dialog.component.ngfactory.js + 1 modules
var view_picture_dialog_component_ngfactory = __webpack_require__("YAEL");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-gift-edit-dialog/promotion-gift-edit-dialog.component.ngfactory.js + 1 modules
var promotion_gift_edit_dialog_component_ngfactory = __webpack_require__("RswS");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-view-dialog/promotion-rule-view-dialog.component.ngfactory.js + 1 modules
var promotion_rule_view_dialog_component_ngfactory = __webpack_require__("BRe2");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-feedback-dialog/order-feedback-dialog.component.ngfactory.js + 1 modules
var order_feedback_dialog_component_ngfactory = __webpack_require__("otmp");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/tutorial-dialog/tutorial-dialog.component.ngfactory.js + 1 modules
var tutorial_dialog_component_ngfactory = __webpack_require__("Uvoc");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/overlay.js
var overlay = __webpack_require__("QQfA");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/bidi.js
var bidi = __webpack_require__("IP0z");

// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/fesm2015/sweetalert2-ngx-sweetalert2.js
var sweetalert2_ngx_sweetalert2 = __webpack_require__("hvj1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/positioning/fesm2015/ngx-bootstrap-positioning.js
var ngx_bootstrap_positioning = __webpack_require__("2uy1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/component-loader/fesm2015/ngx-bootstrap-component-loader.js
var ngx_bootstrap_component_loader = __webpack_require__("z/SZ");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/fesm2015/ngx-bootstrap-typeahead.js + 2 modules
var ngx_bootstrap_typeahead = __webpack_require__("ZMeN");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers-routing.module.ts



const routes = [
    { path: '', component: customers_list_component_CustomersListComponent },
    { path: 'new', component: customers_edit_component_CustomersEditComponent },
    { path: ':id/edit', component: customers_edit_component_CustomersEditComponent }
];
class CustomersRoutingModule {
}

// EXTERNAL MODULE: ./src/app/shared/directives/directives.module.ts + 1 modules
var directives_module = __webpack_require__("yGOH");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/portal.js
var portal = __webpack_require__("zMNK");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/platform.js
var platform = __webpack_require__("/HVE");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/scrolling.js + 6 modules
var scrolling = __webpack_require__("hOhj");

// EXTERNAL MODULE: ./node_modules/br-mask/dist/app.module.js
var app_module = __webpack_require__("CbX2");

// EXTERNAL MODULE: ./node_modules/angular2-chartjs/dist/chart.module.js
var chart_module = __webpack_require__("AE88");

// EXTERNAL MODULE: ./node_modules/@nebular/eva-icons/fesm2015/index.js
var eva_icons_fesm2015 = __webpack_require__("XoTT");

// EXTERNAL MODULE: ./node_modules/ngx-dropzone/fesm2015/ngx-dropzone.js
var ngx_dropzone = __webpack_require__("tq8E");

// EXTERNAL MODULE: ./src/app/shared/pipes/pipes.module.ts + 9 modules
var pipes_module = __webpack_require__("9Xeq");

// EXTERNAL MODULE: ./src/app/shared/ui/ui.module.ts + 6 modules
var ui_module = __webpack_require__("4zvT");

// CONCATENATED MODULE: ./src/app/pages/wholesale/customers/customers.module.ngfactory.js
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomersModuleNgFactory", function() { return CustomersModuleNgFactory; });
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 














































var CustomersModuleNgFactory = core["ɵcmf"](CustomersModule, [], function (_l) { return core["ɵmod"]([core["ɵmpd"](512, core["ComponentFactoryResolver"], core["ɵCodegenComponentFactoryResolver"], [[8, [router_ngfactory["a" /* ɵangular_packages_router_router_lNgFactory */], CustomersListComponentNgFactory, CustomersEditComponentNgFactory, angular_fontawesome_ngfactory["b" /* FaIconComponentNgFactory */], angular_fontawesome_ngfactory["a" /* FaDuotoneIconComponentNgFactory */], index_ngfactory["n" /* NbTooltipComponentNgFactory */], index_ngfactory["h" /* NbContextMenuComponentNgFactory */], index_ngfactory["j" /* NbDialogContainerComponentNgFactory */], index_ngfactory["k" /* NbPopoverComponentNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["b" /* SwalComponentNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["d" /* ɵcNgFactory */], ngx_bootstrap_typeahead_ngfactory["a" /* TypeaheadContainerComponentNgFactory */], cashback_credit_dialog_component_ngfactory["a" /* CashbackCreditDialogComponentNgFactory */], category_quick_form_dialog_component_ngfactory["a" /* CategoryQuickFormDialogComponentNgFactory */], edit_customization_value_dialog_component_ngfactory["a" /* EditCustomizationValueDialogComponentNgFactory */], edit_delivery_address_dialog_component_ngfactory["a" /* EditDeliveryAddressDialogComponentNgFactory */], extract_cashback_list_dialog_component_ngfactory["a" /* ExtractCashbackListDialogComponentNgFactory */], order_detail_dialog_component_ngfactory["a" /* OrderDetailDialogComponentNgFactory */], order_update_dialog_component_ngfactory["a" /* OrderUpdateDialogComponentNgFactory */], promotion_rule_edit_dialog_component_ngfactory["a" /* PromotionRuleEditDialogComponentNgFactory */], view_picture_dialog_component_ngfactory["b" /* ViewPictureDialogComponentNgFactory */], promotion_gift_edit_dialog_component_ngfactory["a" /* PromotionGiftEditDialogComponentNgFactory */], promotion_rule_view_dialog_component_ngfactory["a" /* PromotionRuleViewDialogComponentNgFactory */], order_feedback_dialog_component_ngfactory["a" /* OrderFeedbackDialogComponentNgFactory */], tutorial_dialog_component_ngfactory["b" /* TutorialDialogComponentNgFactory */]]], [3, core["ComponentFactoryResolver"]], core["NgModuleRef"]]), core["ɵmpd"](4608, common["q" /* NgLocalization */], common["p" /* NgLocaleLocalization */], [core["LOCALE_ID"], [2, common["R" /* ɵangular_packages_common_common_a */]]]), core["ɵmpd"](4608, fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], []), core["ɵmpd"](4608, overlay["d" /* Overlay */], overlay["d" /* Overlay */], [overlay["i" /* ScrollStrategyOptions */], overlay["e" /* OverlayContainer */], core["ComponentFactoryResolver"], overlay["h" /* OverlayPositionBuilder */], overlay["f" /* OverlayKeyboardDispatcher */], core["Injector"], core["NgZone"], common["e" /* DOCUMENT */], bidi["b" /* Directionality */], [2, common["k" /* Location */]]]), core["ɵmpd"](5120, overlay["j" /* ɵc */], overlay["k" /* ɵd */], [overlay["d" /* Overlay */]]), core["ɵmpd"](4608, fesm2015_forms["g" /* FormBuilder */], fesm2015_forms["g" /* FormBuilder */], []), core["ɵmpd"](4608, sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], []), core["ɵmpd"](4608, ngx_bootstrap_positioning["a" /* PositioningService */], ngx_bootstrap_positioning["a" /* PositioningService */], [core["NgZone"], core["RendererFactory2"], core["PLATFORM_ID"]]), core["ɵmpd"](4608, ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], [core["ComponentFactoryResolver"], core["NgZone"], core["Injector"], ngx_bootstrap_positioning["a" /* PositioningService */], core["ApplicationRef"]]), core["ɵmpd"](4608, ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], []), core["ɵmpd"](1073742336, common["c" /* CommonModule */], common["c" /* CommonModule */], []), core["ɵmpd"](1073742336, fesm2015_router["p" /* RouterModule */], fesm2015_router["p" /* RouterModule */], [[2, fesm2015_router["u" /* ɵangular_packages_router_router_a */]], [2, fesm2015_router["l" /* Router */]]]), core["ɵmpd"](1073742336, CustomersRoutingModule, CustomersRoutingModule, []), core["ɵmpd"](1073742336, directives_module["a" /* DirectivesModule */], directives_module["a" /* DirectivesModule */], []), core["ɵmpd"](1073742336, angular_fontawesome["j" /* FontAwesomeModule */], angular_fontawesome["j" /* FontAwesomeModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], []), core["ɵmpd"](1073742336, fesm2015_forms["n" /* FormsModule */], fesm2015_forms["n" /* FormsModule */], []), core["ɵmpd"](1073742336, fesm2015["pe" /* ɵc */], fesm2015["pe" /* ɵc */], []), core["ɵmpd"](1073742336, fesm2015["M" /* NbButtonModule */], fesm2015["M" /* NbButtonModule */], []), core["ɵmpd"](1073742336, fesm2015["dc" /* NbIconModule */], fesm2015["dc" /* NbIconModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["nb" /* NbCardModule */], fesm2015["nb" /* NbCardModule */], []), core["ɵmpd"](1073742336, fesm2015["Bb" /* NbCheckboxModule */], fesm2015["Bb" /* NbCheckboxModule */], []), core["ɵmpd"](1073742336, fesm2015["fc" /* NbInputModule */], fesm2015["fc" /* NbInputModule */], []), core["ɵmpd"](1073742336, fesm2015["vc" /* NbMenuModule */], fesm2015["vc" /* NbMenuModule */], []), core["ɵmpd"](1073742336, bidi["a" /* BidiModule */], bidi["a" /* BidiModule */], []), core["ɵmpd"](1073742336, portal["f" /* PortalModule */], portal["f" /* PortalModule */], []), core["ɵmpd"](1073742336, platform["b" /* PlatformModule */], platform["b" /* PlatformModule */], []), core["ɵmpd"](1073742336, scrolling["b" /* ScrollingModule */], scrolling["b" /* ScrollingModule */], []), core["ɵmpd"](1073742336, overlay["g" /* OverlayModule */], overlay["g" /* OverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["pb" /* NbCdkMappingModule */], fesm2015["pb" /* NbCdkMappingModule */], []), core["ɵmpd"](1073742336, fesm2015["ob" /* NbCdkAdapterModule */], fesm2015["ob" /* NbCdkAdapterModule */], []), core["ɵmpd"](1073742336, fesm2015["Ec" /* NbOverlayModule */], fesm2015["Ec" /* NbOverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["kd" /* NbSelectModule */], fesm2015["kd" /* NbSelectModule */], []), core["ɵmpd"](1073742336, fesm2015["Vc" /* NbRadioModule */], fesm2015["Vc" /* NbRadioModule */], []), core["ɵmpd"](1073742336, fesm2015["Qd" /* NbTooltipModule */], fesm2015["Qd" /* NbTooltipModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["x" /* ReactiveFormsModule */], fesm2015_forms["x" /* ReactiveFormsModule */], []), core["ɵmpd"](1073742336, app_module["a" /* BrMaskerModule */], app_module["a" /* BrMaskerModule */], []), core["ɵmpd"](1073742336, chart_module["ChartModule"], chart_module["ChartModule"], []), core["ɵmpd"](1073742336, fesm2015["D" /* NbAlertModule */], fesm2015["D" /* NbAlertModule */], []), core["ɵmpd"](1073742336, fesm2015["F" /* NbBadgeModule */], fesm2015["F" /* NbBadgeModule */], []), core["ɵmpd"](1073742336, fesm2015["B" /* NbActionsModule */], fesm2015["B" /* NbActionsModule */], []), core["ɵmpd"](1073742336, fesm2015["Gb" /* NbContextMenuModule */], fesm2015["Gb" /* NbContextMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Qb" /* NbDialogModule */], fesm2015["Qb" /* NbDialogModule */], []), core["ɵmpd"](1073742336, eva_icons_fesm2015["a" /* NbEvaIconsModule */], eva_icons_fesm2015["a" /* NbEvaIconsModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["rc" /* NbListModule */], fesm2015["rc" /* NbListModule */], []), core["ɵmpd"](1073742336, fesm2015["Lc" /* NbPopoverModule */], fesm2015["Lc" /* NbPopoverModule */], []), core["ɵmpd"](1073742336, fesm2015["Ed" /* NbTabsetModule */], fesm2015["Ed" /* NbTabsetModule */], []), core["ɵmpd"](1073742336, fesm2015["fe" /* NbUserModule */], fesm2015["fe" /* NbUserModule */], []), core["ɵmpd"](1073742336, ngx_dropzone["c" /* NgxDropzoneModule */], ngx_dropzone["c" /* NgxDropzoneModule */], []), core["ɵmpd"](1073742336, pipes_module["a" /* PipesModule */], pipes_module["a" /* PipesModule */], []), core["ɵmpd"](1073742336, sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], []), core["ɵmpd"](1073742336, ngx_bootstrap_typeahead["d" /* TypeaheadModule */], ngx_bootstrap_typeahead["d" /* TypeaheadModule */], []), core["ɵmpd"](1073742336, ui_module["a" /* UiModule */], ui_module["a" /* UiModule */], []), core["ɵmpd"](1073742336, CustomersModule, CustomersModule, []), core["ɵmpd"](1024, fesm2015_router["j" /* ROUTES */], function () { return [[{ path: "", component: customers_list_component_CustomersListComponent }, { path: "new", component: customers_edit_component_CustomersEditComponent }, { path: ":id/edit", component: customers_edit_component_CustomersEditComponent }]]; }, []), core["ɵmpd"](256, sweetalert2_ngx_sweetalert2["d" /* ɵa */], undefined, [])]); });



/***/ }),

/***/ "J4PQ":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/@angular/core/fesm2015/core.js
var core = __webpack_require__("8Y7J");

// CONCATENATED MODULE: ./src/app/pages/customers/customers.module.ts
class CustomersModule {
}

// EXTERNAL MODULE: ./node_modules/@angular/router/router.ngfactory.js
var router_ngfactory = __webpack_require__("pMnS");

// EXTERNAL MODULE: ./src/app/shared/ui/badge/badge.component.ngfactory.js + 1 modules
var badge_component_ngfactory = __webpack_require__("mcHM");

// EXTERNAL MODULE: ./src/app/shared/ui/badge/badge.component.ts
var badge_component = __webpack_require__("C62Z");

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/angular-fontawesome.ngfactory.js
var angular_fontawesome_ngfactory = __webpack_require__("fNgX");

// EXTERNAL MODULE: ./node_modules/@fortawesome/angular-fontawesome/fesm2015/angular-fontawesome.js
var angular_fontawesome = __webpack_require__("Nv++");

// EXTERNAL MODULE: ./node_modules/@angular/platform-browser/fesm2015/platform-browser.js
var platform_browser = __webpack_require__("cUpR");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/grid-label/grid-label.component.ngfactory.js
var grid_label_component_ngfactory = __webpack_require__("3xHq");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/grid-label/grid-label.component.ts
var grid_label_component = __webpack_require__("uddK");

// EXTERNAL MODULE: ./node_modules/@angular/common/fesm2015/common.js
var common = __webpack_require__("SVse");

// EXTERNAL MODULE: ./src/app/shared/ui/dropdown-menu/dropdown-menu.component.ngfactory.js
var dropdown_menu_component_ngfactory = __webpack_require__("QM7m");

// EXTERNAL MODULE: ./src/app/shared/ui/dropdown-menu/dropdown-menu.component.ts + 1 modules
var dropdown_menu_component = __webpack_require__("jEJX");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/pagination/pagination.component.ngfactory.js + 1 modules
var pagination_component_ngfactory = __webpack_require__("tHyn");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/pagination/pagination.component.ts
var pagination_component = __webpack_require__("HJd8");

// EXTERNAL MODULE: ./src/app/shared/pipes/situacao.pipe.ts
var situacao_pipe = __webpack_require__("4B9u");

// EXTERNAL MODULE: ./src/app/shared/pipes/address.pipe.ts
var address_pipe = __webpack_require__("Nd6I");

// EXTERNAL MODULE: ./src/app/shared/pipes/telefone.pipe.ts
var telefone_pipe = __webpack_require__("/8qz");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ngfactory.js + 1 modules
var page_title_component_ngfactory = __webpack_require__("laEC");

// EXTERNAL MODULE: ./src/app/shared/ui/page-title/page-title.component.ts
var page_title_component = __webpack_require__("S4p5");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/fesm2015/index.js + 5 modules
var fesm2015 = __webpack_require__("tKwJ");

// EXTERNAL MODULE: ./node_modules/@nebular/theme/index.ngfactory.js
var index_ngfactory = __webpack_require__("jXVt");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/filter/filter.component.ngfactory.js
var filter_component_ngfactory = __webpack_require__("vtHt");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/filter/filter.component.ts
var filter_component = __webpack_require__("4J+U");

// EXTERNAL MODULE: ./src/app/shared/ui/inline-loader/inline-loader.component.ngfactory.js
var inline_loader_component_ngfactory = __webpack_require__("T9fw");

// EXTERNAL MODULE: ./src/app/shared/ui/inline-loader/inline-loader.component.ts
var inline_loader_component = __webpack_require__("IGDG");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/form-filter/form-filter.component.ngfactory.js + 1 modules
var form_filter_component_ngfactory = __webpack_require__("OQs5");

// EXTERNAL MODULE: ./src/app/shared/ui/datagrid/form-filter/form-filter.component.ts
var form_filter_component = __webpack_require__("/gwA");

// EXTERNAL MODULE: ./node_modules/@angular/forms/fesm2015/forms.js
var fesm2015_forms = __webpack_require__("s7LF");

// EXTERNAL MODULE: ./src/app/shared/ui/field/field.component.ngfactory.js + 1 modules
var field_component_ngfactory = __webpack_require__("jZyr");

// EXTERNAL MODULE: ./src/app/shared/ui/field/field.component.ts
var field_component = __webpack_require__("jaPl");

// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-form-filter-component.ts
var base_form_filter_component = __webpack_require__("4ILO");

// EXTERNAL MODULE: ./src/app/shared/consts/query-operators.ts
var query_operators = __webpack_require__("AtRd");

// EXTERNAL MODULE: ./src/app/shared/utils/string.util.ts
var string_util = __webpack_require__("8n1d");

// CONCATENATED MODULE: ./src/app/pages/customers/customers-filter/customers-filter.component.ts





class customers_filter_component_CustomersFilterComponent extends base_form_filter_component["a" /* BaseFormFilterComponent */] {
    constructor(fb) {
        super();
        this.fb = fb;
    }
    ngOnInit() {
        this.initForm();
    }
    applyFilter() {
        this.filters = [];
        const form = this.formFilter.getRawValue();
        if (!string_util["a" /* StringUtil */].isBlank(form.nome)) {
            this.filters.push({
                key: 'nome',
                label: 'Nome',
                operator: query_operators["a" /* QUERY_OPERATORS */].EQUALS,
                value: this.formFilter.getRawValue().nome,
                tagValue: this.formFilter.getRawValue().nome
            });
        }
        this.saveFilterState(this.filters);
        this.doFilter.emit(this.filters);
    }
    initForm() {
        this.formFilter = this.fb.group({
            nome: ['', fesm2015_forms["z" /* Validators */].minLength(3)]
        });
        this.refreshFilterState();
    }
    refreshFilterState() {
        if (this.getFilterState()) {
            this.getFilterState().criterias.forEach((criteria) => this.formFilter.get(criteria.key).setValue(criteria.value));
        }
    }
    resetFilter() {
        this.filters = [];
        this.doFilter.emit(this.filters);
    }
}

// CONCATENATED MODULE: ./src/app/pages/customers/customers-filter/customers-filter.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 







var styles_CustomersFilterComponent = [];
var RenderType_CustomersFilterComponent = core["ɵcrt"]({ encapsulation: 2, styles: styles_CustomersFilterComponent, data: {} });

function View_CustomersFilterComponent_0(_l) { return core["ɵvid"](0, [core["ɵqud"](402653184, 1, { formFilterRef: 0 }), (_l()(), core["ɵeld"](1, 0, null, null, 25, "form", [["novalidate", ""]], [[2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "ngSubmit"], [null, "submit"], [null, "reset"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("submit" === en)) {
        var pd_0 = (core["ɵnov"](_v, 3).onSubmit($event) !== false);
        ad = (pd_0 && ad);
    } if (("reset" === en)) {
        var pd_1 = (core["ɵnov"](_v, 3).onReset() !== false);
        ad = (pd_1 && ad);
    } if (("ngSubmit" === en)) {
        var pd_2 = (_co.onSubmit() !== false);
        ad = (pd_2 && ad);
    } return ad; }, null, null)), core["ɵdid"](2, 16384, null, 0, fesm2015_forms["D" /* ɵangular_packages_forms_forms_z */], [], null, null), core["ɵdid"](3, 540672, null, 0, fesm2015_forms["l" /* FormGroupDirective */], [[8, null], [8, null]], { form: [0, "form"] }, { ngSubmit: "ngSubmit" }), core["ɵprd"](2048, null, fesm2015_forms["d" /* ControlContainer */], null, [fesm2015_forms["l" /* FormGroupDirective */]]), core["ɵdid"](5, 16384, null, 0, fesm2015_forms["t" /* NgControlStatusGroup */], [[4, fesm2015_forms["d" /* ControlContainer */]]], null, null), (_l()(), core["ɵeld"](6, 0, null, null, 20, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 19, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](8, 0, null, null, 9, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](9, 0, null, null, 8, "omni-field", [["field", "nome"], ["label", "Nome"]], null, null, null, field_component_ngfactory["b" /* View_FieldComponent_0 */], field_component_ngfactory["a" /* RenderType_FieldComponent */])), core["ɵdid"](10, 8437760, null, 0, field_component["a" /* FieldComponent */], [core["ElementRef"], core["Renderer2"]], { field: [0, "field"], form: [1, "form"], label: [2, "label"] }, null), (_l()(), core["ɵeld"](11, 0, null, 0, 6, "input", [["formControlName", "nome"], ["fullWidth", ""], ["name", "nome"], ["nbInput", ""], ["placeholder", "Informe o Nome"], ["status", "primary"], ["type", "text"]], [[8, "readOnly", 0], [2, "input-full-width", null], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-semi-round", null], [2, "shape-round", null], [2, "ng-untouched", null], [2, "ng-touched", null], [2, "ng-pristine", null], [2, "ng-dirty", null], [2, "ng-valid", null], [2, "ng-invalid", null], [2, "ng-pending", null]], [[null, "input"], [null, "blur"], [null, "compositionstart"], [null, "compositionend"]], function (_v, en, $event) { var ad = true; if (("input" === en)) {
        var pd_0 = (core["ɵnov"](_v, 13)._handleInput($event.target.value) !== false);
        ad = (pd_0 && ad);
    } if (("blur" === en)) {
        var pd_1 = (core["ɵnov"](_v, 13).onTouched() !== false);
        ad = (pd_1 && ad);
    } if (("compositionstart" === en)) {
        var pd_2 = (core["ɵnov"](_v, 13)._compositionStart() !== false);
        ad = (pd_2 && ad);
    } if (("compositionend" === en)) {
        var pd_3 = (core["ɵnov"](_v, 13)._compositionEnd($event.target.value) !== false);
        ad = (pd_3 && ad);
    } return ad; }, null, null)), core["ɵdid"](12, 16384, null, 0, fesm2015["ec" /* NbInputDirective */], [], { status: [0, "status"], fullWidth: [1, "fullWidth"] }, null), core["ɵdid"](13, 16384, null, 0, fesm2015_forms["e" /* DefaultValueAccessor */], [core["Renderer2"], core["ElementRef"], [2, fesm2015_forms["b" /* COMPOSITION_BUFFER_MODE */]]], null, null), core["ɵprd"](1024, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015_forms["e" /* DefaultValueAccessor */]]), core["ɵdid"](15, 671744, null, 0, fesm2015_forms["j" /* FormControlName */], [[3, fesm2015_forms["d" /* ControlContainer */]], [8, null], [8, null], [6, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */]], [2, fesm2015_forms["C" /* ɵangular_packages_forms_forms_q */]]], { name: [0, "name"] }, null), core["ɵprd"](2048, null, fesm2015_forms["r" /* NgControl */], null, [fesm2015_forms["j" /* FormControlName */]]), core["ɵdid"](17, 16384, null, 0, fesm2015_forms["s" /* NgControlStatus */], [[4, fesm2015_forms["r" /* NgControl */]]], null, null), (_l()(), core["ɵeld"](18, 0, null, null, 0, "hr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](19, 0, null, null, 3, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](20, 0, null, null, 2, "button", [["fullWidth", ""], ["nbButton", ""], ["status", "primary"], ["type", "submit"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 21).onClick($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](21, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"], fullWidth: [1, "fullWidth"], disabled: [2, "disabled"] }, null), (_l()(), core["ɵted"](-1, 0, [" Pesquisar "])), (_l()(), core["ɵeld"](23, 0, null, null, 3, "div", [["class", "form-group"]], null, null, null, null, null)), (_l()(), core["ɵeld"](24, 0, null, null, 2, "button", [["fullWidth", ""], ["nbButton", ""], ["status", "primary"], ["type", "button"]], [[2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 25).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.onResetFilter() !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](25, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"], outline: [1, "outline"], fullWidth: [2, "fullWidth"], disabled: [3, "disabled"] }, null), (_l()(), core["ɵted"](-1, 0, [" Limpar "]))], function (_ck, _v) { var _co = _v.component; var currVal_7 = _co.formFilter; _ck(_v, 3, 0, currVal_7); var currVal_8 = "nome"; var currVal_9 = _co.formFilter; var currVal_10 = "Nome"; _ck(_v, 10, 0, currVal_8, currVal_9, currVal_10); var currVal_35 = "primary"; var currVal_36 = ""; _ck(_v, 12, 0, currVal_35, currVal_36); var currVal_37 = "nome"; _ck(_v, 15, 0, currVal_37); var currVal_64 = "primary"; var currVal_65 = ""; var currVal_66 = _co.isDisabled; _ck(_v, 21, 0, currVal_64, currVal_65, currVal_66); var currVal_93 = "primary"; var currVal_94 = true; var currVal_95 = ""; var currVal_96 = _co.isDisabled; _ck(_v, 25, 0, currVal_93, currVal_94, currVal_95, currVal_96); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = core["ɵnov"](_v, 5).ngClassUntouched; var currVal_1 = core["ɵnov"](_v, 5).ngClassTouched; var currVal_2 = core["ɵnov"](_v, 5).ngClassPristine; var currVal_3 = core["ɵnov"](_v, 5).ngClassDirty; var currVal_4 = core["ɵnov"](_v, 5).ngClassValid; var currVal_5 = core["ɵnov"](_v, 5).ngClassInvalid; var currVal_6 = core["ɵnov"](_v, 5).ngClassPending; _ck(_v, 1, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); var currVal_11 = _co.isDisabled; var currVal_12 = core["ɵnov"](_v, 12).fullWidth; var currVal_13 = core["ɵnov"](_v, 12).tiny; var currVal_14 = core["ɵnov"](_v, 12).small; var currVal_15 = core["ɵnov"](_v, 12).medium; var currVal_16 = core["ɵnov"](_v, 12).large; var currVal_17 = core["ɵnov"](_v, 12).giant; var currVal_18 = core["ɵnov"](_v, 12).primary; var currVal_19 = core["ɵnov"](_v, 12).info; var currVal_20 = core["ɵnov"](_v, 12).success; var currVal_21 = core["ɵnov"](_v, 12).warning; var currVal_22 = core["ɵnov"](_v, 12).danger; var currVal_23 = core["ɵnov"](_v, 12).basic; var currVal_24 = core["ɵnov"](_v, 12).control; var currVal_25 = core["ɵnov"](_v, 12).rectangle; var currVal_26 = core["ɵnov"](_v, 12).semiRound; var currVal_27 = core["ɵnov"](_v, 12).round; var currVal_28 = core["ɵnov"](_v, 17).ngClassUntouched; var currVal_29 = core["ɵnov"](_v, 17).ngClassTouched; var currVal_30 = core["ɵnov"](_v, 17).ngClassPristine; var currVal_31 = core["ɵnov"](_v, 17).ngClassDirty; var currVal_32 = core["ɵnov"](_v, 17).ngClassValid; var currVal_33 = core["ɵnov"](_v, 17).ngClassInvalid; var currVal_34 = core["ɵnov"](_v, 17).ngClassPending; _ck(_v, 11, 1, [currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34]); var currVal_38 = core["ɵnov"](_v, 21).filled; var currVal_39 = core["ɵnov"](_v, 21).outline; var currVal_40 = core["ɵnov"](_v, 21).ghost; var currVal_41 = core["ɵnov"](_v, 21).hero; var currVal_42 = core["ɵnov"](_v, 21).fullWidth; var currVal_43 = core["ɵnov"](_v, 21).disabled; var currVal_44 = core["ɵnov"](_v, 21).disabled; var currVal_45 = core["ɵnov"](_v, 21).tabbable; var currVal_46 = core["ɵnov"](_v, 21).tiny; var currVal_47 = core["ɵnov"](_v, 21).small; var currVal_48 = core["ɵnov"](_v, 21).medium; var currVal_49 = core["ɵnov"](_v, 21).large; var currVal_50 = core["ɵnov"](_v, 21).giant; var currVal_51 = core["ɵnov"](_v, 21).primary; var currVal_52 = core["ɵnov"](_v, 21).info; var currVal_53 = core["ɵnov"](_v, 21).success; var currVal_54 = core["ɵnov"](_v, 21).warning; var currVal_55 = core["ɵnov"](_v, 21).danger; var currVal_56 = core["ɵnov"](_v, 21).basic; var currVal_57 = core["ɵnov"](_v, 21).control; var currVal_58 = core["ɵnov"](_v, 21).rectangle; var currVal_59 = core["ɵnov"](_v, 21).round; var currVal_60 = core["ɵnov"](_v, 21).semiRound; var currVal_61 = core["ɵnov"](_v, 21).iconLeft; var currVal_62 = core["ɵnov"](_v, 21).iconRight; var currVal_63 = core["ɵnov"](_v, 21).transitions; _ck(_v, 20, 1, [currVal_38, currVal_39, currVal_40, currVal_41, currVal_42, currVal_43, currVal_44, currVal_45, currVal_46, currVal_47, currVal_48, currVal_49, currVal_50, currVal_51, currVal_52, currVal_53, currVal_54, currVal_55, currVal_56, currVal_57, currVal_58, currVal_59, currVal_60, currVal_61, currVal_62, currVal_63]); var currVal_67 = core["ɵnov"](_v, 25).filled; var currVal_68 = core["ɵnov"](_v, 25).outline; var currVal_69 = core["ɵnov"](_v, 25).ghost; var currVal_70 = core["ɵnov"](_v, 25).hero; var currVal_71 = core["ɵnov"](_v, 25).fullWidth; var currVal_72 = core["ɵnov"](_v, 25).disabled; var currVal_73 = core["ɵnov"](_v, 25).disabled; var currVal_74 = core["ɵnov"](_v, 25).tabbable; var currVal_75 = core["ɵnov"](_v, 25).tiny; var currVal_76 = core["ɵnov"](_v, 25).small; var currVal_77 = core["ɵnov"](_v, 25).medium; var currVal_78 = core["ɵnov"](_v, 25).large; var currVal_79 = core["ɵnov"](_v, 25).giant; var currVal_80 = core["ɵnov"](_v, 25).primary; var currVal_81 = core["ɵnov"](_v, 25).info; var currVal_82 = core["ɵnov"](_v, 25).success; var currVal_83 = core["ɵnov"](_v, 25).warning; var currVal_84 = core["ɵnov"](_v, 25).danger; var currVal_85 = core["ɵnov"](_v, 25).basic; var currVal_86 = core["ɵnov"](_v, 25).control; var currVal_87 = core["ɵnov"](_v, 25).rectangle; var currVal_88 = core["ɵnov"](_v, 25).round; var currVal_89 = core["ɵnov"](_v, 25).semiRound; var currVal_90 = core["ɵnov"](_v, 25).iconLeft; var currVal_91 = core["ɵnov"](_v, 25).iconRight; var currVal_92 = core["ɵnov"](_v, 25).transitions; _ck(_v, 24, 1, [currVal_67, currVal_68, currVal_69, currVal_70, currVal_71, currVal_72, currVal_73, currVal_74, currVal_75, currVal_76, currVal_77, currVal_78, currVal_79, currVal_80, currVal_81, currVal_82, currVal_83, currVal_84, currVal_85, currVal_86, currVal_87, currVal_88, currVal_89, currVal_90, currVal_91, currVal_92]); }); }
function View_CustomersFilterComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customers-filter", [], null, null, null, View_CustomersFilterComponent_0, RenderType_CustomersFilterComponent)), core["ɵdid"](1, 114688, null, 0, customers_filter_component_CustomersFilterComponent, [fesm2015_forms["g" /* FormBuilder */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomersFilterComponentNgFactory = core["ɵccf"]("omni-customers-filter", customers_filter_component_CustomersFilterComponent, View_CustomersFilterComponent_Host_0, { pageId: "pageId", currentPage: "currentPage" }, { doFilter: "doFilter" }, []);


// EXTERNAL MODULE: ./node_modules/@fortawesome/free-solid-svg-icons/index.js
var free_solid_svg_icons = __webpack_require__("YTkO");

// EXTERNAL MODULE: ./src/app/shared/base/base-form/base-list-component.ts
var base_list_component = __webpack_require__("Ki94");

// EXTERNAL MODULE: ./src/app/shared/consts/actions.ts
var actions = __webpack_require__("CIyo");

// EXTERNAL MODULE: ./src/app/shared/consts/order-options.ts
var order_options = __webpack_require__("a7yC");

// CONCATENATED MODULE: ./src/app/pages/customers/customers.component.ts





class customers_component_CustomersComponent extends base_list_component["a" /* BaseListComponent */] {
    constructor(router, companyService, customerService, menuService, requestService, toastrService, alertService, authService, messagesService) {
        super(alertService, authService, messagesService);
        this.router = router;
        this.companyService = companyService;
        this.customerService = customerService;
        this.menuService = menuService;
        this.requestService = requestService;
        this.toastrService = toastrService;
        this.confirmMessage = '';
        this.faBan = free_solid_svg_icons["faBan"];
        this.faUser = free_solid_svg_icons["faUser"];
        this.feedbackMessage = '';
        this.hasOnlinePayment = false;
        this.pageId = 'customerList';
        this.companyService.companyId = this.authService.loggedUser.id;
        this.customerService.companyId = this.authService.loggedUser.id;
    }
    ngOnInit() {
        this.loadFilterState();
        this.loadOnlinePaymentConfig();
        this.list();
        this.initGridContextMenu();
    }
    applyFilters(filterList) {
        this.currentPage = 1;
        this.filterList = filterList;
        this.formFilterRef.closeForm();
        this.addCriteria();
    }
    block() {
        if (this.inDemoMode(this.messagesService.getMessage('MSG.INFO.014'))) {
            return;
        }
        this.loadState();
        this.customerService.blockOrUnblockCustomer(this.customer).subscribe(() => {
            this.loadState();
            this.toastrService.success(this.messagesService.getMessage(this.customer.usuario.bloqueado ? 'MSG.SUCESSO.026' : 'MSG.SUCESSO.025', [this.customer.nome]));
            this.list();
        }, (resp) => {
            this.loadState();
            this.requestService.handleError(resp, this.toastrService);
        });
    }
    lockOnlinePaymentReceivement() {
        if (this.inDemoMode(this.messagesService.getMessage('MSG.INFO.014'))) {
            return;
        }
        this.loadState();
        this.customerService.lockOnlinePaymentReceivement(this.customer.id).subscribe(() => {
            this.toastrService.success(this.messagesService.getMessage('MSG.SUCESSO.046', [this.customer.nome, !this.customer.pagamentoOnlineBloqueado ? 'bloqueado' : 'desbloqueado']));
            this.list();
        }, (resp) => {
            this.loadState();
            this.requestService.handleError(resp, this.toastrService);
        });
    }
    delete() { }
    edit(id) { }
    getCustomerStatus(status) {
        return this.customerService.getCustomerStatus(status);
    }
    initGridContextMenu() {
        this.menuService.onItemClick().subscribe(menu => {
            const data = menu.item.data;
            if (data && data.action) {
                switch (data.action) {
                    case actions["a" /* ACTIONS */].BLOCK:
                        this.customer = data.entity;
                        this.setConfirmMessage();
                        this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.015', [
                            this.customer.usuario.bloqueado ? 'desbloquear' : 'bloquear', this.customer.nome
                        ]), result => {
                            if (result.value) {
                                this.block();
                            }
                        });
                        break;
                    case actions["a" /* ACTIONS */].LOCK:
                        this.customer = data.entity;
                        this.setConfirmMessage();
                        this.alertService.confirm(this.messagesService.getMessage('MSG.CONFIRM.038', [this.customer.nome]), result => {
                            if (result.value) {
                                this.lockOnlinePaymentReceivement();
                            }
                        });
                        break;
                    case actions["a" /* ACTIONS */].SHOW_PURCHASE_HISTORY:
                        this.router.navigate([`admin/consult/order-history/${this.customer.id}/customer`]);
                        break;
                }
            }
        });
    }
    list() {
        this.datasource = [];
        this.isLoading = true;
        this.customerService.filter(this.searchCriteria, this.currentPage, ['nome', 'id'], order_options["a" /* ORDER_OPTIONS */].ASCENDING).subscribe(resultSet => {
            this.resultSet = resultSet;
            this.resultSet.content.forEach(customer => {
                const item = {
                    item: customer,
                    itemMenu: this.makeMenu(customer)
                };
                this.datasource.push(item);
            }, (resp) => this.requestService.handleError(resp, this.toastrService));
        }, (resp) => this.requestService.handleError(resp, this.toastrService), () => this.isLoading = false);
    }
    makeMenu(customer) {
        const menuItems = [{
                icon: 'toggle-right-outline',
                title: customer.usuario.bloqueado
                    ? 'Desbloquear usuário'
                    : 'Bloquear usuário',
                data: { action: actions["a" /* ACTIONS */].BLOCK, entity: customer }
            }];
        if (this.hasOnlinePayment) {
            menuItems.push({
                icon: 'toggle-right-outline',
                title: customer.pagamentoOnlineBloqueado
                    ? 'Desbloquear receb. de Pagamento'
                    : 'Bloquear receb. de Pagamento',
                data: { action: actions["a" /* ACTIONS */].LOCK, entity: customer }
            });
        }
        menuItems.push({
            icon: 'layers',
            title: 'Historico de Pedidos',
            link: `admin/consult/order-history/${customer.id}/customer`
        });
        return menuItems;
    }
    setConfirmMessage() { }
    loadOnlinePaymentConfig() {
        this.loadState();
        this.companyService.getCompanyConfig('config-faz-pagamento-online').subscribe(config => {
            this.loadState();
            this.hasOnlinePayment = config && config.valor === '1';
        }, (resp) => {
            this.loadState();
            this.requestService.handleError(resp, this.toastrService);
        });
    }
}

// EXTERNAL MODULE: ./node_modules/@angular/router/fesm2015/router.js + 5 modules
var fesm2015_router = __webpack_require__("iInd");

// EXTERNAL MODULE: ./src/app/shared/services/empresa.service.ts
var empresa_service = __webpack_require__("x715");

// EXTERNAL MODULE: ./src/app/shared/services/cliente.service.ts
var cliente_service = __webpack_require__("eCBd");

// EXTERNAL MODULE: ./src/app/shared/services/request.service.ts
var request_service = __webpack_require__("a9NN");

// EXTERNAL MODULE: ./src/app/shared/services/alert.service.ts
var alert_service = __webpack_require__("Cmua");

// EXTERNAL MODULE: ./src/app/shared/services/auth.service.ts + 3 modules
var auth_service = __webpack_require__("IYfF");

// EXTERNAL MODULE: ./src/app/shared/services/messages.service.ts + 1 modules
var messages_service = __webpack_require__("N7YL");

// CONCATENATED MODULE: ./src/app/pages/customers/customers.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 





































var styles_CustomersComponent = [];
var RenderType_CustomersComponent = core["ɵcrt"]({ encapsulation: 2, styles: styles_CustomersComponent, data: {} });

function View_CustomersComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-badge", [["class", "ml-3"], ["status", "danger"], ["text", "Recebimento de Pgto. on-line bloqueado"]], null, null, null, badge_component_ngfactory["b" /* View_BadgeComponent_0 */], badge_component_ngfactory["a" /* RenderType_BadgeComponent */])), core["ɵdid"](1, 49152, null, 0, badge_component["a" /* BadgeComponent */], [], { status: [0, "status"], text: [1, "text"] }, null)], function (_ck, _v) { var currVal_0 = "danger"; var currVal_1 = "Recebimento de Pgto. on-line bloqueado"; _ck(_v, 1, 0, currVal_0, currVal_1); }, null); }
function View_CustomersComponent_4(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "span", [["class", "ml-3"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 1, "fa-icon", [["class", "text-danger ng-fa-icon"], ["size", "lg"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, angular_fontawesome_ngfactory["d" /* View_FaIconComponent_0 */], angular_fontawesome_ngfactory["c" /* RenderType_FaIconComponent */])), core["ɵdid"](2, 573440, null, 0, angular_fontawesome["c" /* FaIconComponent */], [platform_browser["b" /* DomSanitizer */], angular_fontawesome["a" /* FaConfig */], angular_fontawesome["d" /* FaIconLibrary */], [2, angular_fontawesome["i" /* FaStackItemSizeDirective */]]], { icon: [0, "icon"], size: [1, "size"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_2 = _co.faBan; var currVal_3 = "lg"; _ck(_v, 2, 0, currVal_2, currVal_3); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 2).title; var currVal_1 = core["ɵnov"](_v, 2).renderedIconHTML; _ck(_v, 1, 0, currVal_0, currVal_1); }); }
function View_CustomersComponent_5(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "span", [], null, null, null, null, null)), (_l()(), core["ɵted"](1, null, [" ", " "])), core["ɵppd"](2, 1)], null, function (_ck, _v) { var currVal_0 = core["ɵunv"](_v, 1, 0, _ck(_v, 2, 0, core["ɵnov"](_v.parent.parent.parent, 1), _v.parent.context.$implicit.item.enderecosDeEntrega[0])); _ck(_v, 1, 0, currVal_0); }); }
function View_CustomersComponent_6(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 3, "omni-grid-label", [["label", "Data de Nascimento"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](1, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], inline: [1, "inline"] }, null), (_l()(), core["ɵted"](2, 0, [" ", " "])), core["ɵppd"](3, 2)], function (_ck, _v) { var currVal_0 = "Data de Nascimento"; var currVal_1 = false; _ck(_v, 1, 0, currVal_0, currVal_1); }, function (_ck, _v) { var currVal_2 = core["ɵunv"](_v, 2, 0, _ck(_v, 3, 0, core["ɵnov"](_v.parent.parent.parent, 3), _v.parent.context.$implicit.item.dataNascimento, "dd/MM/yyyy")); _ck(_v, 2, 0, currVal_2); }); }
function View_CustomersComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 32, "div", [["class", "col-12 col-sm-12 col-md-12 col-lg-6 mb-2 pr-1 pl-1"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 31, "div", [["class", "card card-grid"]], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 14, "div", [["class", "card-title"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 13, "div", [["class", "d-flex flex-row align-items-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 10, "div", [["class", "flex-grow-1"]], null, null, null, null, null)), (_l()(), core["ɵeld"](5, 0, null, null, 9, "div", [["class", "d-flex flex-row align-items-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](6, 0, null, null, 1, "h5", [], null, null, null, null, null)), (_l()(), core["ɵted"](7, null, ["", ""])), (_l()(), core["ɵeld"](8, 0, null, null, 2, "omni-badge", [["class", "ml-3"]], null, null, null, badge_component_ngfactory["b" /* View_BadgeComponent_0 */], badge_component_ngfactory["a" /* RenderType_BadgeComponent */])), core["ɵdid"](9, 49152, null, 0, badge_component["a" /* BadgeComponent */], [], { status: [0, "status"], text: [1, "text"] }, null), core["ɵppd"](10, 1), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersComponent_3)), core["ɵdid"](12, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersComponent_4)), core["ɵdid"](14, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](15, 0, null, null, 1, "omni-dropdown-menu", [], null, null, null, dropdown_menu_component_ngfactory["b" /* View_DropdownMenuComponent_0 */], dropdown_menu_component_ngfactory["a" /* RenderType_DropdownMenuComponent */])), core["ɵdid"](16, 114688, null, 0, dropdown_menu_component["a" /* DropdownMenuComponent */], [], { optionsList: [0, "optionsList"] }, null), (_l()(), core["ɵeld"](17, 0, null, null, 15, "div", [["class", "card-body"]], null, null, null, null, null)), (_l()(), core["ɵeld"](18, 0, null, null, 14, "div", [["class", "d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](19, 0, null, null, 3, "omni-grid-label", [["class", "mb-2"], ["label", "Endere\u00E7o"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](20, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"] }, null), (_l()(), core["ɵand"](16777216, null, 0, 1, null, View_CustomersComponent_5)), core["ɵdid"](22, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](23, 0, null, null, 9, "div", [["class", "d-flex justify-content-between"]], null, null, null, null, null)), (_l()(), core["ɵeld"](24, 0, null, null, 3, "omni-grid-label", [["label", "Telefone"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](25, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], inline: [1, "inline"] }, null), (_l()(), core["ɵted"](26, 0, [" ", " "])), core["ɵppd"](27, 1), (_l()(), core["ɵeld"](28, 0, null, null, 2, "omni-grid-label", [["class", "pl-2 pr-2"], ["label", "E-mail"]], null, null, null, grid_label_component_ngfactory["b" /* View_GridLabelComponent_0 */], grid_label_component_ngfactory["a" /* RenderType_GridLabelComponent */])), core["ɵdid"](29, 49152, null, 0, grid_label_component["a" /* GridLabelComponent */], [], { label: [0, "label"], inline: [1, "inline"] }, null), (_l()(), core["ɵted"](30, 0, [" ", " "])), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersComponent_6)), core["ɵdid"](32, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_1 = _co.getCustomerStatus(_v.context.$implicit.item.ativo); var currVal_2 = core["ɵunv"](_v, 9, 1, _ck(_v, 10, 0, core["ɵnov"](_v.parent.parent, 0), _v.context.$implicit.item.ativo)); _ck(_v, 9, 0, currVal_1, currVal_2); var currVal_3 = _v.context.$implicit.item.pagamentoOnlineBloqueado; _ck(_v, 12, 0, currVal_3); var currVal_4 = _v.context.$implicit.item.usuario.bloqueado; _ck(_v, 14, 0, currVal_4); var currVal_5 = _v.context.$implicit.itemMenu; _ck(_v, 16, 0, currVal_5); var currVal_6 = "Endere\u00E7o"; _ck(_v, 20, 0, currVal_6); var currVal_7 = (_v.context.$implicit.item.enderecosDeEntrega && (_v.context.$implicit.item.enderecosDeEntrega.length > 0)); _ck(_v, 22, 0, currVal_7); var currVal_8 = "Telefone"; var currVal_9 = false; _ck(_v, 25, 0, currVal_8, currVal_9); var currVal_11 = "E-mail"; var currVal_12 = false; _ck(_v, 29, 0, currVal_11, currVal_12); var currVal_14 = _v.context.$implicit.item.dataNascimento; _ck(_v, 32, 0, currVal_14); }, function (_ck, _v) { var currVal_0 = _v.context.$implicit.item.nome; _ck(_v, 7, 0, currVal_0); var currVal_10 = core["ɵunv"](_v, 26, 0, _ck(_v, 27, 0, core["ɵnov"](_v.parent.parent, 2), _v.context.$implicit.item.telefone)); _ck(_v, 26, 0, currVal_10); var currVal_13 = _v.context.$implicit.item.usuario.login; _ck(_v, 30, 0, currVal_13); }); }
function View_CustomersComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 2, "div", [["class", "d-flex align-items-stretch flex-wrap mt-2"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersComponent_2)), core["ɵdid"](2, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.datasource; _ck(_v, 2, 0, currVal_0); }, null); }
function View_CustomersComponent_7(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-pagination", [], null, [[null, "pageChange"], [null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("pageChange" === en)) {
        var pd_1 = (_co.changePage($event) !== false);
        ad = (pd_1 && ad);
    } return ad; }, pagination_component_ngfactory["b" /* View_PaginationComponent_0 */], pagination_component_ngfactory["a" /* RenderType_PaginationComponent */])), core["ɵdid"](1, 114688, null, 0, pagination_component["a" /* PaginationComponent */], [], { currentPage: [0, "currentPage"], totalPages: [1, "totalPages"] }, { pageChange: "pageChange" })], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.currentPage; var currVal_1 = _co.resultSet.totalPages; _ck(_v, 1, 0, currVal_0, currVal_1); }, null); }
function View_CustomersComponent_0(_l) { return core["ɵvid"](0, [core["ɵpid"](0, situacao_pipe["a" /* SituacaoPipe */], []), core["ɵpid"](0, address_pipe["a" /* AddressPipe */], []), core["ɵpid"](0, telefone_pipe["a" /* TelefonePipe */], []), core["ɵpid"](0, common["f" /* DatePipe */], [core["LOCALE_ID"]]), core["ɵqud"](671088640, 1, { formFilterRef: 0 }), (_l()(), core["ɵeld"](5, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](6, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 1, "omni-page-title", [["pageTitle", "Clientes"]], null, null, null, page_title_component_ngfactory["b" /* View_PageTitleComponent_0 */], page_title_component_ngfactory["a" /* RenderType_PageTitleComponent */])), core["ɵdid"](8, 114688, null, 0, page_title_component["a" /* PageTitleComponent */], [fesm2015["Rb" /* NbDialogService */]], { icon: [0, "icon"], pageTitle: [1, "pageTitle"] }, null), (_l()(), core["ɵeld"](9, 0, null, null, 14, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](10, 0, null, null, 13, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](11, 0, null, null, 12, "nb-card", [], [[2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "accent", null], [2, "accent-primary", null], [2, "accent-info", null], [2, "accent-success", null], [2, "accent-warning", null], [2, "accent-danger", null], [2, "accent-basic", null], [2, "accent-control", null]], null, null, index_ngfactory["O" /* View_NbCardComponent_0 */], index_ngfactory["r" /* RenderType_NbCardComponent */])), core["ɵdid"](12, 49152, null, 0, fesm2015["jb" /* NbCardComponent */], [], null, null), (_l()(), core["ɵeld"](13, 0, null, 1, 10, "nb-card-body", [["class", "flat-body"]], null, null, null, index_ngfactory["N" /* View_NbCardBodyComponent_0 */], index_ngfactory["q" /* RenderType_NbCardBodyComponent */])), core["ɵdid"](14, 49152, null, 0, fesm2015["ib" /* NbCardBodyComponent */], [], null, null), (_l()(), core["ɵeld"](15, 0, null, 0, 8, "div", [["class", "d-flex flex-column"]], null, null, null, null, null)), (_l()(), core["ɵeld"](16, 0, null, null, 1, "omni-filter", [], null, [[null, "resultSetChange"], [null, "newButtonClick"], [null, "filterButtonClick"], [null, "updateFilterList"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("resultSetChange" === en)) {
        var pd_0 = ((_co.resultSet = $event) !== false);
        ad = (pd_0 && ad);
    } if (("newButtonClick" === en)) {
        var pd_1 = (_co.edit() !== false);
        ad = (pd_1 && ad);
    } if (("filterButtonClick" === en)) {
        var pd_2 = (_co.showFormFilter() !== false);
        ad = (pd_2 && ad);
    } if (("updateFilterList" === en)) {
        var pd_3 = (_co.applyFilters($event) !== false);
        ad = (pd_3 && ad);
    } return ad; }, filter_component_ngfactory["b" /* View_FilterComponent_0 */], filter_component_ngfactory["a" /* RenderType_FilterComponent */])), core["ɵdid"](17, 114688, null, 0, filter_component["a" /* FilterComponent */], [], { filterList: [0, "filterList"], resultSet: [1, "resultSet"], showNewButton: [2, "showNewButton"] }, { filterButtonClick: "filterButtonClick", newButtonClick: "newButtonClick", resultSetChange: "resultSetChange", updateFilterList: "updateFilterList" }), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersComponent_1)), core["ɵdid"](19, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_CustomersComponent_7)), core["ɵdid"](21, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](22, 0, null, null, 1, "omni-inline-loader", [["label", "Listando Clientes..."]], null, null, null, inline_loader_component_ngfactory["b" /* View_InlineLoaderComponent_0 */], inline_loader_component_ngfactory["a" /* RenderType_InlineLoaderComponent */])), core["ɵdid"](23, 114688, null, 0, inline_loader_component["a" /* InlineLoaderComponent */], [], { label: [0, "label"], refreshState: [1, "refreshState"] }, null), (_l()(), core["ɵeld"](24, 0, null, null, 3, "omni-form-filter", [], null, [["window", "keyup"], [null, "click"]], function (_v, en, $event) { var ad = true; if (("window:keyup" === en)) {
        var pd_0 = (core["ɵnov"](_v, 25).onEscape($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (core["ɵnov"](_v, 25).onClick($event) !== false);
        ad = (pd_1 && ad);
    } return ad; }, form_filter_component_ngfactory["b" /* View_FormFilterComponent_0 */], form_filter_component_ngfactory["a" /* RenderType_FormFilterComponent */])), core["ɵdid"](25, 49152, [[1, 4], ["formFilter", 4]], 0, form_filter_component["a" /* FormFilterComponent */], [], null, null), (_l()(), core["ɵeld"](26, 0, null, 0, 1, "omni-customers-filter", [], null, [[null, "doFilter"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("doFilter" === en)) {
        var pd_0 = (_co.applyFilters($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, View_CustomersFilterComponent_0, RenderType_CustomersFilterComponent)), core["ɵdid"](27, 114688, [["customerFilter", 4]], 0, customers_filter_component_CustomersFilterComponent, [fesm2015_forms["g" /* FormBuilder */]], { pageId: [0, "pageId"], currentPage: [1, "currentPage"] }, { doFilter: "doFilter" })], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.faUser; var currVal_1 = "Clientes"; _ck(_v, 8, 0, currVal_0, currVal_1); var currVal_22 = _co.filterList; var currVal_23 = _co.resultSet; var currVal_24 = false; _ck(_v, 17, 0, currVal_22, currVal_23, currVal_24); var currVal_25 = ((_co.datasource.length > 0) && !_co.isLoading); _ck(_v, 19, 0, currVal_25); var currVal_26 = ((((_co.resultSet == null) ? null : _co.resultSet.totalPages) > 1) && !_co.isLoading); _ck(_v, 21, 0, currVal_26); var currVal_27 = "Listando Clientes..."; var currVal_28 = _co.isLoading; _ck(_v, 23, 0, currVal_27, currVal_28); var currVal_29 = _co.pageId; var currVal_30 = _co.currentPage; _ck(_v, 27, 0, currVal_29, currVal_30); }, function (_ck, _v) { var currVal_2 = core["ɵnov"](_v, 12).tiny; var currVal_3 = core["ɵnov"](_v, 12).small; var currVal_4 = core["ɵnov"](_v, 12).medium; var currVal_5 = core["ɵnov"](_v, 12).large; var currVal_6 = core["ɵnov"](_v, 12).giant; var currVal_7 = core["ɵnov"](_v, 12).primary; var currVal_8 = core["ɵnov"](_v, 12).info; var currVal_9 = core["ɵnov"](_v, 12).success; var currVal_10 = core["ɵnov"](_v, 12).warning; var currVal_11 = core["ɵnov"](_v, 12).danger; var currVal_12 = core["ɵnov"](_v, 12).basic; var currVal_13 = core["ɵnov"](_v, 12).control; var currVal_14 = core["ɵnov"](_v, 12).hasAccent; var currVal_15 = core["ɵnov"](_v, 12).primaryAccent; var currVal_16 = core["ɵnov"](_v, 12).infoAccent; var currVal_17 = core["ɵnov"](_v, 12).successAccent; var currVal_18 = core["ɵnov"](_v, 12).warningAccent; var currVal_19 = core["ɵnov"](_v, 12).dangerAccent; var currVal_20 = core["ɵnov"](_v, 12).basicAccent; var currVal_21 = core["ɵnov"](_v, 12).controlAccent; _ck(_v, 11, 1, [currVal_2, currVal_3, currVal_4, currVal_5, currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21]); }); }
function View_CustomersComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-customers", [], null, null, null, View_CustomersComponent_0, RenderType_CustomersComponent)), core["ɵdid"](1, 114688, null, 0, customers_component_CustomersComponent, [fesm2015_router["l" /* Router */], empresa_service["a" /* EmpresaService */], cliente_service["a" /* ClienteService */], fesm2015["wc" /* NbMenuService */], request_service["a" /* RequestService */], fesm2015["Ld" /* NbToastrService */], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CustomersComponentNgFactory = core["ɵccf"]("omni-customers", customers_component_CustomersComponent, View_CustomersComponent_Host_0, {}, {}, []);


// CONCATENATED MODULE: ./src/app/pages/customers/send-activation-email/send-activation-email.component.scss.shim.ngstyle.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 
var styles = [""];


// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ngfactory.js + 1 modules
var form_container_component_ngfactory = __webpack_require__("+aW9");

// EXTERNAL MODULE: ./src/app/shared/ui/form-container/form-container.component.ts
var form_container_component = __webpack_require__("NX1Y");

// EXTERNAL MODULE: ./src/app/shared/utils/null.util.ts
var null_util = __webpack_require__("5tvI");

// CONCATENATED MODULE: ./src/app/pages/customers/send-activation-email/send-activation-email.component.ts



class send_activation_email_component_SendActivationEmailComponent {
    constructor(cd, alertService, authService, messagesService, clienteService, requestService, toastrService) {
        this.cd = cd;
        this.alertService = alertService;
        this.authService = authService;
        this.messagesService = messagesService;
        this.clienteService = clienteService;
        this.requestService = requestService;
        this.toastrService = toastrService;
        this.isLoading = false;
        this.isRefreshing = false;
        this.isSubmiting = false;
        this.clienteService.companyId = this.authService.loggedUser.id;
    }
    get faMail() {
        return free_solid_svg_icons["faEnvelope"];
    }
    ngOnInit() {
        this.list();
    }
    checkAllSendEmailState() {
        if (null_util["a" /* NullUtil */].isNotNull(this.checkAllSendEmailRef)) {
            this.checkAllSendEmailRef.checked = this.datasource.filter(_ => _.item.ativo === true).length === this.datasource.length;
        }
    }
    list() {
        this.datasource = [];
        this.currentCustomers = [];
        this.loadState();
        this.clienteService.findInactiveCustomers().subscribe(resultSet => {
            this.loadState();
            this.inactiveCustomers = resultSet;
            resultSet.forEach(customer => {
                const item = {
                    item: customer,
                    itemMenu: null
                };
                this.currentCustomers.push(item);
                this.datasource.push(JSON.parse(JSON.stringify(item)));
            });
            this.cd.markForCheck();
            this.checkAllSendEmailState();
        }, (resp) => {
            this.requestService.handleError(resp, this.toastrService);
            this.loadState();
        });
    }
    submit() {
        const customers = [];
        this.datasource.forEach((_, index) => {
            const current = this.currentCustomers[index].item;
            const changed = _.item;
            if ((current.ativo !== changed.ativo)) {
                customers.push(changed.id);
            }
        });
        this.loadRefreshState();
        this.clienteService.sendEmail(customers).subscribe(() => {
            this.loadRefreshState();
            this.isSubmiting = false;
            this.alertService.success(this.messagesService.getMessage('MSG.SUCESSO.034', ['E-mail(s) de ativação de conta']));
            this.list();
        }, (resp) => {
            this.requestService.handleError(resp, this.toastrService);
            this.loadRefreshState();
        });
    }
    toggleCheckAllSendEmail(checked) {
        this.datasource.map(dataItem => dataItem.item.ativo = checked);
    }
    toggleCheckSendEmail(checked, index) {
        this.datasource[index].item.ativo = checked;
        this.checkAllSendEmailState();
    }
    loadRefreshState() {
        this.isRefreshing = !this.isRefreshing;
    }
    loadState() {
        this.isLoading = !this.isLoading;
    }
}

// CONCATENATED MODULE: ./src/app/pages/customers/send-activation-email/send-activation-email.component.ngfactory.js
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 



















var styles_SendActivationEmailComponent = [styles];
var RenderType_SendActivationEmailComponent = core["ɵcrt"]({ encapsulation: 0, styles: styles_SendActivationEmailComponent, data: {} });

function View_SendActivationEmailComponent_3(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 13, "tr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 3, "td", [], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 2, "div", [["class", "d-flex flex-row align-items-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 1, "div", [["class", "flex-grow-1"]], null, null, null, null, null)), (_l()(), core["ɵted"](4, null, [" ", " "])), (_l()(), core["ɵeld"](5, 0, null, null, 1, "td", [], null, null, null, null, null)), (_l()(), core["ɵted"](6, null, ["", ""])), (_l()(), core["ɵeld"](7, 0, null, null, 2, "td", [["class", "w-15"]], null, null, null, null, null)), (_l()(), core["ɵted"](8, null, [" ", " "])), core["ɵppd"](9, 1), (_l()(), core["ɵeld"](10, 0, null, null, 3, "td", [["class", "text-center w-10"]], null, null, null, null, null)), (_l()(), core["ɵeld"](11, 0, null, null, 2, "nb-checkbox", [["class", "single-checkbox"], ["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], [[null, "checkedChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("checkedChange" === en)) {
        var pd_0 = (_co.toggleCheckSendEmail($event, _v.context.index) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵprd"](5120, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](13, 49152, null, 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { checked: [0, "checked"], status: [1, "status"] }, { checkedChange: "checkedChange" })], function (_ck, _v) { var currVal_10 = _v.context.$implicit.item.ativo; var currVal_11 = "primary"; _ck(_v, 13, 0, currVal_10, currVal_11); }, function (_ck, _v) { var currVal_0 = _v.context.$implicit.item.nome; _ck(_v, 4, 0, currVal_0); var currVal_1 = _v.context.$implicit.item.usuario.login; _ck(_v, 6, 0, currVal_1); var currVal_2 = core["ɵunv"](_v, 8, 0, _ck(_v, 9, 0, core["ɵnov"](_v.parent.parent.parent, 0), _v.context.$implicit.item.telefone)); _ck(_v, 8, 0, currVal_2); var currVal_3 = core["ɵnov"](_v, 13).primary; var currVal_4 = core["ɵnov"](_v, 13).success; var currVal_5 = core["ɵnov"](_v, 13).warning; var currVal_6 = core["ɵnov"](_v, 13).danger; var currVal_7 = core["ɵnov"](_v, 13).info; var currVal_8 = core["ɵnov"](_v, 13).basic; var currVal_9 = core["ɵnov"](_v, 13).control; _ck(_v, 11, 0, currVal_3, currVal_4, currVal_5, currVal_6, currVal_7, currVal_8, currVal_9); }); }
function View_SendActivationEmailComponent_2(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 20, "table", [["class", "table table-bordered table-sm table-hover table-striped"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 16, "thead", [], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 8, "tr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 1, "th", [["class", "text-primary w-45"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Cliente"])), (_l()(), core["ɵeld"](5, 0, null, null, 1, "th", [["class", "text-primary w-30"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["E-mail"])), (_l()(), core["ɵeld"](7, 0, null, null, 1, "th", [["class", "text-primary w-15"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Telefone"])), (_l()(), core["ɵeld"](9, 0, null, null, 1, "th", [["class", "text-primary text-center w-10"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Enviar e-mail"])), (_l()(), core["ɵeld"](11, 0, null, null, 6, "tr", [], null, null, null, null, null)), (_l()(), core["ɵeld"](12, 0, null, null, 1, "th", [["class", "text-right"], ["colspan", "3"]], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["Selecionar Tudo"])), (_l()(), core["ɵeld"](14, 0, null, null, 3, "th", [["class", "text-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](15, 0, null, null, 2, "nb-checkbox", [["class", "single-checkbox"], ["status", "primary"]], [[2, "status-primary", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-info", null], [2, "status-basic", null], [2, "status-control", null]], [[null, "checkedChange"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("checkedChange" === en)) {
        var pd_0 = (_co.toggleCheckAllSendEmail($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, index_ngfactory["R" /* View_NbCheckboxComponent_0 */], index_ngfactory["u" /* RenderType_NbCheckboxComponent */])), core["ɵprd"](5120, null, fesm2015_forms["q" /* NG_VALUE_ACCESSOR */], function (p0_0) { return [p0_0]; }, [fesm2015["Ab" /* NbCheckboxComponent */]]), core["ɵdid"](17, 49152, [[1, 4], ["checkAllSendEmail", 4]], 0, fesm2015["Ab" /* NbCheckboxComponent */], [core["ChangeDetectorRef"]], { status: [0, "status"] }, { checkedChange: "checkedChange" }), (_l()(), core["ɵeld"](18, 0, null, null, 2, "tbody", [], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_SendActivationEmailComponent_3)), core["ɵdid"](20, 278528, null, 0, common["n" /* NgForOf */], [core["ViewContainerRef"], core["TemplateRef"], core["IterableDiffers"]], { ngForOf: [0, "ngForOf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_7 = "primary"; _ck(_v, 17, 0, currVal_7); var currVal_8 = _co.datasource; _ck(_v, 20, 0, currVal_8); }, function (_ck, _v) { var currVal_0 = core["ɵnov"](_v, 17).primary; var currVal_1 = core["ɵnov"](_v, 17).success; var currVal_2 = core["ɵnov"](_v, 17).warning; var currVal_3 = core["ɵnov"](_v, 17).danger; var currVal_4 = core["ɵnov"](_v, 17).info; var currVal_5 = core["ɵnov"](_v, 17).basic; var currVal_6 = core["ɵnov"](_v, 17).control; _ck(_v, 15, 0, currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6); }); }
function View_SendActivationEmailComponent_4(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 2, "div", [["class", "col-12 p-2 text-center"]], null, null, null, null, null)), (_l()(), core["ɵeld"](2, 0, null, null, 1, "em", [], null, null, null, null, null)), (_l()(), core["ɵted"](-1, null, ["N\u00E3o h\u00E1 conta(s) inativa(s) para enviar e-mail de ativa\u00E7\u00E3o."]))], null, null); }
function View_SendActivationEmailComponent_1(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 5, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](1, 0, null, null, 4, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_SendActivationEmailComponent_2)), core["ɵdid"](3, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_SendActivationEmailComponent_4)), core["ɵdid"](5, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_0 = (_co.datasource.length > 0); _ck(_v, 3, 0, currVal_0); var currVal_1 = (_co.datasource.length === 0); _ck(_v, 5, 0, currVal_1); }, null); }
function View_SendActivationEmailComponent_0(_l) { return core["ɵvid"](2, [core["ɵpid"](0, telefone_pipe["a" /* TelefonePipe */], []), core["ɵqud"](671088640, 1, { checkAllSendEmailRef: 0 }), (_l()(), core["ɵeld"](2, 0, null, null, 3, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](3, 0, null, null, 2, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](4, 0, null, null, 1, "omni-page-title", [["pageTitle", "Enviar e-mail de ativa\u00E7\u00E3o"]], null, null, null, page_title_component_ngfactory["b" /* View_PageTitleComponent_0 */], page_title_component_ngfactory["a" /* RenderType_PageTitleComponent */])), core["ɵdid"](5, 114688, null, 0, page_title_component["a" /* PageTitleComponent */], [fesm2015["Rb" /* NbDialogService */]], { icon: [0, "icon"], pageTitle: [1, "pageTitle"] }, null), (_l()(), core["ɵeld"](6, 0, null, null, 12, "div", [["class", "row"]], null, null, null, null, null)), (_l()(), core["ɵeld"](7, 0, null, null, 11, "div", [["class", "col-12"]], null, null, null, null, null)), (_l()(), core["ɵeld"](8, 0, null, null, 10, "omni-form-container", [], null, null, null, form_container_component_ngfactory["b" /* View_FormContainerComponent_0 */], form_container_component_ngfactory["a" /* RenderType_FormContainerComponent */])), core["ɵdid"](9, 114688, null, 0, form_container_component["a" /* FormContainerComponent */], [alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */]], { isLoading: [0, "isLoading"], showBackButton: [1, "showBackButton"], showRequiredInfo: [2, "showRequiredInfo"] }, null), (_l()(), core["ɵeld"](10, 0, null, 1, 4, "div", [["class", "form-content"]], null, null, null, null, null)), (_l()(), core["ɵand"](16777216, null, null, 1, null, View_SendActivationEmailComponent_1)), core["ɵdid"](12, 16384, null, 0, common["o" /* NgIf */], [core["ViewContainerRef"], core["TemplateRef"]], { ngIf: [0, "ngIf"] }, null), (_l()(), core["ɵeld"](13, 0, null, null, 1, "omni-inline-loader", [["label", "Obtendo clientes..."]], null, null, null, inline_loader_component_ngfactory["b" /* View_InlineLoaderComponent_0 */], inline_loader_component_ngfactory["a" /* RenderType_InlineLoaderComponent */])), core["ɵdid"](14, 114688, null, 0, inline_loader_component["a" /* InlineLoaderComponent */], [], { label: [0, "label"], refreshState: [1, "refreshState"] }, null), (_l()(), core["ɵeld"](15, 0, null, 3, 3, "div", [["class", "form-footer mr-2"]], null, null, null, null, null)), (_l()(), core["ɵeld"](16, 0, null, null, 2, "button", [["nbButton", ""], ["status", "success"], ["type", "submit"]], [[1, "disabled", 0], [2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; var _co = _v.component; if (("click" === en)) {
        var pd_0 = (core["ɵnov"](_v, 17).onClick($event) !== false);
        ad = (pd_0 && ad);
    } if (("click" === en)) {
        var pd_1 = (_co.submit() !== false);
        ad = (pd_1 && ad);
    } return ad; }, index_ngfactory["M" /* View_NbButtonComponent_0 */], index_ngfactory["p" /* RenderType_NbButtonComponent */])), core["ɵdid"](17, 4243456, null, 0, fesm2015["L" /* NbButtonComponent */], [core["Renderer2"], core["ElementRef"], core["ChangeDetectorRef"]], { status: [0, "status"] }, null), (_l()(), core["ɵted"](18, 0, [" ", " "]))], function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.faMail; var currVal_1 = "Enviar e-mail de ativa\u00E7\u00E3o"; _ck(_v, 5, 0, currVal_0, currVal_1); var currVal_2 = _co.isLoading; var currVal_3 = false; var currVal_4 = false; _ck(_v, 9, 0, currVal_2, currVal_3, currVal_4); var currVal_5 = !_co.isLoading; _ck(_v, 12, 0, currVal_5); var currVal_6 = "Obtendo clientes..."; var currVal_7 = _co.isLoading; _ck(_v, 14, 0, currVal_6, currVal_7); var currVal_35 = "success"; _ck(_v, 17, 0, currVal_35); }, function (_ck, _v) { var _co = _v.component; var currVal_8 = ((_co.isRefreshing || (_co.datasource.length === 0)) ? true : null); var currVal_9 = core["ɵnov"](_v, 17).filled; var currVal_10 = core["ɵnov"](_v, 17).outline; var currVal_11 = core["ɵnov"](_v, 17).ghost; var currVal_12 = core["ɵnov"](_v, 17).hero; var currVal_13 = core["ɵnov"](_v, 17).fullWidth; var currVal_14 = core["ɵnov"](_v, 17).disabled; var currVal_15 = core["ɵnov"](_v, 17).disabled; var currVal_16 = core["ɵnov"](_v, 17).tabbable; var currVal_17 = core["ɵnov"](_v, 17).tiny; var currVal_18 = core["ɵnov"](_v, 17).small; var currVal_19 = core["ɵnov"](_v, 17).medium; var currVal_20 = core["ɵnov"](_v, 17).large; var currVal_21 = core["ɵnov"](_v, 17).giant; var currVal_22 = core["ɵnov"](_v, 17).primary; var currVal_23 = core["ɵnov"](_v, 17).info; var currVal_24 = core["ɵnov"](_v, 17).success; var currVal_25 = core["ɵnov"](_v, 17).warning; var currVal_26 = core["ɵnov"](_v, 17).danger; var currVal_27 = core["ɵnov"](_v, 17).basic; var currVal_28 = core["ɵnov"](_v, 17).control; var currVal_29 = core["ɵnov"](_v, 17).rectangle; var currVal_30 = core["ɵnov"](_v, 17).round; var currVal_31 = core["ɵnov"](_v, 17).semiRound; var currVal_32 = core["ɵnov"](_v, 17).iconLeft; var currVal_33 = core["ɵnov"](_v, 17).iconRight; var currVal_34 = core["ɵnov"](_v, 17).transitions; _ck(_v, 16, 1, [currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27, currVal_28, currVal_29, currVal_30, currVal_31, currVal_32, currVal_33, currVal_34]); var currVal_36 = (_co.isRefreshing ? "Aguarde..." : "Enviar"); _ck(_v, 18, 0, currVal_36); }); }
function View_SendActivationEmailComponent_Host_0(_l) { return core["ɵvid"](0, [(_l()(), core["ɵeld"](0, 0, null, null, 1, "omni-send-activation-email", [], null, null, null, View_SendActivationEmailComponent_0, RenderType_SendActivationEmailComponent)), core["ɵdid"](1, 114688, null, 0, send_activation_email_component_SendActivationEmailComponent, [core["ChangeDetectorRef"], alert_service["a" /* AlertService */], auth_service["a" /* AuthService */], messages_service["a" /* MessagesService */], cliente_service["a" /* ClienteService */], request_service["a" /* RequestService */], fesm2015["Ld" /* NbToastrService */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var SendActivationEmailComponentNgFactory = core["ɵccf"]("omni-send-activation-email", send_activation_email_component_SendActivationEmailComponent, View_SendActivationEmailComponent_Host_0, {}, {}, []);


// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/sweetalert2-ngx-sweetalert2.ngfactory.js
var sweetalert2_ngx_sweetalert2_ngfactory = __webpack_require__("kExW");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/ngx-bootstrap-typeahead.ngfactory.js
var ngx_bootstrap_typeahead_ngfactory = __webpack_require__("SfUx");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/cashback-credit-dialog/cashback-credit-dialog.component.ngfactory.js + 1 modules
var cashback_credit_dialog_component_ngfactory = __webpack_require__("sKAB");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/category/category-quick-form-dialog/category-quick-form-dialog.component.ngfactory.js + 1 modules
var category_quick_form_dialog_component_ngfactory = __webpack_require__("iY9W");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/customization/edit-customization-value-dialog/edit-customization-value-dialog.component.ngfactory.js + 1 modules
var edit_customization_value_dialog_component_ngfactory = __webpack_require__("x9iD");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/edit-delivery-address-dialog/edit-delivery-address-dialog.component.ngfactory.js + 1 modules
var edit_delivery_address_dialog_component_ngfactory = __webpack_require__("EXuQ");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/cashback/extract-cashback-list-dialog/extract-cashback-list-dialog.component.ngfactory.js + 1 modules
var extract_cashback_list_dialog_component_ngfactory = __webpack_require__("ZjL+");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-detail-dialog/order-detail-dialog.component.ngfactory.js + 3 modules
var order_detail_dialog_component_ngfactory = __webpack_require__("lbLe");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-update-dialog/order-update-dialog.component.ngfactory.js + 1 modules
var order_update_dialog_component_ngfactory = __webpack_require__("/Cjm");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-edit-dialog/promotion-rule-edit-dialog.component.ngfactory.js + 1 modules
var promotion_rule_edit_dialog_component_ngfactory = __webpack_require__("AHux");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/view-picture-dialog/view-picture-dialog.component.ngfactory.js + 1 modules
var view_picture_dialog_component_ngfactory = __webpack_require__("YAEL");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-gift-edit-dialog/promotion-gift-edit-dialog.component.ngfactory.js + 1 modules
var promotion_gift_edit_dialog_component_ngfactory = __webpack_require__("RswS");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/promotion/promotion-rule-view-dialog/promotion-rule-view-dialog.component.ngfactory.js + 1 modules
var promotion_rule_view_dialog_component_ngfactory = __webpack_require__("BRe2");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/orders/order-feedback-dialog/order-feedback-dialog.component.ngfactory.js + 1 modules
var order_feedback_dialog_component_ngfactory = __webpack_require__("otmp");

// EXTERNAL MODULE: ./src/app/shared/ui/dialogs/tutorial-dialog/tutorial-dialog.component.ngfactory.js + 1 modules
var tutorial_dialog_component_ngfactory = __webpack_require__("Uvoc");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/overlay.js
var overlay = __webpack_require__("QQfA");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/bidi.js
var bidi = __webpack_require__("IP0z");

// EXTERNAL MODULE: ./node_modules/@sweetalert2/ngx-sweetalert2/fesm2015/sweetalert2-ngx-sweetalert2.js
var sweetalert2_ngx_sweetalert2 = __webpack_require__("hvj1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/positioning/fesm2015/ngx-bootstrap-positioning.js
var ngx_bootstrap_positioning = __webpack_require__("2uy1");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/component-loader/fesm2015/ngx-bootstrap-component-loader.js
var ngx_bootstrap_component_loader = __webpack_require__("z/SZ");

// EXTERNAL MODULE: ./node_modules/ngx-bootstrap/typeahead/fesm2015/ngx-bootstrap-typeahead.js + 2 modules
var ngx_bootstrap_typeahead = __webpack_require__("ZMeN");

// EXTERNAL MODULE: ./node_modules/br-mask/dist/app.module.js
var app_module = __webpack_require__("CbX2");

// CONCATENATED MODULE: ./src/app/pages/customers/customers-routing.module.ts



const routes = [
    { path: '', component: customers_component_CustomersComponent },
    { path: 'send-activation-email', component: send_activation_email_component_SendActivationEmailComponent }
];
class CustomersRoutingModule {
}

// EXTERNAL MODULE: ./src/app/shared/pipes/pipes.module.ts + 9 modules
var pipes_module = __webpack_require__("9Xeq");

// EXTERNAL MODULE: ./node_modules/angular2-chartjs/dist/chart.module.js
var chart_module = __webpack_require__("AE88");

// EXTERNAL MODULE: ./src/app/shared/directives/directives.module.ts + 1 modules
var directives_module = __webpack_require__("yGOH");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/portal.js
var portal = __webpack_require__("zMNK");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/platform.js
var platform = __webpack_require__("/HVE");

// EXTERNAL MODULE: ./node_modules/@angular/cdk/esm2015/scrolling.js + 6 modules
var scrolling = __webpack_require__("hOhj");

// EXTERNAL MODULE: ./node_modules/@nebular/eva-icons/fesm2015/index.js
var eva_icons_fesm2015 = __webpack_require__("XoTT");

// EXTERNAL MODULE: ./node_modules/ngx-dropzone/fesm2015/ngx-dropzone.js
var ngx_dropzone = __webpack_require__("tq8E");

// EXTERNAL MODULE: ./src/app/shared/ui/ui.module.ts + 6 modules
var ui_module = __webpack_require__("4zvT");

// EXTERNAL MODULE: ./src/app/pages/customers/send-activation-email/send-activation-email.module.ts
var send_activation_email_module = __webpack_require__("XyBk");

// CONCATENATED MODULE: ./src/app/pages/customers/customers.module.ngfactory.js
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomersModuleNgFactory", function() { return CustomersModuleNgFactory; });
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 















































var CustomersModuleNgFactory = core["ɵcmf"](CustomersModule, [], function (_l) { return core["ɵmod"]([core["ɵmpd"](512, core["ComponentFactoryResolver"], core["ɵCodegenComponentFactoryResolver"], [[8, [router_ngfactory["a" /* ɵangular_packages_router_router_lNgFactory */], CustomersComponentNgFactory, SendActivationEmailComponentNgFactory, angular_fontawesome_ngfactory["b" /* FaIconComponentNgFactory */], angular_fontawesome_ngfactory["a" /* FaDuotoneIconComponentNgFactory */], index_ngfactory["h" /* NbContextMenuComponentNgFactory */], index_ngfactory["j" /* NbDialogContainerComponentNgFactory */], index_ngfactory["k" /* NbPopoverComponentNgFactory */], index_ngfactory["n" /* NbTooltipComponentNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["b" /* SwalComponentNgFactory */], sweetalert2_ngx_sweetalert2_ngfactory["d" /* ɵcNgFactory */], ngx_bootstrap_typeahead_ngfactory["a" /* TypeaheadContainerComponentNgFactory */], cashback_credit_dialog_component_ngfactory["a" /* CashbackCreditDialogComponentNgFactory */], category_quick_form_dialog_component_ngfactory["a" /* CategoryQuickFormDialogComponentNgFactory */], edit_customization_value_dialog_component_ngfactory["a" /* EditCustomizationValueDialogComponentNgFactory */], edit_delivery_address_dialog_component_ngfactory["a" /* EditDeliveryAddressDialogComponentNgFactory */], extract_cashback_list_dialog_component_ngfactory["a" /* ExtractCashbackListDialogComponentNgFactory */], order_detail_dialog_component_ngfactory["a" /* OrderDetailDialogComponentNgFactory */], order_update_dialog_component_ngfactory["a" /* OrderUpdateDialogComponentNgFactory */], promotion_rule_edit_dialog_component_ngfactory["a" /* PromotionRuleEditDialogComponentNgFactory */], view_picture_dialog_component_ngfactory["b" /* ViewPictureDialogComponentNgFactory */], promotion_gift_edit_dialog_component_ngfactory["a" /* PromotionGiftEditDialogComponentNgFactory */], promotion_rule_view_dialog_component_ngfactory["a" /* PromotionRuleViewDialogComponentNgFactory */], order_feedback_dialog_component_ngfactory["a" /* OrderFeedbackDialogComponentNgFactory */], tutorial_dialog_component_ngfactory["b" /* TutorialDialogComponentNgFactory */]]], [3, core["ComponentFactoryResolver"]], core["NgModuleRef"]]), core["ɵmpd"](4608, common["q" /* NgLocalization */], common["p" /* NgLocaleLocalization */], [core["LOCALE_ID"], [2, common["R" /* ɵangular_packages_common_common_a */]]]), core["ɵmpd"](4608, fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], fesm2015_forms["B" /* ɵangular_packages_forms_forms_o */], []), core["ɵmpd"](4608, fesm2015_forms["g" /* FormBuilder */], fesm2015_forms["g" /* FormBuilder */], []), core["ɵmpd"](4608, overlay["d" /* Overlay */], overlay["d" /* Overlay */], [overlay["i" /* ScrollStrategyOptions */], overlay["e" /* OverlayContainer */], core["ComponentFactoryResolver"], overlay["h" /* OverlayPositionBuilder */], overlay["f" /* OverlayKeyboardDispatcher */], core["Injector"], core["NgZone"], common["e" /* DOCUMENT */], bidi["b" /* Directionality */], [2, common["k" /* Location */]]]), core["ɵmpd"](5120, overlay["j" /* ɵc */], overlay["k" /* ɵd */], [overlay["d" /* Overlay */]]), core["ɵmpd"](4608, sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], sweetalert2_ngx_sweetalert2["b" /* SwalPartialTargets */], []), core["ɵmpd"](4608, ngx_bootstrap_positioning["a" /* PositioningService */], ngx_bootstrap_positioning["a" /* PositioningService */], [core["NgZone"], core["RendererFactory2"], core["PLATFORM_ID"]]), core["ɵmpd"](4608, ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], ngx_bootstrap_component_loader["a" /* ComponentLoaderFactory */], [core["ComponentFactoryResolver"], core["NgZone"], core["Injector"], ngx_bootstrap_positioning["a" /* PositioningService */], core["ApplicationRef"]]), core["ɵmpd"](4608, ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], ngx_bootstrap_typeahead["a" /* TypeaheadConfig */], []), core["ɵmpd"](1073742336, common["c" /* CommonModule */], common["c" /* CommonModule */], []), core["ɵmpd"](1073742336, app_module["a" /* BrMaskerModule */], app_module["a" /* BrMaskerModule */], []), core["ɵmpd"](1073742336, fesm2015_router["p" /* RouterModule */], fesm2015_router["p" /* RouterModule */], [[2, fesm2015_router["u" /* ɵangular_packages_router_router_a */]], [2, fesm2015_router["l" /* Router */]]]), core["ɵmpd"](1073742336, CustomersRoutingModule, CustomersRoutingModule, []), core["ɵmpd"](1073742336, angular_fontawesome["j" /* FontAwesomeModule */], angular_fontawesome["j" /* FontAwesomeModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], fesm2015_forms["A" /* ɵangular_packages_forms_forms_d */], []), core["ɵmpd"](1073742336, fesm2015_forms["n" /* FormsModule */], fesm2015_forms["n" /* FormsModule */], []), core["ɵmpd"](1073742336, fesm2015["pe" /* ɵc */], fesm2015["pe" /* ɵc */], []), core["ɵmpd"](1073742336, fesm2015["dc" /* NbIconModule */], fesm2015["dc" /* NbIconModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["nb" /* NbCardModule */], fesm2015["nb" /* NbCardModule */], []), core["ɵmpd"](1073742336, fesm2015["M" /* NbButtonModule */], fesm2015["M" /* NbButtonModule */], []), core["ɵmpd"](1073742336, fesm2015["fc" /* NbInputModule */], fesm2015["fc" /* NbInputModule */], []), core["ɵmpd"](1073742336, pipes_module["a" /* PipesModule */], pipes_module["a" /* PipesModule */], []), core["ɵmpd"](1073742336, fesm2015_forms["x" /* ReactiveFormsModule */], fesm2015_forms["x" /* ReactiveFormsModule */], []), core["ɵmpd"](1073742336, fesm2015["Bb" /* NbCheckboxModule */], fesm2015["Bb" /* NbCheckboxModule */], []), core["ɵmpd"](1073742336, chart_module["ChartModule"], chart_module["ChartModule"], []), core["ɵmpd"](1073742336, directives_module["a" /* DirectivesModule */], directives_module["a" /* DirectivesModule */], []), core["ɵmpd"](1073742336, fesm2015["D" /* NbAlertModule */], fesm2015["D" /* NbAlertModule */], []), core["ɵmpd"](1073742336, fesm2015["F" /* NbBadgeModule */], fesm2015["F" /* NbBadgeModule */], []), core["ɵmpd"](1073742336, fesm2015["B" /* NbActionsModule */], fesm2015["B" /* NbActionsModule */], []), core["ɵmpd"](1073742336, bidi["a" /* BidiModule */], bidi["a" /* BidiModule */], []), core["ɵmpd"](1073742336, portal["f" /* PortalModule */], portal["f" /* PortalModule */], []), core["ɵmpd"](1073742336, platform["b" /* PlatformModule */], platform["b" /* PlatformModule */], []), core["ɵmpd"](1073742336, scrolling["b" /* ScrollingModule */], scrolling["b" /* ScrollingModule */], []), core["ɵmpd"](1073742336, overlay["g" /* OverlayModule */], overlay["g" /* OverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["pb" /* NbCdkMappingModule */], fesm2015["pb" /* NbCdkMappingModule */], []), core["ɵmpd"](1073742336, fesm2015["ob" /* NbCdkAdapterModule */], fesm2015["ob" /* NbCdkAdapterModule */], []), core["ɵmpd"](1073742336, fesm2015["Ec" /* NbOverlayModule */], fesm2015["Ec" /* NbOverlayModule */], []), core["ɵmpd"](1073742336, fesm2015["vc" /* NbMenuModule */], fesm2015["vc" /* NbMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Gb" /* NbContextMenuModule */], fesm2015["Gb" /* NbContextMenuModule */], []), core["ɵmpd"](1073742336, fesm2015["Qb" /* NbDialogModule */], fesm2015["Qb" /* NbDialogModule */], []), core["ɵmpd"](1073742336, eva_icons_fesm2015["a" /* NbEvaIconsModule */], eva_icons_fesm2015["a" /* NbEvaIconsModule */], [fesm2015["cc" /* NbIconLibraries */]]), core["ɵmpd"](1073742336, fesm2015["rc" /* NbListModule */], fesm2015["rc" /* NbListModule */], []), core["ɵmpd"](1073742336, fesm2015["Lc" /* NbPopoverModule */], fesm2015["Lc" /* NbPopoverModule */], []), core["ɵmpd"](1073742336, fesm2015["Vc" /* NbRadioModule */], fesm2015["Vc" /* NbRadioModule */], []), core["ɵmpd"](1073742336, fesm2015["kd" /* NbSelectModule */], fesm2015["kd" /* NbSelectModule */], []), core["ɵmpd"](1073742336, fesm2015["Ed" /* NbTabsetModule */], fesm2015["Ed" /* NbTabsetModule */], []), core["ɵmpd"](1073742336, fesm2015["Qd" /* NbTooltipModule */], fesm2015["Qd" /* NbTooltipModule */], []), core["ɵmpd"](1073742336, fesm2015["fe" /* NbUserModule */], fesm2015["fe" /* NbUserModule */], []), core["ɵmpd"](1073742336, ngx_dropzone["c" /* NgxDropzoneModule */], ngx_dropzone["c" /* NgxDropzoneModule */], []), core["ɵmpd"](1073742336, sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], sweetalert2_ngx_sweetalert2["c" /* SweetAlert2Module */], []), core["ɵmpd"](1073742336, ngx_bootstrap_typeahead["d" /* TypeaheadModule */], ngx_bootstrap_typeahead["d" /* TypeaheadModule */], []), core["ɵmpd"](1073742336, ui_module["a" /* UiModule */], ui_module["a" /* UiModule */], []), core["ɵmpd"](1073742336, send_activation_email_module["a" /* SendActivationEmailModule */], send_activation_email_module["a" /* SendActivationEmailModule */], []), core["ɵmpd"](1073742336, CustomersModule, CustomersModule, []), core["ɵmpd"](1024, fesm2015_router["j" /* ROUTES */], function () { return [[{ path: "", component: customers_component_CustomersComponent }, { path: "send-activation-email", component: send_activation_email_component_SendActivationEmailComponent }]]; }, []), core["ɵmpd"](256, sweetalert2_ngx_sweetalert2["d" /* ɵa */], undefined, [])]); });



/***/ }),

/***/ "JAJw":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return TelefoneValidator; });
/* harmony import */ var src_app_shared_utils_string_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("8n1d");

function TelefoneValidator(control) {
    if (control.value && control.value.trim()) {
        const pattern = /^([\+][0-9]{1,3}([ \.\-])?)?([\(][0-9]{1,6}[\)])?([0-9 \.\-]{1,32})(([A-Za-z \:]{1,11})?[0-9]{1,4}?)$/;
        const regex = new RegExp(pattern, 'g');
        const numero = src_app_shared_utils_string_util__WEBPACK_IMPORTED_MODULE_0__[/* StringUtil */ "a"].removeAllSpecialChars(control.value);
        if (!regex.test(control.value) || numero.length < 10 || src_app_shared_utils_string_util__WEBPACK_IMPORTED_MODULE_0__[/* StringUtil */ "a"].isRepeatedChars(numero)) {
            return { invalidPhone: true };
        }
    }
    return null;
}


/***/ }),

/***/ "JmCY":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return NavExtrasService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("8Y7J");

class NavExtrasService {
    constructor() { }
    setExtras(...data) {
        this.extras = data;
    }
    getExtras() {
        return this.extras;
    }
    resetExtras() {
        this.extras = null;
    }
}
NavExtrasService.ngInjectableDef = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵdefineInjectable"]({ factory: function NavExtrasService_Factory() { return new NavExtrasService(); }, token: NavExtrasService, providedIn: "root" });


/***/ }),

/***/ "QM7m":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RenderType_DropdownMenuComponent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return View_DropdownMenuComponent_0; });
/* unused harmony export View_DropdownMenuComponent_Host_0 */
/* unused harmony export DropdownMenuComponentNgFactory */
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("8Y7J");
/* harmony import */ var _node_modules_nebular_theme_index_ngfactory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("jXVt");
/* harmony import */ var _nebular_theme__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tKwJ");
/* harmony import */ var _node_modules_fortawesome_angular_fontawesome_angular_fontawesome_ngfactory__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("fNgX");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("SVse");
/* harmony import */ var _fortawesome_angular_fontawesome__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("Nv++");
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("cUpR");
/* harmony import */ var _dropdown_menu_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("jEJX");
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 








var styles_DropdownMenuComponent = [];
var RenderType_DropdownMenuComponent = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵcrt"]({ encapsulation: 2, styles: styles_DropdownMenuComponent, data: {} });

function View_DropdownMenuComponent_1(_l) { return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵvid"](0, [(_l()(), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵeld"](0, 0, null, null, 1, "span", [], null, null, null, null, null)), (_l()(), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵted"](1, null, ["", ""]))], null, function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.label; _ck(_v, 1, 0, currVal_0); }); }
function View_DropdownMenuComponent_0(_l) { return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵvid"](0, [(_l()(), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵeld"](0, 0, null, null, 11, "button", [["nbButton", ""], ["nbContextMenuTag", "context-menu-dropdown"], ["size", "small"], ["type", "button"]], [[1, "disabled", 0], [2, "appearance-filled", null], [2, "appearance-outline", null], [2, "appearance-ghost", null], [2, "appearance-hero", null], [2, "full-width", null], [1, "aria-disabled", 0], [2, "btn-disabled", null], [1, "tabindex", 0], [2, "size-tiny", null], [2, "size-small", null], [2, "size-medium", null], [2, "size-large", null], [2, "size-giant", null], [2, "status-primary", null], [2, "status-info", null], [2, "status-success", null], [2, "status-warning", null], [2, "status-danger", null], [2, "status-basic", null], [2, "status-control", null], [2, "shape-rectangle", null], [2, "shape-round", null], [2, "shape-semi-round", null], [2, "icon-start", null], [2, "icon-end", null], [2, "transitions", null], [2, "context-menu-host", null]], [[null, "click"]], function (_v, en, $event) { var ad = true; if (("click" === en)) {
        var pd_0 = (_angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).onClick($event) !== false);
        ad = (pd_0 && ad);
    } return ad; }, _node_modules_nebular_theme_index_ngfactory__WEBPACK_IMPORTED_MODULE_1__[/* View_NbButtonComponent_0 */ "M"], _node_modules_nebular_theme_index_ngfactory__WEBPACK_IMPORTED_MODULE_1__[/* RenderType_NbButtonComponent */ "p"])), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵdid"](1, 4243456, null, 0, _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbButtonComponent */ "L"], [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Renderer2"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["ElementRef"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["ChangeDetectorRef"]], { size: [0, "size"], status: [1, "status"], appearance: [2, "appearance"], fullWidth: [3, "fullWidth"] }, null), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵprd"](512, null, _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbDynamicOverlay */ "Tb"], _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbDynamicOverlay */ "Tb"], [_nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbOverlayService */ "Gc"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["ComponentFactoryResolver"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["NgZone"], _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbOverlayContainer */ "Bc"]]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵprd"](512, null, _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbDynamicOverlayHandler */ "Ub"], _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbDynamicOverlayHandler */ "Ub"], [_nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbPositionBuilderService */ "Oc"], _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbTriggerStrategyBuilderService */ "de"], _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbDynamicOverlay */ "Tb"]]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵdid"](4, 4931584, null, 0, _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbContextMenuDirective */ "Fb"], [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ElementRef"], _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbMenuService */ "wc"], _nebular_theme__WEBPACK_IMPORTED_MODULE_2__[/* NbDynamicOverlayHandler */ "Ub"]], { tag: [0, "tag"], items: [1, "items"] }, null), (_l()(), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵeld"](5, 0, null, 0, 4, "fa-icon", [["class", "ng-fa-icon"]], [[1, "title", 0], [8, "innerHTML", 1]], null, null, _node_modules_fortawesome_angular_fontawesome_angular_fontawesome_ngfactory__WEBPACK_IMPORTED_MODULE_3__[/* View_FaIconComponent_0 */ "d"], _node_modules_fortawesome_angular_fontawesome_angular_fontawesome_ngfactory__WEBPACK_IMPORTED_MODULE_3__[/* RenderType_FaIconComponent */ "c"])), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵprd"](512, null, _angular_common__WEBPACK_IMPORTED_MODULE_4__[/* ɵNgClassImpl */ "K"], _angular_common__WEBPACK_IMPORTED_MODULE_4__[/* ɵNgClassR2Impl */ "L"], [_angular_core__WEBPACK_IMPORTED_MODULE_0__["IterableDiffers"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["KeyValueDiffers"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["ElementRef"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["Renderer2"]]), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵdid"](7, 278528, null, 0, _angular_common__WEBPACK_IMPORTED_MODULE_4__[/* NgClass */ "m"], [_angular_common__WEBPACK_IMPORTED_MODULE_4__[/* ɵNgClassImpl */ "K"]], { ngClass: [0, "ngClass"] }, null), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵpod"](8, { "mr-2": 0 }), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵdid"](9, 573440, null, 0, _fortawesome_angular_fontawesome__WEBPACK_IMPORTED_MODULE_5__[/* FaIconComponent */ "c"], [_angular_platform_browser__WEBPACK_IMPORTED_MODULE_6__[/* DomSanitizer */ "b"], _fortawesome_angular_fontawesome__WEBPACK_IMPORTED_MODULE_5__[/* FaConfig */ "a"], _fortawesome_angular_fontawesome__WEBPACK_IMPORTED_MODULE_5__[/* FaIconLibrary */ "d"], [2, _fortawesome_angular_fontawesome__WEBPACK_IMPORTED_MODULE_5__[/* FaStackItemSizeDirective */ "i"]]], { icon: [0, "icon"] }, null), (_l()(), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵand"](16777216, null, 0, 1, null, View_DropdownMenuComponent_1)), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵdid"](11, 16384, null, 0, _angular_common__WEBPACK_IMPORTED_MODULE_4__[/* NgIf */ "o"], [_angular_core__WEBPACK_IMPORTED_MODULE_0__["ViewContainerRef"], _angular_core__WEBPACK_IMPORTED_MODULE_0__["TemplateRef"]], { ngIf: [0, "ngIf"] }, null)], function (_ck, _v) { var _co = _v.component; var currVal_28 = "small"; var currVal_29 = _co.status; var currVal_30 = _co.appearance; var currVal_31 = !_co.isResponsive; _ck(_v, 1, 0, currVal_28, currVal_29, currVal_30, currVal_31); var currVal_32 = "context-menu-dropdown"; var currVal_33 = _co.optionsList; _ck(_v, 4, 0, currVal_32, currVal_33); var currVal_36 = _ck(_v, 8, 0, !_co.isResponsive); _ck(_v, 7, 0, currVal_36); var currVal_37 = _co.icon; _ck(_v, 9, 0, currVal_37); var currVal_38 = !_co.isResponsive; _ck(_v, 11, 0, currVal_38); }, function (_ck, _v) { var _co = _v.component; var currVal_0 = (_co.isLoading ? true : null); var currVal_1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).filled; var currVal_2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).outline; var currVal_3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).ghost; var currVal_4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).hero; var currVal_5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).fullWidth; var currVal_6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).disabled; var currVal_7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).disabled; var currVal_8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).tabbable; var currVal_9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).tiny; var currVal_10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).small; var currVal_11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).medium; var currVal_12 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).large; var currVal_13 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).giant; var currVal_14 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).primary; var currVal_15 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).info; var currVal_16 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).success; var currVal_17 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).warning; var currVal_18 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).danger; var currVal_19 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).basic; var currVal_20 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).control; var currVal_21 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).rectangle; var currVal_22 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).round; var currVal_23 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).semiRound; var currVal_24 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).iconLeft; var currVal_25 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).iconRight; var currVal_26 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 1).transitions; var currVal_27 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 4).contextMenuHost; _ck(_v, 0, 1, [currVal_0, currVal_1, currVal_2, currVal_3, currVal_4, currVal_5, currVal_6, currVal_7, currVal_8, currVal_9, currVal_10, currVal_11, currVal_12, currVal_13, currVal_14, currVal_15, currVal_16, currVal_17, currVal_18, currVal_19, currVal_20, currVal_21, currVal_22, currVal_23, currVal_24, currVal_25, currVal_26, currVal_27]); var currVal_34 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 9).title; var currVal_35 = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵnov"](_v, 9).renderedIconHTML; _ck(_v, 5, 0, currVal_34, currVal_35); }); }
function View_DropdownMenuComponent_Host_0(_l) { return _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵvid"](0, [(_l()(), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵeld"](0, 0, null, null, 1, "omni-dropdown-menu", [], null, null, null, View_DropdownMenuComponent_0, RenderType_DropdownMenuComponent)), _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵdid"](1, 114688, null, 0, _dropdown_menu_component__WEBPACK_IMPORTED_MODULE_7__[/* DropdownMenuComponent */ "a"], [], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var DropdownMenuComponentNgFactory = _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵccf"]("omni-dropdown-menu", _dropdown_menu_component__WEBPACK_IMPORTED_MODULE_7__[/* DropdownMenuComponent */ "a"], View_DropdownMenuComponent_Host_0, { appearance: "appearance", icon: "icon", isLoading: "isLoading", label: "label", mode: "mode", optionsList: "optionsList", status: "status" }, {}, []);



/***/ }),

/***/ "XyBk":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return SendActivationEmailModule; });
class SendActivationEmailModule {
}


/***/ }),

/***/ "a0Ve":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export PerfilDoUsuario */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return PERFIL_USUARIO; });
class PerfilDoUsuario {
    constructor(id, descricao) {
        this.id = id;
        this.descricao = descricao;
    }
}
const PERFIL_USUARIO = {
    ADMINISTRADOR: new PerfilDoUsuario(1, 'Administrador'),
    CLIENTE: new PerfilDoUsuario(2, 'Cliente'),
    EMPRESA: new PerfilDoUsuario(3, 'Empresa'),
    VENDEDOR: new PerfilDoUsuario(4, 'Vendedor')
};


/***/ }),

/***/ "eCBd":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ClienteService; });
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("IheW");
/* harmony import */ var _resource_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("edFq");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("8Y7J");




class ClienteService extends _resource_service__WEBPACK_IMPORTED_MODULE_1__[/* ResourceService */ "a"] {
    constructor(http) {
        super(http, 'admin/clientes');
    }
    /**
     * Update an User, changing block status on it.
     * @param customer: Cliente
     */
    blockOrUnblockCustomer(customer) {
        const params = new _angular_common_http__WEBPACK_IMPORTED_MODULE_0__[/* HttpParams */ "h"]()
            .append('customerId', customer.id.toString());
        return this.http.put(`${this.api}/${this.endpoint}/${customer.empresa.id}/bloqueio/usuario`, params);
    }
    /**
     * Atualiza o estado de bloqueio de recebimento de pagamento online do cliente.
     * @param customerId number
     */
    lockOnlinePaymentReceivement(customerId) {
        const params = new _angular_common_http__WEBPACK_IMPORTED_MODULE_0__[/* HttpParams */ "h"]().append('customerId', customerId.toString());
        return this.http.put(`${this.api}/${this.endpoint}/${this.vendorId}/bloqueio/pagamento-online`, params);
    }
    findInactiveCustomers() {
        return this.http.get(`${this.api}/${this.endpoint}/${this.vendorId}/inactive-customers`);
    }
    getCustomerStatus(status) {
        return status ? 'success' : 'danger';
    }
    /**
     * Get all users who don't buy anything in the last 90 days.
     */
    getDetachedCustomers() {
        return this.http.get(`${this.api}/${this.endpoint}/${this.vendorId}/consultas/sem-pedidos-90`);
    }
    /**
     * Update all customers data.
     * @param customers: Cliente[]
     * @returns Observable<Cliente[]>
     */
    sendEmail(customers) {
        return this.http.post(`${this.api}/${this.endpoint}/${this.vendorId}/send-email`, customers);
    }
}
ClienteService.ngInjectableDef = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({ factory: function ClienteService_Factory() { return new ClienteService(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_0__[/* HttpClient */ "c"])); }, token: ClienteService, providedIn: "root" });


/***/ }),

/***/ "iqQw":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Perfil; });
/* harmony import */ var _resource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("05o1");

class Perfil extends _resource__WEBPACK_IMPORTED_MODULE_0__[/* Resource */ "a"] {
    constructor(id) {
        super();
        this.id = id || null;
    }
}


/***/ }),

/***/ "iufN":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Usuario; });
/* harmony import */ var _resource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("05o1");

class Usuario extends _resource__WEBPACK_IMPORTED_MODULE_0__[/* Resource */ "a"] {
    constructor(login, senha, confirmacaoSenha) {
        super();
        this.login = login || '';
        this.senha = senha || '';
        this.confirmacaoSenha = confirmacaoSenha || '';
        this.bloqueado = false;
        this.demonstracao = false;
    }
}


/***/ })

};;