/*
 * Decompiled with CFR 0.152.
 */
package br.com.escolpi.omni.printer.resource;

import br.com.escolpi.omni.printer.enumeration.FormaDeEntrega;
import br.com.escolpi.omni.printer.enumeration.FormaDePagamento;
import br.com.escolpi.omni.printer.enumeration.FuncaoPagamento;
import br.com.escolpi.omni.printer.enumeration.SituacaoDoPedido;
import br.com.escolpi.omni.printer.enumeration.TipoCupomDesconto;
import br.com.escolpi.omni.printer.helper.Category;
import br.com.escolpi.omni.printer.helper.Printer;
import br.com.escolpi.omni.printer.helper.PrinterSettings;
import br.com.escolpi.omni.printer.model.CestaDePromocao;
import br.com.escolpi.omni.printer.model.Cliente;
import br.com.escolpi.omni.printer.model.Empresa;
import br.com.escolpi.omni.printer.model.GrupoDePersonalizacoes;
import br.com.escolpi.omni.printer.model.ItemDoPedido;
import br.com.escolpi.omni.printer.model.ItemDoPedidoPorPromocao;
import br.com.escolpi.omni.printer.model.OpcaoDePagamento;
import br.com.escolpi.omni.printer.model.OpcionalDoItemDoPedido;
import br.com.escolpi.omni.printer.model.Pedido;
import br.com.escolpi.omni.printer.model.Personalizacao;
import br.com.escolpi.omni.printer.model.PersonalizacaoDeProduto;
import br.com.escolpi.omni.printer.model.Produto;
import br.com.escolpi.omni.printer.model.ValorDaPersonalizacao;
import br.com.escolpi.omni.printer.service.PrinterService;
import br.com.escolpi.omni.printer.util.DateUtil;
import br.com.escolpi.omni.printer.util.NullUtil;
import br.com.escolpi.omni.printer.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/printer"})
public class PrintOrderResource {
    public static final String API_URL = "https://api1.pedidoagora.com.br";
    private static final String LOCAL_API_URL = "http://localhost:8080";
    private static final String URL_GET_COMPANY_ENDPOINT = "/empresas/%s";
    private static final String PEDIDO_PARA_ENTREGA = "PEDIDO PARA ENTREGA";
    private static final String PEDIDO_A_RETIRAR = "PEDIDO A RETIRAR";
    private static final String PEDIDO_NA_MESA = "PEDIDO NA MESA %s";
    @Autowired
    private PrinterService printerService;
    private PrinterSettings settings;
    private Empresa company;

    @PostMapping(value={"/full-order"})
    public void printFullOrder(@RequestBody Pedido order) throws Exception {
        this.initPrinterSettings();
        this.initCompany();
        order.setEmpresa(this.company);
        StringBuilder text = new StringBuilder();
        text.append(this.getDeliveryWayDescription(order));
        this.renderHeader(order, text, Boolean.valueOf(true));
        this.renderOrderItems(order, text);
        this.renderOrderItemsByPromotion(order, text);
        this.renderSummary(order, text);
        this.renderFooter(text);
        for (int i = 0; i < order.getEmpresa().getQuantidadeImpressoes(); ++i) {
            this.printerService.printString(this.settings.getDefaultPrinter().getPath(), text.toString(), Integer.valueOf(0), Integer.valueOf(this.settings.getJumpsLinesAfterEnd()));
            if (!this.printerService.printersWillCutPaper().booleanValue()) continue;
            this.printerService.printString(this.settings.getDefaultPrinter().getPath(), "\u001bm", Integer.valueOf(0), Integer.valueOf(0));
        }
    }

    @PostMapping(value={"/order"})
    public void printOrder(@RequestBody Pedido order) throws Exception {
        this.initPrinterSettings();
        this.initCompany();
        order.setEmpresa(this.company);
        HashMap rows = new HashMap();
        HashMap keySet = this.distributeItemsToPrinters(order);
        StringBuilder text = new StringBuilder();
        for (Map.Entry entry : keySet.entrySet()) {
            for (StringBuilder value : ((HashMap)entry.getValue()).values()) {
                if (!rows.containsKey(entry.getKey())) {
                    text = value;
                } else {
                    StringBuilder builder = new StringBuilder((CharSequence)rows.get(entry.getKey()));
                    text = builder.append((CharSequence)value);
                }
                rows.put(entry.getKey(), text);
                text = new StringBuilder();
            }
        }
        for (String key : rows.keySet()) {
            text = new StringBuilder();
            if (order.getFormaEntrega().equals((Object)FormaDeEntrega.NA_MESA)) {
                String tableCustomerName = this.getDeliveryWayDescription(order).concat(" - ").concat(order.getNomeClienteMesa().toUpperCase());
                text.append(tableCustomerName.length() > 48 ? tableCustomerName.subSequence(0, 48) : tableCustomerName);
            }
            this.renderHeader(order, text, Boolean.valueOf(false));
            text.append((CharSequence)rows.get(key));
            this.renderFooter(text);
            for (int i = 0; i < order.getEmpresa().getQuantidadeImpressoes(); ++i) {
                this.printerService.printString(key, text.toString(), Integer.valueOf(0), Integer.valueOf(this.settings.getJumpsLinesAfterEnd()));
                if (!this.printerService.printersWillCutPaper().booleanValue()) continue;
                this.printerService.printString(key, "\u001bm", Integer.valueOf(0), Integer.valueOf(0));
            }
        }
    }

    private void addTextToPrinter(HashMap<String, HashMap<String, StringBuilder>> texts, String printerPath, StringBuilder text, String categoryName, ItemDoPedido item) {
        if (!texts.containsKey(printerPath)) {
            HashMap<String, StringBuilder> hm = new HashMap<String, StringBuilder>();
            hm.put(categoryName, text);
            texts.put(printerPath, hm);
        } else if (!texts.get(printerPath).containsKey(categoryName)) {
            texts.get(printerPath).put(categoryName, text);
        } else {
            HashMap<String, StringBuilder> hm = new HashMap<String, StringBuilder>();
            StringBuilder sb = new StringBuilder();
            sb.append((CharSequence)(NullUtil.isNotNull((Object)item.getObservacoes()) ? text.append(item.getObservacoes()) : text));
            for (Map.Entry<String, StringBuilder> entry : texts.get(printerPath).entrySet()) {
                sb.append((CharSequence)entry.getValue());
                hm.put(categoryName, sb);
                texts.put(printerPath, hm);
            }
        }
    }

    private void addTextToPrinter(HashMap<String, HashMap<String, StringBuilder>> texts, String printerPath, StringBuilder text, String categoryName, ItemDoPedidoPorPromocao item) {
        if (NullUtil.isNotNull((Object)item.getObservacoes()) && StringUtil.isNotBlank((String)item.getObservacoes())) {
            text.append(String.format("OBS: %s", item.getObservacoes().toUpperCase())).append("\n");
        }
        if (!texts.containsKey(printerPath)) {
            HashMap<String, StringBuilder> hm = new HashMap<String, StringBuilder>();
            hm.put(categoryName, text);
            texts.put(printerPath, hm);
        } else if (!texts.get(printerPath).containsKey(categoryName)) {
            texts.get(printerPath).put(categoryName, text);
        } else {
            HashMap<String, StringBuilder> hm = new HashMap<String, StringBuilder>();
            StringBuilder sb = new StringBuilder();
            sb.append((CharSequence)text);
            for (Map.Entry<String, StringBuilder> entry : texts.get(printerPath).entrySet()) {
                sb.append((CharSequence)entry.getValue());
                hm.put(categoryName, sb);
                texts.put(printerPath, hm);
            }
        }
    }

    private void createConfigFile(File configFile) throws IOException {
        if (configFile.createNewFile()) {
            FileWriter writer = new FileWriter(configFile);
            String oldConfigFilePath = System.getProperty("user.dir") + File.separator + "printer-cfg.txt";
            File oldConfigFile = new File(oldConfigFilePath);
            if (oldConfigFile.exists()) {
                String defaultPrinter = new String(Files.readAllBytes(oldConfigFile.toPath()));
                writer.write(String.format("{ \n\t\"printers\": [\n\t\t{ \"path\": \"%s\", \"default\": %s }\n\t],\n\t\"categories\": [\n\t\t{ \"description\": \"\", \"printer\": \"%s\" }\n\t],\n\t\"triggerGuillotine\": true\n}", defaultPrinter, true, defaultPrinter));
                oldConfigFile.delete();
            } else {
                writer.write(String.format("{ \n\t\"printers\": [\n\t\t{ \"path\": \"%s\", \"default\": %s }\n\t],\n\t\"categories\": [\n\t\t{ \"description\": \"\", \"printer\": \"%s\" }\n\t],\n\t\"triggerGuillotine\": true\n}", "IMPCAIXA", false, "IMPCAIXA"));
            }
            writer.close();
        }
    }

    private HashMap<String, HashMap<String, StringBuilder>> distributeItemsToPrinters(Pedido order) {
        StringBuilder text;
        HashMap<String, HashMap<String, StringBuilder>> texts = new HashMap<String, HashMap<String, StringBuilder>>();
        Set categoriesNames = this.settings.getCategories().stream().map(category -> category.getDescription()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            text = new StringBuilder();
            for (ItemDoPedido item : order.getItensDoPedido()) {
                String currentCategoryName;
                if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                    this.groupProductNameByComposition(item, text, Boolean.valueOf(false));
                } else {
                    this.groupProductName(item, text, Boolean.valueOf(false));
                }
                if (NullUtil.isNotEmpty((Collection)item.getGrupoPersonalizacoesDeProduto())) {
                    for (Object grupo : item.getGrupoPersonalizacoesDeProduto()) {
                        text.append(StringUtil.generateWhitespace((int)8)).append(((PersonalizacaoDeProduto)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                        if (!CollectionUtils.isEmpty((Collection)grupo.getOpcionais())) {
                            for (OpcionalDoItemDoPedido optional : grupo.getOpcionais()) {
                                text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNullOrZero((Serializable)optional.getQuantidade()) ? optional.getQuantidade() : 1L).append("x ").append(NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getProduto()) ? optional.getValorDaPersonalizacao().getProduto().getNome().toUpperCase() : optional.getValorDaPersonalizacao().getDescricao().toUpperCase()).append("\n");
                            }
                            continue;
                        }
                        for (ValorDaPersonalizacao valor : grupo.getValoresDaPersonalizacao()) {
                            text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNull((Object)valor.getProduto()) ? valor.getProduto().getNome().toUpperCase() : valor.getDescricao().toUpperCase()).append("\n");
                        }
                    }
                }
                if (NullUtil.isNotEmpty((Collection)item.getGrupoPersonalizacoes())) {
                    for (Object grupo : item.getGrupoPersonalizacoes()) {
                        text.append(StringUtil.generateWhitespace((int)8)).append(((Personalizacao)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                        if (!CollectionUtils.isEmpty((Collection)grupo.getOpcionais())) {
                            for (OpcionalDoItemDoPedido optional : grupo.getOpcionais()) {
                                text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNullOrZero((Serializable)optional.getQuantidade()) ? optional.getQuantidade() : 1L).append("x ").append(NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getProduto()) ? optional.getValorDaPersonalizacao().getProduto().getNome().toUpperCase() : optional.getValorDaPersonalizacao().getDescricao().toUpperCase()).append("\n");
                            }
                            continue;
                        }
                        text.append(StringUtil.generateWhitespace((int)8)).append(((Personalizacao)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                        for (ValorDaPersonalizacao valor : grupo.getValoresDaPersonalizacao()) {
                            text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNull((Object)valor.getProduto()) ? valor.getProduto().getNome().toUpperCase() : valor.getDescricao().toUpperCase()).append("\n");
                        }
                    }
                }
                if (StringUtil.isNotBlank((String)item.getObservacoes())) {
                    text.append(String.format("OBS: %s", item.getObservacoes().toUpperCase())).append("\n").append("\n");
                }
                if (categoriesNames.contains(currentCategoryName = NullUtil.isNotNull((Object)item.getProdutoComposto()) ? ((Produto)item.getProdutoComposto().getProdutos().get(0)).getCategoria().getDescricao().toUpperCase().trim() : item.getProduto().getCategoria().getDescricao().toUpperCase().trim())) {
                    Object grupo;
                    grupo = this.getPrintersOfCategory(currentCategoryName).iterator();
                    while (grupo.hasNext()) {
                        Printer printer = (Printer)grupo.next();
                        this.addTextToPrinter(texts, printer.getPath(), text, currentCategoryName, item);
                    }
                } else {
                    this.addTextToPrinter(texts, this.settings.getDefaultPrinter().getPath(), text, currentCategoryName, item);
                }
                text = new StringBuilder();
            }
        }
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            text = new StringBuilder();
            for (CestaDePromocao cesta : order.getCestasDePromocao()) {
                if (CollectionUtils.isEmpty((Collection)cesta.getItens())) continue;
                for (ItemDoPedidoPorPromocao item : cesta.getItens()) {
                    String observacao = NullUtil.isNotNull((Object)item.getObservacoes()) ? new String(item.getObservacoes()) : null;
                    System.out.println(observacao);
                    text.append(StringUtil.renderTableLine((String)"%1$-4s %2$-23s %3$1s", (int)42, (String[])new String[]{cesta.getQuantidade().toString(), "PROMO " + StringUtil.removerAcentos((String)this.printerService.truncateText(cesta.getPromocao().getTitulo(), 41).toUpperCase()), ""}));
                    String categoryName = item.getProduto().getCategoria().getDescricao().toUpperCase().trim();
                    if (categoriesNames.contains(categoryName)) {
                        String categoryPrinter = "";
                        for (Category category2 : this.settings.getCategories()) {
                            if (!category2.getDescription().toUpperCase().trim().equals(categoryName)) continue;
                            categoryPrinter = category2.getPrinterName();
                            break;
                        }
                        this.groupProductNameByPromotion(item, text, Boolean.valueOf(false));
                        this.addTextToPrinter(texts, categoryPrinter, text, categoryName, item);
                    } else {
                        this.addTextToPrinter(texts, this.settings.getDefaultPrinter().getPath(), text, categoryName, item);
                    }
                    if (NullUtil.isNotEmpty((Collection)item.getGrupoPersonalizacoesDeProduto())) {
                        for (GrupoDePersonalizacoes grupo : item.getGrupoPersonalizacoesDeProduto()) {
                            text.append(StringUtil.generateWhitespace((int)8)).append(((PersonalizacaoDeProduto)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                            for (ValorDaPersonalizacao valor : grupo.getValoresDaPersonalizacao()) {
                                text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNull((Object)valor.getProduto()) ? StringUtil.removerAcentos((String)valor.getProduto().getNome().toUpperCase()) : StringUtil.removerAcentos((String)valor.getDescricao().toUpperCase())).append("\n");
                            }
                        }
                    }
                    if (NullUtil.isNotEmpty((Collection)item.getGrupoPersonalizacoes())) {
                        for (GrupoDePersonalizacoes grupo : item.getGrupoPersonalizacoes()) {
                            text.append(StringUtil.generateWhitespace((int)8)).append(((Personalizacao)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                            for (ValorDaPersonalizacao valor : grupo.getValoresDaPersonalizacao()) {
                                text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNull((Object)valor.getProduto()) ? StringUtil.removerAcentos((String)valor.getProduto().getNome().toUpperCase()) : StringUtil.removerAcentos((String)valor.getDescricao().toUpperCase())).append("\n");
                            }
                        }
                    }
                    text = new StringBuilder();
                }
            }
        }
        return texts;
    }

    private String getDeliveryWayDescription(Pedido order) {
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            return PEDIDO_PARA_ENTREGA;
        }
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.RETIRAR_NO_LOCAL)) {
            return PEDIDO_A_RETIRAR;
        }
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.NA_MESA)) {
            return String.format(PEDIDO_NA_MESA, order.getMesa());
        }
        return null;
    }

    private List<Printer> getPrintersOfCategory(String categoryName) {
        return this.settings.getCategories().stream().filter(category -> category.getDescription().trim().toUpperCase().equals(categoryName)).map(category -> new Printer(category.getPrinterName())).collect(Collectors.toList());
    }

    private void groupProductName(ItemDoPedido item, StringBuilder text, Boolean showFullOrder) {
        List<ValorDaPersonalizacao> compositions = item.getOpcionais().stream().filter(optional -> NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getPersonalizacao()) && NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getPersonalizacao().getSubProduto()) && optional.getValorDaPersonalizacao().getPersonalizacao().getSubProduto() != false).map(optional -> optional.getValorDaPersonalizacao()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(compositions)) {
            HashMap<String, String> subProducts = new HashMap<String, String>();
            String column = StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-4s 1/%2$-27s %3$10s" : "%1$-4s 1/%2$-23s %3$1s"), (int)(showFullOrder != false ? 27 : 42), (String[])new String[]{item.getQuantidade().toString(), item.getProduto().getNome().toUpperCase(), showFullOrder != false ? StringUtil.formatarDecimal((Double)item.getValor().doubleValue()) : ""});
            text.append(column);
            compositions.forEach(value -> subProducts.put(String.format("1/%s %s", compositions.size() + 1, StringUtil.removerAcentos((String)value.getProduto().getNome()).toUpperCase()), NullUtil.isNotNull((Object)value.getValor()) && value.getValor().compareTo(BigDecimal.ZERO) > 0 ? (showFullOrder.booleanValue() ? StringUtil.formatarDecimal((Double)value.getValor().doubleValue()) : "") : " "));
            subProducts.forEach((key, value) -> {
                String itemColumn = StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-4s %2$-32s %3$10s" : "%1$-4s %2$-23s %3$1s"), (int)(showFullOrder != false ? 32 : 42), (String[])new String[]{"", key, value});
                text.append(itemColumn);
            });
        } else {
            String column = StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-4s %2$-32s %3$10s" : "%1$-4s %2$-23s %3$1s"), (int)(showFullOrder != false ? 32 : 42), (String[])new String[]{item.getQuantidade().toString(), item.getProduto().getNome().toUpperCase(), showFullOrder != false ? StringUtil.formatarDecimal((Double)item.getValor().doubleValue()) : ""});
            text.append(column);
        }
    }

    private void groupProductNameByComposition(ItemDoPedido item, StringBuilder text, Boolean showFullOrder) {
        Integer compositionSize = item.getProdutoComposto().getProdutos().size();
        if (compositionSize > 1) {
            HashMap<String, String> subProducts = new HashMap<String, String>();
            String column = StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-4s 1/%2$-30s %3$10s" : "%1$-4s 1/%2$-23s %3$1s"), (int)(showFullOrder != false ? 27 : 42), (String[])new String[]{item.getQuantidade().toString(), String.valueOf(compositionSize) + " " + ((Produto)item.getProdutoComposto().getProdutos().get(0)).getNome().toUpperCase() + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ", showFullOrder != false ? StringUtil.formatarDecimal((Double)item.getValor().doubleValue()) : ""});
            text.append(column);
            item.getProdutoComposto().getProdutos().forEach(produto -> {
                if (item.getProdutoComposto().getProdutos().indexOf(produto) != 0) {
                    subProducts.put(String.format("1/%s %s", compositionSize, StringUtil.removerAcentos((String)produto.getNome()).toUpperCase()) + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ", NullUtil.isNotNull((Object)produto.getValor()) && produto.getValor().compareTo(BigDecimal.ZERO) > 0 ? (showFullOrder.booleanValue() ? StringUtil.formatarDecimal((Double)produto.getValor().doubleValue()) : "") : " ");
                }
            });
            subProducts.forEach((key, value) -> {
                String itemColumn = StringUtil.renderTableLine((String)"%1$-4s %2$-42s", (int)42, (String[])new String[]{"", key, ""});
                text.append(itemColumn);
            });
        } else {
            String column = StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-4s %2$-32s %3$10s" : "%1$-4s %2$-23s %3$1s"), (int)(showFullOrder != false ? 32 : 42), (String[])new String[]{item.getQuantidade().toString(), ((Produto)item.getProdutoComposto().getProdutos().get(0)).getNome().toUpperCase() + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ", showFullOrder != false ? StringUtil.formatarDecimal((Double)item.getValor().doubleValue()) : ""});
            text.append(column);
        }
    }

    private void groupProductNameByComposition(ItemDoPedidoPorPromocao item, StringBuilder text, Boolean showFullOrder) {
        Integer compositionSize = item.getProdutoComposto().getProdutos().size();
        if (compositionSize > 1) {
            HashMap<String, String> subProducts = new HashMap<String, String>();
            String column = StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-4s 1/%2$-30s %3$10s" : "%1$-4s 1/%2$-23s %3$1s"), (int)(showFullOrder != false ? 27 : 42), (String[])new String[]{item.getQuantidade().toString(), String.valueOf(compositionSize) + " " + ((Produto)item.getProdutoComposto().getProdutos().get(0)).getNome().toUpperCase() + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ", showFullOrder != false ? StringUtil.formatarDecimal((Double)item.getValor().doubleValue()) : ""});
            text.append(column);
            item.getProdutoComposto().getProdutos().forEach(produto -> {
                if (item.getProdutoComposto().getProdutos().indexOf(produto) != 0) {
                    subProducts.put(String.format("1/%s %s", compositionSize, StringUtil.removerAcentos((String)produto.getNome()).toUpperCase()) + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ", NullUtil.isNotNull((Object)produto.getValor()) && produto.getValor().compareTo(BigDecimal.ZERO) > 0 ? (showFullOrder.booleanValue() ? StringUtil.formatarDecimal((Double)produto.getValor().doubleValue()) : "") : " ");
                }
            });
            subProducts.forEach((key, value) -> {
                String itemColumn = StringUtil.renderTableLine((String)"%1$-4s %2$-42s", (int)42, (String[])new String[]{"", key, ""});
                text.append(itemColumn);
            });
        } else {
            String column = StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-4s %2$-32s %3$10s" : "%1$-4s %2$-23s %3$1s"), (int)(showFullOrder != false ? 32 : 42), (String[])new String[]{item.getQuantidade().toString(), ((Produto)item.getProdutoComposto().getProdutos().get(0)).getNome().toUpperCase() + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ", showFullOrder != false ? StringUtil.formatarDecimal((Double)item.getValor().doubleValue()) : ""});
            text.append(column);
        }
    }

    private void groupProductNameByPromotion(ItemDoPedidoPorPromocao item, StringBuilder text, Boolean showFullOrder) {
        List<ValorDaPersonalizacao> compositions = item.getOpcionais().stream().map(optional -> optional.getValorDaPersonalizacao()).filter(valor -> NullUtil.isNotNull((Object)valor.getPersonalizacao()) && valor.getPersonalizacao().getSubProduto() != false).sorted((p1, p2) -> p1.getProduto().getNome().compareTo(p2.getProduto().getNome())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(compositions)) {
            HashMap<String, String> subProducts = new HashMap<String, String>();
            subProducts.put(String.format("1/%s %s", compositions.size() + 1, StringUtil.removerAcentos((String)this.printerService.breakText(item.getProduto().getNome())).toUpperCase()) + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ", !item.getGratuito().booleanValue() && NullUtil.isNotNull((Object)item.getValor()) && item.getValor().compareTo(BigDecimal.ZERO) > 0 ? (showFullOrder.booleanValue() ? StringUtil.formatarDecimal((Double)item.getValor().doubleValue()) : "") : " ");
            compositions.forEach(value -> subProducts.put(String.format("1/%s %s", compositions.size() + 1, StringUtil.removerAcentos((String)value.getProduto().getNome()).toUpperCase()) + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ", !item.getGratuito().booleanValue() && NullUtil.isNotNull((Object)value.getValor()) && value.getValor().compareTo(BigDecimal.ZERO) > 0 ? (showFullOrder.booleanValue() ? StringUtil.formatarDecimal((Double)value.getValor().doubleValue()) : "") : " "));
            subProducts.forEach((key, value) -> text.append(StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-7s %2$-28s %3$10s" : "%1$-7s %2$-19s %3$1s"), (int)(showFullOrder != false ? 28 : 38), (String[])new String[]{"", key, showFullOrder != false ? value : ""})));
            return;
        }
        if (!item.getOpcaoQuantitativa().booleanValue()) {
            text.append(StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-7s %2$-28s %3$10s" : "%1$-7s %2$-19s %3$1s"), (int)(showFullOrder != false ? 28 : 38), (String[])new String[]{" ", StringUtil.removerAcentos((String)this.printerService.breakText(item.getProduto().getNome())).toUpperCase(), " "}));
        } else {
            String[] stringArray = new String[3];
            stringArray[0] = "";
            stringArray[1] = StringUtils.leftPad((String)item.getQuantidade().toString(), (int)2).replace(" ", "0").concat(" ").concat(StringUtil.removerAcentos((String)this.printerService.breakText(item.getProduto().getNome()).toUpperCase()) + " " + (StringUtil.isNotBlank((String)item.getProdutoComposto().getTamanhoAbreviado()) ? item.getProdutoComposto().getTamanhoAbreviado().toUpperCase() : item.getProdutoComposto().getTamanho().toUpperCase()) + " ");
            stringArray[2] = !item.getGratuito().booleanValue() && NullUtil.isNotNull((Object)item.getValor()) && item.getValor().compareTo(BigDecimal.ZERO) > 0 ? (showFullOrder.booleanValue() ? StringUtil.formatarDecimal((Double)item.getValor().doubleValue()) : "") : " ";
            text.append(StringUtil.renderTableLine((String)(showFullOrder != false ? "%1$-7s %2$-28s %3$10s" : "%1$-7s %2$-19s %3$1s"), (int)(showFullOrder != false ? 28 : 38), (String[])stringArray));
        }
    }

    private void initCompany() {
        if (this.company == null) {
            try {
                String url = API_URL;
                if (InetAddress.getLocalHost().getHostName().equals("localhost")) {
                    url = LOCAL_API_URL;
                }
                url = url.concat(String.format(URL_GET_COMPANY_ENDPOINT, this.settings.getCompanyId()));
                RestTemplate template = new RestTemplate();
                ResponseEntity response = template.getForEntity(String.format(url, this.settings.getCompanyId()), Empresa.class, new Object[0]);
                this.company = (Empresa)response.getBody();
            }
            catch (UnknownHostException e) {
                System.out.println(String.format("Erro ao obter dados da empresa: %s", e.getMessage()));
            }
        }
    }

    private void initPrinterSettings() throws IOException {
        String configFilePath = System.getProperty("user.dir") + File.separator + "printer-cfg.json";
        File configFile = new File(configFilePath);
        this.createConfigFile(configFile);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(configFile);
        this.settings = new PrinterSettings(json.get("companyId").longValue());
        this.settings.setPrinters(new ArrayList());
        this.settings.setCategories(new ArrayList());
        for (JsonNode printer : json.get("printers")) {
            this.settings.getPrinters().add(new Printer(printer.get("path").asText(), printer.get("default").asBoolean()));
        }
        for (JsonNode category : json.get("categories")) {
            this.settings.getCategories().add(new Category(category.get("printer").asText(), category.get("description").asText()));
        }
        this.settings.setTriggerGuillotine(json.get("triggerGuillotine").asBoolean());
        this.settings.setJumpsLinesAfterEnd(json.get("jumpsLinesAfterEnd").asInt());
    }

    private void renderHeader(Pedido order, StringBuilder text, Boolean showFullOrder) throws ParseException {
        Empresa company = order.getEmpresa();
        Cliente customer = order.getCliente();
        text.append("\n").append(StringUtil.removerAcentos((String)company.getNomeFantasia().toUpperCase())).append("\n").append("\n");
        if (showFullOrder.booleanValue()) {
            text.append(StringUtil.removerAcentos((String)company.getLogradouro().toUpperCase())).append(", ").append(StringUtil.removerAcentos((String)company.getNumero().toUpperCase())).append("\n").append(StringUtil.formatarTelefone((String)company.getTelefonePrincipal())).append(" - ").append(StringUtil.removerAcentos((String)company.getMunicipio().getNome().toUpperCase())).append("/").append(company.getMunicipio().getUf()).append(StringUtil.isNotBlank((String)company.getUrlSite()) ? "\n" + company.getUrlSite() + "\n" : "\n").append("------------------------------------------------").append("\n").append("CUPOM PARA SIMPLES CONFER\u00caNCIA").append("\n").append("------------------------------------------------").append("\n");
        }
        text.append("PEDIDO N\u00ba: ").append(order.getId()).append("\n").append("DATA/HORA: ").append(DateUtil.format((String)"dd/MM/yyyy '\u00e0s' HH:mm:ss", (Date)order.getDataHoraPedido())).append("\n");
        if (showFullOrder.booleanValue()) {
            text.append("------------------------------------------------").append("\n");
            if (order.getClienteSemCadastro().booleanValue()) {
                text.append(String.format("CLIENTE: %s", order.getNomeClienteSemCadastro())).append("\n");
            } else {
                text.append(String.format("CLIENTE: %s", StringUtil.removerAcentos((String)customer.getNome().toUpperCase()))).append("\n");
            }
        }
        if (StringUtil.isNotBlank((String)order.getCpfCnpjNota()) && showFullOrder.booleanValue()) {
            if (order.getCpfCnpjNota().length() == 11) {
                text.append("\n").append(String.format("%1$-10s %2$-15s %3$10s", "CPF/CNPJ NA NOTA:", " ", StringUtil.formatarCpfCnpj((String)order.getCpfCnpjNota())));
            } else {
                text.append("\n").append(String.format("%1$-7s %2$-11s %3$10s", "CPF/CNPJ NA NOTA:", " ", StringUtil.formatarCpfCnpj((String)order.getCpfCnpjNota())));
            }
            text.append("\n");
        }
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY) && showFullOrder.booleanValue()) {
            if (order.getClienteSemCadastro().booleanValue()) {
                String[] addressComponents = order.getEnderecoDeEntregaClienteSemCadastro().replaceAll("\\,\\s", ",").split(",");
                text.append(String.format("END: %s, %s", StringUtil.removerAcentos((String)addressComponents[0].toUpperCase()), addressComponents[1]));
                if (addressComponents.length >= 6) {
                    text.append("\n").append(StringUtil.removerAcentos((String)addressComponents[5].toUpperCase()));
                }
                text.append("\n").append(String.format("BAIRRO: %s", addressComponents[2])).append("\n").append(String.format("MUNICIPIO: %s", addressComponents[4])).append("\n").append(String.format("CEP: %s", addressComponents[3])).append("\n");
                if (addressComponents.length == 7) {
                    text.append(StringUtil.removerAcentos((String)addressComponents[6]).toUpperCase()).append("\n");
                }
            } else {
                text.append("END: " + order.getEnderecoEntrega().getLogradouro().toUpperCase()).append(", ").append(order.getEnderecoEntrega().getNumero());
                if (StringUtil.isNotBlank((String)order.getEnderecoEntrega().getComplemento())) {
                    text.append("\n").append(StringUtil.removerAcentos((String)order.getEnderecoEntrega().getComplemento().toUpperCase()));
                }
                text.append("\n").append("BAIRRO: " + order.getEnderecoEntrega().getBairro().toUpperCase()).append("\n").append("MUNICIPIO: " + order.getEnderecoEntrega().getMunicipio().getNome().toUpperCase()).append("\n").append("CEP: " + StringUtil.formatarCEP((String)order.getEnderecoEntrega().getCep())).append("\n");
                if (StringUtil.isNotBlank((String)order.getEnderecoEntrega().getPontoDeReferencia())) {
                    text.append(order.getEnderecoEntrega().getPontoDeReferencia().toUpperCase()).append("\n");
                }
            }
        }
        if (showFullOrder.booleanValue()) {
            if (order.getClienteSemCadastro().booleanValue()) {
                text.append("TEL: " + StringUtil.formatarTelefone((String)order.getTelefoneClienteSemCadastro())).append("\n");
            } else {
                text.append("TEL: " + StringUtil.formatarTelefone((String)order.getCliente().getTelefone())).append("\n");
            }
        }
        text.append("------------------------------------------------").append("\n").append(StringUtil.generateWhitespace((int)16)).append("ITENS DO PEDIDO").append("\n").append("------------------------------------------------").append("\n");
        if (showFullOrder.booleanValue()) {
            text.append(String.format("%1$-4s %2$-32s %3$10s", "QTDE", "PRODUTO", "TOTAL (R$)"));
        } else {
            text.append(String.format("%1$-4s %2$-32s", "QTDE", "PRODUTO"));
        }
        text.append("\n");
    }

    private void renderFooter(StringBuilder text) {
        text.append("\n").append("------------------------------------------------").append("\n").append("\n").append("PEDIDO AGORA").append("\n").append("www.pedidoagora.com.br").append("\n");
    }

    private void renderOrderItems(Pedido order, StringBuilder text) {
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            order.getItensDoPedido().forEach(item -> {
                if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                    this.groupProductNameByComposition(item, text, Boolean.valueOf(true));
                } else {
                    this.groupProductName(item, text, Boolean.valueOf(true));
                }
                if (NullUtil.isNotEmpty((Collection)item.getGrupoPersonalizacoes())) {
                    item.getGrupoPersonalizacoes().forEach(grupo -> {
                        text.append(StringUtil.generateWhitespace((int)8)).append(((Personalizacao)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                        if (!CollectionUtils.isEmpty((Collection)grupo.getOpcionais())) {
                            grupo.getOpcionais().forEach(optional -> text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNullOrZero((Serializable)optional.getQuantidade()) ? optional.getQuantidade() : 1L).append("x ").append(NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getProduto()) ? optional.getValorDaPersonalizacao().getProduto().getNome().toUpperCase() : optional.getValorDaPersonalizacao().getDescricao().toUpperCase()).append("\n"));
                        } else {
                            grupo.getValoresDaPersonalizacao().forEach(valor -> text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNull((Object)valor.getProduto()) ? valor.getProduto().getNome().toUpperCase() : valor.getDescricao().toUpperCase()).append("\n"));
                        }
                    });
                }
                if (NullUtil.isNotEmpty((Collection)item.getGrupoPersonalizacoesDeProduto())) {
                    item.getGrupoPersonalizacoesDeProduto().forEach(grupo -> {
                        text.append(StringUtil.generateWhitespace((int)8)).append(((PersonalizacaoDeProduto)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                        if (!CollectionUtils.isEmpty((Collection)grupo.getOpcionais())) {
                            grupo.getOpcionais().forEach(optional -> text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNullOrZero((Serializable)optional.getQuantidade()) ? optional.getQuantidade() : 1L).append("x ").append(NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getProduto()) ? optional.getValorDaPersonalizacao().getProduto().getNome().toUpperCase() : optional.getValorDaPersonalizacao().getDescricao().toUpperCase()).append("\n"));
                        } else {
                            grupo.getValoresDaPersonalizacao().forEach(valor -> text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNull((Object)valor.getProduto()) ? valor.getProduto().getNome().toUpperCase() : valor.getDescricao().toUpperCase()).append("\n"));
                        }
                    });
                }
                if (StringUtil.isNotBlank((String)item.getObservacoes())) {
                    text.append(String.format("OBS: %s", item.getObservacoes().toUpperCase())).append("\n").append("\n");
                }
            });
        }
    }

    private void renderOrderItemsByPromotion(Pedido order, StringBuilder text) {
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            order.getCestasDePromocao().forEach(cesta -> {
                if (!CollectionUtils.isEmpty((Collection)cesta.getItens())) {
                    String title = this.printerService.truncateText(cesta.getPromocao().getTitulo(), 25);
                    text.append(StringUtil.renderTableLine((String)"%1$-4s %2$-32s %3$10s", (int)32, (String[])new String[]{cesta.getQuantidade().toString(), "PROMO " + StringUtil.removerAcentos((String)title.toUpperCase()), StringUtil.formatarDecimal((Double)cesta.getValor().doubleValue())}));
                    cesta.getItens().forEach(item -> {
                        if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                            this.groupProductNameByComposition(item, text, Boolean.valueOf(true));
                        } else {
                            this.groupProductNameByPromotion(item, text, Boolean.valueOf(true));
                        }
                        if (NullUtil.isNotEmpty((Collection)item.getGrupoPersonalizacoesDeProduto())) {
                            item.getGrupoPersonalizacoesDeProduto().forEach(grupo -> {
                                text.append(StringUtil.generateWhitespace((int)8)).append(((PersonalizacaoDeProduto)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                                grupo.getOpcionaisPorPromocao().stream().map(optional -> optional.getValorDaPersonalizacao()).forEach(valor -> text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNull((Object)valor.getProduto()) ? valor.getProduto().getNome().toUpperCase() : valor.getDescricao().toUpperCase()).append("\n"));
                            });
                        }
                        if (NullUtil.isNotEmpty((Collection)item.getGrupoPersonalizacoes())) {
                            item.getGrupoPersonalizacoes().forEach(grupo -> {
                                text.append(StringUtil.generateWhitespace((int)8)).append(((Personalizacao)grupo.getPersonalizacao()).getDescricao().toUpperCase()).append("\n");
                                grupo.getOpcionaisPorPromocao().stream().map(optional -> optional.getValorDaPersonalizacao()).forEach(valor -> text.append(StringUtil.generateWhitespace((int)12)).append(NullUtil.isNotNull((Object)valor.getProduto()) ? StringUtil.removerAcentos((String)valor.getProduto().getNome().toUpperCase()) : StringUtil.removerAcentos((String)valor.getDescricao().toUpperCase())).append("\n"));
                            });
                        }
                        if (StringUtil.isNotBlank((String)item.getObservacoes())) {
                            text.append(String.format("OBS: %s", item.getObservacoes().toUpperCase())).append("\n").append("\n");
                        }
                    });
                }
            });
        }
    }

    private void renderSummary(Pedido order, StringBuilder text) {
        String column;
        if (NullUtil.isNotNull((Object)order.getDataHoraAgendamento())) {
            text.append("------------------------------------------------").append("\n").append(String.format("%1$-15s %2$31s", "AGENDADO PARA:", DateUtil.format((String)"dd/MM/yyyy '\u00e0s' HH:mm:ss", (Date)order.getDataHoraAgendamento()))).append("\n");
        }
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            text.append("------------------------------------------------").append("\n").append(String.format("%1$-15s %2$31s", "TAXA DE ENTREGA", StringUtil.formatarDecimal((Double)order.getTaxaDeEntrega().doubleValue()))).append("\n");
        }
        if (NullUtil.isNotNull((Object)order.getCupomDeDesconto())) {
            text.append("------------------------------------------------").append("\n").append("CUPOM DE DESCONTO:").append("\n");
            if (order.getCupomDeDesconto().getTipoDesconto().equals((Object)TipoCupomDesconto.SEM_TAXA_DE_ENTREGA)) {
                column = StringUtil.renderTableLine((String)"%1$-27s %2$1s %3$13s", (int)32, (String[])new String[]{order.getCupomDeDesconto().getCodigo(), "", "S/ TAXA DE ENTREGA"});
                text.append(column).append("\n");
            } else {
                column = StringUtil.renderTableLine((String)"%1$-32s %2$1s %3$13s", (int)32, (String[])new String[]{order.getCodigoDoCupom(), "", "-" + StringUtil.formatarDecimal((Double)order.getValorDesconto().doubleValue())});
                text.append(column).append("\n");
            }
        }
        if (StringUtil.isNotBlank((String)order.getCodigoDoCupom()) && NullUtil.isNotNullOrZero((BigDecimal)order.getValorDesconto())) {
            text.append("------------------------------------------------").append("\n").append("CUPOM DE DESCONTO:").append("\n");
            column = StringUtil.renderTableLine((String)"%1$-32s %2$1s %3$13s", (int)32, (String[])new String[]{order.getCodigoDoCupom(), "", "-" + StringUtil.formatarDecimal((Double)order.getValorDesconto().doubleValue())});
            text.append(column).append("\n");
        }
        if (NullUtil.isNotNullOrZero((BigDecimal)order.getValorDescontoPagamentoEmDinheiro())) {
            text.append("------------------------------------------------").append("\n").append(String.format("%1$-15s %2$16s", "DESCONTO POR PGTO. EM DINHEIRO:", "-" + StringUtil.formatarDecimal((Double)order.getValorDescontoPagamentoEmDinheiro().doubleValue()))).append("\n");
        }
        if (NullUtil.isNotNullOrZero((BigDecimal)order.getDebitoCashback())) {
            text.append("------------------------------------------------").append("\n").append(String.format("%1$-15s %2$26s", "DESCONTO DE CASHBACK:", StringUtil.formatarDecimal((Double)(order.getDebitoCashback().doubleValue() * -1.0)))).append("\n");
        }
        text.append("------------------------------------------------").append("\n").append(String.format("%1$-15s %2$31s", "TOTAL DO PEDIDO:", StringUtil.formatarDecimal((Double)order.getTotalDoPedido().doubleValue())));
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            if (order.getFormaPagamento().equals((Object)FormaDePagamento.DINHEIRO)) {
                text.append("\n").append("------------------------------------------------").append("\n");
                if (NullUtil.isNotNull((Object)order.getValorTroco()) && !order.getValorTroco().equals(BigDecimal.ZERO)) {
                    text.append(String.format("%1$-20s %2$27s", "RECEBER DO CLIENTE:", StringUtil.formatarDecimal((Double)order.getValorTroco().doubleValue()))).append("\n").append("------------------------------------------------").append("\n");
                    BigDecimal changeValue = order.getValorTroco().subtract(order.getTotalDoPedido());
                    if (changeValue.compareTo(BigDecimal.ZERO) == 1) {
                        text.append(String.format("%1$-15s %2$31s", "LEVAR TROCO DE:", StringUtil.formatarDecimal((Double)changeValue.doubleValue())));
                    }
                } else {
                    text.append("DINHEIRO - N\u00c3O PRECISA DE TROCO");
                }
            } else {
                text.append("\n").append("------------------------------------------------").append("\n").append(this.getPaymentOption(order.getOpcaoPagamento())).append("\n").append(StringUtil.removerAcentos((String)order.getOpcaoPagamento().getDescricao().toUpperCase()));
            }
            if (NullUtil.isNotNull((Object)order.getOpcaoPagamento()) && NullUtil.isNotNullOrZero((Serializable)order.getOpcaoPagamento().getDescontoAplicado())) {
                text.append("\n").append(String.format("%1$-15s %2$24s", "DESCONTO POR PAGAMENTO:", " -" + StringUtil.formatarDecimal((Double)this.calculateOtherPaymentDiscount(order))));
            }
        }
        if (NullUtil.isNotNull((Object)order.getFormaPagamento()) && order.getFormaPagamento().equals((Object)FormaDePagamento.PAGAMENTO_ONLINE)) {
            text.append("\n").append("------------------------------------------------").append("\n").append("PAGAMENTO ON-LINE").append("\n");
            if (NullUtil.isNotNull((Object)order.getPagamento()) && order.getPagamento().getQuantidadeParcelas() > 1) {
                Integer parcelas = order.getPagamento().getQuantidadeParcelas();
                BigDecimal valor = order.getTotalDoPedido().divide(new BigDecimal(parcelas));
                BigDecimal installmentInterest = this.getInstallmentInterest(order);
                String installmentInfo = installmentInterest.compareTo(BigDecimal.ZERO) > 0 ? String.format("em %sx de %s (acr\u00e9scimo de %s)", parcelas, StringUtil.formatCurrency((Double)valor.doubleValue()), StringUtil.formatCurrency((Double)installmentInterest.doubleValue())) : String.format("em %sx de %s", parcelas, StringUtil.formatCurrency((Double)valor.doubleValue()));
                text.append(installmentInfo);
            }
        }
        if (NullUtil.isNotNullOrZero((BigDecimal)order.getCreditoCashback())) {
            String action = order.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO) ? " ACUMULADO" : " APROVISIONADO";
            text.append("\n").append("------------------------------------------------").append("\n").append(String.format("%1$-15s %2$22s", "CASHBACK" + action + ":", "+ " + StringUtil.formatarDecimal((Double)order.getCreditoCashback().doubleValue())));
        }
    }

    private Double calculateOtherPaymentDiscount(Pedido order) {
        BigDecimal discountValue = BigDecimal.ZERO;
        discountValue = order.getItensDoPedido().stream().map(item -> item.getValor()).reduce(BigDecimal.ZERO, (prev, next) -> prev.add((BigDecimal)next));
        discountValue = discountValue.multiply(new BigDecimal(order.getOpcaoPagamento().getDescontoAplicado() / 100.0));
        return discountValue.doubleValue();
    }

    private BigDecimal getInstallmentInterest(Pedido order) {
        BigDecimal totalItems;
        BigDecimal totalOrderItems = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            totalItems = order.getItensDoPedido().stream().map(item -> item.getValor()).reduce(BigDecimal.ZERO, (total, value) -> total.add((BigDecimal)value));
            totalOrderItems = totalOrderItems.add(totalItems);
        }
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            totalItems = order.getCestasDePromocao().stream().map(item -> item.getValor()).reduce(BigDecimal.ZERO, (total, value) -> total.add((BigDecimal)value));
            totalOrderItems = totalOrderItems.add(totalItems);
        }
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.DELIVERY)) {
            totalOrderItems = totalOrderItems.add(order.getTaxaDeEntrega());
        }
        return order.getTotalDoPedido().subtract(totalOrderItems);
    }

    private String getPaymentOption(OpcaoDePagamento paymentOption) {
        if (paymentOption.getFuncao().equals((Object)FuncaoPagamento.PIX)) {
            return String.format("PAGAMENTO EM PIX (CHAVE: %s)", paymentOption.getChavePix());
        }
        if (paymentOption.getFuncao().equals((Object)FuncaoPagamento.OUTROS)) {
            return "PAGAMENTO POR " + paymentOption.getFuncao().getDescricao();
        }
        return "LEVAR M\u00c1QUINA DE CART\u00c3O";
    }
}

