/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.view.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ImagePanel
extends JPanel {
    private BufferedImage image;
    private JLabel panelLabel = new JLabel("");

    public ImagePanel(String imageName) {
        this.setLayout(null);
        try {
            File imageFile = new File(System.getProperty("user.dir") + File.separator + imageName);
            this.image = ImageIO.read(imageFile);
        }
        catch (IOException | IllegalArgumentException ex) {
            JOptionPane.showMessageDialog(null, "Imagem n\u00e3o encontrada. Revise sua instala\u00e7\u00e3o ou entre em contato com nosso suporte t\u00e9cnico.");
            System.exit(0);
        }
    }

    public ImagePanel(String imageName, String label) {
        this(imageName);
        this.panelLabel.setFont(UIManager.getFont("medium.bold.font"));
        this.panelLabel.setBounds(50, 50, 100, 15);
        this.panelLabel.setText(label);
        this.add((Component)this.panelLabel);
    }

    public void setLabelBounds(int x, int y, int width, int height) {
        this.panelLabel.setBounds(x, y, width, height);
    }

    public void setLabelForeground(Color color) {
        this.panelLabel.setForeground(color);
    }

    public void setLabelText(String text) {
        this.panelLabel.setText(text);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.image, 0, 0, (ImageObserver)this);
    }
}

