/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemInformation {
    public static String getMacAddress() {
        try {
            byte[] hardwareAddress = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
            String macAddress = "";
            for (int i = 0; i < hardwareAddress.length; ++i) {
                macAddress = macAddress + String.format("%02X%s", hardwareAddress[i], i < hardwareAddress.length - 1 ? "-" : "");
            }
            return macAddress;
        }
        catch (SocketException | UnknownHostException e) {
            JOptionPane.showMessageDialog(null, "N\u00e3o foi poss\u00edvel identificar o computador.", "Erro", 64);
            e.printStackTrace();
            return null;
        }
    }

    public static String getMotherboardSerialWindows() {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.trim();
    }

    public static String getMotherboardSerialLinux() {
        String result = "";
        try {
            String line;
            String[] args = new String[]{"bash", "-c", "lshw -class bus | grep serial"};
            Process p = Runtime.getRuntime().exec(args);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result.trim().length() < 1 || result == null) {
            result = "NO_DISK_ID";
        }
        return SystemInformation.filtraString((String)result, (String)"serial: ");
    }

    public static String getHDSerialWindows(String drive) {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("tmp", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"" + drive + "\")\nWscript.Echo objDrive.SerialNumber";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result.trim().length() < 1 || result == null) {
            result = "NO_DISK_ID";
        }
        return result.trim();
    }

    public static String getHDSerialLinux() {
        String result = "";
        try {
            String line;
            String[] args = new String[]{"bash", "-c", "lshw -class disk | grep serial"};
            Process p = Runtime.getRuntime().exec(args);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result.trim().length() < 1 || result == null) {
            result = "NO_DISK_ID";
        }
        return SystemInformation.filtraString((String)result, (String)"serial: ");
    }

    public static String getCPUSerialWindows() {
        String result = "";
        try {
            String line;
            File file = File.createTempFile("tmp", ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "On Error Resume Next \r\n\r\nstrComputer = \".\"  \r\nSet objWMIService = GetObject(\"winmgmts:\" _ \r\n    & \"{impersonationLevel=impersonate}!\\\\\" & strComputer & \"\\root\\cimv2\") \r\nSet colItems = objWMIService.ExecQuery(\"Select * from Win32_Processor\")  \r\n For Each objItem in colItems\r\n     Wscript.Echo objItem.ProcessorId  \r\n     exit for  ' do the first cpu only! \r\nNext                    ";
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result.trim().length() < 1 || result == null) {
            result = "NO_CPU_ID";
        }
        return result.trim();
    }

    public static String getCPUSerialLinux() {
        String result = "";
        try {
            String line;
            String[] args = new String[]{"bash", "-c", "lshw -class processor | grep serial"};
            Process p = Runtime.getRuntime().exec(args);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                result = result + line;
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result.trim().length() < 1 || result == null) {
            result = "NO_DISK_ID";
        }
        return SystemInformation.filtraString((String)result, (String)"serial: ");
    }

    public static String filtraString(String nome, String delimitador) {
        return nome.split(delimitador)[1];
    }

    public static String retornaMacAddress() throws SocketException, UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        NetworkInterface netInter = NetworkInterface.getByInetAddress(localHost);
        byte[] macAddressBytes = netInter.getHardwareAddress();
        String macAddress = String.format("%1$02x-%2$02x-%3$02x-%4$02x-%5$02x-%6$02x", macAddressBytes[0], macAddressBytes[1], macAddressBytes[2], macAddressBytes[3], macAddressBytes[4], macAddressBytes[5]).toUpperCase();
        return macAddress;
    }

    public static void main(String[] args) {
        try {
            System.out.println("Serial do HD: " + SystemInformation.getHDSerial());
            System.out.println("Serial da CPU: " + SystemInformation.getCPUSerial());
            System.out.println("Serial da Placa Mae: " + SystemInformation.getMotherboardSerial());
            System.out.println("Serial do MAC: " + SystemInformation.retornaMacAddress());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static final String getHDSerial() throws IOException {
        String os = System.getProperty("os.name");
        try {
            if (os.startsWith("Windows")) {
                return SystemInformation.getHDSerialWindows((String)"C");
            }
            if (os.startsWith("Linux")) {
                return SystemInformation.getHDSerialLinux();
            }
            throw new IOException("Unknown operating system: " + os);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public static final String getCPUSerial() throws IOException {
        String os = System.getProperty("os.name");
        try {
            if (os.startsWith("Windows")) {
                return SystemInformation.getCPUSerialWindows();
            }
            if (os.startsWith("Linux")) {
                return SystemInformation.getCPUSerialLinux();
            }
            throw new IOException("Unknown operating system: " + os);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    private static final String getMotherboardSerial() throws IOException {
        String os = System.getProperty("os.name");
        try {
            if (os.startsWith("Windows")) {
                return SystemInformation.getMotherboardSerialWindows();
            }
            if (os.startsWith("Linux")) {
                return SystemInformation.getMotherboardSerialLinux();
            }
            throw new IOException("Unknown operating system: " + os);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }
}

