/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.util;

import com.escolpi.omni.integracao.util.NullUtil;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.text.MaskFormatter;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    public static String formatarPrimeiraLetraMaiuscula(String str) {
        String valor = "";
        if (!StringUtils.isEmpty((Object)str)) {
            valor = Character.toUpperCase(str.charAt(0)) + str.substring(1);
            valor = valor.substring(0, 1) + valor.substring(1, valor.length()).toLowerCase();
        }
        return valor;
    }

    public static boolean isBlank(String valor) {
        return valor == null || valor.trim() == "" || valor.length() == 0 || valor == "null";
    }

    public static boolean isNotBlank(String valor) {
        return valor != null && valor.length() > 0 && !valor.equals("null");
    }

    public static boolean isNumeric(String value) {
        if (StringUtil.isBlank((String)value)) {
            return false;
        }
        Pattern pattern = Pattern.compile("-?\\d+(\\.\\d+)?");
        return pattern.matcher(value).matches();
    }

    public static String formatar(String pattern, Object valor) throws ParseException {
        MaskFormatter mascara = new MaskFormatter(pattern);
        mascara.setValueContainsLiteralCharacters(false);
        try {
            return mascara.valueToString(valor);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatarCPF(String valor) throws ParseException {
        return StringUtil.formatar((String)"###.###.###-##", (Object)valor);
    }

    public static String formatarCNPJ(String valor) throws ParseException {
        return StringUtil.formatar((String)"##.###.###/####-##", (Object)valor);
    }

    public static String formatarCEP(String valor) throws ParseException {
        return StringUtil.formatar((String)"##.###-###", (Object)valor);
    }

    public static String formatarTelefone(String valor) {
        try {
            if (valor.length() == 11) {
                return StringUtil.formatar((String)"(##) #####-####", (Object)valor);
            }
            return StringUtil.formatar((String)"(##) ####-####", (Object)valor);
        }
        catch (ParseException e) {
            return valor;
        }
    }

    public static String formatarData(Date data) {
        if (data == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        return sdf.format(data);
    }

    public static String formatarMoeda(Double valor) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("pt", "BR"));
        return nf.format(valor);
    }

    public static String removerAcentos(String valor) {
        valor = Normalizer.normalize(valor, Normalizer.Form.NFD);
        valor = valor.replaceAll("[^\\p{ASCII}]", "");
        return valor;
    }

    public static String getStringHexa(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int parteAlta = (bytes[i] >> 4 & 0xF) << 4;
            int parteBaixa = bytes[i] & 0xF;
            if (parteAlta == 0) {
                builder.append('0');
            }
            builder.append(Integer.toHexString(parteAlta | parteBaixa));
        }
        return builder.toString();
    }

    public static String codificarBase64(Number codigo) throws Exception {
        try {
            if (codigo != null) {
                return Base64.getEncoder().encodeToString(codigo.toString().getBytes("UTF-8"));
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception("Erro ao codificar para base 64: ".concat(e.getMessage()));
        }
    }

    public static String decodificarBase64(String codigo) throws Exception {
        if (StringUtil.isNotBlank((String)codigo)) {
            return new String(Base64.getDecoder().decode(codigo));
        }
        return null;
    }

    public static String gerarSenha() {
        String[] caracteres = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "x", "w", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "W", "Y", "Z"};
        String senha = "";
        for (int i = 0; i < 8; ++i) {
            int j = (int)(Math.random() * (double)caracteres.length);
            senha = senha + caracteres[j];
        }
        System.out.println("Sua senha gerada \u00e9: " + senha);
        return senha;
    }

    public static String obterExtensao(String nomeArquivo) {
        if (StringUtil.isNotBlank((String)nomeArquivo)) {
            return nomeArquivo.substring(nomeArquivo.lastIndexOf(46), nomeArquivo.length());
        }
        return null;
    }

    public static String obterNomeArquivo(String nomeArquivo) {
        if (StringUtil.isNotBlank((String)nomeArquivo)) {
            return nomeArquivo.substring(0, nomeArquivo.lastIndexOf(46));
        }
        return null;
    }

    public static String removerUltimoCaractere(String valor, String caractere) {
        if (StringUtil.isNotBlank((String)valor) && StringUtil.isNotBlank((String)caractere)) {
            return valor.substring(0, valor.lastIndexOf(caractere));
        }
        return null;
    }

    public static String minificarString(String valor) {
        if (StringUtil.isNotBlank((String)valor)) {
            valor = valor.replaceAll(" ", "");
            valor = valor.toLowerCase();
            valor = StringUtil.removerAcentos((String)valor);
            return valor;
        }
        return null;
    }

    public static String formatarFlag(boolean flag, String whenTrue, String whenFalse) {
        if (whenTrue != null && whenFalse != null) {
            if (flag) {
                return whenTrue;
            }
            return whenFalse;
        }
        return "N/A";
    }

    public static String truncarValor(String valor, Integer limite) {
        if (valor.length() >= limite) {
            return valor.substring(0, limite - 3) + "...";
        }
        return valor;
    }

    public static String capitalizar(String valor) {
        if (!StringUtil.isBlank((String)valor)) {
            return StringUtils.capitalize((String)valor);
        }
        return "";
    }

    public static String retornaPrimeiroNome(String nomeCompleto) {
        if (nomeCompleto.contains(" ")) {
            return nomeCompleto.split(" ")[0];
        }
        return nomeCompleto;
    }

    public static String isTextNull(String text) {
        if (text == null || text.equals("null")) {
            return "";
        }
        return text;
    }

    public static Boolean isNull(String text) {
        if (text == null || text.equals("null") || text.length() == 0) {
            return true;
        }
        return false;
    }

    public static String removeSpecificCharacters(String text, String ... characters) {
        for (String character : characters) {
            if (NullUtil.isNull((Object)character)) continue;
            text = text.replaceAll(character, "");
        }
        return text;
    }

    public static String formatValue(String value) {
        Float floatValue = Float.valueOf(Float.parseFloat(value));
        DecimalFormat decimalFormatter = new DecimalFormat("0.00");
        decimalFormatter.setMaximumFractionDigits(2);
        return decimalFormatter.format(floatValue);
    }
}

