/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.service;

import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.components.integrations.CardapioDigitalIntegrationComponent;
import com.escolpi.omni.integracao.components.routes.RouteComponent;
import com.escolpi.omni.integracao.entity.DadosDaVendaTemporaria;
import com.escolpi.omni.integracao.entity.ItemDoPedido;
import com.escolpi.omni.integracao.entity.LogInterno;
import com.escolpi.omni.integracao.entity.Pedido;
import com.escolpi.omni.integracao.entity.Personalizacao;
import com.escolpi.omni.integracao.entity.api.ConfiguracaoDePizzariaApi;
import com.escolpi.omni.integracao.entity.configs.CardapioDigitalSettings;
import com.escolpi.omni.integracao.entity.dto.SolicitacaoDeFechamentoDaComandaDto;
import com.escolpi.omni.integracao.enumeration.SituacaoDoPedido;
import com.escolpi.omni.integracao.exceptions.ConfigurationNotFoundException;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.exceptions.ProductNotFoundException;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.CategoriaDoProdutoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.ItemDoPedidoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.OpcionalDoItemDoPedidoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.PedidoDto;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.ProdutoDto;
import com.escolpi.omni.integracao.repository.DadosDaVendaTemporariaRepository;
import com.escolpi.omni.integracao.repository.ItemDoPedidoRepository;
import com.escolpi.omni.integracao.repository.OpcionalRepository;
import com.escolpi.omni.integracao.repository.PedidoRepository;
import com.escolpi.omni.integracao.repository.VendaDaMesaRepository;
import com.escolpi.omni.integracao.service.LogInternoService;
import com.escolpi.omni.integracao.util.DateUtil;
import com.escolpi.omni.integracao.util.NullUtil;
import com.escolpi.omni.integracao.util.StringUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CardapioDigitalIntegrationService {
    private final OpcionalRepository optionalRepository;
    private final PedidoRepository orderRepository;
    private final ItemDoPedidoRepository orderItemRepository;
    private final DadosDaVendaTemporariaRepository tempSaleDataRepository;
    private final VendaDaMesaRepository tableSellRepository;
    private final LogInternoService logService;
    private final Logger log = LoggerFactory.getLogger(CardapioDigitalIntegrationComponent.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final RestTemplate rest = new RestTemplate();
    private final RouteComponent route;

    public CardapioDigitalIntegrationService(OpcionalRepository optionalRepository, ItemDoPedidoRepository orderItemRepository, PedidoRepository repository, DadosDaVendaTemporariaRepository tempSaleDataRepository, VendaDaMesaRepository tableSellRepository, LogInternoService logService, RouteComponent route) {
        this.optionalRepository = optionalRepository;
        this.orderItemRepository = orderItemRepository;
        this.orderRepository = repository;
        this.tempSaleDataRepository = tempSaleDataRepository;
        this.tableSellRepository = tableSellRepository;
        this.logService = logService;
        this.route = route;
    }

    @Transactional
    public Pedido createOrder(PedidoDto dto) {
        String currentDate = DateUtil.format((String)"dd/MM/yyyy", (Date)new Date());
        Pedido order = this.orderRepository.findByPedidoIdApi(dto.getId().toString(), currentDate).orElse(new Pedido());
        if (NullUtil.isNotNullOrZero((Serializable)order.getId()) && this.isOrderImported(order.getId())) {
            return null;
        }
        order.setPedidoIdApi(dto.getId().toString());
        order.setEmpresaId(dto.getEmpresa().getId());
        order.setMesa(dto.getMesa());
        order.setNomeClienteMesa(dto.getNomeClienteMesa());
        order.setClienteNome("Usu\u00e1rio do Card\u00e1pio Digital");
        order.setClienteTelefone("(99) 99999-9999");
        order.setOrigem("C DIGITAL");
        order.setSituacao(dto.getSituacao());
        order.setConfirmado("0");
        order.setFormaEntrega(dto.getFormaEntrega().toString());
        order.setDtHrPedido(DateUtil.format((String)"dd/MM/yyyy HH:mm:ss", (Date)dto.getDataHoraPedido()));
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
        if (NullUtil.isNotNull((Object)dto.getDataAtualizacaoPedido())) {
            localDateTime = DateUtil.parseLocalDateTime((Date)dto.getDataAtualizacaoPedido());
            order.setDtHrAtualizacao(localDateTime.minusHours(3L).format(dateTimeFormatter));
        } else {
            order.setDtHrAtualizacao(localDateTime.format(dateTimeFormatter));
        }
        this.orderRepository.save((Object)order);
        if (NullUtil.isNotNull((Object)dto.getDataAtualizacaoPedido())) {
            this.saveOrderItems(order, dto.getItensDoPedido());
        }
        return order;
    }

    private CardapioDigitalSettings getConfig() {
        return IntegrationConfig.config.getCardapioDigitalSettings();
    }

    private List<ProdutoDto> getPizzaFlavorsFromItem(ItemDoPedidoDto item, ConfiguracaoDePizzariaApi config) {
        try {
            List ids = Arrays.stream(item.getProdutoComposto().getProdutosIds().split(",")).map(id -> Long.valueOf(id.split(":")[0])).collect(Collectors.toList());
            String url = this.route.getEndpoint("/products/", config.getEmpresa().getId().toString(), new String[0]);
            HttpEntity entity = new HttpEntity(ids);
            ResponseEntity response = this.rest.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new IntegrationException("Produtos dos sabores de pizza n\u00e3o foram encontrados! Revise os c\u00f3digos de integra\u00e7\u00e3o!");
            }
            List<Object> foundedPizzas = Arrays.asList((Object[])this.mapper.readValue((String)response.getBody(), ProdutoDto[].class));
            if (CollectionUtils.isEmpty(foundedPizzas)) {
                throw new ProductNotFoundException("Produtos dos sabores de pizza n\u00e3o foram encontrados! Revise os c\u00f3digos de integra\u00e7\u00e3o!");
            }
            return foundedPizzas.stream().map(p -> CardapioDigitalIntegrationService.parseToPizzaProduct((String)item.getProdutoComposto().getTamanho(), (String)item.getProdutoComposto().getTamanhoAbreviado(), (ConfiguracaoDePizzariaApi)config, (ProdutoDto)p)).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.log.error("Erro de leitura ao obter os pedidos do Pedido Agora: {}", (Object)e.getMessage());
            throw new IntegrationException(e.getMessage());
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            throw new IntegrationException(e.getMessage());
        }
    }

    private ConfiguracaoDePizzariaApi getPizzeriaConfig(Long companyId) {
        try {
            RestTemplate rest = new RestTemplate();
            String url = this.route.getEndpoint(this.route.getCardapioDigitalBaseUrl(), "/config/pizzeria", new String[]{companyId.toString()});
            ResponseEntity response = rest.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                return (ConfiguracaoDePizzariaApi)this.mapper.readValue((String)response.getBody(), ConfiguracaoDePizzariaApi.class);
            }
            return null;
        }
        catch (IOException | RestClientException e) {
            String msg = String.format("Servi\u00e7o do Pedido Agora est\u00e1 indispon\u00edvel: %s", e.getMessage());
            this.logService.save(new LogInterno(Boolean.valueOf(true), msg, "P AGORA"));
            throw new IntegrationException(msg);
        }
    }

    private boolean isOrderImported(Long orderId) {
        String currentDate = DateUtil.format((String)"dd/MM/yyyy", (Date)new Date());
        return this.orderRepository.findByPedidoIdApi(orderId.toString(), currentDate).isPresent();
    }

    private static ProdutoDto parseToPizzaProduct(String size, String shortSize, ConfiguracaoDePizzariaApi config, ProdutoDto product) {
        ProdutoDto pizza = new ProdutoDto();
        String productName = String.format("%s  %s", product.getNome(), StringUtil.isNotBlank((String)shortSize) ? shortSize.toUpperCase() : StringUtil.removerAcentos((String)size).substring(0, 4).toUpperCase());
        pizza.setNome(productName);
        pizza.setCategoria(new CategoriaDoProdutoDto(product.getCategoria().getId(), product.getCategoria().getDescricao()));
        if (NullUtil.isNotNull((Object)config.getLabelTamanhoBroto()) && config.getLabelTamanhoBroto().equals(size)) {
            pizza.setCodigoAtos(product.getCodigoAtos());
            pizza.setValor(product.getValorTamanhoBroto());
        } else if (NullUtil.isNotNull((Object)config.getLabelTamanhoMedio()) && config.getLabelTamanhoMedio().equals(size)) {
            pizza.setCodigoAtos(product.getCodigoAtosMedio());
            pizza.setValor(product.getValorTamanhoMedio());
        } else if (NullUtil.isNotNull((Object)config.getLabelTamanhoGrande()) && config.getLabelTamanhoGrande().equals(size)) {
            pizza.setCodigoAtos(product.getCodigoAtosGrande());
            pizza.setValor(product.getValorTamanhoGrande());
        } else if (NullUtil.isNotNull((Object)config.getLabelTamanhoGigante()) && config.getLabelTamanhoGigante().equals(size)) {
            pizza.setCodigoAtos(product.getCodigoAtosGigante());
            pizza.setValor(product.getValorTamanhoGigante());
        } else {
            pizza.setCodigoAtos(product.getCodigoAtos());
            pizza.setValor(product.getValor());
        }
        return pizza;
    }

    @Transactional
    private void saveOrderItems(Pedido order, Set<ItemDoPedidoDto> items) {
        List pizzaFlavors = new ArrayList();
        for (ItemDoPedidoDto item : items) {
            ItemDoPedido orderItem = new ItemDoPedido();
            orderItem.setPedido(order);
            if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                ConfiguracaoDePizzariaApi pizzaConfig = this.getPizzeriaConfig(order.getEmpresaId());
                if (pizzaConfig == null) {
                    throw new ConfigurationNotFoundException("Configura\u00e7\u00e3o de Pizzaria do Pedido Agora");
                }
                pizzaFlavors = this.getPizzaFlavorsFromItem(item, pizzaConfig);
                orderItem.setCategoria(((ProdutoDto)pizzaFlavors.get(0)).getCategoria().getDescricao());
                orderItem.setProdutoCodigoAtos(((ProdutoDto)pizzaFlavors.get(0)).getCodigoAtos());
            } else {
                orderItem.setProdutoNome(item.getProduto().getNome());
                orderItem.setCategoria(item.getProduto().getCategoria().getDescricao());
                orderItem.setProdutoCodigoAtos(item.getProduto().getCodigoAtos());
            }
            orderItem.setObservacoes(StringUtil.isTextNull((String)item.getObservacoes()));
            orderItem.setQuantidade(item.getQuantidade());
            orderItem.setValor(Double.valueOf(item.getValor().doubleValue()));
            orderItem.setIndPromocao("0");
            if (NullUtil.isNotNull((Object)item.getProdutoComposto())) {
                this.savePizzaProduct(pizzaFlavors, orderItem, item.getOpcionais());
                continue;
            }
            this.orderItemRepository.save((Object)orderItem);
            this.saveOptionals(orderItem, item.getOpcionais());
        }
    }

    @Transactional
    private void saveOptionals(ItemDoPedido orderItem, Set<OpcionalDoItemDoPedidoDto> optionals) {
        if (!CollectionUtils.isEmpty(optionals)) {
            for (OpcionalDoItemDoPedidoDto optional : optionals) {
                Personalizacao itemCustomization = new Personalizacao();
                if (NullUtil.isNotNull((Object)optional.getValorDaPersonalizacao().getPersonalizacao())) {
                    itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)(optional.getValorDaPersonalizacao().getPersonalizacao().getDescricao() + ": " + StringUtil.isTextNull((String)optional.getValorDaPersonalizacao().getDescricao()))));
                } else {
                    itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)(optional.getValorDaPersonalizacao().getPersonalizacaoDeProduto().getDescricao() + ": " + StringUtil.isTextNull((String)optional.getValorDaPersonalizacao().getDescricao()))));
                }
                if (NullUtil.isNullOrZero((Serializable)optional.getQuantidade())) {
                    optional.setQuantidade(Long.valueOf(1L));
                }
                itemCustomization.setQuantidade(Integer.valueOf(optional.getQuantidade().intValue()));
                itemCustomization.setItemPedido(orderItem);
                itemCustomization.setPersonalizacaoValor(Double.valueOf(optional.getValorDaPersonalizacao().getValor().doubleValue()));
                this.optionalRepository.save((Object)itemCustomization);
            }
        }
    }

    @Transactional
    private void savePizzaProduct(List<ProdutoDto> pizzaFlavors, ItemDoPedido orderItem, Set<OpcionalDoItemDoPedidoDto> optionals) {
        int subProductCounter = pizzaFlavors.size();
        Long parentAtosCode = 0L;
        for (ProdutoDto pizza : pizzaFlavors) {
            if (NullUtil.isNull((Object)orderItem.getProdutoCodigoAtos()) || StringUtil.isBlank((String)orderItem.getProdutoCodigoAtos())) continue;
            Personalizacao itemCustomization = new Personalizacao();
            ItemDoPedido subProductItem = new ItemDoPedido();
            try {
                subProductItem.setCategoria(orderItem.getCategoria());
                subProductItem.setPedido(orderItem.getPedido());
                itemCustomization.setPersonalizacaoDescricao(StringUtil.isTextNull((String)pizza.getNome()));
                subProductItem.setProdutoNome(subProductCounter > 1 ? "1/" + subProductCounter + " " + itemCustomization.getPersonalizacaoDescricao() : itemCustomization.getPersonalizacaoDescricao());
                subProductItem.setProdutoCodigoAtos(StringUtil.isTextNull((String)pizza.getCodigoAtos()));
                subProductItem.setQuantidade(orderItem.getQuantidade());
                subProductItem.setObservacoes(orderItem.getObservacoes());
                subProductItem.setValor(orderItem.getValor());
                if (StringUtil.isNotBlank((String)orderItem.getIndPromocao())) {
                    subProductItem.setIndPromocao(orderItem.getIndPromocao());
                }
                this.orderItemRepository.save((Object)subProductItem);
                if (pizzaFlavors.indexOf(pizza) == 0) {
                    parentAtosCode = subProductItem.getId();
                } else if (pizzaFlavors.indexOf(pizza) > 0) {
                    subProductItem.setProdutoCodigoAtosPai(String.valueOf(parentAtosCode));
                }
                if (!pizza.getCodigoAtos().equals(orderItem.getProdutoCodigoAtos())) continue;
                this.saveOptionals(subProductItem, optionals);
            }
            catch (Exception e) {
                this.logService.save(new LogInterno(Boolean.valueOf(true), StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "", "P AGORA"));
            }
        }
    }

    @Transactional
    public void closeOrderControlsFromCardapioDigital(Long companyId) {
        try {
            String url = this.route.getEndpoint("/order-control/request/closements", companyId.toString(), new String[0]);
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, null, String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                HttpEntity entity;
                ResponseEntity responseEntity;
                List<Object> requests = Arrays.asList((Object[])this.mapper.readValue((String)response.getBody(), SolicitacaoDeFechamentoDaComandaDto[].class));
                ArrayList<Long> commitedRequests = new ArrayList<Long>();
                if (!CollectionUtils.isEmpty(requests)) {
                    for (SolicitacaoDeFechamentoDaComandaDto solicitacaoDeFechamentoDaComandaDto : requests) {
                        List tableSellItems;
                        if (this.getConfig().getSourcePdv().equals("concentre")) {
                            DadosDaVendaTemporaria saleData = this.tempSaleDataRepository.findAllOrderOnTable(solicitacaoDeFechamentoDaComandaDto.getMesa()).orElse(null);
                            if (saleData == null) continue;
                            String status = "PRE_FECHADA|";
                            if (!StringUtil.isBlank((String)solicitacaoDeFechamentoDaComandaDto.getClientes())) {
                                status = status + String.format("%s|", solicitacaoDeFechamentoDaComandaDto.getClientes());
                            }
                            saleData.setStatus(status);
                            this.tempSaleDataRepository.save((Object)saleData);
                            commitedRequests.add(solicitacaoDeFechamentoDaComandaDto.getId());
                            this.updateOrdersFromTable(solicitacaoDeFechamentoDaComandaDto.getMesa(), SituacaoDoPedido.COMANDA_EM_FECHAMENTO);
                            continue;
                        }
                        if (!this.getConfig().getSourcePdv().equals("food") || CollectionUtils.isEmpty((Collection)(tableSellItems = this.tableSellRepository.findByMesa(solicitacaoDeFechamentoDaComandaDto.getMesa())))) continue;
                        tableSellItems.forEach(item -> {
                            item.setSituacao("F");
                            this.tableSellRepository.save(item);
                        });
                        commitedRequests.add(solicitacaoDeFechamentoDaComandaDto.getId());
                        this.updateOrdersFromTable(solicitacaoDeFechamentoDaComandaDto.getMesa(), SituacaoDoPedido.COMANDA_EM_FECHAMENTO);
                    }
                }
                if (!CollectionUtils.isEmpty(commitedRequests) && (responseEntity = this.rest.exchange(url = this.route.getEndpoint("/order-control/request/closements", companyId.toString(), new String[0]), HttpMethod.DELETE, entity = new HttpEntity(commitedRequests), String.class, new Object[0])).getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
                    this.logService.saveAndShowLog(Boolean.valueOf(false), "As solicita\u00e7\u00f5es de fechamento em aberto foram finalizadas com sucesso!", "C DIGITAL", this.log);
                }
            }
        }
        catch (IOException | RestClientException e) {
            this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("Ocorreu um erro ao realizar o fechamento de comandas: %s", e.getMessage()), "C DIGITAL", this.log);
        }
    }

    @Transactional
    public void updateOrdersFromTable(String table, SituacaoDoPedido status) {
        List orders = this.orderRepository.findCurrentOrderControlsByTable(table);
        if (!CollectionUtils.isEmpty((Collection)orders)) {
            orders.forEach(order -> {
                order.setSituacao(status);
                order.setDtHrAtualizacao(DateUtil.format((String)"dd/MM/yyyy HH:mm:ss", (Date)new Date()));
                this.orderRepository.save(order);
            });
        }
    }
}

