/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.repository;

import com.escolpi.omni.integracao.entity.DadosDaVendaTemporaria;
import com.escolpi.omni.integracao.entity.dto.ComandaAtivaDto;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DadosDaVendaTemporariaRepository
extends JpaRepository<DadosDaVendaTemporaria, Long> {
    @Query(value="FROM DadosDaVendaTemporaria dv WHERE dv.tipoDeOperacao = 'COMANDA' AND dv.identificacao = :table")
    public Optional<DadosDaVendaTemporaria> findAllOrderOnTable(@Param(value="table") String var1);

    @Query(value="SELECT new com.escolpi.omni.integracao.entity.dto.ComandaAtivaDto(dv.identificacao, v.cliente) FROM DadosDaVendaTemporaria dv INNER JOIN VendaTemporaria v ON dv.id = v.codVenda WHERE dv.tipoDeOperacao = 'COMANDA' GROUP BY dv.identificacao, v.cliente ORDER BY dv.identificacao")
    public List<ComandaAtivaDto> findActiveOrdersOnTable();

    @Query(value="SELECT dv.identificacao FROM DadosDaVendaTemporaria dv WHERE dv.tipoDeOperacao = 'COMANDA' AND dv.status = 'FECHADO'")
    public List<String> findClosedSaleTempData();
}

