/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao.components.integrations;

import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.components.integrations.CardapioDigitalIntegrationComponent;
import com.escolpi.omni.integracao.components.routes.RouteComponent;
import com.escolpi.omni.integracao.entity.AtualizacaoDeSituacao;
import com.escolpi.omni.integracao.entity.DadosDaVendaTemporaria;
import com.escolpi.omni.integracao.entity.LogInterno;
import com.escolpi.omni.integracao.entity.Pedido;
import com.escolpi.omni.integracao.entity.VendaDaMesa;
import com.escolpi.omni.integracao.entity.VendaTemporaria;
import com.escolpi.omni.integracao.entity.configs.CardapioDigitalSettings;
import com.escolpi.omni.integracao.entity.dto.AtualizacaoDePedidoDeComandaDto;
import com.escolpi.omni.integracao.entity.dto.ComandaDto;
import com.escolpi.omni.integracao.entity.dto.VendaTemporariaDto;
import com.escolpi.omni.integracao.enumeration.SituacaoDoPedido;
import com.escolpi.omni.integracao.enums.IntegrationVendor;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.exceptions.StoreRestrictedException;
import com.escolpi.omni.integracao.integrations.pedidoagora.dto.PedidoDto;
import com.escolpi.omni.integracao.repository.DadosDaVendaTemporariaRepository;
import com.escolpi.omni.integracao.repository.VendaDaMesaRepository;
import com.escolpi.omni.integracao.repository.VendaTemporariaRepository;
import com.escolpi.omni.integracao.service.AtualizacaoDeSituacaoService;
import com.escolpi.omni.integracao.service.CardapioDigitalIntegrationService;
import com.escolpi.omni.integracao.service.LogInternoService;
import com.escolpi.omni.integracao.util.NullUtil;
import com.escolpi.omni.integracao.util.RestUtil;
import com.escolpi.omni.integracao.util.StringUtil;
import com.escolpi.omni.integracao.view.MainWindow;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class CardapioDigitalIntegrationComponent {
    private final LogInternoService logService;
    private final CardapioDigitalIntegrationService cdService;
    private final AtualizacaoDeSituacaoService updateService;
    private final VendaDaMesaRepository tableSellRepository;
    private final VendaTemporariaRepository tempSaleRepository;
    private final DadosDaVendaTemporariaRepository tempSaleDataRepository;
    private final Logger log = LoggerFactory.getLogger(CardapioDigitalIntegrationComponent.class);
    private final PriorityQueue<Long> orderQueue = new PriorityQueue();
    private final ObjectMapper mapper = new ObjectMapper();
    private final RestTemplate rest;
    private final RouteComponent routeComponent;
    public static final int ORDER_CONTROLS_PER_RECEIVING = 10;

    public CardapioDigitalIntegrationComponent(LogInternoService logService, CardapioDigitalIntegrationService cdService, AtualizacaoDeSituacaoService updateService, VendaDaMesaRepository tableSellRepository, VendaTemporariaRepository tempSaleRepository, DadosDaVendaTemporariaRepository tempSaleDataRepository, RestTemplate rest, RouteComponent routeComponent) {
        this.logService = logService;
        this.cdService = cdService;
        this.updateService = updateService;
        this.tableSellRepository = tableSellRepository;
        this.tempSaleRepository = tempSaleRepository;
        this.tempSaleDataRepository = tempSaleDataRepository;
        this.rest = rest;
        this.routeComponent = routeComponent;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void sendOrderControlClosements(Set<String> tables) {
        LinkedHashMap orderControlsByTable = new LinkedHashMap();
        tables.forEach(table -> {
            List orderControls;
            if (this.getConfig().getSourcePdv().equals("concentre")) {
                List sales = this.groupTempSaleData(table);
                List orderControls2 = this.processConcentreOrdersControls(sales);
                if (!CollectionUtils.isEmpty((Collection)orderControls2)) {
                    orderControls2.forEach(orderControl -> orderControl.setEmFechamento(Boolean.valueOf(true)));
                    orderControlsByTable.put(table, orderControls2);
                }
            } else if (this.getConfig().getSourcePdv().equals("food") && !CollectionUtils.isEmpty((Collection)(orderControls = this.processFoodOrdersControls(table)))) {
                orderControls.forEach(orderControl -> orderControl.setEmFechamento(Boolean.valueOf(true)));
                orderControlsByTable.put(table, orderControls);
            }
        });
        if (!CollectionUtils.isEmpty(orderControlsByTable)) {
            try {
                String url = this.routeComponent.getEndpoint(this.routeComponent.getCardapioDigitalBaseUrl(), "/order-control/update", new String[]{this.getConfig().getCompanyId().toString()});
                this.rest.put(url, orderControlsByTable, new Object[0]);
            }
            catch (RestClientException e) {
                String logMessage = String.format("Erro processar o(s) Pedido(s) na Mesa(s): %s", e.getMessage());
                this.logService.save(new LogInterno(Boolean.valueOf(true), logMessage, "C DIGITAL"));
            }
        }
    }

    @Transactional
    public void closeRequestedOrderControls() {
        try {
            this.cdService.closeOrderControlsFromCardapioDigital(IntegrationConfig.config.getCardapioDigitalSettings().getCompanyId());
            List updateStatus = this.updateService.listOrderControlStatusToClose();
            if (!CollectionUtils.isEmpty((Collection)updateStatus)) {
                Set tables = updateStatus.stream().map(AtualizacaoDeSituacao::getMesa).collect(Collectors.toSet());
                this.sendOrderControlClosements(tables);
                updateStatus.forEach(arg_0 -> ((AtualizacaoDeSituacaoService)this.updateService).delete(arg_0));
            }
        }
        catch (HttpClientErrorException e) {
            this.entryErrorLog(e);
        }
    }

    @Transactional
    public void finalizeOrderControls() {
        try {
            List updates = this.updateService.listOrderControlStatusToFinalize();
            if (!CollectionUtils.isEmpty((Collection)updates)) {
                List<String> tables = updates.stream().map(AtualizacaoDeSituacao::getMesa).collect(Collectors.toList());
                this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("Finalizando comandas das mesas: %s", String.join((CharSequence)",", tables)), "C DIGITAL", this.log);
                if (!CollectionUtils.isEmpty(tables)) {
                    String url = this.routeComponent.getEndpoint(this.routeComponent.getCardapioDigitalBaseUrl(), "/order-control/finalize", new String[]{this.getConfig().getCompanyId().toString()});
                    this.rest.put(url, (Object)RestUtil.getEntityWithUserAgent(tables), new Object[0]);
                    updates.forEach(arg_0 -> ((AtualizacaoDeSituacaoService)this.updateService).delete(arg_0));
                    tables.forEach(table -> this.cdService.updateOrdersFromTable(table, SituacaoDoPedido.FINALIZADO));
                }
            }
        }
        catch (RestClientException e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), StringUtil.isNotBlank((String)e.getMessage()) ? e.getMessage() : "No error message!", "C DIGITAL"));
        }
    }

    @Transactional
    public void receiveNewOrders() throws IntegrationException {
        try {
            if (this.orderQueue.isEmpty()) {
                this.prepareOrderQueue();
            } else {
                String url;
                ResponseEntity response;
                ArrayList<Long> importedOrders = new ArrayList<Long>();
                while (!this.orderQueue.isEmpty()) {
                    PedidoDto order = this.getOrderFromCardapioDigitalApi((Long)this.orderQueue.peek());
                    if (!this.getConfig().getGetTestOrders().booleanValue() && order.getTeste().booleanValue()) {
                        this.logService.saveAndShowLog(Boolean.valueOf(false), "Esta loja n\u00e3o permite recebimento de pedido de testes.", "C DIGITAL", this.log);
                        this.orderQueue.remove();
                        continue;
                    }
                    Pedido created = this.cdService.createOrder(order);
                    importedOrders.add(Long.valueOf(created.getPedidoIdApi()));
                    this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("Pedido n\u00ba %s da mesa %s foi importado com sucesso!", created.getPedidoIdApi(), created.getMesa()), "C DIGITAL", this.log);
                    this.orderQueue.remove();
                }
                if (!CollectionUtils.isEmpty(importedOrders) && !(response = this.rest.postForEntity(url = this.routeComponent.getEndpoint(this.routeComponent.getCardapioDigitalBaseUrl(), "/order/confirm/import", new String[]{this.getConfig().getCompanyId().toString()}), (Object)RestUtil.getEntityWithUserAgent(importedOrders), Object.class, new Object[0])).getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
                    String notImportedIds = importedOrders.stream().map(String::valueOf).collect(Collectors.joining(","));
                    this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("Os pedido(s) %s n\u00e3o puderam ser importado(s).", notImportedIds), "C DIGITAL", this.log);
                }
            }
        }
        catch (Exception e) {
            this.logService.save(new LogInterno(Boolean.valueOf(true), e.getMessage(), "C DIGITAL"));
        }
    }

    @Transactional
    public void syncronizeOrderUpdates() {
        try {
            List updates = this.updateService.listOrderUpdates("C DIGITAL");
            if (!CollectionUtils.isEmpty((Collection)updates)) {
                String orderIds = updates.stream().map(u -> String.valueOf(u.getPedidoId())).collect(Collectors.joining(","));
                this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("Sincronizando atualiza\u00e7\u00e3o do(s) pedido(s): %s", orderIds), "C DIGITAL", this.log);
                Set tables = updates.stream().map(AtualizacaoDeSituacao::getMesa).collect(Collectors.toSet());
                List ordersToUpdate = updates.stream().filter(update -> StringUtil.isNumeric((String)update.getPedidoId())).map(update -> new AtualizacaoDePedidoDeComandaDto(Long.valueOf(update.getPedidoId()), SituacaoDoPedido.get((int)update.getSituacaoDoPedido()), update.getMesa())).collect(Collectors.toList());
                String url = this.routeComponent.getEndpoint(this.routeComponent.getCardapioDigitalBaseUrl(), "/order/update", new String[]{this.getConfig().getCompanyId().toString()});
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                ResponseEntity response = this.rest.exchange(url, HttpMethod.PUT, RestUtil.getEntityWithUserAgent((HttpHeaders)headers, ordersToUpdate), String.class, new Object[0]);
                if (response.getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
                    for (AtualizacaoDeSituacao orderUpdate : updates) {
                        this.updateService.delete(orderUpdate);
                    }
                    this.updateOrderControls(tables);
                    this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("Os pedidos %s foram atualizados com sucesso!", orderIds), "C DIGITAL", this.log);
                }
            }
        }
        catch (HttpClientErrorException e) {
            this.entryErrorLog(e);
        }
        catch (Exception e) {
            this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("Ocorreu um problema ao atualizar o(s) pedido(s): %s", e.getMessage()), "PEDIDO_AGORA", this.log);
        }
    }

    private void updateOrderControls(Set<String> tables) {
        try {
            LinkedHashMap<String, List> orderControlsByTable = new LinkedHashMap<String, List>();
            for (String table : tables) {
                List sales;
                List orderControls;
                if (this.getConfig().getSourcePdv().equals("concentre") && !CollectionUtils.isEmpty((Collection)(orderControls = this.processConcentreOrdersControls(sales = this.groupTempSaleData(table))))) {
                    orderControlsByTable.put(table, orderControls);
                }
                if (!this.getConfig().getSourcePdv().equals("food") || CollectionUtils.isEmpty((Collection)(orderControls = this.processFoodOrdersControls(table)))) continue;
                orderControlsByTable.put(table, orderControls);
            }
            if (!CollectionUtils.isEmpty(orderControlsByTable)) {
                String url = this.routeComponent.getEndpoint(this.routeComponent.getCardapioDigitalBaseUrl(), "/order-control/update", new String[]{this.getConfig().getCompanyId().toString()});
                this.rest.put(url, (Object)RestUtil.getEntityWithUserAgent(orderControlsByTable), new Object[0]);
                this.logService.saveAndShowLog(Boolean.valueOf(false), String.format("Os pedidos %s foram atualizados com sucesso!", String.join((CharSequence)",", tables)), "C DIGITAL", this.log);
            }
        }
        catch (HttpClientErrorException e) {
            this.entryErrorLog(e);
        }
    }

    @Transactional
    private void entryErrorLog(HttpClientErrorException e) {
        switch (1.$SwitchMap$org$springframework$http$HttpStatus[e.getStatusCode().ordinal()]) {
            case 1: {
                this.logService.saveAndShowLog(Boolean.valueOf(true), "Ocorreu um problema ao realizar uma requisi\u00e7\u00e3o: %s", "C DIGITAL", this.log);
                break;
            }
            case 2: {
                this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("Ocorreu um problema ao realizar uma requisi\u00e7\u00e3o: %s", e.getMessage()), "C DIGITAL", this.log);
                break;
            }
            case 3: {
                this.logService.saveAndShowLog(Boolean.valueOf(true), String.format("O servi\u00e7o do Pedido Agora est\u00e1 indispon\u00edvel: %s", e.getMessage()), "C DIGITAL", this.log);
            }
            case 4: {
                this.logService.saveAndShowLog(Boolean.valueOf(true), "Erro interno no servi\u00e7o do Pedido Agora: %s", "C DIGITAL", this.log);
            }
        }
    }

    private CardapioDigitalSettings getConfig() {
        return IntegrationConfig.config.getCardapioDigitalSettings();
    }

    public boolean getRestrictionState() {
        try {
            String url = this.routeComponent.getEndpoint(this.routeComponent.getCardapioDigitalBaseUrl(), "/check-restriction", new String[]{this.getConfig().getCompanyId().toString()});
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, HttpEntity.EMPTY, Boolean.class, new Object[0]);
            boolean isNotRestricted = Boolean.TRUE.equals(response.getBody());
            if (!isNotRestricted) {
                throw new StoreRestrictedException(IntegrationVendor.CARDAPIO_DIGITAL.getDescricao());
            }
            return true;
        }
        catch (HttpClientErrorException e) {
            this.entryErrorLog(e);
            return false;
        }
        catch (StoreRestrictedException e) {
            this.log.info(e.getMessage());
            MainWindow.setErrorState((String)"Servi\u00e7o Indispon\u00edvel");
            return false;
        }
    }

    private PedidoDto getOrderFromCardapioDigitalApi(Long id) {
        try {
            String url = this.routeComponent.getEndpoint(this.routeComponent.getCardapioDigitalBaseUrl(), "/order/%s", new String[]{this.getConfig().getCompanyId().toString(), id.toString()});
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, RestUtil.getEntityWithUserAgent(), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                return (PedidoDto)this.mapper.readValue((String)response.getBody(), PedidoDto.class);
            }
            if (response.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
                throw new IntegrationException("O Pedido %s n\u00e3o foi identificado na plataforma do Pedido Agora.");
            }
            throw new IntegrationException(String.format("O Pedido %s n\u00e3o foi obtido. Verifique a disponibilidade da plataforma %s", id, "C DIGITAL"));
        }
        catch (Exception e) {
            throw new IntegrationException(e.getMessage());
        }
    }

    private List<VendaTemporariaDto> groupTempSaleData(String table) {
        List tempSales;
        ArrayList<VendaTemporariaDto> sales = new ArrayList<VendaTemporariaDto>();
        DadosDaVendaTemporaria saleData = this.tempSaleDataRepository.findAllOrderOnTable(table).orElse(null);
        if (NullUtil.isNotNull((Object)saleData) && !CollectionUtils.isEmpty((Collection)(tempSales = this.tempSaleRepository.findByCodVenda(saleData.getId())))) {
            sales.add(new VendaTemporariaDto(saleData, tempSales));
        }
        return sales;
    }

    private void prepareOrderQueue() {
        try {
            String url = this.routeComponent.getEndpoint(this.routeComponent.getCardapioDigitalBaseUrl(), "/new-orders/", new String[]{this.getConfig().getCompanyId().toString()});
            ResponseEntity response = this.rest.exchange(url, HttpMethod.GET, RestUtil.getEntityWithUserAgent(), String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                Arrays.stream((Object[])this.mapper.readValue((String)response.getBody(), Long[].class)).filter(id -> !this.orderQueue.contains(id)).collect(Collectors.toList()).forEach(id -> {
                    if (this.orderQueue.size() < 10) {
                        this.orderQueue.add(id);
                    }
                });
                if (!this.orderQueue.isEmpty()) {
                    this.receiveNewOrders();
                }
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage());
        }
    }

    private List<ComandaDto> processConcentreOrdersControls(List<VendaTemporariaDto> sales) {
        ArrayList<ComandaDto> orderControls = new ArrayList<ComandaDto>();
        sales.forEach(sale -> {
            List<VendaTemporaria> parentItems = sale.getItensDaVenda().stream().filter(item -> item.getId().equals(Integer.valueOf(item.getSequencia()))).collect(Collectors.toList());
            List childItems = sale.getItensDaVenda().stream().filter(item -> !item.getId().equals(Integer.valueOf(item.getSequencia()))).collect(Collectors.toList());
            parentItems.forEach(item -> {
                ComandaDto orderOnTable = new ComandaDto();
                orderOnTable.setEmpresaId(IntegrationConfig.config.getCardapioDigitalSettings().getCompanyId());
                orderOnTable.setMesa(sale.getVenda().getIdentificacao());
                orderOnTable.setCliente(StringUtil.isNotBlank((String)item.getCliente()) ? item.getCliente().toUpperCase() : " N\u00e3o Vinculado");
                orderOnTable.setVendedor(!StringUtil.isBlank((String)item.getVendedor()) ? item.getVendedor() : " C_DIGITAL");
                orderOnTable.setDescricao(item.getProduto());
                orderOnTable.setValorUnitario(item.getValorUnitario());
                orderOnTable.setQuantidade(item.getQuantidade());
                orderOnTable.setTotalDaComanda(item.getValorTotal());
                orderOnTable.setEmFechamento(Boolean.valueOf(false));
                List<VendaTemporaria> optionals = childItems.stream().filter(i -> Integer.valueOf(i.getSequencia()).equals(item.getId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(optionals)) {
                    orderOnTable.setOpcionais(new ArrayList());
                    optionals.forEach(optional -> {
                        ComandaDto opt = new ComandaDto();
                        opt.setEmpresaId(IntegrationConfig.config.getCardapioDigitalSettings().getCompanyId());
                        opt.setMesa(sale.getVenda().getIdentificacao());
                        opt.setCliente(optional.getCliente());
                        opt.setVendedor(optional.getVendedor());
                        opt.setDescricao(optional.getProduto());
                        opt.setValorUnitario(optional.getValorUnitario());
                        opt.setQuantidade(optional.getQuantidade());
                        opt.setTotalDaComanda(optional.getValorTotal());
                        orderOnTable.getOpcionais().add(opt);
                    });
                }
                orderControls.add(orderOnTable);
            });
        });
        return orderControls;
    }

    private List<ComandaDto> processFoodOrdersControls(String table) {
        ArrayList<ComandaDto> orderControls = new ArrayList<ComandaDto>();
        List sales = this.tableSellRepository.findByMesa(table);
        if (!CollectionUtils.isEmpty((Collection)sales)) {
            List<VendaDaMesa> parentItems = sales.stream().filter(item -> item.getId().equals(Long.valueOf(item.getSequenciaFilho()))).collect(Collectors.toList());
            List childItems = sales.stream().filter(item -> !item.getId().equals(Long.valueOf(item.getSequenciaFilho()))).collect(Collectors.toList());
            parentItems.forEach(item -> {
                ComandaDto orderOnTable = new ComandaDto();
                orderOnTable.setEmpresaId(IntegrationConfig.config.getCardapioDigitalSettings().getCompanyId());
                orderOnTable.setMesa(item.getMesa());
                orderOnTable.setCliente(StringUtil.isNotBlank((String)item.getCliente()) ? item.getCliente().toUpperCase() : " N\u00e3o Vinculado");
                orderOnTable.setVendedor(!StringUtil.isBlank((String)item.getVendedor()) ? item.getVendedor() : " C_DIGITAL");
                orderOnTable.setDescricao(item.getProduto());
                orderOnTable.setValorUnitario(item.getValorUnitario());
                orderOnTable.setQuantidade(item.getQuantidade());
                orderOnTable.setTotalDaComanda(item.getValorTotal());
                orderOnTable.setEmFechamento(Boolean.valueOf(false));
                List<VendaDaMesa> optionals = childItems.stream().filter(i -> Long.valueOf(i.getSequenciaFilho()).equals(item.getId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(optionals)) {
                    orderOnTable.setOpcionais(new ArrayList());
                    optionals.forEach(optional -> {
                        ComandaDto opt = new ComandaDto();
                        opt.setEmpresaId(IntegrationConfig.config.getCardapioDigitalSettings().getCompanyId());
                        opt.setMesa(optional.getMesa());
                        opt.setCliente(optional.getCliente());
                        opt.setVendedor(optional.getVendedor());
                        opt.setDescricao(optional.getProduto());
                        opt.setValorUnitario(optional.getValorUnitario());
                        opt.setQuantidade(optional.getQuantidade());
                        opt.setTotalDaComanda(optional.getValorTotal());
                        orderOnTable.getOpcionais().add(opt);
                    });
                }
                orderControls.add(orderOnTable);
            });
        }
        return orderControls;
    }
}

