/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.integracao;

import com.escolpi.omni.integracao.components.ConnectionComponent;
import com.escolpi.omni.integracao.components.IntegrationConfig;
import com.escolpi.omni.integracao.components.routes.RouteComponent;
import com.escolpi.omni.integracao.entity.configs.MainConfiguration;
import com.escolpi.omni.integracao.exceptions.IntegrationException;
import com.escolpi.omni.integracao.integrations.ifood.dto.IFoodAuthorizationDto;
import com.escolpi.omni.integracao.util.StringUtil;
import com.escolpi.omni.integracao.view.IFoodRequestAuthorizeWindow;
import com.escolpi.omni.integracao.view.MainWindow;
import com.escolpi.omni.integracao.view.SplashScreenWindow;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.formdev.flatlaf.intellijthemes.FlatArcOrangeIJTheme;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableJpaRepositories(enableDefaultTransactions=false)
@SpringBootApplication
public class Application {
    public static ConfigurableApplicationContext applicationContext;
    private static final Logger log;
    @Autowired
    private ConnectionComponent connectionUtil;
    @Autowired
    private RouteComponent routeComponent;

    public static void main(String[] args) {
        try {
            log.info("Iniciando Integra\u00e7\u00e3o...");
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
            UIManager.setLookAndFeel((LookAndFeel)new FlatArcOrangeIJTheme());
            IntegrationConfig.readConfigFile();
            SplashScreenWindow splashScreen = new SplashScreenWindow();
            splashScreen.showWindow();
            applicationContext = SpringApplication.run(Application.class, (String[])args);
            Application app = (Application)applicationContext.getBean(Application.class);
            if (IntegrationConfig.isIFoodActive() && !StringUtil.isBlank((String)Application.getConfig().getiFoodSettings().getRefreshToken())) {
                app.updateIFoodToken();
            }
            app.checkInitialConnecitons();
            splashScreen.closeWindow();
            app.initializeView();
        }
        catch (Exception e) {
            String errorMsg = String.format("Erro ao iniciar integra\u00e7\u00e3o: %s", e.getMessage());
            log.error(errorMsg);
            JOptionPane.showMessageDialog(null, errorMsg, "Erro ao Iniciar", 0);
            System.exit(0);
        }
    }

    private void updateIFoodToken() {
        try {
            RestTemplate template = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            ObjectMapper mapper = new ObjectMapper();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
            requestBody.add((Object)"grantType", (Object)"refresh_token");
            requestBody.add((Object)"clientId", (Object)Application.getConfig().getiFoodSettings().getClientId());
            requestBody.add((Object)"clientSecret", (Object)Application.getConfig().getiFoodSettings().getClientSecret());
            requestBody.add((Object)"refreshToken", (Object)Application.getConfig().getiFoodSettings().getRefreshToken());
            HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            ResponseEntity response = template.exchange("https://merchant-api.ifood.com.br/authentication/v1.0/oauth/token", HttpMethod.POST, request, String.class, new Object[0]);
            if (response.getStatusCode().equals((Object)HttpStatus.OK) && null != response.getBody()) {
                IFoodAuthorizationDto auth = (IFoodAuthorizationDto)mapper.readValue((String)response.getBody(), IFoodAuthorizationDto.class);
                Application.getConfig().getiFoodSettings().setAccessToken(auth.getAccessToken());
                Application.getConfig().getiFoodSettings().setRefreshToken(auth.getRefreshToken());
                IntegrationConfig.updateConfigFile();
            }
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().equals((Object)HttpStatus.UNAUTHORIZED) || e.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) {
                JOptionPane.showMessageDialog(null, "Aten\u00e7\u00e3o", "O Token de Acesso da API do IFood expirou e precisa ser renovado. Reinicie a integra\u00e7\u00e3o e atualize suas credenciais. Contate nosso suporte caso precise de ajuda.", 2);
                Application.getConfig().getiFoodSettings().setAccessToken("");
                Application.getConfig().getiFoodSettings().setRefreshToken("");
                IntegrationConfig.updateConfigFile();
                System.exit(0);
            }
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            log.error("O token da integra\u00e7\u00e3o com sua loja IFood expirou e n\u00e3o pode ser renovado de forma autom\u00e1tica. Entre em contato com nosso suporte para renovar a autoriza\u00e7\u00e3o de forma manual.");
        }
    }

    private void checkInitialConnecitons() {
        try {
            this.connectionUtil.checkDatabaseConnection();
            this.connectionUtil.checkIntegrationConnections();
        }
        catch (IntegrationException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Erro de Conex\u00e3o", 0);
            System.exit(0);
        }
    }

    private void initializeView() {
        MainWindow.createView();
        if (IntegrationConfig.isIFoodActive() && StringUtil.isBlank((String)Application.getConfig().getiFoodSettings().getAccessToken())) {
            IFoodRequestAuthorizeWindow.createView((RouteComponent)this.routeComponent);
        } else {
            Application.showMainWindow();
        }
        MainWindow.defineLastChecking();
        log.info("Integra\u00e7\u00e3o iniciada com sucesso!");
    }

    private static MainConfiguration getConfig() {
        return IntegrationConfig.config;
    }

    private static void showMainWindow() {
        if (Boolean.FALSE.equals(IntegrationConfig.config.getHideOnClose())) {
            MainWindow.showMainWindow();
        }
    }

    static {
        log = LoggerFactory.getLogger(Application.class);
    }
}

